'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbSASetGroup __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSASetGroup \- Sets the group_XXX field of act from the group index grp
.SH SYNOPSIS
.HP
.B void XkbSASetGroup
.BI "(\^XkbAction " "act" "\^,"
.BI "int " "grp" "\^);"
.SH ARGUMENTS
.TP
.I \- act
action from which to set group
.TP
.I \- grp
group index to set in group_XXX
.SH DESCRIPTION
.LP
.I XkbSASetGroup 
sets the 
.I group_XXX 
field of 
.I act 
from the group index 
.I grp. 
.SH STRUCTURE
.LP
Actions associated with the XkbGroupAction structure change the
current group state when keys are pressed and released:

.nf
.ft CW
    typedef struct _XkbGroupAction {
        unsigned char    type;       /\(** XkbSA_{Set|Latch|Lock}Group */
        unsigned char    flags;      /\(** with type, controls the effect on groups */
        char             group_XXX;  /\(** represents a group index or delta */
    } XkbGroupAction;
.ft
.fi
.SH WARNING
.LP
This manpage seems to be incomplete
