# aubinator_error_decode

This tool allows decode an error state dump generated by the kernel
driver.

Make a copy of the error state file (i915) :
```
$ sudo cp /sys/devices/pci0000:00/0000:00:02.0/drm/card0/error /tmp/error
$ sudo chmod go+rw /tmp/error
```

Make a copy of the error state file (Xe) :
```
$ sudo cp /sys/class/drm/card0/device/devcoredump/data /tmp/error
$ sudo chmod go+rw /tmp/error
```

Then visualize the error state (from the mesa build directory) :
```
$ ./src/intel/tools/aubinator_error_decode /tmp/error
```

# intel_stub_gpu

This tool allows faking a particular device at the ioctl level. This
is useful to test compiler changes (using shader-db/fossils-db
replays) across a number of device you don't necessarily have access
too.

Faking a DG2 device :
```
$ intel_stub_gpu -p dg2 fossilize-replay /path/to/fossilize.foz --enable-pipeline-stats /tmp/dg2.csv
```

Faking a ICL device :
```
$ intel_stub_gpu -p icl fossilize-replay /path/to/fossilize.foz --enable-pipeline-stats /tmp/icl.csv
```

# intel_error2hangdump

This tool converts an error state dump into an
uncompressed/easy-to-modify binary file (format described in
`src/intel/common/intel_hang_dump.h`).

Capture the error state (i915) :
```
$ sudo cp /sys/devices/pci0000:00/0000:00:02.0/drm/card0/error /tmp/error
$ sudo chmod go+rw /tmp/error
```
Capture the error state (Xe) :
```
$ sudo cp /sys/class/drm/card0/device/devcoredump/data /tmp/error
$ sudo chmod go+rw /tmp/error
```

Convert an error state (from the mesa build directory) :
```
$ ./src/intel/tools/intel_error2hang /tmp/error
```

A resulting `error.dmp` file will be created

# intel_hang_replay

This tool replays a binary file generated by `intel_error2hangdump`.

From the mesa build directory :
```
$ ./src/intel/tools/intel_hang_replay -d /tmp/error.dmp
```

# intel_hang_viewer

This tool is a editor/visualizer for the file generated by
`intel_error2hangdump`. When replaying on simulation a few tweaks
might be needed in order for the simulator to accept the input
commands (this is due to divergences between the simulation & HW
implementations).

To visualize a file generated from a DG2 error state (from the mesa
build directory) :
```
./src/intel/tools/intel_hang_viewer -p dg2 /tmp/error.dmp
```

To visualize and edit a file generated from a DG2 error state (from the mesa
build directory) :
```
./src/intel/tools/intel_hang_viewer -e -p dg2 /tmp/error.dmp
```
