#ifndef INCLUDE_PBBLIST_H
#define INCLUDE_PBBLIST_H
/* ----------------------------------------------------------------------------
 * pbblist.h
 * prototypes and definitions for double linked lists
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

struct listnode {
	struct listnode *next;
	struct listnode *pred;
	int datalen;              /* length of buffer behind node structure */
};

struct listhead {
	struct listnode *first;
	struct listnode *tail;     /* always NULL */
	struct listnode *tailpred;
};

/* prototypes */
void initListHeader (struct listhead *lh);
void appendListNode (struct listhead *lh, struct listnode *ln);
struct listnode *removeListNode (struct listnode *ln);
void freeListNode (struct listnode *ln);
void freeList (struct listhead *lh);

struct listnode *newListNode (int datalen);
void *getNodeData (struct listnode *ln);
void *getNodeDataEnd (struct listnode *ln);
int getNodeCount (struct listhead *lh);

#endif    /* INCLUDE_PBBLIST_H */

