import json

# https://raw.githubusercontent.com/whatwg/encoding/master/encodings.json
with open("encodings.json") as f:
    s = json.loads(f.read())

print "// autogenerated by /tools/encodings/gen-encoding-aliases.py\n"

for gr in s:
    print "// {}".format((gr["heading"]))

    for dst in gr["encodings"]:
        dst_enc = dst["name"]

        print '{{ "{}", "{}" }},'.format(dst_enc, dst_enc)
        for src_enc in dst["labels"]:
            print '{{ "{}", "{}" }},'.format(dst_enc, src_enc)

    print ""
