/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.FastGenotype;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;

@Invariant(value={"alleles != null"})
public final class GenotypeBuilder {
    private static final List<Allele> HAPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL);
    private static final List<Allele> DIPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private String sampleName = null;
    private List<Allele> alleles = Collections.emptyList();
    private boolean isPhased = false;
    private int GQ = -1;
    private int DP = -1;
    private int[] AD = null;
    private int[] PL = null;
    private Map<String, Object> extendedAttributes = null;
    private String filters = null;
    private int initialAttributeMapSize = 5;
    private static final Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap(0));

    public static Genotype create(String sampleName, List<Allele> alleles) {
        return new GenotypeBuilder(sampleName, alleles).make();
    }

    public static Genotype create(String sampleName, List<Allele> alleles, Map<String, Object> attributes) {
        return new GenotypeBuilder(sampleName, alleles).attributes(attributes).make();
    }

    protected static Genotype create(String sampleName, List<Allele> alleles, double[] gls) {
        return new GenotypeBuilder(sampleName, alleles).PL(gls).make();
    }

    public static Genotype createMissing(String sampleName, int ploidy) {
        GenotypeBuilder builder = new GenotypeBuilder(sampleName);
        switch (ploidy) {
            case 1: {
                builder.alleles(HAPLOID_NO_CALL);
                break;
            }
            case 2: {
                builder.alleles(DIPLOID_NO_CALL);
                break;
            }
            default: {
                builder.alleles(Collections.nCopies(ploidy, Allele.NO_CALL));
            }
        }
        return builder.make();
    }

    public GenotypeBuilder() {
    }

    public GenotypeBuilder(String sampleName) {
        this.name(sampleName);
    }

    public GenotypeBuilder(String sampleName, List<Allele> alleles) {
        this.name(sampleName);
        this.alleles(alleles);
    }

    public GenotypeBuilder(Genotype g) {
        this.copy(g);
    }

    public GenotypeBuilder copy(Genotype g) {
        this.name(g.getSampleName());
        this.alleles(g.getAlleles());
        this.phased(g.isPhased());
        this.GQ(g.getGQ());
        this.DP(g.getDP());
        this.AD(g.getAD());
        this.PL(g.getPL());
        this.filter(g.getFilters());
        this.attributes(g.getExtendedAttributes());
        return this;
    }

    public final void reset(boolean keepSampleName) {
        if (!keepSampleName) {
            this.sampleName = null;
        }
        this.alleles = Collections.emptyList();
        this.isPhased = false;
        this.GQ = -1;
        this.DP = -1;
        this.AD = null;
        this.PL = null;
        this.filters = null;
        this.extendedAttributes = null;
    }

    @Ensures(value={"result != null"})
    public Genotype make() {
        Map<String, Object> ea = this.extendedAttributes == null ? NO_ATTRIBUTES : this.extendedAttributes;
        return new FastGenotype(this.sampleName, this.alleles, this.isPhased, this.GQ, this.DP, this.AD, this.PL, this.filters, ea);
    }

    @Requires(value={"sampleName != null"})
    @Ensures(value={"this.sampleName != null"})
    public GenotypeBuilder name(String sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    @Ensures(value={"this.alleles != null"})
    public GenotypeBuilder alleles(List<Allele> alleles) {
        this.alleles = alleles == null ? Collections.emptyList() : alleles;
        return this;
    }

    public GenotypeBuilder phased(boolean phased) {
        this.isPhased = phased;
        return this;
    }

    @Requires(value={"GQ >= -1"})
    @Ensures(value={"this.GQ == GQ", "this.GQ >= -1"})
    public GenotypeBuilder GQ(int GQ) {
        this.GQ = GQ;
        return this;
    }

    @Deprecated
    public GenotypeBuilder log10PError(double pLog10Error) {
        if (pLog10Error == 1.0) {
            return this.GQ(-1);
        }
        return this.GQ((int)Math.round(pLog10Error * -10.0));
    }

    public GenotypeBuilder noGQ() {
        this.GQ = -1;
        return this;
    }

    public GenotypeBuilder noAD() {
        this.AD = null;
        return this;
    }

    public GenotypeBuilder noDP() {
        this.DP = -1;
        return this;
    }

    public GenotypeBuilder noPL() {
        this.PL = null;
        return this;
    }

    @Requires(value={"DP >= -1"})
    @Ensures(value={"this.DP == DP"})
    public GenotypeBuilder DP(int DP) {
        this.DP = DP;
        return this;
    }

    @Requires(value={"AD == null || AD.length > 0"})
    @Ensures(value={"this.AD == AD"})
    public GenotypeBuilder AD(int[] AD) {
        this.AD = AD;
        return this;
    }

    @Requires(value={"PL == null || PL.length > 0"})
    @Ensures(value={"this.PL == PL"})
    public GenotypeBuilder PL(int[] PL) {
        this.PL = PL;
        return this;
    }

    @Requires(value={"PL == null || PL.length > 0"})
    @Ensures(value={"this.PL == PL"})
    public GenotypeBuilder PL(double[] GLs) {
        this.PL = GenotypeLikelihoods.fromLog10Likelihoods(GLs).getAsPLs();
        return this;
    }

    @Requires(value={"attributes != null"})
    @Ensures(value={"attributes.isEmpty() || extendedAttributes != null"})
    public GenotypeBuilder attributes(Map<String, Object> attributes) {
        for (Map.Entry<String, Object> pair : attributes.entrySet()) {
            this.attribute(pair.getKey(), pair.getValue());
        }
        return this;
    }

    public GenotypeBuilder noAttributes() {
        this.extendedAttributes = null;
        return this;
    }

    @Requires(value={"key != null"})
    @Ensures(value={"extendedAttributes != null", "extendedAttributes.containsKey(key)"})
    public GenotypeBuilder attribute(String key, Object value) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new HashMap<String, Object>(this.initialAttributeMapSize);
        }
        this.extendedAttributes.put(key, value);
        return this;
    }

    @Requires(value={"filters != null"})
    public GenotypeBuilder filters(List<String> filters) {
        if (filters.isEmpty()) {
            return this.filter(null);
        }
        if (filters.size() == 1) {
            return this.filter(filters.get(0));
        }
        return this.filter(ParsingUtils.join((String)";", (Collection)ParsingUtils.sortList(filters)));
    }

    @Requires(value={"filters != null"})
    public GenotypeBuilder filters(String ... filters) {
        return this.filters(Arrays.asList(filters));
    }

    public GenotypeBuilder filter(String filter) {
        this.filters = "PASS".equals(filter) ? null : filter;
        return this;
    }

    public GenotypeBuilder unfiltered() {
        return this.filter(null);
    }

    public GenotypeBuilder maxAttributes(int i) {
        this.initialAttributeMapSize = i;
        return this;
    }
}

