# IGV 2.4.x

**Java 8 is now required.** IGV 2.4 requires Java version 8 to run. The latest version of Java can be downloaded from https://java.com/en/download/. Note that older versions of IGV are always available via the Archived Versions link on the IGV Downloads page.

## IGV 2.4  Initial release: September 2017

**1. Support for PacBio long-read sequencing data.** PacBio reads are long (up to 50kb) and have a high rate of small random errors that can clutter the view. However, because the errors are random, quality is extremely high in a consensus of independent reads and a mismatch that is consistent across reads indicate biological variation. IGV has two new features to filter the errors from view:

* **Consensus Mode** shows mismatches only at positions where a significant number of reads do not match the reference (`Preferences > Alignments` tab).
* **Hide Indels** suppresses small indels, the most common error in raw PacBio reads (`Preferences > Alignments` tab).
Other related new features introduced in this release: 

Label large insertions and deletions (`Preferences > Alignments` tab).
Group alignments by base to aid in the exploration of haplotype phase (right-click popup menu in alignment tracks).
​​While the above new features were introduced to support PacBio data, they can be used when viewing alignment data from any data source.

We thank Aaron Wenger at Pacific BioSciences for his code contributions.

**2. Support for 10X Genomics sequencing data.** With the 10X Genomics platform, molecules are barcoded before they are sequenced with standard short read sequencing. The downstream 10X software pipeline digitally recovers the longer molecule from the short reads and their associated barcode information. IGV 2.4 includes a new feature to view aligned reads linked by the 10X barcode sequence (BX) or molecular identifier (MI) (right-click popup menu in alignment tracks). The 10X pipeline also computes the phase and IGV can separate the reads and color them by haplotype tag (HP) if present in the data file. The view in IGV is modeled on the Linked-Read view in 10X’s _Loupe_ software.

**3. Alignment coloring.** Coloring by “YC” tag can now be explicitly enabled and disabled through the `Color By` option of the alignment track pop-up menu. The menu item `Color By YC Tag` will appear, selected by default, if YC tags are used

**4. Support for CRAM files.** IGV 2.4 supports loading sequencing data in CRAM 3.0 format (http://samtools.github.io/hts-specs/CRAMv3.pdf). A corresponding index file is required. By convention, the index file name should be the same as the data file name, with “.crai” appended. For example, if the data file is named `example_xyz.cram`, the index file should be named `example_xyz.cram.crai` or `example_xyz.crai`.

Due to the nature of the CRAM format, the first time the IGV view is zoomed in to load alignments for a particular chromosome, the reference sequence for that whole chromosome is loaded into IGV memory. If loading across the internet, this may take up to 10s of seconds. IGV will cache the chromosome sequence data to optimize performance for subsequent views. Note that the alignments themselves are loaded only as required for the region in view.  The cache size is set by default to 500 MB.  To adjust the size, or disable caching, see the `Preferences > CRAM` tab.

Note: When viewing CRAM files, an error will result if the selected reference genome is not the same as the reference genome used in the creation of the CRAM file. The error message may refer to a _reference sequence MD5 mismatch for slice_.    

**5. Managing genomes.** The user interface for managing the genomes dropdown menu in the IGV window has been simplified and improved. 

* To **add a hosted genome** to the menu: Either click on the `More...` entry at the bottom of the menu or select `Genomes > Load Genome from Server`. This will bring up a list of all the genomes on the server to choose from. Select the one you would like to add, and optionally check the `Download sequence` box to download a FASTA file of the whole genome sequence for offline use. All available genomes are listed, even those that have already been loaded into the local menu. This is in case you want to now download the sequence for a genome already in the menu. Note that a downloadable FASTA file is not available for all hosted genomes. A notice will pop up if you try to download a sequence that is not available.

* Adding other genomes from a file or a URL has not changed: Select `Genomes > Load Genome from File` or `Genomes > Load Genome from URL`.

* To **remove a genome** from the menu: `Select Genomes > Remove genomes`. This will bring up a list of all the genomes in the menu, except the currently viewed genome as it cannot be removed. To remove the currently viewed genome, first switch the view to a different genome. 
 
## IGV 2.4.1   September 2017

Fixed problem with the details pop-up window not showing up.

