/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.data.Index;
import org.fest.swing.driver.JTabbedPaneDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTabbedPaneFixture
extends ComponentFixture<JTabbedPane>
implements CommonComponentFixture,
JComponentFixture,
JPopupMenuInvokerFixture {
    private JTabbedPaneDriver driver;

    public JTabbedPaneFixture(Robot robot, JTabbedPane target) {
        super(robot, target);
        this.createDriver();
    }

    public JTabbedPaneFixture(Robot robot, String tabbedPaneName) {
        super(robot, tabbedPaneName, JTabbedPane.class);
        this.createDriver();
    }

    private void createDriver() {
        this.driver(new JTabbedPaneDriver(this.robot));
    }

    protected final void driver(JTabbedPaneDriver newDriver) {
        JTabbedPaneFixture.validateNotNull(newDriver);
        this.driver = newDriver;
    }

    public String[] tabTitles() {
        return this.driver.tabTitles((JTabbedPane)this.target);
    }

    public JTabbedPaneFixture selectTab(int index) {
        this.driver.selectTab((JTabbedPane)this.target, index);
        return this;
    }

    public JTabbedPaneFixture selectTab(String title) {
        this.driver.selectTab((JTabbedPane)this.target, title);
        return this;
    }

    public JTabbedPaneFixture selectTab(Pattern pattern) {
        this.driver.selectTab((JTabbedPane)this.target, pattern);
        return this;
    }

    public Component selectedComponent() {
        return this.driver.selectedComponentOf((JTabbedPane)this.target);
    }

    @Override
    public JTabbedPaneFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JTabbedPaneFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JTabbedPaneFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JTabbedPaneFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JTabbedPaneFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTabbedPaneFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    public JTabbedPaneFixture requireTitle(String title, Index index) {
        this.driver.requireTabTitle((JTabbedPane)this.target, title, index);
        return this;
    }

    public JTabbedPaneFixture requireTitle(Pattern pattern, Index index) {
        this.driver.requireTabTitle((JTabbedPane)this.target, pattern, index);
        return this;
    }

    public JTabbedPaneFixture requireTabTitles(String ... titles) {
        this.driver.requireTabTitles((JTabbedPane)this.target, titles);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireToolTip(String expected) {
        this.driver.requireToolTip((JComponent)this.target, expected);
        return this;
    }

    @Override
    public JTabbedPaneFixture requireToolTip(Pattern pattern) {
        this.driver.requireToolTip((JComponent)this.target, pattern);
        return this;
    }

    @Override
    public Object clientProperty(Object key) {
        return this.driver.clientProperty((JComponent)this.target, key);
    }

    @Override
    public JPopupMenuFixture showPopupMenu() {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target));
    }

    @Override
    public JPopupMenuFixture showPopupMenuAt(Point p) {
        return new JPopupMenuFixture(this.robot, this.driver.invokePopupMenu(this.target, p));
    }
}

