/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.xml;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public final class XhtmlProcessing {
    protected static void processElement(String string, String string2, Attributes attributes, HtmlMetadata htmlMetadata) {
        if ("html".equals(string)) {
            XhtmlProcessing.processHtml(htmlMetadata, attributes);
        } else if ("meta".equals(string)) {
            XhtmlProcessing.processMeta(htmlMetadata, attributes);
        } else if ("a".equals(string)) {
            XhtmlProcessing.processA(htmlMetadata, attributes);
        } else if ("img".equals(string)) {
            XhtmlProcessing.processImg(htmlMetadata, attributes);
        } else if ("frame".equals(string)) {
            XhtmlProcessing.processFrame(htmlMetadata, attributes);
        } else if ("script".equals(string)) {
            XhtmlProcessing.processScript(htmlMetadata, attributes);
        } else if ("abbr".equals(string)) {
            XhtmlProcessing.processAbbr(htmlMetadata, attributes);
        } else if ("title".equals(string)) {
            XhtmlProcessing.processTitle(htmlMetadata, attributes);
        } else if ("cite".equals(string)) {
            XhtmlProcessing.processCite(htmlMetadata, attributes);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            if (!"lang".equals(string3) || string4 == null) continue;
            htmlMetadata.addLanguage(string4);
        }
    }

    private static void processHtml(HtmlMetadata htmlMetadata, Attributes attributes) {
        String string = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            if (!"lang".equals(string2)) continue;
            string = string3;
        }
        if (string != null) {
            htmlMetadata.setLanguage(string);
        }
    }

    private static void processMeta(HtmlMetadata htmlMetadata, Attributes attributes) {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getLocalName(i);
            String string5 = attributes.getValue(i);
            if ("name".equals(string4)) {
                string = string5;
            }
            if ("http-equiv".equals(string4)) {
                string2 = string5;
            }
            if (!"content".equals(string4)) continue;
            string3 = string5;
        }
        if (string != null || string2 != null || string3 != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>(3);
            if (string != null) {
                arrayList.add(new Property("Name", PropertyType.STRING, string));
            }
            if (string2 != null) {
                arrayList.add(new Property("Httpequiv", PropertyType.STRING, string2));
            }
            if (string3 != null) {
                arrayList.add(new Property("Content", PropertyType.STRING, string3));
            }
            htmlMetadata.addMeta(new Property("Meta", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
    }

    private static void processA(HtmlMetadata htmlMetadata, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (!"href".equals(string)) continue;
            String string3 = string2;
            if (string3.length() <= 0 || string3.charAt(0) == '#') break;
            htmlMetadata.addLink(string3);
            break;
        }
    }

    private static void processImg(HtmlMetadata htmlMetadata, Attributes attributes) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getLocalName(i);
            String string5 = attributes.getValue(i);
            if ("alt".equals(string4)) {
                string = string5;
                continue;
            }
            if ("src".equals(string4)) {
                string3 = string5;
                continue;
            }
            if ("longdesc".equals(string4)) {
                string2 = string5;
                continue;
            }
            if ("height".equals(string4)) {
                try {
                    n = Integer.parseInt(string5);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"width".equals(string4)) continue;
            try {
                n2 = Integer.parseInt(string5);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(5);
        if (string != null) {
            arrayList.add(new Property("Alt", PropertyType.STRING, string));
        }
        if (string2 != null) {
            arrayList.add(new Property("Longdesc", PropertyType.STRING, string2));
        }
        if (string3 != null) {
            arrayList.add(new Property("Src", PropertyType.STRING, string3));
        }
        if (n >= 0) {
            arrayList.add(new Property("Height", PropertyType.INTEGER, new Integer(n)));
        }
        if (n2 >= 0) {
            arrayList.add(new Property("Width", PropertyType.INTEGER, new Integer(n2)));
        }
        if (!arrayList.isEmpty()) {
            htmlMetadata.addImage(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
    }

    private static void processFrame(HtmlMetadata htmlMetadata, Attributes attributes) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            String string6 = attributes.getValue(i);
            if ("name".equals(string5)) {
                string = string6;
                continue;
            }
            if ("title".equals(string5)) {
                string2 = string6;
                continue;
            }
            if ("src".equals(string5)) {
                string3 = string6;
                continue;
            }
            if (!"longdesc".equals(string5)) continue;
            string4 = string6;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        if (string != null) {
            arrayList.add(new Property("Name", PropertyType.STRING, string));
        }
        if (string2 != null) {
            arrayList.add(new Property("Title", PropertyType.STRING, string2));
        }
        if (string4 != null) {
            arrayList.add(new Property("Longdesc", PropertyType.STRING, string4));
        }
        if (string3 != null) {
            arrayList.add(new Property("Src", PropertyType.STRING, string3));
        }
        if (!arrayList.isEmpty()) {
            htmlMetadata.addFrame(new Property("Frame", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
    }

    private static void processScript(HtmlMetadata htmlMetadata, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string;
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            if (!"type".equals(string2) || (string = string3).length() <= 0) continue;
            htmlMetadata.addScript(string);
        }
    }

    private static void processAbbr(HtmlMetadata htmlMetadata, Attributes attributes) {
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        Property property = new Property("abbr", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (!"title".equals(string) || string2.length() <= 0) continue;
            arrayList.add(new Property("title", PropertyType.STRING, string2));
        }
        htmlMetadata.setPropUnderConstruction(property);
    }

    private static void processTitle(HtmlMetadata htmlMetadata, Attributes attributes) {
        Property property = new Property("title", PropertyType.STRING, "");
        htmlMetadata.setPropUnderConstruction(property);
    }

    private static void processCite(HtmlMetadata htmlMetadata, Attributes attributes) {
        Property property = new Property("cite", PropertyType.STRING, "");
        htmlMetadata.setPropUnderConstruction(property);
    }
}

