; Script generated by the HM NIS Edit Script Wizard.

SetCompressor /SOLID lzma

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "KCemu"
!define PRODUCT_VERSION "0.5.1"
!define PRODUCT_PUBLISHER "Torsten Paul"
!define PRODUCT_WEB_SITE "http://kcemu.sourceforge.net/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\kcemu.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "KCemu-0.5.1\COPYING"
; Components page
;!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\bin\kcemu.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\KCemu"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "!KCemu" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /r "kcemu\bin"
  File /r "kcemu\lib"
  File /r "kcemu\share"
  CreateShortCut "$DESKTOP\KCemu.lnk" "$INSTDIR\bin\kcemu.exe" '-P'
  CreateDirectory "$SMPROGRAMS\KCemu"
  CreateShortCut "$SMPROGRAMS\KCemu\KCemu.lnk"       "$INSTDIR\bin\kcemu.exe" '-P' "$INSTDIR\share\KCemu\icons\kcemu-winicon.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\BIC.lnk"         "$INSTDIR\bin\kcemu.exe" '-9' "$INSTDIR\share\KCemu\icons\kcemu-bic.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC85 - 1.lnk"    "$INSTDIR\bin\kcemu.exe" '-1' "$INSTDIR\share\KCemu\icons\kcemu-kc87.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC85 - 2.lnk"    "$INSTDIR\bin\kcemu.exe" '-2' "$INSTDIR\share\KCemu\icons\kcemu-kc85.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC85 - 3.lnk"    "$INSTDIR\bin\kcemu.exe" '-3' "$INSTDIR\share\KCemu\icons\kcemu-kc85.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC85 - 4.lnk"    "$INSTDIR\bin\kcemu.exe" '-4' "$INSTDIR\share\KCemu\icons\kcemu-kc85.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC85 - 5.lnk"    "$INSTDIR\bin\kcemu.exe" '-5' "$INSTDIR\share\KCemu\icons\kcemu-kc85.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\KC87.lnk"        "$INSTDIR\bin\kcemu.exe" '-7' "$INSTDIR\share\KCemu\icons\kcemu-kc87.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\LC80.lnk"        "$INSTDIR\bin\kcemu.exe" '-8' "$INSTDIR\share\KCemu\icons\kcemu-lc80.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\Poly880.lnk"     "$INSTDIR\bin\kcemu.exe" '-6' "$INSTDIR\share\KCemu\icons\kcemu-poly880.ico"
  CreateShortCut "$SMPROGRAMS\KCemu\Z1013.lnk"       "$INSTDIR\bin\kcemu.exe" '-0' "$INSTDIR\share\KCemu\icons\kcemu-z1013.ico"
SectionEnd

SectionGroup "GTK" SEC02
Section "-bin" SEC_GTK_01
  SetOutPath "$INSTDIR\bin"
  SetOverwrite try
  File "dist\bin\charset.dll"
  File "dist\bin\iconv.dll"
  File "dist\bin\iconv.exe"
  File "dist\bin\intl.dll"
  File "dist\bin\libatk-1.0-0.dll"
  File "dist\bin\libcairo-2.dll"
  File "dist\bin\libgailutil-18.dll"
  File "dist\bin\libgdk-win32-2.0-0.dll"
  File "dist\bin\libgdk_pixbuf-2.0-0.dll"
  File "dist\bin\libgio-2.0-0.dll"
  File "dist\bin\libglib-2.0-0.dll"
  File "dist\bin\libgmodule-2.0-0.dll"
  File "dist\bin\libgobject-2.0-0.dll"
  File "dist\bin\libgthread-2.0-0.dll"
  File "dist\bin\libgtk-win32-2.0-0.dll"
  File "dist\bin\libpango-1.0-0.dll"
  File "dist\bin\libpangocairo-1.0-0.dll"
  File "dist\bin\libpangoft2-1.0-0.dll"
  File "dist\bin\libpangowin32-1.0-0.dll"
  File "dist\bin\libpng12-0.dll"
  File "dist\bin\libjpeg-7.dll"
  File "dist\bin\libtiff-3.dll"
  File "dist\bin\libtiffxx-3.dll"
  File "dist\bin\freetype6.dll"
  File "dist\bin\libfontconfig-1.dll"
  File "dist\bin\libexpat-1.dll"
  File "dist\bin\pango-querymodules.exe"
  File "dist\bin\giflib4.dll"
  File "dist\bin\zlib1.dll"
  File "dist\bin\SDL.dll"
SectionEnd
Section "-etc\gtk-2.0" SEC_GTK_02
  SetOutPath "$INSTDIR\etc\gtk-2.0"
  SetOverwrite try
  File "dist\etc\gtk-2.0\gdk-pixbuf.loaders"
  File "dist\etc\gtk-2.0\gtk.immodules"
  File "dist\etc\gtk-2.0\gtkrc"
SectionEnd
Section "-etc\pango" SEC_GTK_03
  SetOutPath "$INSTDIR\etc\pango"
  SetOverwrite try
  File "dist\etc\pango\pango.modules"
SectionEnd
Section "-lib\gtk-2.0\2.10.0\engines" SEC_GTK_ENGINES
  SetOutPath "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
  SetOverwrite try
  File "dist\lib\gtk-2.0\2.10.0\engines\libpixmap.dll"
  File "dist\lib\gtk-2.0\2.10.0\engines\libwimp.dll"
SectionEnd
Section "-share\locale\de\LC_MESSAGES" SEC_GTK_06
  SetOutPath "$INSTDIR\share\locale\de\LC_MESSAGES"
  SetOverwrite try
  File "dist\share\locale\de\LC_MESSAGES\glib20.mo"
  File "dist\share\locale\de\LC_MESSAGES\gtk20.mo"
  File "dist\share\locale\de\LC_MESSAGES\gtk20-properties.mo"
  File "dist\share\locale\de\LC_MESSAGES\libiconv.mo"
SectionEnd
SectionGroupEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\KCemu\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\KCemu\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bin\kcemu.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\bin\kcemu.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "The KCemu program"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "The GTK+ library (http://www.gtk.org/)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\bin\kcemu.exe"
  Delete "$INSTDIR\bin\tdtodump.exe"
  Delete "$INSTDIR\bin\kctape.exe"
  Delete "$INSTDIR\bin\kc2raw.exe"
  Delete "$INSTDIR\bin\kc2wav.exe"
  Delete "$INSTDIR\bin\kc2tap.exe"
  Delete "$INSTDIR\bin\kc2img.exe"

  Delete "$INSTDIR\lib\charset.alias"

  Delete "$INSTDIR\share\man\man1\kc2img.1"
  Delete "$INSTDIR\share\man\man1\kc2raw.1"
  Delete "$INSTDIR\share\man\man1\kc2tap.1"
  Delete "$INSTDIR\share\man\man1\kc2wav.1"
  Delete "$INSTDIR\share\man\man1\kcemu-remote.1"
  Delete "$INSTDIR\share\man\man1\kcemu.1x"
  Delete "$INSTDIR\share\man\man1\kctape.1"
  Delete "$INSTDIR\share\man\man1\tdtodump.1"

  Delete "$INSTDIR\share\doc\kcemu\changelog"

  Delete "$INSTDIR\share\locale\locale.alias"
  Delete "$INSTDIR\share\locale\en\LC_MESSAGES\KCemu.mo"
  Delete "$INSTDIR\share\locale\de\LC_MESSAGES\KCemu.mo"

  Delete "$INSTDIR\share\KCemu\kcemurc"
  Delete "$INSTDIR\share\KCemu\.kcemurc"

  Delete "$INSTDIR\share\KCemu\asm\autostart\kc853.asm"

  Delete "$INSTDIR\share\KCemu\lib\z80\kc853.bin"

  Delete "$INSTDIR\share\KCemu\doc\kcemu-help.xml"
  Delete "$INSTDIR\share\KCemu\doc\kcemu.png"
  Delete "$INSTDIR\share\KCemu\doc\kcemurc.sample"
  Delete "$INSTDIR\share\KCemu\doc\sys-a5105.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-kc85.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-kc855.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-lc80.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-poly880.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-z1013.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-z9001.jpg"
  Delete "$INSTDIR\share\KCemu\doc\sys-xy4131.jpg"
  Delete "$INSTDIR\share\KCemu\doc\window-audio.png"
  Delete "$INSTDIR\share\KCemu\doc\window-disk.png"
  Delete "$INSTDIR\share\KCemu\doc\window-colors.png"
  Delete "$INSTDIR\share\KCemu\doc\window-module-kc85.png"
  Delete "$INSTDIR\share\KCemu\doc\window-module-z1013.png"
  Delete "$INSTDIR\share\KCemu\doc\window-module-z9001.png"
  Delete "$INSTDIR\share\KCemu\doc\window-tape.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-1.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-1_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-2.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-2_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-3.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-3_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-4.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-4_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-5.png"
  Delete "$INSTDIR\share\KCemu\doc\window-profile-5_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-savemem.png"
  Delete "$INSTDIR\share\KCemu\doc\window-savemem_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-select-profile.png"
  Delete "$INSTDIR\share\KCemu\doc\window-select-profile_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-plotter-1.png"
  Delete "$INSTDIR\share\KCemu\doc\window-plotter-1_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-plotter-2.png"
  Delete "$INSTDIR\share\KCemu\doc\window-plotter-2_small.png"
  Delete "$INSTDIR\share\KCemu\doc\window-video.png"
  Delete "$INSTDIR\share\KCemu\doc\window-screenshot.png"

  Delete "$INSTDIR\share\KCemu\images\kcemu.png"
  Delete "$INSTDIR\share\KCemu\images\logo-flac.png"
  Delete "$INSTDIR\share\KCemu\images\logo-gtk.png"
  Delete "$INSTDIR\share\KCemu\images\logo-lame.png"
  Delete "$INSTDIR\share\KCemu\images\logo-libsdl.png"
  Delete "$INSTDIR\share\KCemu\images\logo-libsndfile.png"
  Delete "$INSTDIR\share\KCemu\images\logo-openclipartlibrary.png"
  Delete "$INSTDIR\share\KCemu\images\logo-vorbisdotcom.png"
  Delete "$INSTDIR\share\KCemu\images\logo-theora_org.png"
  Delete "$INSTDIR\share\KCemu\images\logo-ffmpeg.png"
  Delete "$INSTDIR\share\KCemu\images\logo-xvid.png"
  Delete "$INSTDIR\share\KCemu\images\logo-bbc.png"
  Delete "$INSTDIR\share\KCemu\images\media-end.png"
  Delete "$INSTDIR\share\KCemu\images\media-play.png"
  Delete "$INSTDIR\share\KCemu\images\media-record.png"
  Delete "$INSTDIR\share\KCemu\images\media-start.png"
  Delete "$INSTDIR\share\KCemu\images\media-stop.png"
  Delete "$INSTDIR\share\KCemu\images\media-pause.png"
  Delete "$INSTDIR\share\KCemu\images\window-about.png"
  Delete "$INSTDIR\share\KCemu\images\window-audio.png"
  Delete "$INSTDIR\share\KCemu\images\window-copying.png"
  Delete "$INSTDIR\share\KCemu\images\window-disk.png"
  Delete "$INSTDIR\share\KCemu\images\window-help.png"
  Delete "$INSTDIR\share\KCemu\images\window-info.png"
  Delete "$INSTDIR\share\KCemu\images\window-module.png"
  Delete "$INSTDIR\share\KCemu\images\window-question.png"
  Delete "$INSTDIR\share\KCemu\images\window-tape.png"
  Delete "$INSTDIR\share\KCemu\images\window-thanks.png"
  Delete "$INSTDIR\share\KCemu\images\window-color.png"
  Delete "$INSTDIR\share\KCemu\images\window-keyboard.png"
  Delete "$INSTDIR\share\KCemu\images\window-options.png"
  Delete "$INSTDIR\share\KCemu\images\window-video.png"
  Delete "$INSTDIR\share\KCemu\images\window-selector.png"
  Delete "$INSTDIR\share\KCemu\images\window-plotter.png"
  Delete "$INSTDIR\share\KCemu\images\window-screenshot.png"

  Delete "$INSTDIR\share\KCemu\images\about.glade"
  Delete "$INSTDIR\share\KCemu\images\audio.glade"
  Delete "$INSTDIR\share\KCemu\images\color.glade"
  Delete "$INSTDIR\share\KCemu\images\dialog.glade"
  Delete "$INSTDIR\share\KCemu\images\disk.glade"
  Delete "$INSTDIR\share\KCemu\images\help.glade"
  Delete "$INSTDIR\share\KCemu\images\keyboard.glade"
  Delete "$INSTDIR\share\KCemu\images\legal.glade"
  Delete "$INSTDIR\share\KCemu\images\main.glade"
  Delete "$INSTDIR\share\KCemu\images\module.glade"
  Delete "$INSTDIR\share\KCemu\images\options.glade"
  Delete "$INSTDIR\share\KCemu\images\selector.glade"
  Delete "$INSTDIR\share\KCemu\images\tapeedit.glade"
  Delete "$INSTDIR\share\KCemu\images\tape.glade"
  Delete "$INSTDIR\share\KCemu\images\thanks.glade"
  Delete "$INSTDIR\share\KCemu\images\savemem.glade"
  Delete "$INSTDIR\share\KCemu\images\video.glade"
  Delete "$INSTDIR\share\KCemu\images\plotter.glade"
  Delete "$INSTDIR\share\KCemu\images\vdip.glade"
  Delete "$INSTDIR\share\KCemu\images\screenshot.glade"

  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_20.rom"
  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_a2.rom"
  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_rb.rom"
  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_ul.rom"
  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_bl.rom"
  Delete "$INSTDIR\share\KCemu\roms\z1013\z1013_zg.rom"

  Delete "$INSTDIR\share\KCemu\roms\z9001\192k__d2.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\192k__d3.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\192k__d5.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\basic_c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\basic_c0.87a"
  Delete "$INSTDIR\share\KCemu\roms\z9001\basic_c0.87b"
  Delete "$INSTDIR\share\KCemu\roms\z9001\bitex_c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\cpmz9_c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\edas__c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\idas__c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\os____f0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\os____f0.87b"
  Delete "$INSTDIR\share\KCemu\roms\z9001\r80___c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\rom_bank.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\zm30__c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\zsid__c0.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\kcpascal.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\mega_rom.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\os_rb20.rom"
  Delete "$INSTDIR\share\KCemu\roms\z9001\os_rb21.rom"
  Delete "$INSTDIR\share\KCemu\roms\z9001\chargen.851"
  Delete "$INSTDIR\share\KCemu\roms\z9001\kc_caos.rom"
  Delete "$INSTDIR\share\KCemu\roms\z9001\zg_cga.rom"
  Delete "$INSTDIR\share\KCemu\roms\z9001\zg_cgai.rom"
  Delete "$INSTDIR\share\KCemu\roms\z9001\zg_de.rom"

  Delete "$INSTDIR\share\KCemu\roms\kc85\hc900.852"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__e0.852"
  Delete "$INSTDIR\share\KCemu\roms\kc85\basic_c0.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__e0.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos33.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos34.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\pi88_ge.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\pi88_sw.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\pi88_ws.853"
  Delete "$INSTDIR\share\KCemu\roms\kc85\basic_c0.854"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__c0.854"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__e0.854"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos41c.854"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos41e.854"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos43c.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos43e.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\basic_c0.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\basicusb.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__c0.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\caos__e0.855"
  Delete "$INSTDIR\share\KCemu\roms\kc85\floppy20.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\floppy30.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\floppy31.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\floppy32.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m006.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m012.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m026.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m027.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m033.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m052.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m900.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\m901.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\vdip12.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\vdip2_42.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\vdip2_44.rom"
  Delete "$INSTDIR\share\KCemu\roms\kc85\vdip21.rom"

  Delete "$INSTDIR\share\KCemu\roms\poly880\poly880a.rom"
  Delete "$INSTDIR\share\KCemu\roms\poly880\poly880b.rom"
  Delete "$INSTDIR\share\KCemu\roms\poly880\sc1.rom"

  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80__00.rom"
  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80__08.rom"
  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80__2k.rom"
  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80e_00.rom"
  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80e_10.rom"
  Delete "$INSTDIR\share\KCemu\roms\lc80\lc80e_c0.rom"

  Delete "$INSTDIR\share\KCemu\roms\a5105\k1505_00.rom"
  Delete "$INSTDIR\share\KCemu\roms\a5105\k1505_80.rom"
  Delete "$INSTDIR\share\KCemu\roms\a5105\k5651_40.rom"
  Delete "$INSTDIR\share\KCemu\roms\a5105\k5651_60.rom"

  Delete "$INSTDIR\share\KCemu\roms\kramermc\ass.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\basic.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\chargen.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\debugger.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\editor.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\io-mon.kmc"
  Delete "$INSTDIR\share\KCemu\roms\kramermc\reass.kmc"

  Delete "$INSTDIR\share\KCemu\roms\muglerpc\chargen.pcm"
  Delete "$INSTDIR\share\KCemu\roms\muglerpc\muglerpc.pcm"

  Delete "$INSTDIR\share\KCemu\roms\vcs80\monitor.rom"

  Delete "$INSTDIR\share\KCemu\roms\c80\monitor.rom"

  Delete "$INSTDIR\share\KCemu\icons\icon-default.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-deleted.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-root.png"

  Delete "$INSTDIR\share\KCemu\icons\kcemu-winicon.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-winicon_16x16.png"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-winicon_32x32.png"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-winicon_48x48.png"

  Delete "$INSTDIR\share\KCemu\icons\kcemu-bic.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kc85.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kc87.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-lc80.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-poly880.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-z1013.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kramermc.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-pcm.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-vcs80.ico"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-c80.ico"

  Delete "$INSTDIR\share\KCemu\icons\icon-bic.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-kc85.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-kc87.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-lc80.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-poly880.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-z1013.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-kramermc.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-pcm.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-vcs80.png"
  Delete "$INSTDIR\share\KCemu\icons\icon-c80.png"

  Delete "$INSTDIR\share\KCemu\icons\kcemu-icon.png"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-icon.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-bic.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kc85.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kc87.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-lc80.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-poly880.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-z1013.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-kramermc.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-pcm.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-vcs80.xpm"
  Delete "$INSTDIR\share\KCemu\icons\kcemu-c80.xpm"

  Delete "$INSTDIR\share\KCemu\keymaps\kc851.key"
  Delete "$INSTDIR\share\KCemu\keymaps\kc851_keyboard.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\kc851_keyboard_pressed.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\kc854.key"
  Delete "$INSTDIR\share\KCemu\keymaps\kc854_keyboard.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\kc854_keyboard_pressed.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\lc80.key"
  Delete "$INSTDIR\share\KCemu\keymaps\lc80_keyboard.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\lc80_keyboard_pressed.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\poly880.key"
  Delete "$INSTDIR\share\KCemu\keymaps\poly880_keyboard.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\poly880_keyboard_pressed.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\vcs80.key"
  Delete "$INSTDIR\share\KCemu\keymaps\vcs80_keyboard.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\vcs80_keyboard_pressed.xpm"
  Delete "$INSTDIR\share\KCemu\keymaps\a5105.key"
  Delete "$INSTDIR\share\KCemu\keymaps\a5105_keyboard.png"
  Delete "$INSTDIR\share\KCemu\keymaps\a5105_keyboard_pressed.png"

  Delete "$INSTDIR\share\KCemu\disks\a5105sys.dump"
  Delete "$INSTDIR\share\KCemu\disks\caos.dump"
  Delete "$INSTDIR\share\KCemu\disks\cpmz9.dump"
  Delete "$INSTDIR\share\KCemu\disks\microdos.dump"
  Delete "$INSTDIR\share\KCemu\disks\tools.dump"
  Delete "$INSTDIR\share\KCemu\disks\z1013cpm.dump"
  Delete "$INSTDIR\share\KCemu\disks\z1013gdc.dump"

  Delete "$INSTDIR\share\KCemu\tapes\files.kct"
  Delete "$INSTDIR\share\KCemu\tapes\z1013.kct"
  Delete "$INSTDIR\share\KCemu\tapes\lc80.kct"

  Delete "$INSTDIR\share\KCemu\config\a5105.conf"
  Delete "$INSTDIR\share\KCemu\config\c80.conf"
  Delete "$INSTDIR\share\KCemu\config\default.conf"
  Delete "$INSTDIR\share\KCemu\config\kc85-1.conf"
  Delete "$INSTDIR\share\KCemu\config\kc85-2.conf"
  Delete "$INSTDIR\share\KCemu\config\kc85-3.conf"
  Delete "$INSTDIR\share\KCemu\config\kc85-4.conf"
  Delete "$INSTDIR\share\KCemu\config\kc85-5.conf"
  Delete "$INSTDIR\share\KCemu\config\kc87.conf"
  Delete "$INSTDIR\share\KCemu\config\kramermc.conf"
  Delete "$INSTDIR\share\KCemu\config\lc80.conf"
  Delete "$INSTDIR\share\KCemu\config\pcm.conf"
  Delete "$INSTDIR\share\KCemu\config\poly880.conf"
  Delete "$INSTDIR\share\KCemu\config\vcs80.conf"
  Delete "$INSTDIR\share\KCemu\config\z1013.conf"

  Delete "$SMPROGRAMS\KCemu\Uninstall.lnk"
  Delete "$SMPROGRAMS\KCemu\Website.lnk"
  Delete "$DESKTOP\KCemu.lnk"
  
  Delete "$SMPROGRAMS\KCemu\BIC.lnk"
  Delete "$SMPROGRAMS\KCemu\KC85 - 1.lnk"
  Delete "$SMPROGRAMS\KCemu\KC85 - 2.lnk"
  Delete "$SMPROGRAMS\KCemu\KC85 - 3.lnk"
  Delete "$SMPROGRAMS\KCemu\KC85 - 4.lnk"
  Delete "$SMPROGRAMS\KCemu\KC85 - 5.lnk"
  Delete "$SMPROGRAMS\KCemu\KC87.lnk"
  Delete "$SMPROGRAMS\KCemu\LC80.lnk"
  Delete "$SMPROGRAMS\KCemu\Poly880.lnk"
  Delete "$SMPROGRAMS\KCemu\Z1013.lnk"
  Delete "$SMPROGRAMS\KCemu\Z1013 (BL4).lnk"
  Delete "$SMPROGRAMS\KCemu\KramerMC.lnk"
  Delete "$SMPROGRAMS\KCemu\PCM.lnk"
  Delete "$SMPROGRAMS\KCemu\VCS80.lnk"
  Delete "$DESKTOP\KCemu.lnk"

  # GTK START

  Delete "$INSTDIR\bin\charset.dll"
  Delete "$INSTDIR\bin\gspawn-win32-helper-console.exe"
  Delete "$INSTDIR\bin\gspawn-win32-helper.exe"
  Delete "$INSTDIR\bin\iconv.dll"
  Delete "$INSTDIR\bin\iconv.exe"
  Delete "$INSTDIR\bin\intl.dll"
  Delete "$INSTDIR\bin\libatk-1.0-0.dll"
  Delete "$INSTDIR\bin\libcairo-2.dll"
  Delete "$INSTDIR\bin\libgailutil-18.dll"
  Delete "$INSTDIR\bin\libgdk-win32-2.0-0.dll"
  Delete "$INSTDIR\bin\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\bin\libglib-2.0-0.dll"
  Delete "$INSTDIR\bin\libgio-2.0-0.dll"
  Delete "$INSTDIR\bin\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\bin\libgobject-2.0-0.dll"
  Delete "$INSTDIR\bin\libgthread-2.0-0.dll"
  Delete "$INSTDIR\bin\libgtk-win32-2.0-0.dll"
  Delete "$INSTDIR\bin\libpango-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangocairo-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangoft2-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangowin32-1.0-0.dll"
  Delete "$INSTDIR\bin\libpng12.dll"
  Delete "$INSTDIR\bin\libpng12-0.dll"
  Delete "$INSTDIR\bin\libpng13.dll"
  Delete "$INSTDIR\bin\jpeg62.dll"
  Delete "$INSTDIR\bin\libjpeg-7.dll"
  Delete "$INSTDIR\bin\libtiff3.dll"
  Delete "$INSTDIR\bin\libtiff-3.dll"
  Delete "$INSTDIR\bin\libtiffxx-3.dll"
  Delete "$INSTDIR\bin\freetype6.dll"
  Delete "$INSTDIR\bin\libfontconfig-1.dll"
  Delete "$INSTDIR\bin\libexpat-1.dll"
  Delete "$INSTDIR\bin\pango-querymodules.exe"
  Delete "$INSTDIR\bin\giflib4.dll"
  Delete "$INSTDIR\bin\zlib1.dll"
  Delete "$INSTDIR\bin\SDL.dll"
  Delete "$INSTDIR\etc\gtk-2.0\gdk-pixbuf.loaders"
  Delete "$INSTDIR\etc\gtk-2.0\gtk.immodules"
  Delete "$INSTDIR\etc\gtk-2.0\gtkrc"
  Delete "$INSTDIR\etc\pango\pango.aliases"
  Delete "$INSTDIR\etc\pango\pango.modules"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ani.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-bmp.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-gif.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ico.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-jpeg.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-pcx.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-png.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-pnm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ras.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-tga.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-tiff.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-wbmp.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-xbm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-xpm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-am-et.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-cedilla.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-cyrillic-translit.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ime.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-inuktitut.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ipa.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-thai-broken.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ti-er.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ti-et.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-viqr.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\engines\libpixmap.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.4.0\engines\libwimp.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ani.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-bmp.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-gif.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ico.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-jpeg.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-pcx.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-png.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-pnm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ras.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-tga.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-tiff.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-wbmp.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-xbm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-xpm.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-am-et.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-cedilla.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-cyrillic-translit.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-ime.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-inuktitut.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-ipa.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-multipress.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-thai.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-ti-er.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-ti-et.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\immodules\im-viqr.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\engines\libpixmap.dll"
  Delete "$INSTDIR\lib\gtk-2.0\2.10.0\engines\libwimp.dll"
  Delete "$INSTDIR\lib\locale\de\LC_MESSAGES\glib20.mo"
  Delete "$INSTDIR\lib\locale\de\LC_MESSAGES\gtk20.mo"
  Delete "$INSTDIR\lib\locale\de\LC_MESSAGES\gtk20-properties.mo"
  Delete "$INSTDIR\lib\locale\de\LC_MESSAGES\atk10.mo"
  Delete "$INSTDIR\share\locale\de\LC_MESSAGES\glib20.mo"
  Delete "$INSTDIR\share\locale\de\LC_MESSAGES\gtk20.mo"
  Delete "$INSTDIR\share\locale\de\LC_MESSAGES\gtk20-properties.mo"
  Delete "$INSTDIR\share\locale\de\LC_MESSAGES\libiconv.mo"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-arabic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-basic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-basic-win32.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-hangul-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-hebrew-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-indic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-khmer-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-syriac-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-thai-fc.dll"
  Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-tibetan-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-arabic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-basic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-basic-win32.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-hangul-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-hebrew-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-indic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-khmer-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-syriac-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-thai-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-tibetan-fc.dll"

  # GTK END

  RMDir "$INSTDIR\share\man\man1"
  RMDir "$INSTDIR\share\man"
  RMDir "$INSTDIR\share\KCemu\roms\z1013"
  RMDir "$INSTDIR\share\KCemu\roms\z9001"
  RMDir "$INSTDIR\share\KCemu\roms\kc85"
  RMDir "$INSTDIR\share\KCemu\roms\poly880"
  RMDir "$INSTDIR\share\KCemu\roms\lc80"
  RMDir "$INSTDIR\share\KCemu\roms\a5105"
  RMDir "$INSTDIR\share\KCemu\roms\kramermc"
  RMDir "$INSTDIR\share\KCemu\roms\muglerpc"
  RMDir "$INSTDIR\share\KCemu\roms\vcs80"
  RMDir "$INSTDIR\share\KCemu\roms\c80"
  RMDir "$INSTDIR\share\KCemu\roms"
  RMDir "$INSTDIR\share\KCemu\disks"
  RMDir "$INSTDIR\share\KCemu\tapes"
  RMDir "$INSTDIR\share\KCemu\keymaps"
  RMDir "$INSTDIR\share\KCemu\lib\z80"
  RMDir "$INSTDIR\share\KCemu\lib"
  RMDir "$INSTDIR\share\KCemu\asm\autostart"
  RMDir "$INSTDIR\share\KCemu\asm"
  RMDir "$INSTDIR\share\KCemu\doc"
  RMDir "$INSTDIR\share\KCemu\icons"
  RMDir "$INSTDIR\share\KCemu\images"
  RMDir "$INSTDIR\share\KCemu\config"
  RMDir "$INSTDIR\share\KCemu"
  RMDir "$INSTDIR\share\locale\de\LC_MESSAGES"
  RMDir "$INSTDIR\share\locale\en\LC_MESSAGES"
  RMDir "$INSTDIR\share\locale\de"
  RMDir "$INSTDIR\share\locale\en"
  RMDir "$INSTDIR\share\locale"
  RMDir "$INSTDIR\share\doc\kcemu"
  RMDir "$INSTDIR\share\doc"
  RMDir "$INSTDIR\share"
  RMDir "$INSTDIR\etc\gtk-2.0"
  RMDir "$INSTDIR\etc\pango"
  RMDir "$INSTDIR\etc"
  RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\loaders"
  RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\immodules"
  RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\engines"
  RMDir "$INSTDIR\lib\gtk-2.0\2.4.0"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0\loaders"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0\immodules"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0"
  RMDir "$INSTDIR\lib\gtk-2.0"
  RMDir "$INSTDIR\lib\locale\de\LC_MESSAGES"
  RMDir "$INSTDIR\lib\locale\de"
  RMDir "$INSTDIR\lib\locale"
  RMDir "$INSTDIR\lib\pango\1.4.0\modules"
  RMDir "$INSTDIR\lib\pango\1.4.0"
  RMDir "$INSTDIR\lib\pango\1.5.0\modules"
  RMDir "$INSTDIR\lib\pango\1.5.0"
  RMDir "$INSTDIR\lib\pango"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR"

  RMDir "$SMPROGRAMS\KCemu"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
