/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.UserAbortedException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.security.MaskedValueConsoleInput;
import amazon.fws.clicommando.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

public class StdInCommandProcessor
implements CommandProcessor {
    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        int count = 0;
        ParamConfig stdinParam = null;
        for (ParamConfig param : parameters) {
            if (!param.getValue().equals("-")) continue;
            stdinParam = param;
            if (++count <= 1) continue;
            throw new BadInputException(ErrorMessages.ErrorCode.MORE_THAN_ONE_STDIN_OPTION, new String[0]);
        }
        if (stdinParam != null) {
            boolean secureInput = stdinParam.isSecureInput();
            if (secureInput) {
                this.readStdinInputSecurly(stdinParam);
            } else {
                this.readStdinInput(stdinParam);
            }
        }
        return process;
    }

    private void readStdinInput(ParamConfig stdinParam) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        System.out.flush();
        try {
            input = stdin.readLine();
        }
        catch (IOException e) {
            throw new BadInputException(ErrorMessages.ErrorCode.CANNOT_READ_FILE, "standard input", e.getMessage());
        }
        if (!StringUtils.isEmpty(input)) {
            stdinParam.setValue(input);
        }
    }

    private void readStdinInputSecurly(ParamConfig stdinParam) {
        String input = "";
        try {
            input = MaskedValueConsoleInput.readValue(System.in, stdinParam.getPrompt(), stdinParam.getMaxValueSize());
        }
        catch (Exception e) {
            throw new UserAbortedException(ErrorMessages.ErrorCode.ABORTING_COMMAND, new String[0]);
        }
        if (!StringUtils.isEmpty(input)) {
            stdinParam.setValue(input);
        }
    }
}

