/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.HandlerOrderer;
import org.codehaus.xfire.handler.Phase;

public class HandlerPipeline
implements Handler {
    private static final Log log = LogFactory.getLog((Class)HandlerPipeline.class);
    private List phases;
    private Map handlers;
    private boolean paused = false;
    private Phase currentPhase;
    private String INVOKED_INTERCEPTORS = this.toString();

    public HandlerPipeline(List phases) {
        this.handlers = new HashMap();
        this.phases = phases;
        Iterator itr = phases.iterator();
        while (itr.hasNext()) {
            Phase phase = (Phase)itr.next();
            this.handlers.put(phase.getName(), new HandlerOrderer());
        }
    }

    public void addHandlers(List newhandlers) {
        if (newhandlers == null) {
            return;
        }
        Iterator itr = newhandlers.iterator();
        while (itr.hasNext()) {
            Handler handler = (Handler)itr.next();
            this.addHandler(handler);
        }
    }

    public void addHandler(Handler handler) {
        HandlerOrderer phaseHandlers;
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding handler " + handler + " to phase " + handler.getPhase()));
        }
        if ((phaseHandlers = this.getPhaseHandlers(handler.getPhase())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Phase " + handler.getPhase() + " does not exist. Skipping handler " + handler.getClass().getName()));
            }
        } else {
            phaseHandlers.insertHandler(handler);
        }
    }

    public HandlerOrderer getPhaseHandlers(String phase) {
        return (HandlerOrderer)this.handlers.get(phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext context) throws Exception {
        if (this.paused) {
            return;
        }
        context.setCurrentPipeline(this);
        Stack<Handler> invoked = (Stack<Handler>)context.getProperty(this.INVOKED_INTERCEPTORS);
        if (invoked == null) {
            invoked = new Stack<Handler>();
            context.setProperty(this.INVOKED_INTERCEPTORS, invoked);
        }
        Iterator itr = this.phases.iterator();
        while (itr.hasNext()) {
            Phase phase = (Phase)itr.next();
            if (this.currentPhase != null && phase.compareTo(this.currentPhase) < 0) continue;
            this.currentPhase = phase;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking phase " + phase.getName()));
            }
            ArrayList phaseHandlers = this.getPhaseHandlers(phase.getName()).getHandlers();
            for (int i = 0; i < phaseHandlers.size(); ++i) {
                Handler h = (Handler)phaseHandlers.get(i);
                if (invoked.contains(h)) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invoking handler " + h.getClass().getName() + " in phase " + phase.getName()));
                    }
                    h.invoke(context);
                    continue;
                }
                finally {
                    invoked.push(h);
                    if (this.paused) {
                        return;
                    }
                }
            }
        }
    }

    public void handleFault(XFireFault fault, MessageContext context) {
        Stack invoked = (Stack)context.getProperty(this.toString());
        if (null != invoked) {
            while (invoked.size() > 0) {
                Handler h = (Handler)invoked.pop();
                h.handleFault(fault, context);
            }
        }
    }

    public boolean understands(QName name) {
        Iterator itr = this.phases.iterator();
        while (itr.hasNext()) {
            Phase phase = (Phase)itr.next();
            ArrayList phaseHandlers = this.getPhaseHandlers(phase.getName()).getHandlers();
            for (int i = 0; i < phaseHandlers.size(); ++i) {
                Handler h = (Handler)phaseHandlers.get(i);
                QName[] understoodQs = h.getUnderstoodHeaders();
                if (understoodQs == null) continue;
                for (int j = 0; j < understoodQs.length; ++j) {
                    if (!understoodQs[j].equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume(MessageContext context) throws Exception {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.invoke(context);
    }

    public List getAfter() {
        return null;
    }

    public List getBefore() {
        return null;
    }

    public String getPhase() {
        return null;
    }

    public String[] getRoles() {
        return null;
    }

    public QName[] getUnderstoodHeaders() {
        return null;
    }
}

