/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.util.CachedOutputStream;
import org.codehaus.xfire.util.STAXUtils;

public class OutMessageDataSource
implements DataSource {
    private OutMessage msg;
    private MessageContext context;
    private InputStream is;
    private CachedOutputStream out;

    public OutMessageDataSource(MessageContext context2, OutMessage message) throws XFireException {
        this.context = context2;
        this.msg = message;
        this.is = this.createInputStream();
    }

    public String getContentType() {
        String encoding = this.msg.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        StringBuffer ct = new StringBuffer();
        ct.append("application/xop+xml; charset=").append(encoding).append("; type=\"").append(this.getSoapContentType()).append("\"");
        return ct.toString();
    }

    public String getSoapContentType() {
        SoapVersion soap = this.msg.getSoapVersion();
        if (!(soap instanceof Soap11)) {
            if (soap instanceof Soap12) {
                return "application/soap+xml";
            }
            return "text/xml";
        }
        String ct = "text/xml";
        return ct;
    }

    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    public InputStream createInputStream() throws XFireException {
        try {
            this.out = new CachedOutputStream(1024000, null);
            XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(this.out, this.msg.getEncoding(), this.context);
            this.msg.setProperty("channel.outputstream", this.out);
            this.msg.getSerializer().writeMessage(this.msg, writer, this.context);
            writer.flush();
            writer.close();
            this.out.close();
            return this.out.getInputStream();
        }
        catch (XMLStreamException e) {
            throw new XFireException("Couldn't send message.", e);
        }
        catch (IOException e) {
            throw new XFireException("Couldn't send message.", e);
        }
    }

    public String getName() {
        return "soap.xml@xfire.codehaus.org";
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void dispose() {
        this.out.dispose();
    }
}

