/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef BASE_SERVER_COMMON_H_
#define BASE_SERVER_COMMON_H_

#include <Common.h>
#include <SMBIOS.h>

// Define EnabledState Constants
#define ES_UNKNOWN			0
#define ES_ENABLE			2
#define ES_DISABLE			3
#define ES_NOT_APPLICABLE	5
#define ES_ENABLED_OFFLINE	6

// Define RequestedState Constants
#define RS_UNKNOWN			0
#define RS_NO_CHANGE		5
#define RS_NOT_APPLICABLE	12

// Define Dedicated Constants
#define D_UNKNOWN			1
#define D_OTHER				2

// Define HealthState Constants
#define HS_UNKNOWN 			0
#define HS_OK				5

// Define OperationalStatus Constants
#define OS_UNKNOW			0
#define OS_OK				2
#define OS_IN_SERVICE		11

int CF_getComputerSystemOtherIdentifyingInfo(string& otherIdentifyingInfo,string& errorMessage);

#endif /*BASE_SERVER_COMMON_H_*/
