/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_OWNINGCOLLECTIONBIOS_H_
#define OPENDRIM_OWNINGCOLLECTIONBIOS_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_Collection.h"
#include "CIM_CollectionAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_OwningCollectionBIOS_classnames[] = {"OpenDRIM_OwningCollectionBIOS"};
static string OpenDRIM_OwningCollectionBIOS_NAMESPACE = _NAMESPACE;
const static string OwnedElement_role = "OwnedElement";
const static char* OwnedElement_classnames[] = {"OpenDRIM_BIOSConcreteCollection"};
const static string OwnedElement_NAMESPACE = _NAMESPACE;

const static string OwningElement_role = "OwningElement";
const static char* OwningElement_classnames[] = {"OpenDRIM_BIOSElement"};
const static string OwningElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_OwningCollectionBIOS {

public:
	
	Objectpath OwningElement;
	bool OwningElement_isNULL;
	
	Objectpath OwnedElement;
	bool OwnedElement_isNULL;
	
	OpenDRIM_OwningCollectionBIOS() {
		OwningElement_isNULL = true;
		OwnedElement_isNULL = true;
	}
	
	~OpenDRIM_OwningCollectionBIOS() {}
	
	string getKeys() const {
		return CF_toLowCase(".OwningElement=\"" + CF_quoteString(OwningElement.toString()) + "\""".OwnedElement=\"" + CF_quoteString(OwnedElement.toString()) + "\"");
	}

	int getOwningElement(Objectpath& value) const {
		if (OwningElement_isNULL==true)
			return NOT_FOUND;
		value = OwningElement;
		return OK;
	}
	
	int setOwningElement(const Objectpath& newValue) {
		OwningElement = newValue;
		OwningElement.setNamespace(OwningElement_NAMESPACE);
		OwningElement_isNULL = false;
		return OK;
	}

	int getOwnedElement(Objectpath& value) const {
		if (OwnedElement_isNULL==true)
			return NOT_FOUND;
		value = OwnedElement;
		return OK;
	}
	
	int setOwnedElement(const Objectpath& newValue) {
		OwnedElement = newValue;
		OwnedElement.setNamespace(OwnedElement_NAMESPACE);
		OwnedElement_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_OWNINGCOLLECTIONBIOS_H_*/
