/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OSCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_OSCONFORMSTOPROFILEACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_OSConformsToProfile.h"
#include "assocOpenDRIM_OSConformsToProfile.h"

int OS_OpenDRIM_OSConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_unload(string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OSConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OSConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OSConformsToProfile& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OSConformsToProfile& newInstance, const OpenDRIM_OSConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OSConformsToProfile& instance, string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OSConformsToProfile& instance, string& errorMessage);

int OS_OpenDRIM_OSConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OSConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OSConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_OSConformsToProfile>& OpenDRIM_OSConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OSConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_OSConformsToProfile>& OpenDRIM_OSConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OSConformsToProfile_populate(OpenDRIM_OSConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_OSCONFORMSTOPROFILEACCESS_H_*/
