/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTCAPABILITIESACCESS_H_
#define OPENDRIM_ACCOUNTCAPABILITIESACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_AccountCapabilities.h"

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountCapabilities& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountCapabilities& newInstance, const OpenDRIM_AccountCapabilities& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountCapabilities& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountCapabilities& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_CreateGoalSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountCapabilities& instance, unsigned short& returnValue, const OpenDRIM_AccountCapabilities_CreateGoalSettings_In& in, OpenDRIM_AccountCapabilities_CreateGoalSettings_Out& out, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_extractAccountCapabilitiesInfo(OpenDRIM_AccountCapabilities& instance, const vector<string>& current_etc_passwd_line, const vector<string>& current_etc_shadow_line, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountCapabilities_populate(OpenDRIM_AccountCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_ACCOUNTCAPABILITIESACCESS_H_*/
