#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sort the Court
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220208.5

# Set game-specific variables

GAME_ID='sort-the-court'
GAME_NAME='Sort the Court'

ARCHIVE_BASE_0='SortTheCourt_Linux.zip'
ARCHIVE_BASE_0_MD5='70561aaeddc67f2c9c36139d1f747478'
ARCHIVE_BASE_0_SIZE='87000'
ARCHIVE_BASE_0_VERSION='2.2.0-itch'
ARCHIVE_BASE_0_URL='https://graebor.itch.io/sort-the-court'

UNITY3D_NAME='SortTheCourt'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.x86
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGL.so.1 libX11.so.6 libgtk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0 xcursor libxrandr"

# Use persistent storage for user data

DATA_FILES="./*_save.dat"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary directories

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
