# Copyright (c) 2001, Stanford University
# All rights reserved.
#
# See the file LICENSE.txt for information on redistributing this software.

# This script generates the include/state/cr_currentpointers.h file.

import sys
sys.path.append( "../glapi_parser" )
import apiutil

from pack_currenttypes import *

apiutil.CopyrightC()

print """
/* DO NOT EDIT - THIS FILE GENERATED BY THE pack_currentheader.py SCRIPT */

#ifndef CR_CURRENT_H
#define CR_CURRENT_H

#include "state/cr_limits.h"
"""

for k in current_fns.keys():
	name = k.lower();
	print "typedef struct {"
	if current_fns[k].has_key( 'array' ):
		print "\tconst unsigned char *ptr[%s];" % current_fns[k]['array']
	else:
		print "\tconst unsigned char *ptr;"
	for type in current_fns[k]['types']:
		for size in current_fns[k]['sizes']:
			if current_fns[k].has_key( 'array' ):
				print "\tconst unsigned char *%s%d[%s];" % (type, size, current_fns[k]['array'])
			else:
				print "\tconst unsigned char *%s%d;" % (type, size)
	print "} GL%s_p;\n" % name

print "typedef	struct attrs {"
for k in current_fns.keys():
	name = k.lower()
	field = '%s%s' % (k[:1].lower(),k[1:])
	print "\tGL%s_p %s;" % (name,field)
print	"	} CRCurrentStateAttr;"
	

print "typedef struct {"
print """
	CRCurrentStateAttr c;
	unsigned char *vtx_op;
	unsigned char *vtx_data;
	unsigned char *begin_op;
	unsigned char *begin_data;
	unsigned int vtx_count;
	unsigned int vtx_max;
	unsigned int vtx_count_begin;
	unsigned int attribsUsedMask;
    unsigned int changedVertexAttrib;
} CRCurrentStatePointers;

#endif /* CR_CURRENT_H */
"""
