/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSet;

public class FieldNameSelector
extends FieldSet<String>
implements FieldSelector {
    public int getFieldIndex(String header) {
        return this.getFieldIndexes(new String[]{header})[0];
    }

    @Override
    public int[] getFieldIndexes(String[] headers) {
        if (headers == null) {
            return null;
        }
        headers = ArgumentUtils.normalize(headers);
        List<String> selection = this.get();
        ArgumentUtils.normalize(selection);
        Object[] chosenFields = selection.toArray(new String[selection.size()]);
        Object[] unknownFields = ArgumentUtils.findMissingElements((Object[])headers, chosenFields);
        if (unknownFields.length > 0 && !selection.containsAll(Arrays.asList(headers)) && unknownFields.length == chosenFields.length) {
            return new int[0];
        }
        int[] out = new int[chosenFields.length];
        int i = 0;
        for (Object chosenField : chosenFields) {
            int[] indexes = ArgumentUtils.indexesOf(headers, chosenField);
            if (indexes.length > 1) {
                out = Arrays.copyOf(out, out.length + indexes.length - 1);
            }
            if (indexes.length == 0) {
                out[i++] = -1;
                continue;
            }
            for (int j = 0; j < indexes.length; ++j) {
                out[i++] = indexes[j];
            }
        }
        return out;
    }
}

