/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:53:11 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PushbackReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class GenbankStreamFeature_ESTest extends GenbankStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      // Undeclared exception!
      try { 
        GenbankStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature(emblStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = genbankStreamFeature0.copy();
      assertNotSame(genbankStreamFeature0, feature0);
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(108);
      PushbackReader pushbackReader0 = new PushbackReader(pipedReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pushbackReader0);
      try { 
        GenbankStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = null;
      try {
        genbankStreamFeature0 = new GenbankStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Key key0 = Key.CDS;
      QualifierVector qualifierVector0 = new QualifierVector();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature(key0, (Location) null, qualifierVector0);
  }
}
