/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _DIALOGERROR_H
#define _DIALOGERROR_H

#include <gtkmm.h>
#include <iostream>
#include <libintl.h>

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

using namespace std;

class DialogError : public Gtk::Dialog {
public:
  DialogError(string primary, string secondary, Gtk::Window &parent);
  
protected:
  void on_signal_response(int response);
  
  Gtk::HBox   hbox_main;
  Gtk::VBox   vbox_icon;
  Gtk::Image  image_question;
  Gtk::Fixed  fixed_icon;
  Gtk::Label  label_question;
};

#endif /* _DIALOGERROR_H */
