//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Info/MessageBox.h
//! @brief     Defines class GUIHelpers functions
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INFO_MESSAGEBOX_H
#define BORNAGAIN_GUI_VIEW_INFO_MESSAGEBOX_H

#include <QWidget>

namespace GUI::Message {

void information(QWidget* parent, const QString& title, const QString& text,
                 const QString& detailedText = "");

void warning(QWidget* parent, const QString& title, const QString& text,
             const QString& detailedText = "");

bool question(QWidget* parent, const QString& title, const QString& text,
              const QString& detailedText = "", const QString& yesText = "&Yes",
              const QString& noText = "&No");

bool okToDelete(QWidget* parent, const QString& title, const QString& text,
                const QString& detailedText = "");

} // namespace GUI::Message

#endif // BORNAGAIN_GUI_VIEW_INFO_MESSAGEBOX_H
