//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/AlphaScanEditor.h
//! @brief     Defines class AlphaScanEditor.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_DEVICE_ALPHASCANEDITOR_H
#define BORNAGAIN_GUI_VIEW_DEVICE_ALPHASCANEDITOR_H

#include "GUI/View/Widget/GroupBoxes.h"

class DistributionPlot;
class DistributionSelector;
class ScanItem;
class ScanRangeForm;

//! Editor for scanning inclination angles

class AlphaScanEditor : public StaticGroupBox {
    Q_OBJECT
public:
    AlphaScanEditor(QWidget* parent, ScanItem* item, bool allow_distr);

    void updateIndicators();

signals:
    void dataChanged();

private slots:
    void onAxisTypeSelected(int index);
    void updatePlot();

private:
    DistributionSelector* m_selector;
    ScanRangeForm* m_form;
    ScanItem* m_item;
    DistributionPlot* m_plot;
};

#endif // BORNAGAIN_GUI_VIEW_DEVICE_ALPHASCANEDITOR_H
