/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU Lesser General Public License, Version 2.1,
 * February 1999, which is contained in the read-me file named
 * "README_GNU_LGPL." This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */

#ifndef LCDUTILS_H
#define LCDUTILS_H 1

#include <sys/types.h>
#include <fcntl.h>

#include <libintl.h>

/* locking bits */
extern int lcd_lock(void);
extern void lcd_unlock(void);

/* locale setting */
extern void lcd_setlocale(void);

/* button settings */
extern int lcd_button_debounce(void *);
extern int lcd_button_sense(void *);

/* timeout facilities */
extern int lcd_timeout_start(void (*)(const int), const int);
extern void lcd_timeout_stop(void);
extern int lcd_timeout_reset(void);

/* display and writing utils */
extern void *lcd_open(const int);
extern int lcd_write(void *, const char *, const char *);
extern void lcd_wait_no_button(void *);
extern void lcd_blink_invalid(void *);
extern void lcd_spin(void *, const char *, const char *);
extern void lcd_close(void *);
extern int lcd_setleds(void *, const int);
extern void lcd_reset(void *);
extern void lcd_set(void *, const int);

/* cursor utilities */
extern void lcd_setcursorpos(void *, unsigned char);
extern void lcd_setcursor(void *, unsigned char);
extern int lcd_getcursorpos(void *);
extern int lcd_getcursor(void *);
extern int lcd_movecursor(void *, const int);

/* link utilities */
extern int lcd_checklink(void *);
extern int lcd_checklink2(void *, int *);

/* reading utilities */
extern int lcd_getdisplay(void *, char **, char **, int *);
extern int lcd_readbutton(void *);
extern int lcd_getbutton(void *);

/* net utilities */
extern void lcd_netcorrect(void *);
extern int lcd_netbutton(void *);
extern void lcd_rev_format(char *);

#ifndef _
#define _(mesg)  gettext((mesg))
#endif

#endif
