// Atom types

typedef enum {
  PDB_NULL_ATOM,
  PDB_ALA_C_ATOM,
  PDB_ALA_CA_ATOM,
  PDB_ALA_CB_ATOM,
  PDB_ALA_N_ATOM,
  PDB_ALA_O_ATOM,
  PDB_ALA_HA_ATOM,
  PDB_ALA_HB1_ATOM,
  PDB_ALA_HB2_ATOM,
  PDB_ALA_HB3_ATOM,
  PDB_ALA_HN_ATOM,
  PDB_CYS_C_ATOM,
  PDB_CYS_CA_ATOM,
  PDB_CYS_CB_ATOM,
  PDB_CYS_N_ATOM,
  PDB_CYS_O_ATOM,
  PDB_CYS_SG_ATOM,
  PDB_CYS_HA_ATOM,
  PDB_CYS_HB1_ATOM,
  PDB_CYS_HB2_ATOM,
  PDB_CYS_HG1_ATOM,
  PDB_CYS_HN_ATOM,
  PDB_GLU_C_ATOM,
  PDB_GLU_CA_ATOM,
  PDB_GLU_CB_ATOM,
  PDB_GLU_CD_ATOM,
  PDB_GLU_CG_ATOM,
  PDB_GLU_N_ATOM,
  PDB_GLU_O_ATOM,
  PDB_GLU_OE1_ATOM,
  PDB_GLU_OE2_ATOM,
  PDB_GLU_HA_ATOM,
  PDB_GLU_HB1_ATOM,
  PDB_GLU_HB2_ATOM,
  PDB_GLU_HG1_ATOM,
  PDB_GLU_HG2_ATOM,
  PDB_GLU_HN_ATOM,
  PDB_ASP_C_ATOM,
  PDB_ASP_CA_ATOM,
  PDB_ASP_CB_ATOM,
  PDB_ASP_CG_ATOM,
  PDB_ASP_N_ATOM,
  PDB_ASP_O_ATOM,
  PDB_ASP_OD1_ATOM,
  PDB_ASP_OD2_ATOM,
  PDB_ASP_HA_ATOM,
  PDB_ASP_HB1_ATOM,
  PDB_ASP_HB2_ATOM,
  PDB_ASP_HN_ATOM,
  PDB_PHE_C_ATOM,
  PDB_PHE_CA_ATOM,
  PDB_PHE_CB_ATOM,
  PDB_PHE_CD1_ATOM,
  PDB_PHE_CD2_ATOM,
  PDB_PHE_CE1_ATOM,
  PDB_PHE_CE2_ATOM,
  PDB_PHE_CG_ATOM,
  PDB_PHE_CZ_ATOM,
  PDB_PHE_N_ATOM,
  PDB_PHE_O_ATOM,
  PDB_PHE_HA_ATOM,
  PDB_PHE_HB1_ATOM,
  PDB_PHE_HB2_ATOM,
  PDB_PHE_HD1_ATOM,
  PDB_PHE_HD2_ATOM,
  PDB_PHE_HE1_ATOM,
  PDB_PHE_HE2_ATOM,
  PDB_PHE_HZ_ATOM,
  PDB_PHE_HN_ATOM,
  PDB_GLY_C_ATOM,
  PDB_GLY_CA_ATOM,
  PDB_GLY_N_ATOM,
  PDB_GLY_O_ATOM,
  PDB_GLY_HA1_ATOM,
  PDB_GLY_HA2_ATOM,
  PDB_GLY_HN_ATOM,
  PDB_HIS_C_ATOM,
  PDB_HIS_CA_ATOM,
  PDB_HIS_CB_ATOM,
  PDB_HIS_CD2_ATOM,
  PDB_HIS_CE1_ATOM,
  PDB_HIS_CG_ATOM,
  PDB_HIS_N_ATOM,
  PDB_HIS_ND1_ATOM,
  PDB_HIS_NE2_ATOM,
  PDB_HIS_O_ATOM,
  PDB_HIS_HA_ATOM,
  PDB_HIS_HB1_ATOM,
  PDB_HIS_HB2_ATOM,
  PDB_HIS_HD1_ATOM,
  PDB_HIS_HD2_ATOM,
  PDB_HIS_HE1_ATOM,
  PDB_HIS_HN_ATOM,
  PDB_ILE_C_ATOM,
  PDB_ILE_CA_ATOM,
  PDB_ILE_CB_ATOM,
  PDB_ILE_CD_ATOM,
  PDB_ILE_CG1_ATOM,
  PDB_ILE_CG2_ATOM,
  PDB_ILE_N_ATOM,
  PDB_ILE_O_ATOM,
  PDB_ILE_HA_ATOM,
  PDB_ILE_HB_ATOM,
  PDB_ILE_HD1_ATOM,
  PDB_ILE_HD2_ATOM,
  PDB_ILE_HD3_ATOM,
  PDB_ILE_HG11_ATOM,
  PDB_ILE_HG12_ATOM,
  PDB_ILE_HG21_ATOM,
  PDB_ILE_HG22_ATOM,
  PDB_ILE_HG23_ATOM,
  PDB_ILE_HN_ATOM,
  PDB_LYS_C_ATOM,
  PDB_LYS_CA_ATOM,
  PDB_LYS_CB_ATOM,
  PDB_LYS_CD_ATOM,
  PDB_LYS_CE_ATOM,
  PDB_LYS_CG_ATOM,
  PDB_LYS_N_ATOM,
  PDB_LYS_NZ_ATOM,
  PDB_LYS_O_ATOM,
  PDB_LYS_HA_ATOM,
  PDB_LYS_HB1_ATOM,
  PDB_LYS_HB2_ATOM,
  PDB_LYS_HD1_ATOM,
  PDB_LYS_HD2_ATOM,
  PDB_LYS_HE1_ATOM,
  PDB_LYS_HE2_ATOM,
  PDB_LYS_HG1_ATOM,
  PDB_LYS_HG2_ATOM,
  PDB_LYS_HN_ATOM,
  PDB_LYS_HZ1_ATOM,
  PDB_LYS_HZ2_ATOM,
  PDB_LYS_HZ3_ATOM,
  PDB_LEU_C_ATOM,
  PDB_LEU_CA_ATOM,
  PDB_LEU_CB_ATOM,
  PDB_LEU_CD1_ATOM,
  PDB_LEU_CD2_ATOM,
  PDB_LEU_CG_ATOM,
  PDB_LEU_N_ATOM,
  PDB_LEU_O_ATOM,
  PDB_LEU_HA_ATOM,
  PDB_LEU_HB1_ATOM,
  PDB_LEU_HB2_ATOM,
  PDB_LEU_HD11_ATOM,
  PDB_LEU_HD12_ATOM,
  PDB_LEU_HD13_ATOM,
  PDB_LEU_HD21_ATOM,
  PDB_LEU_HD22_ATOM,
  PDB_LEU_HD23_ATOM,
  PDB_LEU_HG_ATOM,
  PDB_LEU_HN_ATOM,
  PDB_MET_C_ATOM,
  PDB_MET_CA_ATOM,
  PDB_MET_CB_ATOM,
  PDB_MET_CE_ATOM,
  PDB_MET_CG_ATOM,
  PDB_MET_N_ATOM,
  PDB_MET_O_ATOM,
  PDB_MET_SD_ATOM,
  PDB_MET_HA_ATOM,
  PDB_MET_HB1_ATOM,
  PDB_MET_HB2_ATOM,
  PDB_MET_HE1_ATOM,
  PDB_MET_HE2_ATOM,
  PDB_MET_HE3_ATOM,
  PDB_MET_HG1_ATOM,
  PDB_MET_HG2_ATOM,
  PDB_MET_HN_ATOM,
  PDB_ASN_C_ATOM,
  PDB_ASN_CA_ATOM,
  PDB_ASN_CB_ATOM,
  PDB_ASN_CG_ATOM,
  PDB_ASN_N_ATOM,
  PDB_ASN_ND2_ATOM,
  PDB_ASN_O_ATOM,
  PDB_ASN_OD1_ATOM,
  PDB_ASN_HA_ATOM,
  PDB_ASN_HB1_ATOM,
  PDB_ASN_HB2_ATOM,
  PDB_ASN_HD21_ATOM,
  PDB_ASN_HD22_ATOM,
  PDB_ASN_HN_ATOM,
  PDB_PRO_C_ATOM,
  PDB_PRO_CA_ATOM,
  PDB_PRO_CB_ATOM,
  PDB_PRO_CD_ATOM,
  PDB_PRO_CG_ATOM,
  PDB_PRO_N_ATOM,
  PDB_PRO_O_ATOM,
  PDB_PRO_HA_ATOM,
  PDB_PRO_HB1_ATOM,
  PDB_PRO_HB2_ATOM,
  PDB_PRO_HD1_ATOM,
  PDB_PRO_HD2_ATOM,
  PDB_PRO_HG1_ATOM,
  PDB_PRO_HG2_ATOM,
  PDB_GLN_C_ATOM,
  PDB_GLN_CA_ATOM,
  PDB_GLN_CB_ATOM,
  PDB_GLN_CD_ATOM,
  PDB_GLN_CG_ATOM,
  PDB_GLN_N_ATOM,
  PDB_GLN_NE2_ATOM,
  PDB_GLN_O_ATOM,
  PDB_GLN_OE1_ATOM,
  PDB_GLN_HA_ATOM,
  PDB_GLN_HB1_ATOM,
  PDB_GLN_HB2_ATOM,
  PDB_GLN_HE21_ATOM,
  PDB_GLN_HE22_ATOM,
  PDB_GLN_HG1_ATOM,
  PDB_GLN_HG2_ATOM,
  PDB_GLN_HN_ATOM,
  PDB_ARG_C_ATOM,
  PDB_ARG_CA_ATOM,
  PDB_ARG_CB_ATOM,
  PDB_ARG_CD_ATOM,
  PDB_ARG_CG_ATOM,
  PDB_ARG_CZ_ATOM,
  PDB_ARG_N_ATOM,
  PDB_ARG_NE_ATOM,
  PDB_ARG_NH1_ATOM,
  PDB_ARG_NH2_ATOM,
  PDB_ARG_O_ATOM,
  PDB_ARG_HA_ATOM,
  PDB_ARG_HB1_ATOM,
  PDB_ARG_HB2_ATOM,
  PDB_ARG_HD1_ATOM,
  PDB_ARG_HD2_ATOM,
  PDB_ARG_HE_ATOM,
  PDB_ARG_HG1_ATOM,
  PDB_ARG_HG2_ATOM,
  PDB_ARG_HH11_ATOM,
  PDB_ARG_HH12_ATOM,
  PDB_ARG_HH21_ATOM,
  PDB_ARG_HH22_ATOM,
  PDB_ARG_HN_ATOM,
  PDB_SER_C_ATOM,
  PDB_SER_CA_ATOM,
  PDB_SER_CB_ATOM,
  PDB_SER_N_ATOM,
  PDB_SER_O_ATOM,
  PDB_SER_OG_ATOM,
  PDB_SER_HA_ATOM,
  PDB_SER_HB1_ATOM,
  PDB_SER_HB2_ATOM,
  PDB_SER_HG1_ATOM,
  PDB_SER_HN_ATOM,
  PDB_THR_C_ATOM,
  PDB_THR_CA_ATOM,
  PDB_THR_CB_ATOM,
  PDB_THR_CG2_ATOM,
  PDB_THR_N_ATOM,
  PDB_THR_O_ATOM,
  PDB_THR_OG1_ATOM,
  PDB_THR_HA_ATOM,
  PDB_THR_HB_ATOM,
  PDB_THR_HG1_ATOM,
  PDB_THR_HG21_ATOM,
  PDB_THR_HG22_ATOM,
  PDB_THR_HG23_ATOM,
  PDB_THR_HN_ATOM,
  PDB_VAL_C_ATOM,
  PDB_VAL_CA_ATOM,
  PDB_VAL_CB_ATOM,
  PDB_VAL_CG1_ATOM,
  PDB_VAL_CG2_ATOM,
  PDB_VAL_N_ATOM,
  PDB_VAL_O_ATOM,
  PDB_VAL_HA_ATOM,
  PDB_VAL_HB_ATOM,
  PDB_VAL_HG11_ATOM,
  PDB_VAL_HG12_ATOM,
  PDB_VAL_HG13_ATOM,
  PDB_VAL_HG21_ATOM,
  PDB_VAL_HG22_ATOM,
  PDB_VAL_HG23_ATOM,
  PDB_VAL_HN_ATOM,
  PDB_TRP_C_ATOM,
  PDB_TRP_CA_ATOM,
  PDB_TRP_CB_ATOM,
  PDB_TRP_CD1_ATOM,
  PDB_TRP_CD2_ATOM,
  PDB_TRP_CE2_ATOM,
  PDB_TRP_CE3_ATOM,
  PDB_TRP_CG_ATOM,
  PDB_TRP_CH2_ATOM,
  PDB_TRP_CZ2_ATOM,
  PDB_TRP_CZ3_ATOM,
  PDB_TRP_N_ATOM,
  PDB_TRP_NE1_ATOM,
  PDB_TRP_O_ATOM,
  PDB_TRP_HA_ATOM,
  PDB_TRP_HB1_ATOM,
  PDB_TRP_HB2_ATOM,
  PDB_TRP_HD1_ATOM,
  PDB_TRP_HE1_ATOM,
  PDB_TRP_HE3_ATOM,
  PDB_TRP_HH2_ATOM,
  PDB_TRP_HN_ATOM,
  PDB_TRP_HZ2_ATOM,
  PDB_TRP_HZ3_ATOM,
  PDB_TYR_C_ATOM,
  PDB_TYR_CA_ATOM,
  PDB_TYR_CB_ATOM,
  PDB_TYR_CD1_ATOM,
  PDB_TYR_CD2_ATOM,
  PDB_TYR_CE1_ATOM,
  PDB_TYR_CE2_ATOM,
  PDB_TYR_CG_ATOM,
  PDB_TYR_CZ_ATOM,
  PDB_TYR_N_ATOM,
  PDB_TYR_O_ATOM,
  PDB_TYR_OH_ATOM,
  PDB_TYR_HA_ATOM,
  PDB_TYR_HB1_ATOM,
  PDB_TYR_HB2_ATOM,
  PDB_TYR_HD1_ATOM,
  PDB_TYR_HD2_ATOM,
  PDB_TYR_HE1_ATOM,
  PDB_TYR_HE2_ATOM,
  PDB_TYR_HH_ATOM,
  PDB_TYR_HN_ATOM,
  PDB_NUM_ATOMS,
} PDBAtomType;



// Atom groups
// Based on Engh & Huber, 1991

typedef enum {
  PDB_NULL_ATOM_GROUP,       
  PDB_NH1_ATOM_GROUP,        // Backbone NH                                          
  PDB_C_ATOM_GROUP,          // Backbone C                                           
  PDB_CH1E_ATOM_GROUP,       // Backbone CA (exc. Gly)                               
  PDB_O_ATOM_GROUP,          // Backbone O                                           
  PDB_CH0_ATOM_GROUP,        // Arg CZ, Asn CG, Asp CG, Gln CD, Glu CD               
  PDB_CH1S_ATOM_GROUP,       // Sidechain CH1: Ile CB, Leu CG, Thr CB, Val CB        
  PDB_CH2E_ATOM_GROUP,       // Tetrahedral CH2 (except CH2P,CH2G) All CB            
  PDB_CH3E_ATOM_GROUP,       // Tetrahedral CH3                                      
  PDB_CR1E_ATOM_GROUP,       // Aromatic CH (except CR1W, CRHH, CR1H)                
  PDB_OH1_ATOM_GROUP,        // Alcohol OH (Ser OG, Thr OG1, Tyr OH)                 
  PDB_OC_ATOM_GROUP,         // Carboxyl O (Asp OD1, OD2, Glu OE1, OE2)              
  PDB_OS_ATOM_GROUP,         // Sidechain O: Asn OD1, Gln OE1                        
  PDB_CH2G_ATOM_GROUP,       // Gly CA                                               
  PDB_CH2P_ATOM_GROUP,       // Pro CG, CD                                           
  PDB_NH1S_ATOM_GROUP,       // Sidechain NH: Arg NE, His ND1, NE1, Trp NE1          
  PDB_NC2_ATOM_GROUP,        // Arg NH1, NH2                                         
  PDB_NH2_ATOM_GROUP,        // Asn ND2, Gln NE2                                     
  PDB_CR1W_ATOM_GROUP,       // Trp CZ2, CH2                                         
  PDB_CY2_ATOM_GROUP,        // Tyr CZ                                               
  PDB_SH1E_ATOM_GROUP,       // Cys S                                                
  PDB_CF_ATOM_GROUP,         // Phe CG                                               
  PDB_SM_ATOM_GROUP,         // Met S                                                
  PDB_CY_ATOM_GROUP,         // Tyr CG                                               
  PDB_CW_ATOM_GROUP,         // Trp CD2, CE2                                         
  PDB_CRHH_ATOM_GROUP,       // His CE1                                              
  PDB_NH3_ATOM_GROUP,        // Lys NZ                                               
  PDB_CR1H_ATOM_GROUP,       // His CD2                                              
  PDB_C5_ATOM_GROUP,         // His CG                                               
  PDB_N_ATOM_GROUP,          // Pro N                                                
  PDB_C5W_ATOM_GROUP,        // Trp CG                                               
  PDB_HOH_ATOM_GROUP,        // Water                                                
  PDB_CL_ATOM_GROUP,         // Chlorine                                             
  PDB_F_ATOM_GROUP,          // Fluorine                                             
  PDB_S2_ATOM_GROUP,         // Sulphonate sulphur                                   
  PDB_N4_ATOM_GROUP,         // Amine                                                
  PDB_N5_ATOM_GROUP,         // CN nitrogen                                          
  PDB_N6_ATOM_GROUP,         // NO2 nitrogen                                         
  PDB_O4_ATOM_GROUP,         // Sulphonate oxygen                                    
  PDB_O6_ATOM_GROUP,         // NO2 oxygen                                           
  PDB_C5N_ATOM_GROUP,        // CN carbon                                            
  PDB_P_ATOM_GROUP,          // Phosphorus                                           
  PDB_NUM_ATOM_GROUPS
} PDBAtomGroup;



// Class definition

struct PDBAminoAcidAtomData {
  PDBAminoAcidAtomData(int aminoacid_id, int atom_id, int group, const char *atom_name, const char *element_name, RNScalar charge);
  int aminoacid_id;
  int atom_id;
  int group;
  const char *atom_name;
  PDBElement *element;
  RNScalar charge;
};



// Don't use this stuff -- used only by PDBAtom

extern int FindAminoAcidAtomType(PDBAtom *atom);
extern const PDBAminoAcidAtomData PDBaminoacid_atoms[PDB_NUM_ATOMS];

