if not modules then modules = { } end modules ['char-ent'] = {
    version   = 1.001,
    comment   = "companion to math-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "derived from the mathml 2.0 specification",
    dataonly  = true,
}

-- http://www.w3.org/2003/entities/2007/w3centities-f.ent
-- http://www.w3.org/2003/entities/2007/htmlmathml-f.ent

local entities = utilities.storage.allocate {
    ["AElig"] = "Æ", -- U+000C6
    ["AMP"] = "&", -- U+00026
    ["Aacgr"] = "Ά", -- U+00386
    ["Aacute"] = "Á", -- U+000C1
    ["Abreve"] = "Ă", -- U+00102
    ["Acirc"] = "Â", -- U+000C2
    ["Acy"] = "А", -- U+00410
    ["Afr"] = "𝔄", -- U+1D504
    ["Agr"] = "Α", -- U+00391
    ["Agrave"] = "À", -- U+000C0
    ["Alpha"] = "Α", -- U+00391
    ["Amacr"] = "Ā", -- U+00100
    ["And"] = "⩓", -- U+02A53
    ["Aogon"] = "Ą", -- U+00104
    ["Aopf"] = "𝔸", -- U+1D538
    ["ApplyFunction"] = "⁡", -- U+02061
    ["Aring"] = "Å", -- U+000C5
    ["Ascr"] = "𝒜", -- U+1D49C
    ["Assign"] = "≔", -- U+02254
    ["Atilde"] = "Ã", -- U+000C3
    ["Auml"] = "Ä", -- U+000C4
    ["Backslash"] = "∖", -- U+02216
    ["Barv"] = "⫧", -- U+02AE7
    ["Barwed"] = "⌆", -- U+02306
    ["Bcy"] = "Б", -- U+00411
    ["Because"] = "∵", -- U+02235
    ["Bernoullis"] = "ℬ", -- U+0212C
    ["Beta"] = "Β", -- U+00392
    ["Bfr"] = "𝔅", -- U+1D505
    ["Bgr"] = "Β", -- U+00392
    ["Bopf"] = "𝔹", -- U+1D539
    ["Breve"] = "˘", -- U+002D8
    ["Bscr"] = "ℬ", -- U+0212C
    ["Bumpeq"] = "≎", -- U+0224E
    ["CHcy"] = "Ч", -- U+00427
    ["COPY"] = "©", -- U+000A9
    ["Cacute"] = "Ć", -- U+00106
    ["Cap"] = "⋒", -- U+022D2
    ["CapitalDifferentialD"] = "ⅅ", -- U+02145
    ["Cayleys"] = "ℭ", -- U+0212D
    ["Ccaron"] = "Č", -- U+0010C
    ["Ccedil"] = "Ç", -- U+000C7
    ["Ccirc"] = "Ĉ", -- U+00108
    ["Cconint"] = "∰", -- U+02230
    ["Cdot"] = "Ċ", -- U+0010A
    ["Cedilla"] = "¸", -- U+000B8
    ["CenterDot"] = "·", -- U+000B7
    ["Cfr"] = "ℭ", -- U+0212D
    ["Chi"] = "Χ", -- U+003A7
    ["CircleDot"] = "⊙", -- U+02299
    ["CircleMinus"] = "⊖", -- U+02296
    ["CirclePlus"] = "⊕", -- U+02295
    ["CircleTimes"] = "⊗", -- U+02297
    ["ClockwiseContourIntegral"] = "∲", -- U+02232
    ["CloseCurlyDoubleQuote"] = "”", -- U+0201D
    ["CloseCurlyQuote"] = "’", -- U+02019
    ["Colon"] = "∷", -- U+02237
    ["Colone"] = "⩴", -- U+02A74
    ["Congruent"] = "≡", -- U+02261
    ["Conint"] = "∯", -- U+0222F
    ["ContourIntegral"] = "∮", -- U+0222E
    ["Copf"] = "ℂ", -- U+02102
    ["Coproduct"] = "∐", -- U+02210
    ["CounterClockwiseContourIntegral"] = "∳", -- U+02233
    ["Cross"] = "⨯", -- U+02A2F
    ["Cscr"] = "𝒞", -- U+1D49E
    ["Cup"] = "⋓", -- U+022D3
    ["CupCap"] = "≍", -- U+0224D
    ["DD"] = "ⅅ", -- U+02145
    ["DDotrahd"] = "⤑", -- U+02911
    ["DJcy"] = "Ђ", -- U+00402
    ["DScy"] = "Ѕ", -- U+00405
    ["DZcy"] = "Џ", -- U+0040F
    ["Dagger"] = "‡", -- U+02021
    ["Darr"] = "↡", -- U+021A1
    ["Dashv"] = "⫤", -- U+02AE4
    ["Dcaron"] = "Ď", -- U+0010E
    ["Dcy"] = "Д", -- U+00414
    ["Del"] = "∇", -- U+02207
    ["Delta"] = "Δ", -- U+00394
    ["Dfr"] = "𝔇", -- U+1D507
    ["Dgr"] = "Δ", -- U+00394
    ["DiacriticalAcute"] = "´", -- U+000B4
    ["DiacriticalDot"] = "˙", -- U+002D9
    ["DiacriticalDoubleAcute"] = "˝", -- U+002DD
    ["DiacriticalGrave"] = "`", -- U+00060
    ["DiacriticalTilde"] = "˜", -- U+002DC
    ["Diamond"] = "⋄", -- U+022C4
    ["DifferentialD"] = "ⅆ", -- U+02146
    ["Dopf"] = "𝔻", -- U+1D53B
    ["Dot"] = "¨", -- U+000A8
    ["DotDot"] = "⃜", -- U+020DC
    ["DotEqual"] = "≐", -- U+02250
    ["DoubleContourIntegral"] = "∯", -- U+0222F
    ["DoubleDot"] = "¨", -- U+000A8
    ["DoubleDownArrow"] = "⇓", -- U+021D3
    ["DoubleLeftArrow"] = "⇐", -- U+021D0
    ["DoubleLeftRightArrow"] = "⇔", -- U+021D4
    ["DoubleLeftTee"] = "⫤", -- U+02AE4
    ["DoubleLongLeftArrow"] = "⟸", -- U+027F8
    ["DoubleLongLeftRightArrow"] = "⟺", -- U+027FA
    ["DoubleLongRightArrow"] = "⟹", -- U+027F9
    ["DoubleRightArrow"] = "⇒", -- U+021D2
    ["DoubleRightTee"] = "⊨", -- U+022A8
    ["DoubleUpArrow"] = "⇑", -- U+021D1
    ["DoubleUpDownArrow"] = "⇕", -- U+021D5
    ["DoubleVerticalBar"] = "∥", -- U+02225
    ["DownArrow"] = "↓", -- U+02193
    ["DownArrowBar"] = "⤓", -- U+02913
    ["DownArrowUpArrow"] = "⇵", -- U+021F5
    ["DownBreve"] = "̑", -- U+00311
    ["DownLeftRightVector"] = "⥐", -- U+02950
    ["DownLeftTeeVector"] = "⥞", -- U+0295E
    ["DownLeftVector"] = "↽", -- U+021BD
    ["DownLeftVectorBar"] = "⥖", -- U+02956
    ["DownRightTeeVector"] = "⥟", -- U+0295F
    ["DownRightVector"] = "⇁", -- U+021C1
    ["DownRightVectorBar"] = "⥗", -- U+02957
    ["DownTee"] = "⊤", -- U+022A4
    ["DownTeeArrow"] = "↧", -- U+021A7
    ["Downarrow"] = "⇓", -- U+021D3
    ["Dscr"] = "𝒟", -- U+1D49F
    ["Dstrok"] = "Đ", -- U+00110
    ["EEacgr"] = "Ή", -- U+00389
    ["EEgr"] = "Η", -- U+00397
    ["ENG"] = "Ŋ", -- U+0014A
    ["ETH"] = "Ð", -- U+000D0
    ["Eacgr"] = "Έ", -- U+00388
    ["Eacute"] = "É", -- U+000C9
    ["Ecaron"] = "Ě", -- U+0011A
    ["Ecirc"] = "Ê", -- U+000CA
    ["Ecy"] = "Э", -- U+0042D
    ["Edot"] = "Ė", -- U+00116
    ["Efr"] = "𝔈", -- U+1D508
    ["Egr"] = "Ε", -- U+00395
    ["Egrave"] = "È", -- U+000C8
    ["Element"] = "∈", -- U+02208
    ["Emacr"] = "Ē", -- U+00112
    ["EmptySmallSquare"] = "◻", -- U+025FB
    ["EmptyVerySmallSquare"] = "▫", -- U+025AB
    ["Eogon"] = "Ę", -- U+00118
    ["Eopf"] = "𝔼", -- U+1D53C
    ["Epsilon"] = "Ε", -- U+00395
    ["Equal"] = "⩵", -- U+02A75
    ["EqualTilde"] = "≂", -- U+02242
    ["Equilibrium"] = "⇌", -- U+021CC
    ["Escr"] = "ℰ", -- U+02130
    ["Esim"] = "⩳", -- U+02A73
    ["Eta"] = "Η", -- U+00397
    ["Euml"] = "Ë", -- U+000CB
    ["Exists"] = "∃", -- U+02203
    ["ExponentialE"] = "ⅇ", -- U+02147
    ["Fcy"] = "Ф", -- U+00424
    ["Ffr"] = "𝔉", -- U+1D509
    ["FilledSmallSquare"] = "◼", -- U+025FC
    ["FilledVerySmallSquare"] = "▪", -- U+025AA
    ["Fopf"] = "𝔽", -- U+1D53D
    ["ForAll"] = "∀", -- U+02200
    ["Fouriertrf"] = "ℱ", -- U+02131
    ["Fscr"] = "ℱ", -- U+02131
    ["GJcy"] = "Ѓ", -- U+00403
    ["GT"] = ">", -- U+0003E
    ["Gamma"] = "Γ", -- U+00393
    ["Gammad"] = "Ϝ", -- U+003DC
    ["Gbreve"] = "Ğ", -- U+0011E
    ["Gcedil"] = "Ģ", -- U+00122
    ["Gcirc"] = "Ĝ", -- U+0011C
    ["Gcy"] = "Г", -- U+00413
    ["Gdot"] = "Ġ", -- U+00120
    ["Gfr"] = "𝔊", -- U+1D50A
    ["Gg"] = "⋙", -- U+022D9
    ["Ggr"] = "Γ", -- U+00393
    ["Gopf"] = "𝔾", -- U+1D53E
    ["GreaterEqual"] = "≥", -- U+02265
    ["GreaterEqualLess"] = "⋛", -- U+022DB
    ["GreaterFullEqual"] = "≧", -- U+02267
    ["GreaterGreater"] = "⪢", -- U+02AA2
    ["GreaterLess"] = "≷", -- U+02277
    ["GreaterSlantEqual"] = "⩾", -- U+02A7E
    ["GreaterTilde"] = "≳", -- U+02273
    ["Gscr"] = "𝒢", -- U+1D4A2
    ["Gt"] = "≫", -- U+0226B
    ["HARDcy"] = "Ъ", -- U+0042A
    ["Hacek"] = "ˇ", -- U+002C7
    ["Hat"] = "^", -- U+0005E
    ["Hcirc"] = "Ĥ", -- U+00124
    ["Hfr"] = "ℌ", -- U+0210C
    ["HilbertSpace"] = "ℋ", -- U+0210B
    ["Hopf"] = "ℍ", -- U+0210D
    ["HorizontalLine"] = "─", -- U+02500
    ["Hscr"] = "ℋ", -- U+0210B
    ["Hstrok"] = "Ħ", -- U+00126
    ["HumpDownHump"] = "≎", -- U+0224E
    ["HumpEqual"] = "≏", -- U+0224F
    ["IEcy"] = "Е", -- U+00415
    ["IJlig"] = "Ĳ", -- U+00132
    ["IOcy"] = "Ё", -- U+00401
    ["Iacgr"] = "Ί", -- U+0038A
    ["Iacute"] = "Í", -- U+000CD
    ["Icirc"] = "Î", -- U+000CE
    ["Icy"] = "И", -- U+00418
    ["Idigr"] = "Ϊ", -- U+003AA
    ["Idot"] = "İ", -- U+00130
    ["Ifr"] = "ℑ", -- U+02111
    ["Igr"] = "Ι", -- U+00399
    ["Igrave"] = "Ì", -- U+000CC
    ["Im"] = "ℑ", -- U+02111
    ["Imacr"] = "Ī", -- U+0012A
    ["ImaginaryI"] = "ⅈ", -- U+02148
    ["Implies"] = "⇒", -- U+021D2
    ["Int"] = "∬", -- U+0222C
    ["Integral"] = "∫", -- U+0222B
    ["Intersection"] = "⋂", -- U+022C2
    ["InvisibleComma"] = "⁣", -- U+02063
    ["InvisibleTimes"] = "⁢", -- U+02062
    ["Iogon"] = "Į", -- U+0012E
    ["Iopf"] = "𝕀", -- U+1D540
    ["Iota"] = "Ι", -- U+00399
    ["Iscr"] = "ℐ", -- U+02110
    ["Itilde"] = "Ĩ", -- U+00128
    ["Iukcy"] = "І", -- U+00406
    ["Iuml"] = "Ï", -- U+000CF
    ["Jcirc"] = "Ĵ", -- U+00134
    ["Jcy"] = "Й", -- U+00419
    ["Jfr"] = "𝔍", -- U+1D50D
    ["Jopf"] = "𝕁", -- U+1D541
    ["Jscr"] = "𝒥", -- U+1D4A5
    ["Jsercy"] = "Ј", -- U+00408
    ["Jukcy"] = "Є", -- U+00404
    ["KHcy"] = "Х", -- U+00425
    ["KHgr"] = "Χ", -- U+003A7
    ["KJcy"] = "Ќ", -- U+0040C
    ["Kappa"] = "Κ", -- U+0039A
    ["Kcedil"] = "Ķ", -- U+00136
    ["Kcy"] = "К", -- U+0041A
    ["Kfr"] = "𝔎", -- U+1D50E
    ["Kgr"] = "Κ", -- U+0039A
    ["Kopf"] = "𝕂", -- U+1D542
    ["Kscr"] = "𝒦", -- U+1D4A6
    ["LJcy"] = "Љ", -- U+00409
    ["LT"] = "<", -- U+00026
    ["Lacute"] = "Ĺ", -- U+00139
    ["Lambda"] = "Λ", -- U+0039B
    ["Lang"] = "⟪", -- U+027EA
    ["Laplacetrf"] = "ℒ", -- U+02112
    ["Larr"] = "↞", -- U+0219E
    ["Lcaron"] = "Ľ", -- U+0013D
    ["Lcedil"] = "Ļ", -- U+0013B
    ["Lcy"] = "Л", -- U+0041B
    ["LeftAngleBracket"] = "⟨", -- U+027E8
    ["LeftArrow"] = "←", -- U+02190
    ["LeftArrowBar"] = "⇤", -- U+021E4
    ["LeftArrowRightArrow"] = "⇆", -- U+021C6
    ["LeftCeiling"] = "⌈", -- U+02308
    ["LeftDoubleBracket"] = "⟦", -- U+027E6
    ["LeftDownTeeVector"] = "⥡", -- U+02961
    ["LeftDownVector"] = "⇃", -- U+021C3
    ["LeftDownVectorBar"] = "⥙", -- U+02959
    ["LeftFloor"] = "⌊", -- U+0230A
    ["LeftRightArrow"] = "↔", -- U+02194
    ["LeftRightVector"] = "⥎", -- U+0294E
    ["LeftTee"] = "⊣", -- U+022A3
    ["LeftTeeArrow"] = "↤", -- U+021A4
    ["LeftTeeVector"] = "⥚", -- U+0295A
    ["LeftTriangle"] = "⊲", -- U+022B2
    ["LeftTriangleBar"] = "⧏", -- U+029CF
    ["LeftTriangleEqual"] = "⊴", -- U+022B4
    ["LeftUpDownVector"] = "⥑", -- U+02951
    ["LeftUpTeeVector"] = "⥠", -- U+02960
    ["LeftUpVector"] = "↿", -- U+021BF
    ["LeftUpVectorBar"] = "⥘", -- U+02958
    ["LeftVector"] = "↼", -- U+021BC
    ["LeftVectorBar"] = "⥒", -- U+02952
    ["Leftarrow"] = "⇐", -- U+021D0
    ["Leftrightarrow"] = "⇔", -- U+021D4
    ["LessEqualGreater"] = "⋚", -- U+022DA
    ["LessFullEqual"] = "≦", -- U+02266
    ["LessGreater"] = "≶", -- U+02276
    ["LessLess"] = "⪡", -- U+02AA1
    ["LessSlantEqual"] = "⩽", -- U+02A7D
    ["LessTilde"] = "≲", -- U+02272
    ["Lfr"] = "𝔏", -- U+1D50F
    ["Lgr"] = "Λ", -- U+0039B
    ["Ll"] = "⋘", -- U+022D8
    ["Lleftarrow"] = "⇚", -- U+021DA
    ["Lmidot"] = "Ŀ", -- U+0013F
    ["LongLeftArrow"] = "⟵", -- U+027F5
    ["LongLeftRightArrow"] = "⟷", -- U+027F7
    ["LongRightArrow"] = "⟶", -- U+027F6
    ["Longleftarrow"] = "⟸", -- U+027F8
    ["Longleftrightarrow"] = "⟺", -- U+027FA
    ["Longrightarrow"] = "⟹", -- U+027F9
    ["Lopf"] = "𝕃", -- U+1D543
    ["LowerLeftArrow"] = "↙", -- U+02199
    ["LowerRightArrow"] = "↘", -- U+02198
    ["Lscr"] = "ℒ", -- U+02112
    ["Lsh"] = "↰", -- U+021B0
    ["Lstrok"] = "Ł", -- U+00141
    ["Lt"] = "≪", -- U+0226A
    ["Map"] = "⤅", -- U+02905
    ["Mcy"] = "М", -- U+0041C
    ["MediumSpace"] = " ", -- U+0205F
    ["Mellintrf"] = "ℳ", -- U+02133
    ["Mfr"] = "𝔐", -- U+1D510
    ["Mgr"] = "Μ", -- U+0039C
    ["MinusPlus"] = "∓", -- U+02213
    ["Mopf"] = "𝕄", -- U+1D544
    ["Mscr"] = "ℳ", -- U+02133
    ["Mu"] = "Μ", -- U+0039C
    ["NJcy"] = "Њ", -- U+0040A
    ["Nacute"] = "Ń", -- U+00143
    ["Ncaron"] = "Ň", -- U+00147
    ["Ncedil"] = "Ņ", -- U+00145
    ["Ncy"] = "Н", -- U+0041D
    ["NegativeMediumSpace"] = "​", -- U+0200B
    ["NegativeThickSpace"] = "​", -- U+0200B
    ["NegativeThinSpace"] = "​", -- U+0200B
    ["NegativeVeryThinSpace"] = "​", -- U+0200B
    ["NestedGreaterGreater"] = "≫", -- U+0226B
    ["NestedLessLess"] = "≪", -- U+0226A
    ["Nfr"] = "𝔑", -- U+1D511
    ["Ngr"] = "Ν", -- U+0039D
          ["NoBreak"] = "⁠", -- U+02060
    ["NonBreakingSpace"] = " ", -- U+000A0
    ["Nopf"] = "ℕ", -- U+02115
    ["Not"] = "⫬", -- U+02AEC
    ["NotCongruent"] = "≢", -- U+02262
    ["NotCupCap"] = "≭", -- U+0226D
    ["NotDoubleVerticalBar"] = "∦", -- U+02226
    ["NotElement"] = "∉", -- U+02209
    ["NotEqual"] = "≠", -- U+02260
    ["NotEqualTilde"] = "≂̸", -- U+02242 00338
    ["NotExists"] = "∄", -- U+02204
    ["NotGreater"] = "≯", -- U+0226F
    ["NotGreaterEqual"] = "≱", -- U+02271
    ["NotGreaterFullEqual"] = "≧̸", -- U+02267 00338
    ["NotGreaterGreater"] = "≫̸", -- U+0226B 00338
    ["NotGreaterLess"] = "≹", -- U+02279
    ["NotGreaterSlantEqual"] = "⩾̸", -- U+02A7E 00338
    ["NotGreaterTilde"] = "≵", -- U+02275
    ["NotHumpDownHump"] = "≎̸", -- U+0224E 00338
    ["NotHumpEqual"] = "≏̸", -- U+0224F 00338
    ["NotLeftTriangle"] = "⋪", -- U+022EA
    ["NotLeftTriangleBar"] = "⧏̸", -- U+029CF 00338
    ["NotLeftTriangleEqual"] = "⋬", -- U+022EC
    ["NotLess"] = "≮", -- U+0226E
    ["NotLessEqual"] = "≰", -- U+02270
    ["NotLessGreater"] = "≸", -- U+02278
    ["NotLessLess"] = "≪̸", -- U+0226A 00338
    ["NotLessSlantEqual"] = "⩽̸", -- U+02A7D 00338
    ["NotLessTilde"] = "≴", -- U+02274
    ["NotNestedGreaterGreater"] = "⪢̸", -- U+02AA2 00338
    ["NotNestedLessLess"] = "⪡̸", -- U+02AA1 00338
    ["NotPrecedes"] = "⊀", -- U+02280
    ["NotPrecedesEqual"] = "⪯̸", -- U+02AAF 00338
    ["NotPrecedesSlantEqual"] = "⋠", -- U+022E0
    ["NotReverseElement"] = "∌", -- U+0220C
    ["NotRightTriangle"] = "⋫", -- U+022EB
    ["NotRightTriangleBar"] = "⧐̸", -- U+029D0 00338
    ["NotRightTriangleEqual"] = "⋭", -- U+022ED
    ["NotSquareSubset"] = "⊏̸", -- U+0228F 00338
    ["NotSquareSubsetEqual"] = "⋢", -- U+022E2
    ["NotSquareSuperset"] = "⊐̸", -- U+02290 00338
    ["NotSquareSupersetEqual"] = "⋣", -- U+022E3
    ["NotSubset"] = "⊂⃒", -- U+02282 020D2
    ["NotSubsetEqual"] = "⊈", -- U+02288
    ["NotSucceeds"] = "⊁", -- U+02281
    ["NotSucceedsEqual"] = "⪰̸", -- U+02AB0 00338
    ["NotSucceedsSlantEqual"] = "⋡", -- U+022E1
    ["NotSucceedsTilde"] = "≿̸", -- U+0227F 00338
    ["NotSuperset"] = "⊃⃒", -- U+02283 020D2
    ["NotSupersetEqual"] = "⊉", -- U+02289
    ["NotTilde"] = "≁", -- U+02241
    ["NotTildeEqual"] = "≄", -- U+02244
    ["NotTildeFullEqual"] = "≇", -- U+02247
    ["NotTildeTilde"] = "≉", -- U+02249
    ["NotVerticalBar"] = "∤", -- U+02224
    ["Nscr"] = "𝒩", -- U+1D4A9
    ["Ntilde"] = "Ñ", -- U+000D1
    ["Nu"] = "Ν", -- U+0039D
    ["OElig"] = "Œ", -- U+00152
    ["OHacgr"] = "Ώ", -- U+0038F
    ["OHgr"] = "Ω", -- U+003A9
    ["Oacgr"] = "Ό", -- U+0038C
    ["Oacute"] = "Ó", -- U+000D3
    ["Ocirc"] = "Ô", -- U+000D4
    ["Ocy"] = "О", -- U+0041E
    ["Odblac"] = "Ő", -- U+00150
    ["Ofr"] = "𝔒", -- U+1D512
    ["Ogr"] = "Ο", -- U+0039F
    ["Ograve"] = "Ò", -- U+000D2
    ["Omacr"] = "Ō", -- U+0014C
    ["Omega"] = "Ω", -- U+003A9
    ["Omicron"] = "Ο", -- U+0039F
    ["Oopf"] = "𝕆", -- U+1D546
    ["OpenCurlyDoubleQuote"] = "“", -- U+0201C
    ["OpenCurlyQuote"] = "‘", -- U+02018
    ["Or"] = "⩔", -- U+02A54
    ["Oscr"] = "𝒪", -- U+1D4AA
    ["Oslash"] = "Ø", -- U+000D8
    ["Otilde"] = "Õ", -- U+000D5
    ["Otimes"] = "⨷", -- U+02A37
    ["Ouml"] = "Ö", -- U+000D6
    ["OverBar"] = "‾", -- U+0203E
    ["OverBrace"] = "⏞", -- U+023DE
    ["OverBracket"] = "⎴", -- U+023B4
    ["OverParenthesis"] = "⏜", -- U+023DC
    ["PHgr"] = "Φ", -- U+003A6
    ["PSgr"] = "Ψ", -- U+003A8
    ["PartialD"] = "∂", -- U+02202
    ["Pcy"] = "П", -- U+0041F
    ["Pfr"] = "𝔓", -- U+1D513
    ["Pgr"] = "Π", -- U+003A0
    ["Phi"] = "Φ", -- U+003A6
    ["Pi"] = "Π", -- U+003A0
    ["PlusMinus"] = "±", -- U+000B1
    ["Poincareplane"] = "ℌ", -- U+0210C
    ["Popf"] = "ℙ", -- U+02119
    ["Pr"] = "⪻", -- U+02ABB
    ["Precedes"] = "≺", -- U+0227A
    ["PrecedesEqual"] = "⪯", -- U+02AAF
    ["PrecedesSlantEqual"] = "≼", -- U+0227C
    ["PrecedesTilde"] = "≾", -- U+0227E
    ["Prime"] = "″", -- U+02033
    ["Product"] = "∏", -- U+0220F
    ["Proportion"] = "∷", -- U+02237
    ["Proportional"] = "∝", -- U+0221D
    ["Pscr"] = "𝒫", -- U+1D4AB
    ["Psi"] = "Ψ", -- U+003A8
    ["QUOT"] = "\"", -- U+00022
    ["Qfr"] = "𝔔", -- U+1D514
    ["Qopf"] = "ℚ", -- U+0211A
    ["Qscr"] = "𝒬", -- U+1D4AC
    ["RBarr"] = "⤐", -- U+02910
    ["REG"] = "®", -- U+000AE
    ["Racute"] = "Ŕ", -- U+00154
    ["Rang"] = "⟫", -- U+027EB
    ["Rarr"] = "↠", -- U+021A0
    ["Rarrtl"] = "⤖", -- U+02916
    ["Rcaron"] = "Ř", -- U+00158
    ["Rcedil"] = "Ŗ", -- U+00156
    ["Rcy"] = "Р", -- U+00420
    ["Re"] = "ℜ", -- U+0211C
    ["ReverseElement"] = "∋", -- U+0220B
    ["ReverseEquilibrium"] = "⇋", -- U+021CB
    ["ReverseUpEquilibrium"] = "⥯", -- U+0296F
    ["Rfr"] = "ℜ", -- U+0211C
    ["Rgr"] = "Ρ", -- U+003A1
    ["Rho"] = "Ρ", -- U+003A1
    ["RightAngleBracket"] = "⟩", -- U+027E9
    ["RightArrow"] = "→", -- U+02192
    ["RightArrowBar"] = "⇥", -- U+021E5
    ["RightArrowLeftArrow"] = "⇄", -- U+021C4
    ["RightCeiling"] = "⌉", -- U+02309
    ["RightDoubleBracket"] = "⟧", -- U+027E7
    ["RightDownTeeVector"] = "⥝", -- U+0295D
    ["RightDownVector"] = "⇂", -- U+021C2
    ["RightDownVectorBar"] = "⥕", -- U+02955
    ["RightFloor"] = "⌋", -- U+0230B
    ["RightTee"] = "⊢", -- U+022A2
    ["RightTeeArrow"] = "↦", -- U+021A6
    ["RightTeeVector"] = "⥛", -- U+0295B
    ["RightTriangle"] = "⊳", -- U+022B3
    ["RightTriangleBar"] = "⧐", -- U+029D0
    ["RightTriangleEqual"] = "⊵", -- U+022B5
    ["RightUpDownVector"] = "⥏", -- U+0294F
    ["RightUpTeeVector"] = "⥜", -- U+0295C
    ["RightUpVector"] = "↾", -- U+021BE
    ["RightUpVectorBar"] = "⥔", -- U+02954
    ["RightVector"] = "⇀", -- U+021C0
    ["RightVectorBar"] = "⥓", -- U+02953
    ["Rightarrow"] = "⇒", -- U+021D2
    ["Ropf"] = "ℝ", -- U+0211D
    ["RoundImplies"] = "⥰", -- U+02970
    ["Rrightarrow"] = "⇛", -- U+021DB
    ["Rscr"] = "ℛ", -- U+0211B
    ["Rsh"] = "↱", -- U+021B1
    ["RuleDelayed"] = "⧴", -- U+029F4
    ["SHCHcy"] = "Щ", -- U+00429
    ["SHcy"] = "Ш", -- U+00428
    ["SOFTcy"] = "Ь", -- U+0042C
    ["Sacute"] = "Ś", -- U+0015A
    ["Sc"] = "⪼", -- U+02ABC
    ["Scaron"] = "Š", -- U+00160
    ["Scedil"] = "Ş", -- U+0015E
    ["Scirc"] = "Ŝ", -- U+0015C
    ["Scy"] = "С", -- U+00421
    ["Sfr"] = "𝔖", -- U+1D516
    ["Sgr"] = "Σ", -- U+003A3
    ["ShortDownArrow"] = "↓", -- U+02193
    ["ShortLeftArrow"] = "←", -- U+02190
    ["ShortRightArrow"] = "→", -- U+02192
    ["ShortUpArrow"] = "↑", -- U+02191
    ["Sigma"] = "Σ", -- U+003A3
    ["SmallCircle"] = "∘", -- U+02218
    ["Sopf"] = "𝕊", -- U+1D54A
    ["Sqrt"] = "√", -- U+0221A
    ["Square"] = "□", -- U+025A1
    ["SquareIntersection"] = "⊓", -- U+02293
    ["SquareSubset"] = "⊏", -- U+0228F
    ["SquareSubsetEqual"] = "⊑", -- U+02291
    ["SquareSuperset"] = "⊐", -- U+02290
    ["SquareSupersetEqual"] = "⊒", -- U+02292
    ["SquareUnion"] = "⊔", -- U+02294
    ["Sscr"] = "𝒮", -- U+1D4AE
    ["Star"] = "⋆", -- U+022C6
    ["Sub"] = "⋐", -- U+022D0
    ["Subset"] = "⋐", -- U+022D0
    ["SubsetEqual"] = "⊆", -- U+02286
    ["Succeeds"] = "≻", -- U+0227B
    ["SucceedsEqual"] = "⪰", -- U+02AB0
    ["SucceedsSlantEqual"] = "≽", -- U+0227D
    ["SucceedsTilde"] = "≿", -- U+0227F
    ["SuchThat"] = "∋", -- U+0220B
    ["Sum"] = "∑", -- U+02211
    ["Sup"] = "⋑", -- U+022D1
    ["Superset"] = "⊃", -- U+02283
    ["SupersetEqual"] = "⊇", -- U+02287
    ["Supset"] = "⋑", -- U+022D1
    ["THORN"] = "Þ", -- U+000DE
    ["THgr"] = "Θ", -- U+00398
    ["TRADE"] = "™", -- U+02122
    ["TSHcy"] = "Ћ", -- U+0040B
    ["TScy"] = "Ц", -- U+00426
    ["Tab"] = "\9", -- U+00009
    ["Tau"] = "Τ", -- U+003A4
    ["Tcaron"] = "Ť", -- U+00164
    ["Tcedil"] = "Ţ", -- U+00162
    ["Tcy"] = "Т", -- U+00422
    ["Tfr"] = "𝔗", -- U+1D517
    ["Tgr"] = "Τ", -- U+003A4
    ["Therefore"] = "∴", -- U+02234
    ["Theta"] = "Θ", -- U+00398
    ["ThickSpace"] = "  ", -- U+0205F 0200A
    ["ThinSpace"] = " ", -- U+02009
    ["Tilde"] = "∼", -- U+0223C
    ["TildeEqual"] = "≃", -- U+02243
    ["TildeFullEqual"] = "≅", -- U+02245
    ["TildeTilde"] = "≈", -- U+02248
    ["Topf"] = "𝕋", -- U+1D54B
    ["TripleDot"] = "⃛", -- U+020DB
    ["Tscr"] = "𝒯", -- U+1D4AF
    ["Tstrok"] = "Ŧ", -- U+00166
    ["Uacgr"] = "Ύ", -- U+0038E
    ["Uacute"] = "Ú", -- U+000DA
    ["Uarr"] = "↟", -- U+0219F
    ["Uarrocir"] = "⥉", -- U+02949
    ["Ubrcy"] = "Ў", -- U+0040E
    ["Ubreve"] = "Ŭ", -- U+0016C
    ["Ucirc"] = "Û", -- U+000DB
    ["Ucy"] = "У", -- U+00423
    ["Udblac"] = "Ű", -- U+00170
    ["Udigr"] = "Ϋ", -- U+003AB
    ["Ufr"] = "𝔘", -- U+1D518
    ["Ugr"] = "Υ", -- U+003A5
    ["Ugrave"] = "Ù", -- U+000D9
    ["Umacr"] = "Ū", -- U+0016A
 -- ["UnderBar"] = "_", -- U+0005F
    ["UnderBar"] = "‾", -- U+0203E
    ["UnderBrace"] = "⏟", -- U+023DF
    ["UnderBracket"] = "⎵", -- U+023B5
    ["UnderParenthesis"] = "⏝", -- U+023DD
    ["Union"] = "⋃", -- U+022C3
    ["UnionPlus"] = "⊎", -- U+0228E
    ["Uogon"] = "Ų", -- U+00172
    ["Uopf"] = "𝕌", -- U+1D54C
    ["UpArrow"] = "↑", -- U+02191
    ["UpArrowBar"] = "⤒", -- U+02912
    ["UpArrowDownArrow"] = "⇅", -- U+021C5
    ["UpDownArrow"] = "↕", -- U+02195
    ["UpEquilibrium"] = "⥮", -- U+0296E
    ["UpTee"] = "⊥", -- U+022A5
    ["UpTeeArrow"] = "↥", -- U+021A5
    ["Uparrow"] = "⇑", -- U+021D1
    ["Updownarrow"] = "⇕", -- U+021D5
    ["UpperLeftArrow"] = "↖", -- U+02196
    ["UpperRightArrow"] = "↗", -- U+02197
    ["Upsi"] = "ϒ", -- U+003D2
    ["Upsilon"] = "Υ", -- U+003A5
    ["Uring"] = "Ů", -- U+0016E
    ["Uscr"] = "𝒰", -- U+1D4B0
    ["Utilde"] = "Ũ", -- U+00168
    ["Uuml"] = "Ü", -- U+000DC
    ["VDash"] = "⊫", -- U+022AB
    ["Vbar"] = "⫫", -- U+02AEB
    ["Vcy"] = "В", -- U+00412
    ["Vdash"] = "⊩", -- U+022A9
    ["Vdashl"] = "⫦", -- U+02AE6
    ["Vee"] = "⋁", -- U+022C1
    ["Verbar"] = "‖", -- U+02016
    ["Vert"] = "‖", -- U+02016
    ["VerticalBar"] = "∣", -- U+02223
    ["VerticalLine"] = "|", -- U+0007C
    ["VerticalSeparator"] = "❘", -- U+02758
    ["VerticalTilde"] = "≀", -- U+02240
    ["VeryThinSpace"] = " ", -- U+0200A
    ["Vfr"] = "𝔙", -- U+1D519
    ["Vopf"] = "𝕍", -- U+1D54D
    ["Vscr"] = "𝒱", -- U+1D4B1
    ["Vvdash"] = "⊪", -- U+022AA
    ["Wcirc"] = "Ŵ", -- U+00174
    ["Wedge"] = "⋀", -- U+022C0
    ["Wfr"] = "𝔚", -- U+1D51A
    ["Wopf"] = "𝕎", -- U+1D54E
    ["Wscr"] = "𝒲", -- U+1D4B2
    ["Xfr"] = "𝔛", -- U+1D51B
    ["Xgr"] = "Ξ", -- U+0039E
    ["Xi"] = "Ξ", -- U+0039E
    ["Xopf"] = "𝕏", -- U+1D54F
    ["Xscr"] = "𝒳", -- U+1D4B3
    ["YAcy"] = "Я", -- U+0042F
    ["YIcy"] = "Ї", -- U+00407
    ["YUcy"] = "Ю", -- U+0042E
    ["Yacute"] = "Ý", -- U+000DD
    ["Ycirc"] = "Ŷ", -- U+00176
    ["Ycy"] = "Ы", -- U+0042B
    ["Yfr"] = "𝔜", -- U+1D51C
    ["Yopf"] = "𝕐", -- U+1D550
    ["Yscr"] = "𝒴", -- U+1D4B4
    ["Yuml"] = "Ÿ", -- U+00178
    ["ZHcy"] = "Ж", -- U+00416
    ["Zacute"] = "Ź", -- U+00179
    ["Zcaron"] = "Ž", -- U+0017D
    ["Zcy"] = "З", -- U+00417
    ["Zdot"] = "Ż", -- U+0017B
    ["ZeroWidthSpace"] = "​", -- U+0200B
    ["Zeta"] = "Ζ", -- U+00396
    ["Zfr"] = "ℨ", -- U+02128
    ["Zgr"] = "Ζ", -- U+00396
    ["Zopf"] = "ℤ", -- U+02124
    ["Zscr"] = "𝒵", -- U+1D4B5
    ["aacgr"] = "ά", -- U+003AC
    ["aacute"] = "á", -- U+000E1
    ["abreve"] = "ă", -- U+00103
    ["ac"] = "∾", -- U+0223E
    ["acE"] = "∾̳", -- U+0223E 00333
    ["acd"] = "∿", -- U+0223F
    ["acirc"] = "â", -- U+000E2
    ["acute"] = "´", -- U+000B4
    ["acy"] = "а", -- U+00430
    ["aelig"] = "æ", -- U+000E6
    ["af"] = "⁡", -- U+02061
    ["afr"] = "𝔞", -- U+1D51E
    ["agr"] = "α", -- U+003B1
    ["agrave"] = "à", -- U+000E0
    ["alefsym"] = "ℵ", -- U+02135
    ["aleph"] = "ℵ", -- U+02135
    ["alpha"] = "α", -- U+003B1
    ["amacr"] = "ā", -- U+00101
    ["amalg"] = "⨿", -- U+02A3F
    ["amp"] = "&", -- U+00026
    ["and"] = "∧", -- U+02227
    ["andand"] = "⩕", -- U+02A55
    ["andd"] = "⩜", -- U+02A5C
    ["andslope"] = "⩘", -- U+02A58
    ["andv"] = "⩚", -- U+02A5A
    ["ang"] = "∠", -- U+02220
    ["ange"] = "⦤", -- U+029A4
    ["angle"] = "∠", -- U+02220
    ["angmsd"] = "∡", -- U+02221
    ["angmsdaa"] = "⦨", -- U+029A8
    ["angmsdab"] = "⦩", -- U+029A9
    ["angmsdac"] = "⦪", -- U+029AA
    ["angmsdad"] = "⦫", -- U+029AB
    ["angmsdae"] = "⦬", -- U+029AC
    ["angmsdaf"] = "⦭", -- U+029AD
    ["angmsdag"] = "⦮", -- U+029AE
    ["angmsdah"] = "⦯", -- U+029AF
    ["angrt"] = "∟", -- U+0221F
    ["angrtvb"] = "⊾", -- U+022BE
    ["angrtvbd"] = "⦝", -- U+0299D
    ["angsph"] = "∢", -- U+02222
    ["angst"] = "Å", -- U+000C5
    ["angzarr"] = "⍼", -- U+0237C
    ["aogon"] = "ą", -- U+00105
    ["aopf"] = "𝕒", -- U+1D552
    ["ap"] = "≈", -- U+02248
    ["apE"] = "⩰", -- U+02A70
    ["apacir"] = "⩯", -- U+02A6F
    ["ape"] = "≊", -- U+0224A
    ["apid"] = "≋", -- U+0224B
    ["apos"] = "'", -- U+00027
    ["approx"] = "≈", -- U+02248
    ["approxeq"] = "≊", -- U+0224A
    ["aring"] = "å", -- U+000E5
    ["ascr"] = "𝒶", -- U+1D4B6
    ["ast"] = "*", -- U+0002A
    ["asymp"] = "≈", -- U+02248
    ["asympeq"] = "≍", -- U+0224D
    ["atilde"] = "ã", -- U+000E3
    ["auml"] = "ä", -- U+000E4
    ["awconint"] = "∳", -- U+02233
    ["awint"] = "⨑", -- U+02A11
    ["b.Delta"] = "𝚫", -- U+1D6AB
    ["b.Gamma"] = "𝚪", -- U+1D6AA
    ["b.Gammad"] = "𝟊", -- U+1D7CA
    ["b.Lambda"] = "𝚲", -- U+1D6B2
    ["b.Omega"] = "𝛀", -- U+1D6C0
    ["b.Phi"] = "𝚽", -- U+1D6BD
    ["b.Pi"] = "𝚷", -- U+1D6B7
    ["b.Psi"] = "𝚿", -- U+1D6BF
    ["b.Sigma"] = "𝚺", -- U+1D6BA
    ["b.Theta"] = "𝚯", -- U+1D6AF
    ["b.Upsi"] = "𝚼", -- U+1D6BC
    ["b.Xi"] = "𝚵", -- U+1D6B5
    ["b.alpha"] = "𝛂", -- U+1D6C2
    ["b.beta"] = "𝛃", -- U+1D6C3
    ["b.chi"] = "𝛘", -- U+1D6D8
    ["b.delta"] = "𝛅", -- U+1D6C5
    ["b.epsi"] = "𝛆", -- U+1D6C6
    ["b.epsiv"] = "𝛜", -- U+1D6DC
    ["b.eta"] = "𝛈", -- U+1D6C8
    ["b.gamma"] = "𝛄", -- U+1D6C4
    ["b.gammad"] = "𝟋", -- U+1D7CB
    ["b.iota"] = "𝛊", -- U+1D6CA
    ["b.kappa"] = "𝛋", -- U+1D6CB
    ["b.kappav"] = "𝛞", -- U+1D6DE
    ["b.lambda"] = "𝛌", -- U+1D6CC
    ["b.mu"] = "𝛍", -- U+1D6CD
    ["b.nu"] = "𝛎", -- U+1D6CE
    ["b.omega"] = "𝛚", -- U+1D6DA
    ["b.phi"] = "𝛗", -- U+1D6D7
    ["b.phiv"] = "𝛟", -- U+1D6DF
    ["b.pi"] = "𝛑", -- U+1D6D1
    ["b.piv"] = "𝛡", -- U+1D6E1
    ["b.psi"] = "𝛙", -- U+1D6D9
    ["b.rho"] = "𝛒", -- U+1D6D2
    ["b.rhov"] = "𝛠", -- U+1D6E0
    ["b.sigma"] = "𝛔", -- U+1D6D4
    ["b.sigmav"] = "𝛓", -- U+1D6D3
    ["b.tau"] = "𝛕", -- U+1D6D5
    ["b.thetas"] = "𝛉", -- U+1D6C9
    ["b.thetav"] = "𝛝", -- U+1D6DD
    ["b.upsi"] = "𝛖", -- U+1D6D6
    ["b.xi"] = "𝛏", -- U+1D6CF
    ["b.zeta"] = "𝛇", -- U+1D6C7
    ["bNot"] = "⫭", -- U+02AED
    ["backcong"] = "≌", -- U+0224C
    ["backepsilon"] = "϶", -- U+003F6
    ["backprime"] = "‵", -- U+02035
    ["backsim"] = "∽", -- U+0223D
    ["backsimeq"] = "⋍", -- U+022CD
    ["barvee"] = "⊽", -- U+022BD
    ["barwed"] = "⌅", -- U+02305
    ["barwedge"] = "⌅", -- U+02305
    ["bbrk"] = "⎵", -- U+023B5
    ["bbrktbrk"] = "⎶", -- U+023B6
    ["bcong"] = "≌", -- U+0224C
    ["bcy"] = "б", -- U+00431
    ["bdquo"] = "„", -- U+0201E
    ["becaus"] = "∵", -- U+02235
    ["because"] = "∵", -- U+02235
    ["bemptyv"] = "⦰", -- U+029B0
    ["bepsi"] = "϶", -- U+003F6
    ["bernou"] = "ℬ", -- U+0212C
    ["beta"] = "β", -- U+003B2
    ["beth"] = "ℶ", -- U+02136
    ["between"] = "≬", -- U+0226C
    ["bfr"] = "𝔟", -- U+1D51F
    ["bgr"] = "β", -- U+003B2
    ["bigcap"] = "⋂", -- U+022C2
    ["bigcirc"] = "◯", -- U+025EF
    ["bigcup"] = "⋃", -- U+022C3
    ["bigodot"] = "⨀", -- U+02A00
    ["bigoplus"] = "⨁", -- U+02A01
    ["bigotimes"] = "⨂", -- U+02A02
    ["bigsqcup"] = "⨆", -- U+02A06
    ["bigstar"] = "★", -- U+02605
    ["bigtriangledown"] = "▽", -- U+025BD
    ["bigtriangleup"] = "△", -- U+025B3
    ["biguplus"] = "⨄", -- U+02A04
    ["bigvee"] = "⋁", -- U+022C1
    ["bigwedge"] = "⋀", -- U+022C0
    ["bkarow"] = "⤍", -- U+0290D
    ["blacklozenge"] = "⧫", -- U+029EB
    ["blacksquare"] = "▪", -- U+025AA
    ["blacktriangle"] = "▴", -- U+025B4
    ["blacktriangledown"] = "▾", -- U+025BE
    ["blacktriangleleft"] = "◂", -- U+025C2
    ["blacktriangleright"] = "▸", -- U+025B8
    ["blank"] = "␣", -- U+02423
    ["blk12"] = "▒", -- U+02592
    ["blk14"] = "░", -- U+02591
    ["blk34"] = "▓", -- U+02593
    ["block"] = "█", -- U+02588
    ["bne"] = "=⃥", -- U+0003D 020E5
    ["bnequiv"] = "≡⃥", -- U+02261 020E5
    ["bnot"] = "⌐", -- U+02310
    ["bopf"] = "𝕓", -- U+1D553
    ["bot"] = "⊥", -- U+022A5
    ["bottom"] = "⊥", -- U+022A5
    ["bowtie"] = "⋈", -- U+022C8
    ["boxDL"] = "╗", -- U+02557
    ["boxDR"] = "╔", -- U+02554
    ["boxDl"] = "╖", -- U+02556
    ["boxDr"] = "╓", -- U+02553
    ["boxH"] = "═", -- U+02550
    ["boxHD"] = "╦", -- U+02566
    ["boxHU"] = "╩", -- U+02569
    ["boxHd"] = "╤", -- U+02564
    ["boxHu"] = "╧", -- U+02567
    ["boxUL"] = "╝", -- U+0255D
    ["boxUR"] = "╚", -- U+0255A
    ["boxUl"] = "╜", -- U+0255C
    ["boxUr"] = "╙", -- U+02559
    ["boxV"] = "║", -- U+02551
    ["boxVH"] = "╬", -- U+0256C
    ["boxVL"] = "╣", -- U+02563
    ["boxVR"] = "╠", -- U+02560
    ["boxVh"] = "╫", -- U+0256B
    ["boxVl"] = "╢", -- U+02562
    ["boxVr"] = "╟", -- U+0255F
    ["boxbox"] = "⧉", -- U+029C9
    ["boxdL"] = "╕", -- U+02555
    ["boxdR"] = "╒", -- U+02552
    ["boxdl"] = "┐", -- U+02510
    ["boxdr"] = "┌", -- U+0250C
    ["boxh"] = "─", -- U+02500
    ["boxhD"] = "╥", -- U+02565
    ["boxhU"] = "╨", -- U+02568
    ["boxhd"] = "┬", -- U+0252C
    ["boxhu"] = "┴", -- U+02534
    ["boxminus"] = "⊟", -- U+0229F
    ["boxplus"] = "⊞", -- U+0229E
    ["boxtimes"] = "⊠", -- U+022A0
    ["boxuL"] = "╛", -- U+0255B
    ["boxuR"] = "╘", -- U+02558
    ["boxul"] = "┘", -- U+02518
    ["boxur"] = "└", -- U+02514
    ["boxv"] = "│", -- U+02502
    ["boxvH"] = "╪", -- U+0256A
    ["boxvL"] = "╡", -- U+02561
    ["boxvR"] = "╞", -- U+0255E
    ["boxvh"] = "┼", -- U+0253C
    ["boxvl"] = "┤", -- U+02524
    ["boxvr"] = "├", -- U+0251C
    ["bprime"] = "‵", -- U+02035
    ["breve"] = "˘", -- U+002D8
    ["brvbar"] = "¦", -- U+000A6
    ["bscr"] = "𝒷", -- U+1D4B7
    ["bsemi"] = "⁏", -- U+0204F
    ["bsim"] = "∽", -- U+0223D
    ["bsime"] = "⋍", -- U+022CD
    ["bsol"] = "\\", -- U+0005C
    ["bsolb"] = "⧅", -- U+029C5
    ["bsolhsub"] = "⟈", -- U+027C8
    ["bull"] = "•", -- U+02022
    ["bullet"] = "•", -- U+02022
    ["bump"] = "≎", -- U+0224E
    ["bumpE"] = "⪮", -- U+02AAE
    ["bumpe"] = "≏", -- U+0224F
    ["bumpeq"] = "≏", -- U+0224F
    ["cacute"] = "ć", -- U+00107
    ["cap"] = "∩", -- U+02229
    ["capand"] = "⩄", -- U+02A44
    ["capbrcup"] = "⩉", -- U+02A49
    ["capcap"] = "⩋", -- U+02A4B
    ["capcup"] = "⩇", -- U+02A47
    ["capdot"] = "⩀", -- U+02A40
    ["caps"] = "∩︀", -- U+02229 0FE00
    ["caret"] = "⁁", -- U+02041
    ["caron"] = "ˇ", -- U+002C7
    ["ccaps"] = "⩍", -- U+02A4D
    ["ccaron"] = "č", -- U+0010D
    ["ccedil"] = "ç", -- U+000E7
    ["ccirc"] = "ĉ", -- U+00109
    ["ccups"] = "⩌", -- U+02A4C
    ["ccupssm"] = "⩐", -- U+02A50
    ["cdot"] = "ċ", -- U+0010B
    ["cedil"] = "¸", -- U+000B8
    ["cemptyv"] = "⦲", -- U+029B2
    ["cent"] = "¢", -- U+000A2
    ["centerdot"] = "·", -- U+000B7
    ["cfr"] = "𝔠", -- U+1D520
    ["chcy"] = "ч", -- U+00447
    ["check"] = "✓", -- U+02713
    ["checkmark"] = "✓", -- U+02713
    ["chi"] = "χ", -- U+003C7
    ["cir"] = "○", -- U+025CB
    ["cirE"] = "⧃", -- U+029C3
    ["circ"] = "ˆ", -- U+002C6
    ["circeq"] = "≗", -- U+02257
    ["circlearrowleft"] = "↺", -- U+021BA
    ["circlearrowright"] = "↻", -- U+021BB
    ["circledR"] = "®", -- U+000AE
    ["circledS"] = "Ⓢ", -- U+024C8
    ["circledast"] = "⊛", -- U+0229B
    ["circledcirc"] = "⊚", -- U+0229A
    ["circleddash"] = "⊝", -- U+0229D
    ["cire"] = "≗", -- U+02257
    ["cirfnint"] = "⨐", -- U+02A10
    ["cirmid"] = "⫯", -- U+02AEF
    ["cirscir"] = "⧂", -- U+029C2
    ["clubs"] = "♣", -- U+02663
    ["clubsuit"] = "♣", -- U+02663
    ["colon"] = ":", -- U+0003A
    ["colone"] = "≔", -- U+02254
    ["coloneq"] = "≔", -- U+02254
    ["comma"] = ",", -- U+0002C
    ["commat"] = "@", -- U+00040
    ["comp"] = "∁", -- U+02201
    ["compfn"] = "∘", -- U+02218
    ["complement"] = "∁", -- U+02201
    ["complexes"] = "ℂ", -- U+02102
    ["cong"] = "≅", -- U+02245
    ["congdot"] = "⩭", -- U+02A6D
    ["conint"] = "∮", -- U+0222E
    ["copf"] = "𝕔", -- U+1D554
    ["coprod"] = "∐", -- U+02210
    ["copy"] = "©", -- U+000A9
    ["copysr"] = "℗", -- U+02117
    ["crarr"] = "↵", -- U+021B5
    ["cross"] = "✗", -- U+02717
    ["cscr"] = "𝒸", -- U+1D4B8
    ["csub"] = "⫏", -- U+02ACF
    ["csube"] = "⫑", -- U+02AD1
    ["csup"] = "⫐", -- U+02AD0
    ["csupe"] = "⫒", -- U+02AD2
    ["ctdot"] = "⋯", -- U+022EF
    ["cudarrl"] = "⤸", -- U+02938
    ["cudarrr"] = "⤵", -- U+02935
    ["cuepr"] = "⋞", -- U+022DE
    ["cuesc"] = "⋟", -- U+022DF
    ["cularr"] = "↶", -- U+021B6
    ["cularrp"] = "⤽", -- U+0293D
    ["cup"] = "∪", -- U+0222A
    ["cupbrcap"] = "⩈", -- U+02A48
    ["cupcap"] = "⩆", -- U+02A46
    ["cupcup"] = "⩊", -- U+02A4A
    ["cupdot"] = "⊍", -- U+0228D
    ["cupor"] = "⩅", -- U+02A45
    ["cups"] = "∪︀", -- U+0222A 0FE00
    ["curarr"] = "↷", -- U+021B7
    ["curarrm"] = "⤼", -- U+0293C
    ["curlyeqprec"] = "⋞", -- U+022DE
    ["curlyeqsucc"] = "⋟", -- U+022DF
    ["curlyvee"] = "⋎", -- U+022CE
    ["curlywedge"] = "⋏", -- U+022CF
    ["curren"] = "¤", -- U+000A4
    ["curvearrowleft"] = "↶", -- U+021B6
    ["curvearrowright"] = "↷", -- U+021B7
    ["cuvee"] = "⋎", -- U+022CE
    ["cuwed"] = "⋏", -- U+022CF
    ["cwconint"] = "∲", -- U+02232
    ["cwint"] = "∱", -- U+02231
    ["cylcty"] = "⌭", -- U+0232D
    ["dArr"] = "⇓", -- U+021D3
    ["dHar"] = "⥥", -- U+02965
    ["dagger"] = "†", -- U+02020
    ["daleth"] = "ℸ", -- U+02138
    ["darr"] = "↓", -- U+02193
    ["dash"] = "‐", -- U+02010
    ["dashv"] = "⊣", -- U+022A3
    ["dbkarow"] = "⤏", -- U+0290F
    ["dblac"] = "˝", -- U+002DD
    ["dcaron"] = "ď", -- U+0010F
    ["dcy"] = "д", -- U+00434
    ["dd"] = "ⅆ", -- U+02146
    ["ddagger"] = "‡", -- U+02021
    ["ddarr"] = "⇊", -- U+021CA
    ["ddotseq"] = "⩷", -- U+02A77
    ["deg"] = "°", -- U+000B0
    ["delta"] = "δ", -- U+003B4
    ["demptyv"] = "⦱", -- U+029B1
    ["dfisht"] = "⥿", -- U+0297F
    ["dfr"] = "𝔡", -- U+1D521
    ["dgr"] = "δ", -- U+003B4
    ["dharl"] = "⇃", -- U+021C3
    ["dharr"] = "⇂", -- U+021C2
    ["diam"] = "⋄", -- U+022C4
    ["diamond"] = "⋄", -- U+022C4
    ["diamondsuit"] = "♦", -- U+02666
    ["diams"] = "♦", -- U+02666
    ["die"] = "¨", -- U+000A8
    ["digamma"] = "ϝ", -- U+003DD
    ["disin"] = "⋲", -- U+022F2
    ["div"] = "÷", -- U+000F7
    ["divide"] = "÷", -- U+000F7
    ["divideontimes"] = "⋇", -- U+022C7
    ["divonx"] = "⋇", -- U+022C7
    ["djcy"] = "ђ", -- U+00452
    ["dlcorn"] = "⌞", -- U+0231E
    ["dlcrop"] = "⌍", -- U+0230D
    ["dollar"] = "$", -- U+00024
    ["dopf"] = "𝕕", -- U+1D555
    ["dot"] = "˙", -- U+002D9
    ["doteq"] = "≐", -- U+02250
    ["doteqdot"] = "≑", -- U+02251
    ["dotminus"] = "∸", -- U+02238
    ["dotplus"] = "∔", -- U+02214
    ["dotsquare"] = "⊡", -- U+022A1
    ["doublebarwedge"] = "⌆", -- U+02306
    ["downarrow"] = "↓", -- U+02193
    ["downdownarrows"] = "⇊", -- U+021CA
    ["downharpoonleft"] = "⇃", -- U+021C3
    ["downharpoonright"] = "⇂", -- U+021C2
    ["drbkarow"] = "⤐", -- U+02910
    ["drcorn"] = "⌟", -- U+0231F
    ["drcrop"] = "⌌", -- U+0230C
    ["dscr"] = "𝒹", -- U+1D4B9
    ["dscy"] = "ѕ", -- U+00455
    ["dsol"] = "⧶", -- U+029F6
    ["dstrok"] = "đ", -- U+00111
    ["dtdot"] = "⋱", -- U+022F1
    ["dtri"] = "▿", -- U+025BF
    ["dtrif"] = "▾", -- U+025BE
    ["duarr"] = "⇵", -- U+021F5
    ["duhar"] = "⥯", -- U+0296F
    ["dwangle"] = "⦦", -- U+029A6
    ["dzcy"] = "џ", -- U+0045F
    ["dzigrarr"] = "⟿", -- U+027FF
    ["eDDot"] = "⩷", -- U+02A77
    ["eDot"] = "≑", -- U+02251
    ["eacgr"] = "έ", -- U+003AD
    ["eacute"] = "é", -- U+000E9
    ["easter"] = "⩮", -- U+02A6E
    ["ecaron"] = "ě", -- U+0011B
    ["ecir"] = "≖", -- U+02256
    ["ecirc"] = "ê", -- U+000EA
    ["ecolon"] = "≕", -- U+02255
    ["ecy"] = "э", -- U+0044D
    ["edot"] = "ė", -- U+00117
    ["ee"] = "ⅇ", -- U+02147
    ["eeacgr"] = "ή", -- U+003AE
    ["eegr"] = "η", -- U+003B7
    ["efDot"] = "≒", -- U+02252
    ["efr"] = "𝔢", -- U+1D522
    ["eg"] = "⪚", -- U+02A9A
    ["egr"] = "ε", -- U+003B5
    ["egrave"] = "è", -- U+000E8
    ["egs"] = "⪖", -- U+02A96
    ["egsdot"] = "⪘", -- U+02A98
    ["el"] = "⪙", -- U+02A99
    ["elinters"] = "⏧", -- U+023E7
    ["ell"] = "ℓ", -- U+02113
    ["els"] = "⪕", -- U+02A95
    ["elsdot"] = "⪗", -- U+02A97
    ["emacr"] = "ē", -- U+00113
    ["empty"] = "∅", -- U+02205
    ["emptyset"] = "∅", -- U+02205
    ["emptyv"] = "∅", -- U+02205
    ["emsp"] = " ", -- U+02003
    ["emsp13"] = " ", -- U+02004
    ["emsp14"] = " ", -- U+02005
    ["eng"] = "ŋ", -- U+0014B
    ["ensp"] = " ", -- U+02002
    ["eogon"] = "ę", -- U+00119
    ["eopf"] = "𝕖", -- U+1D556
    ["epar"] = "⋕", -- U+022D5
    ["eparsl"] = "⧣", -- U+029E3
    ["eplus"] = "⩱", -- U+02A71
    ["epsi"] = "ε", -- U+003B5
    ["epsilon"] = "ε", -- U+003B5
    ["epsiv"] = "ϵ", -- U+003F5
    ["eqcirc"] = "≖", -- U+02256
    ["eqcolon"] = "≕", -- U+02255
    ["eqsim"] = "≂", -- U+02242
    ["eqslantgtr"] = "⪖", -- U+02A96
    ["eqslantless"] = "⪕", -- U+02A95
    ["equals"] = "=", -- U+0003D
    ["equest"] = "≟", -- U+0225F
    ["equiv"] = "≡", -- U+02261
    ["equivDD"] = "⩸", -- U+02A78
    ["eqvparsl"] = "⧥", -- U+029E5
    ["erDot"] = "≓", -- U+02253
    ["erarr"] = "⥱", -- U+02971
    ["escr"] = "ℯ", -- U+0212F
    ["esdot"] = "≐", -- U+02250
    ["esim"] = "≂", -- U+02242
    ["eta"] = "η", -- U+003B7
    ["eth"] = "ð", -- U+000F0
    ["euml"] = "ë", -- U+000EB
    ["euro"] = "€", -- U+020AC
    ["excl"] = "!", -- U+00021
    ["exist"] = "∃", -- U+02203
    ["expectation"] = "ℰ", -- U+02130
    ["exponentiale"] = "ⅇ", -- U+02147
    ["fallingdotseq"] = "≒", -- U+02252
    ["fcy"] = "ф", -- U+00444
    ["female"] = "♀", -- U+02640
    ["ffilig"] = "ﬃ", -- U+0FB03
    ["fflig"] = "ﬀ", -- U+0FB00
    ["ffllig"] = "ﬄ", -- U+0FB04
    ["ffr"] = "𝔣", -- U+1D523
    ["filig"] = "ﬁ", -- U+0FB01
    ["fjlig"] = "fj", -- U+00066 0006A
    ["flat"] = "♭", -- U+0266D
    ["fllig"] = "ﬂ", -- U+0FB02
    ["fltns"] = "▱", -- U+025B1
    ["fnof"] = "ƒ", -- U+00192
    ["fopf"] = "𝕗", -- U+1D557
    ["forall"] = "∀", -- U+02200
    ["fork"] = "⋔", -- U+022D4
    ["forkv"] = "⫙", -- U+02AD9
    ["fpartint"] = "⨍", -- U+02A0D
    ["frac12"] = "½", -- U+000BD
    ["frac13"] = "⅓", -- U+02153
    ["frac14"] = "¼", -- U+000BC
    ["frac15"] = "⅕", -- U+02155
    ["frac16"] = "⅙", -- U+02159
    ["frac18"] = "⅛", -- U+0215B
    ["frac23"] = "⅔", -- U+02154
    ["frac25"] = "⅖", -- U+02156
    ["frac34"] = "¾", -- U+000BE
    ["frac35"] = "⅗", -- U+02157
    ["frac38"] = "⅜", -- U+0215C
    ["frac45"] = "⅘", -- U+02158
    ["frac56"] = "⅚", -- U+0215A
    ["frac58"] = "⅝", -- U+0215D
    ["frac78"] = "⅞", -- U+0215E
    ["frasl"] = "⁄", -- U+02044
    ["frown"] = "⌢", -- U+02322
    ["fscr"] = "𝒻", -- U+1D4BB
    ["gE"] = "≧", -- U+02267
    ["gEl"] = "⪌", -- U+02A8C
    ["gacute"] = "ǵ", -- U+001F5
    ["gamma"] = "γ", -- U+003B3
    ["gammad"] = "ϝ", -- U+003DD
    ["gap"] = "⪆", -- U+02A86
    ["gbreve"] = "ğ", -- U+0011F
    ["gcirc"] = "ĝ", -- U+0011D
    ["gcy"] = "г", -- U+00433
    ["gdot"] = "ġ", -- U+00121
    ["ge"] = "≥", -- U+02265
    ["gel"] = "⋛", -- U+022DB
    ["geq"] = "≥", -- U+02265
    ["geqq"] = "≧", -- U+02267
    ["geqslant"] = "⩾", -- U+02A7E
    ["ges"] = "⩾", -- U+02A7E
    ["gescc"] = "⪩", -- U+02AA9
    ["gesdot"] = "⪀", -- U+02A80
    ["gesdoto"] = "⪂", -- U+02A82
    ["gesdotol"] = "⪄", -- U+02A84
    ["gesl"] = "⋛︀", -- U+022DB 0FE00
    ["gesles"] = "⪔", -- U+02A94
    ["gfr"] = "𝔤", -- U+1D524
    ["gg"] = "≫", -- U+0226B
    ["ggg"] = "⋙", -- U+022D9
    ["ggr"] = "γ", -- U+003B3
    ["gimel"] = "ℷ", -- U+02137
    ["gjcy"] = "ѓ", -- U+00453
    ["gl"] = "≷", -- U+02277
    ["glE"] = "⪒", -- U+02A92
    ["gla"] = "⪥", -- U+02AA5
    ["glj"] = "⪤", -- U+02AA4
    ["gnE"] = "≩", -- U+02269
    ["gnap"] = "⪊", -- U+02A8A
    ["gnapprox"] = "⪊", -- U+02A8A
    ["gne"] = "⪈", -- U+02A88
    ["gneq"] = "⪈", -- U+02A88
    ["gneqq"] = "≩", -- U+02269
    ["gnsim"] = "⋧", -- U+022E7
    ["gopf"] = "𝕘", -- U+1D558
    ["grave"] = "`", -- U+00060
    ["gscr"] = "ℊ", -- U+0210A
    ["gsim"] = "≳", -- U+02273
    ["gsime"] = "⪎", -- U+02A8E
    ["gsiml"] = "⪐", -- U+02A90
    ["gt"] = ">", -- U+0003E
    ["gtcc"] = "⪧", -- U+02AA7
    ["gtcir"] = "⩺", -- U+02A7A
    ["gtdot"] = "⋗", -- U+022D7
    ["gtlPar"] = "⦕", -- U+02995
    ["gtquest"] = "⩼", -- U+02A7C
    ["gtrapprox"] = "⪆", -- U+02A86
    ["gtrarr"] = "⥸", -- U+02978
    ["gtrdot"] = "⋗", -- U+022D7
    ["gtreqless"] = "⋛", -- U+022DB
    ["gtreqqless"] = "⪌", -- U+02A8C
    ["gtrless"] = "≷", -- U+02277
    ["gtrsim"] = "≳", -- U+02273
    ["gvertneqq"] = "≩︀", -- U+02269 0FE00
    ["gvnE"] = "≩︀", -- U+02269 0FE00
    ["hArr"] = "⇔", -- U+021D4
    ["hairsp"] = " ", -- U+0200A
    ["half"] = "½", -- U+000BD
    ["hamilt"] = "ℋ", -- U+0210B
    ["hardcy"] = "ъ", -- U+0044A
    ["harr"] = "↔", -- U+02194
    ["harrcir"] = "⥈", -- U+02948
    ["harrw"] = "↭", -- U+021AD
    ["hbar"] = "ℏ", -- U+0210F
    ["hcirc"] = "ĥ", -- U+00125
    ["hearts"] = "♥", -- U+02665
    ["heartsuit"] = "♥", -- U+02665
    ["hellip"] = "…", -- U+02026
    ["hercon"] = "⊹", -- U+022B9
    ["hfr"] = "𝔥", -- U+1D525
    ["hksearow"] = "⤥", -- U+02925
    ["hkswarow"] = "⤦", -- U+02926
    ["hoarr"] = "⇿", -- U+021FF
    ["homtht"] = "∻", -- U+0223B
    ["hookleftarrow"] = "↩", -- U+021A9
    ["hookrightarrow"] = "↪", -- U+021AA
    ["hopf"] = "𝕙", -- U+1D559
    ["horbar"] = "―", -- U+02015
    ["hscr"] = "𝒽", -- U+1D4BD
    ["hslash"] = "ℏ", -- U+0210F
    ["hstrok"] = "ħ", -- U+00127
    ["hybull"] = "⁃", -- U+02043
    ["hyphen"] = "‐", -- U+02010
    ["iacgr"] = "ί", -- U+003AF
    ["iacute"] = "í", -- U+000ED
    ["ic"] = "⁣", -- U+02063
    ["icirc"] = "î", -- U+000EE
    ["icy"] = "и", -- U+00438
    ["idiagr"] = "ΐ", -- U+00390
    ["idigr"] = "ϊ", -- U+003CA
    ["iecy"] = "е", -- U+00435
    ["iexcl"] = "¡", -- U+000A1
    ["iff"] = "⇔", -- U+021D4
    ["ifr"] = "𝔦", -- U+1D526
    ["igr"] = "ι", -- U+003B9
    ["igrave"] = "ì", -- U+000EC
    ["ii"] = "ⅈ", -- U+02148
    ["iiiint"] = "⨌", -- U+02A0C
    ["iiint"] = "∭", -- U+0222D
    ["iinfin"] = "⧜", -- U+029DC
    ["iiota"] = "℩", -- U+02129
    ["ijlig"] = "ĳ", -- U+00133
    ["imacr"] = "ī", -- U+0012B
    ["image"] = "ℑ", -- U+02111
    ["imagline"] = "ℐ", -- U+02110
    ["imagpart"] = "ℑ", -- U+02111
    ["imath"] = "ı", -- U+00131
    ["imof"] = "⊷", -- U+022B7
    ["imped"] = "Ƶ", -- U+001B5
    ["in"] = "∈", -- U+02208
    ["incare"] = "℅", -- U+02105
    ["infin"] = "∞", -- U+0221E
    ["infintie"] = "⧝", -- U+029DD
    ["inodot"] = "ı", -- U+00131
    ["int"] = "∫", -- U+0222B
    ["intcal"] = "⊺", -- U+022BA
    ["integers"] = "ℤ", -- U+02124
    ["intercal"] = "⊺", -- U+022BA
    ["intlarhk"] = "⨗", -- U+02A17
    ["intprod"] = "⨼", -- U+02A3C
    ["iocy"] = "ё", -- U+00451
    ["iogon"] = "į", -- U+0012F
    ["iopf"] = "𝕚", -- U+1D55A
    ["iota"] = "ι", -- U+003B9
    ["iprod"] = "⨼", -- U+02A3C
    ["iquest"] = "¿", -- U+000BF
    ["iscr"] = "𝒾", -- U+1D4BE
    ["isin"] = "∈", -- U+02208
    ["isinE"] = "⋹", -- U+022F9
    ["isindot"] = "⋵", -- U+022F5
    ["isins"] = "⋴", -- U+022F4
    ["isinsv"] = "⋳", -- U+022F3
    ["isinv"] = "∈", -- U+02208
    ["it"] = "⁢", -- U+02062
    ["itilde"] = "ĩ", -- U+00129
    ["iukcy"] = "і", -- U+00456
    ["iuml"] = "ï", -- U+000EF
    ["jcirc"] = "ĵ", -- U+00135
    ["jcy"] = "й", -- U+00439
    ["jfr"] = "𝔧", -- U+1D527
    ["jmath"] = "ȷ", -- U+00237
    ["jopf"] = "𝕛", -- U+1D55B
    ["jscr"] = "𝒿", -- U+1D4BF
    ["jsercy"] = "ј", -- U+00458
    ["jukcy"] = "є", -- U+00454
    ["kappa"] = "κ", -- U+003BA
    ["kappav"] = "ϰ", -- U+003F0
    ["kcedil"] = "ķ", -- U+00137
    ["kcy"] = "к", -- U+0043A
    ["kfr"] = "𝔨", -- U+1D528
    ["kgr"] = "κ", -- U+003BA
    ["kgreen"] = "ĸ", -- U+00138
    ["khcy"] = "х", -- U+00445
    ["khgr"] = "χ", -- U+003C7
    ["kjcy"] = "ќ", -- U+0045C
    ["kopf"] = "𝕜", -- U+1D55C
    ["kscr"] = "𝓀", -- U+1D4C0
    ["lAarr"] = "⇚", -- U+021DA
    ["lArr"] = "⇐", -- U+021D0
    ["lAtail"] = "⤛", -- U+0291B
    ["lBarr"] = "⤎", -- U+0290E
    ["lE"] = "≦", -- U+02266
    ["lEg"] = "⪋", -- U+02A8B
    ["lHar"] = "⥢", -- U+02962
    ["lacute"] = "ĺ", -- U+0013A
    ["laemptyv"] = "⦴", -- U+029B4
    ["lagran"] = "ℒ", -- U+02112
    ["lambda"] = "λ", -- U+003BB
    ["lang"] = "⟨", -- U+027E8
    ["langd"] = "⦑", -- U+02991
    ["langle"] = "⟨", -- U+027E8
    ["lap"] = "⪅", -- U+02A85
    ["laquo"] = "«", -- U+000AB
    ["larr"] = "←", -- U+02190
    ["larrb"] = "⇤", -- U+021E4
    ["larrbfs"] = "⤟", -- U+0291F
    ["larrfs"] = "⤝", -- U+0291D
    ["larrhk"] = "↩", -- U+021A9
    ["larrlp"] = "↫", -- U+021AB
    ["larrpl"] = "⤹", -- U+02939
    ["larrsim"] = "⥳", -- U+02973
    ["larrtl"] = "↢", -- U+021A2
    ["lat"] = "⪫", -- U+02AAB
    ["latail"] = "⤙", -- U+02919
    ["late"] = "⪭", -- U+02AAD
    ["lates"] = "⪭︀", -- U+02AAD 0FE00
    ["lbarr"] = "⤌", -- U+0290C
    ["lbbrk"] = "❲", -- U+02772
    ["lbrace"] = "{", -- U+0007B
    ["lbrack"] = "[", -- U+0005B
    ["lbrke"] = "⦋", -- U+0298B
    ["lbrksld"] = "⦏", -- U+0298F
    ["lbrkslu"] = "⦍", -- U+0298D
    ["lcaron"] = "ľ", -- U+0013E
    ["lcedil"] = "ļ", -- U+0013C
    ["lceil"] = "⌈", -- U+02308
    ["lcub"] = "{", -- U+0007B
    ["lcy"] = "л", -- U+0043B
    ["ldca"] = "⤶", -- U+02936
    ["ldquo"] = "“", -- U+0201C
    ["ldquor"] = "„", -- U+0201E
    ["ldrdhar"] = "⥧", -- U+02967
    ["ldrushar"] = "⥋", -- U+0294B
    ["ldsh"] = "↲", -- U+021B2
    ["le"] = "≤", -- U+02264
    ["leftarrow"] = "←", -- U+02190
    ["leftarrowtail"] = "↢", -- U+021A2
    ["leftharpoondown"] = "↽", -- U+021BD
    ["leftharpoonup"] = "↼", -- U+021BC
    ["leftleftarrows"] = "⇇", -- U+021C7
    ["leftrightarrow"] = "↔", -- U+02194
    ["leftrightarrows"] = "⇆", -- U+021C6
    ["leftrightharpoons"] = "⇋", -- U+021CB
    ["leftrightsquigarrow"] = "↭", -- U+021AD
    ["leftthreetimes"] = "⋋", -- U+022CB
    ["leg"] = "⋚", -- U+022DA
    ["leq"] = "≤", -- U+02264
    ["leqq"] = "≦", -- U+02266
    ["leqslant"] = "⩽", -- U+02A7D
    ["les"] = "⩽", -- U+02A7D
    ["lescc"] = "⪨", -- U+02AA8
    ["lesdot"] = "⩿", -- U+02A7F
    ["lesdoto"] = "⪁", -- U+02A81
    ["lesdotor"] = "⪃", -- U+02A83
    ["lesg"] = "⋚︀", -- U+022DA 0FE00
    ["lesges"] = "⪓", -- U+02A93
    ["lessapprox"] = "⪅", -- U+02A85
    ["lessdot"] = "⋖", -- U+022D6
    ["lesseqgtr"] = "⋚", -- U+022DA
    ["lesseqqgtr"] = "⪋", -- U+02A8B
    ["lessgtr"] = "≶", -- U+02276
    ["lesssim"] = "≲", -- U+02272
    ["lfisht"] = "⥼", -- U+0297C
    ["lfloor"] = "⌊", -- U+0230A
    ["lfr"] = "𝔩", -- U+1D529
    ["lg"] = "≶", -- U+02276
    ["lgE"] = "⪑", -- U+02A91
    ["lgr"] = "λ", -- U+003BB
    ["lhard"] = "↽", -- U+021BD
    ["lharu"] = "↼", -- U+021BC
    ["lharul"] = "⥪", -- U+0296A
    ["lhblk"] = "▄", -- U+02584
    ["ljcy"] = "љ", -- U+00459
    ["ll"] = "≪", -- U+0226A
    ["llarr"] = "⇇", -- U+021C7
    ["llcorner"] = "⌞", -- U+0231E
    ["llhard"] = "⥫", -- U+0296B
    ["lltri"] = "◺", -- U+025FA
    ["lmidot"] = "ŀ", -- U+00140
    ["lmoust"] = "⎰", -- U+023B0
    ["lmoustache"] = "⎰", -- U+023B0
    ["lnE"] = "≨", -- U+02268
    ["lnap"] = "⪉", -- U+02A89
    ["lnapprox"] = "⪉", -- U+02A89
    ["lne"] = "⪇", -- U+02A87
    ["lneq"] = "⪇", -- U+02A87
    ["lneqq"] = "≨", -- U+02268
    ["lnsim"] = "⋦", -- U+022E6
    ["loang"] = "⟬", -- U+027EC
    ["loarr"] = "⇽", -- U+021FD
    ["lobrk"] = "⟦", -- U+027E6
    ["longleftarrow"] = "⟵", -- U+027F5
    ["longleftrightarrow"] = "⟷", -- U+027F7
    ["longmapsto"] = "⟼", -- U+027FC
    ["longrightarrow"] = "⟶", -- U+027F6
    ["looparrowleft"] = "↫", -- U+021AB
    ["looparrowright"] = "↬", -- U+021AC
    ["lopar"] = "⦅", -- U+02985
    ["lopf"] = "𝕝", -- U+1D55D
    ["loplus"] = "⨭", -- U+02A2D
    ["lotimes"] = "⨴", -- U+02A34
    ["lowast"] = "∗", -- U+02217
    ["lowbar"] = "_", -- U+0005F
    ["loz"] = "◊", -- U+025CA
    ["lozenge"] = "◊", -- U+025CA
    ["lozf"] = "⧫", -- U+029EB
    ["lpar"] = "(", -- U+00028
    ["lparlt"] = "⦓", -- U+02993
    ["lrarr"] = "⇆", -- U+021C6
    ["lrcorner"] = "⌟", -- U+0231F
    ["lrhar"] = "⇋", -- U+021CB
    ["lrhard"] = "⥭", -- U+0296D
    ["lrm"] = "‎", -- U+0200E
    ["lrtri"] = "⊿", -- U+022BF
    ["lsaquo"] = "‹", -- U+02039
    ["lscr"] = "𝓁", -- U+1D4C1
    ["lsh"] = "↰", -- U+021B0
    ["lsim"] = "≲", -- U+02272
    ["lsime"] = "⪍", -- U+02A8D
    ["lsimg"] = "⪏", -- U+02A8F
    ["lsqb"] = "[", -- U+0005B
    ["lsquo"] = "‘", -- U+02018
    ["lsquor"] = "‚", -- U+0201A
    ["lstrok"] = "ł", -- U+00142
    ["lt"] = "<", -- U+00026
    ["ltcc"] = "⪦", -- U+02AA6
    ["ltcir"] = "⩹", -- U+02A79
    ["ltdot"] = "⋖", -- U+022D6
    ["lthree"] = "⋋", -- U+022CB
    ["ltimes"] = "⋉", -- U+022C9
    ["ltlarr"] = "⥶", -- U+02976
    ["ltquest"] = "⩻", -- U+02A7B
    ["ltrPar"] = "⦖", -- U+02996
    ["ltri"] = "◃", -- U+025C3
    ["ltrie"] = "⊴", -- U+022B4
    ["ltrif"] = "◂", -- U+025C2
    ["lurdshar"] = "⥊", -- U+0294A
    ["luruhar"] = "⥦", -- U+02966
    ["lvertneqq"] = "≨︀", -- U+02268 0FE00
    ["lvnE"] = "≨︀", -- U+02268 0FE00
    ["mDDot"] = "∺", -- U+0223A
    ["macr"] = "¯", -- U+000AF
    ["male"] = "♂", -- U+02642
    ["malt"] = "✠", -- U+02720
    ["maltese"] = "✠", -- U+02720
    ["map"] = "↦", -- U+021A6
    ["mapsto"] = "↦", -- U+021A6
    ["mapstodown"] = "↧", -- U+021A7
    ["mapstoleft"] = "↤", -- U+021A4
    ["mapstoup"] = "↥", -- U+021A5
    ["marker"] = "▮", -- U+025AE
    ["mcomma"] = "⨩", -- U+02A29
    ["mcy"] = "м", -- U+0043C
    ["mdash"] = "—", -- U+02014
    ["measuredangle"] = "∡", -- U+02221
    ["mfr"] = "𝔪", -- U+1D52A
    ["mgr"] = "μ", -- U+003BC
    ["mho"] = "℧", -- U+02127
    ["micro"] = "µ", -- U+000B5
    ["mid"] = "∣", -- U+02223
    ["midast"] = "*", -- U+0002A
    ["midcir"] = "⫰", -- U+02AF0
    ["middot"] = "·", -- U+000B7
    ["minus"] = "−", -- U+02212
    ["minusb"] = "⊟", -- U+0229F
    ["minusd"] = "∸", -- U+02238
    ["minusdu"] = "⨪", -- U+02A2A
    ["mlcp"] = "⫛", -- U+02ADB
    ["mldr"] = "…", -- U+02026
    ["mnplus"] = "∓", -- U+02213
    ["models"] = "⊧", -- U+022A7
    ["mopf"] = "𝕞", -- U+1D55E
    ["mp"] = "∓", -- U+02213
    ["mscr"] = "𝓂", -- U+1D4C2
    ["mstpos"] = "∾", -- U+0223E
    ["mu"] = "μ", -- U+003BC
    ["multimap"] = "⊸", -- U+022B8
    ["mumap"] = "⊸", -- U+022B8
    ["nGg"] = "⋙̸", -- U+022D9 00338
    ["nGt"] = "≫⃒", -- U+0226B 020D2
    ["nGtv"] = "≫̸", -- U+0226B 00338
    ["nLeftarrow"] = "⇍", -- U+021CD
    ["nLeftrightarrow"] = "⇎", -- U+021CE
    ["nLl"] = "⋘̸", -- U+022D8 00338
    ["nLt"] = "≪⃒", -- U+0226A 020D2
    ["nLtv"] = "≪̸", -- U+0226A 00338
    ["nRightarrow"] = "⇏", -- U+021CF
    ["nVDash"] = "⊯", -- U+022AF
    ["nVdash"] = "⊮", -- U+022AE
    ["nabla"] = "∇", -- U+02207
    ["nacute"] = "ń", -- U+00144
    ["nang"] = "∠⃒", -- U+02220 020D2
    ["nap"] = "≉", -- U+02249
    ["napE"] = "⩰̸", -- U+02A70 00338
    ["napid"] = "≋̸", -- U+0224B 00338
    ["napos"] = "ŉ", -- U+00149
    ["napprox"] = "≉", -- U+02249
    ["natur"] = "♮", -- U+0266E
    ["natural"] = "♮", -- U+0266E
    ["naturals"] = "ℕ", -- U+02115
    ["nbsp"] = " ", -- U+000A0
    ["nbump"] = "≎̸", -- U+0224E 00338
    ["nbumpe"] = "≏̸", -- U+0224F 00338
    ["ncap"] = "⩃", -- U+02A43
    ["ncaron"] = "ň", -- U+00148
    ["ncedil"] = "ņ", -- U+00146
    ["ncong"] = "≇", -- U+02247
    ["ncongdot"] = "⩭̸", -- U+02A6D 00338
    ["ncup"] = "⩂", -- U+02A42
    ["ncy"] = "н", -- U+0043D
    ["ndash"] = "–", -- U+02013
    ["ne"] = "≠", -- U+02260
    ["neArr"] = "⇗", -- U+021D7
    ["nearhk"] = "⤤", -- U+02924
    ["nearr"] = "↗", -- U+02197
    ["nearrow"] = "↗", -- U+02197
    ["nedot"] = "≐̸", -- U+02250 00338
    ["nequiv"] = "≢", -- U+02262
    ["nesear"] = "⤨", -- U+02928
    ["nesim"] = "≂̸", -- U+02242 00338
    ["nexist"] = "∄", -- U+02204
    ["nexists"] = "∄", -- U+02204
    ["nfr"] = "𝔫", -- U+1D52B
    ["ngE"] = "≧̸", -- U+02267 00338
    ["nge"] = "≱", -- U+02271
    ["ngeq"] = "≱", -- U+02271
    ["ngeqq"] = "≧̸", -- U+02267 00338
    ["ngeqslant"] = "⩾̸", -- U+02A7E 00338
    ["nges"] = "⩾̸", -- U+02A7E 00338
    ["ngr"] = "ν", -- U+003BD
    ["ngsim"] = "≵", -- U+02275
    ["ngt"] = "≯", -- U+0226F
    ["ngtr"] = "≯", -- U+0226F
    ["nhArr"] = "⇎", -- U+021CE
    ["nharr"] = "↮", -- U+021AE
    ["nhpar"] = "⫲", -- U+02AF2
    ["ni"] = "∋", -- U+0220B
    ["nis"] = "⋼", -- U+022FC
    ["nisd"] = "⋺", -- U+022FA
    ["niv"] = "∋", -- U+0220B
    ["njcy"] = "њ", -- U+0045A
    ["nlArr"] = "⇍", -- U+021CD
    ["nlE"] = "≦̸", -- U+02266 00338
    ["nlarr"] = "↚", -- U+0219A
    ["nldr"] = "‥", -- U+02025
    ["nle"] = "≰", -- U+02270
    ["nleftarrow"] = "↚", -- U+0219A
    ["nleftrightarrow"] = "↮", -- U+021AE
    ["nleq"] = "≰", -- U+02270
    ["nleqq"] = "≦̸", -- U+02266 00338
    ["nleqslant"] = "⩽̸", -- U+02A7D 00338
    ["nles"] = "⩽̸", -- U+02A7D 00338
    ["nless"] = "≮", -- U+0226E
    ["nlsim"] = "≴", -- U+02274
    ["nlt"] = "≮", -- U+0226E
    ["nltri"] = "⋪", -- U+022EA
    ["nltrie"] = "⋬", -- U+022EC
    ["nmid"] = "∤", -- U+02224
    ["nopf"] = "𝕟", -- U+1D55F
    ["not"] = "¬", -- U+000AC
    ["notin"] = "∉", -- U+02209
    ["notinE"] = "⋹̸", -- U+022F9 00338
    ["notindot"] = "⋵̸", -- U+022F5 00338
    ["notinva"] = "∉", -- U+02209
    ["notinvb"] = "⋷", -- U+022F7
    ["notinvc"] = "⋶", -- U+022F6
    ["notni"] = "∌", -- U+0220C
    ["notniva"] = "∌", -- U+0220C
    ["notnivb"] = "⋾", -- U+022FE
    ["notnivc"] = "⋽", -- U+022FD
    ["npar"] = "∦", -- U+02226
    ["nparallel"] = "∦", -- U+02226
    ["nparsl"] = "⫽⃥", -- U+02AFD 020E5
    ["npart"] = "∂̸", -- U+02202 00338
    ["npolint"] = "⨔", -- U+02A14
    ["npr"] = "⊀", -- U+02280
    ["nprcue"] = "⋠", -- U+022E0
    ["npre"] = "⪯̸", -- U+02AAF 00338
    ["nprec"] = "⊀", -- U+02280
    ["npreceq"] = "⪯̸", -- U+02AAF 00338
    ["nrArr"] = "⇏", -- U+021CF
    ["nrarr"] = "↛", -- U+0219B
    ["nrarrc"] = "⤳̸", -- U+02933 00338
    ["nrarrw"] = "↝̸", -- U+0219D 00338
    ["nrightarrow"] = "↛", -- U+0219B
    ["nrtri"] = "⋫", -- U+022EB
    ["nrtrie"] = "⋭", -- U+022ED
    ["nsc"] = "⊁", -- U+02281
    ["nsccue"] = "⋡", -- U+022E1
    ["nsce"] = "⪰̸", -- U+02AB0 00338
    ["nscr"] = "𝓃", -- U+1D4C3
    ["nshortmid"] = "∤", -- U+02224
    ["nshortparallel"] = "∦", -- U+02226
    ["nsim"] = "≁", -- U+02241
    ["nsime"] = "≄", -- U+02244
    ["nsimeq"] = "≄", -- U+02244
    ["nsmid"] = "∤", -- U+02224
    ["nspar"] = "∦", -- U+02226
    ["nsqsube"] = "⋢", -- U+022E2
    ["nsqsupe"] = "⋣", -- U+022E3
    ["nsub"] = "⊄", -- U+02284
    ["nsubE"] = "⫅̸", -- U+02AC5 00338
    ["nsube"] = "⊈", -- U+02288
    ["nsubset"] = "⊂⃒", -- U+02282 020D2
    ["nsubseteq"] = "⊈", -- U+02288
    ["nsubseteqq"] = "⫅̸", -- U+02AC5 00338
    ["nsucc"] = "⊁", -- U+02281
    ["nsucceq"] = "⪰̸", -- U+02AB0 00338
    ["nsup"] = "⊅", -- U+02285
    ["nsupE"] = "⫆̸", -- U+02AC6 00338
    ["nsupe"] = "⊉", -- U+02289
    ["nsupset"] = "⊃⃒", -- U+02283 020D2
    ["nsupseteq"] = "⊉", -- U+02289
    ["nsupseteqq"] = "⫆̸", -- U+02AC6 00338
    ["ntgl"] = "≹", -- U+02279
    ["ntilde"] = "ñ", -- U+000F1
    ["ntlg"] = "≸", -- U+02278
    ["ntriangleleft"] = "⋪", -- U+022EA
    ["ntrianglelefteq"] = "⋬", -- U+022EC
    ["ntriangleright"] = "⋫", -- U+022EB
    ["ntrianglerighteq"] = "⋭", -- U+022ED
    ["nu"] = "ν", -- U+003BD
    ["num"] = "#", -- U+00023
    ["numero"] = "№", -- U+02116
    ["numsp"] = " ", -- U+02007
    ["nvDash"] = "⊭", -- U+022AD
    ["nvHarr"] = "⤄", -- U+02904
    ["nvap"] = "≍⃒", -- U+0224D 020D2
    ["nvdash"] = "⊬", -- U+022AC
    ["nvge"] = "≥⃒", -- U+02265 020D2
    ["nvgt"] = ">⃒", -- U+0003E 020D2
    ["nvinfin"] = "⧞", -- U+029DE
    ["nvlArr"] = "⤂", -- U+02902
    ["nvle"] = "≤⃒", -- U+02264 020D2
    ["nvlt"] = "&⃒", -- U+00026 020D2
    ["nvltrie"] = "⊴⃒", -- U+022B4 020D2
    ["nvrArr"] = "⤃", -- U+02903
    ["nvrtrie"] = "⊵⃒", -- U+022B5 020D2
    ["nvsim"] = "∼⃒", -- U+0223C 020D2
    ["nwArr"] = "⇖", -- U+021D6
    ["nwarhk"] = "⤣", -- U+02923
    ["nwarr"] = "↖", -- U+02196
    ["nwarrow"] = "↖", -- U+02196
    ["nwnear"] = "⤧", -- U+02927
    ["oS"] = "Ⓢ", -- U+024C8
    ["oacgr"] = "ό", -- U+003CC
    ["oacute"] = "ó", -- U+000F3
    ["oast"] = "⊛", -- U+0229B
    ["ocir"] = "⊚", -- U+0229A
    ["ocirc"] = "ô", -- U+000F4
    ["ocy"] = "о", -- U+0043E
    ["odash"] = "⊝", -- U+0229D
    ["odblac"] = "ő", -- U+00151
    ["odiv"] = "⨸", -- U+02A38
    ["odot"] = "⊙", -- U+02299
    ["odsold"] = "⦼", -- U+029BC
    ["oelig"] = "œ", -- U+00153
    ["ofcir"] = "⦿", -- U+029BF
    ["ofr"] = "𝔬", -- U+1D52C
    ["ogon"] = "˛", -- U+002DB
    ["ogr"] = "ο", -- U+003BF
    ["ograve"] = "ò", -- U+000F2
    ["ogt"] = "⧁", -- U+029C1
    ["ohacgr"] = "ώ", -- U+003CE
    ["ohbar"] = "⦵", -- U+029B5
    ["ohgr"] = "ω", -- U+003C9
    ["ohm"] = "Ω", -- U+003A9
    ["oint"] = "∮", -- U+0222E
    ["olarr"] = "↺", -- U+021BA
    ["olcir"] = "⦾", -- U+029BE
    ["olcross"] = "⦻", -- U+029BB
    ["oline"] = "‾", -- U+0203E
    ["olt"] = "⧀", -- U+029C0
    ["omacr"] = "ō", -- U+0014D
    ["omega"] = "ω", -- U+003C9
    ["omicron"] = "ο", -- U+003BF
    ["omid"] = "⦶", -- U+029B6
    ["ominus"] = "⊖", -- U+02296
    ["oopf"] = "𝕠", -- U+1D560
    ["opar"] = "⦷", -- U+029B7
    ["operp"] = "⦹", -- U+029B9
    ["oplus"] = "⊕", -- U+02295
    ["or"] = "∨", -- U+02228
    ["orarr"] = "↻", -- U+021BB
    ["ord"] = "⩝", -- U+02A5D
    ["order"] = "ℴ", -- U+02134
    ["orderof"] = "ℴ", -- U+02134
    ["ordf"] = "ª", -- U+000AA
    ["ordm"] = "º", -- U+000BA
    ["origof"] = "⊶", -- U+022B6
    ["oror"] = "⩖", -- U+02A56
    ["orslope"] = "⩗", -- U+02A57
    ["orv"] = "⩛", -- U+02A5B
    ["oscr"] = "ℴ", -- U+02134
    ["oslash"] = "ø", -- U+000F8
    ["osol"] = "⊘", -- U+02298
    ["otilde"] = "õ", -- U+000F5
    ["otimes"] = "⊗", -- U+02297
    ["otimesas"] = "⨶", -- U+02A36
    ["ouml"] = "ö", -- U+000F6
    ["ovbar"] = "⌽", -- U+0233D
    ["par"] = "∥", -- U+02225
    ["para"] = "¶", -- U+000B6
    ["parallel"] = "∥", -- U+02225
    ["parsim"] = "⫳", -- U+02AF3
    ["parsl"] = "⫽", -- U+02AFD
    ["part"] = "∂", -- U+02202
    ["pcy"] = "п", -- U+0043F
    ["percnt"] = "%", -- U+00025
    ["period"] = ".", -- U+0002E
    ["permil"] = "‰", -- U+02030
    ["perp"] = "⊥", -- U+022A5
    ["pertenk"] = "‱", -- U+02031
    ["pfr"] = "𝔭", -- U+1D52D
    ["pgr"] = "π", -- U+003C0
    ["phgr"] = "φ", -- U+003C6
    ["phi"] = "φ", -- U+003C6
    ["phiv"] = "ϕ", -- U+003D5
    ["phmmat"] = "ℳ", -- U+02133
    ["phone"] = "☎", -- U+0260E
    ["pi"] = "π", -- U+003C0
    ["pitchfork"] = "⋔", -- U+022D4
    ["piv"] = "ϖ", -- U+003D6
    ["planck"] = "ℏ", -- U+0210F
    ["planckh"] = "ℎ", -- U+0210E
    ["plankv"] = "ℏ", -- U+0210F
    ["plus"] = "+", -- U+0002B
    ["plusacir"] = "⨣", -- U+02A23
    ["plusb"] = "⊞", -- U+0229E
    ["pluscir"] = "⨢", -- U+02A22
    ["plusdo"] = "∔", -- U+02214
    ["plusdu"] = "⨥", -- U+02A25
    ["pluse"] = "⩲", -- U+02A72
    ["plusmn"] = "±", -- U+000B1
    ["plussim"] = "⨦", -- U+02A26
    ["plustwo"] = "⨧", -- U+02A27
    ["pm"] = "±", -- U+000B1
    ["pointint"] = "⨕", -- U+02A15
    ["popf"] = "𝕡", -- U+1D561
    ["pound"] = "£", -- U+000A3
    ["pr"] = "≺", -- U+0227A
    ["prE"] = "⪳", -- U+02AB3
    ["prap"] = "⪷", -- U+02AB7
    ["prcue"] = "≼", -- U+0227C
    ["pre"] = "⪯", -- U+02AAF
    ["prec"] = "≺", -- U+0227A
    ["precapprox"] = "⪷", -- U+02AB7
    ["preccurlyeq"] = "≼", -- U+0227C
    ["preceq"] = "⪯", -- U+02AAF
    ["precnapprox"] = "⪹", -- U+02AB9
    ["precneqq"] = "⪵", -- U+02AB5
    ["precnsim"] = "⋨", -- U+022E8
    ["precsim"] = "≾", -- U+0227E
    ["prime"] = "′", -- U+02032
    ["primes"] = "ℙ", -- U+02119
    ["prnE"] = "⪵", -- U+02AB5
    ["prnap"] = "⪹", -- U+02AB9
    ["prnsim"] = "⋨", -- U+022E8
    ["prod"] = "∏", -- U+0220F
    ["profalar"] = "⌮", -- U+0232E
    ["profline"] = "⌒", -- U+02312
    ["profsurf"] = "⌓", -- U+02313
    ["prop"] = "∝", -- U+0221D
    ["propto"] = "∝", -- U+0221D
    ["prsim"] = "≾", -- U+0227E
    ["prurel"] = "⊰", -- U+022B0
    ["pscr"] = "𝓅", -- U+1D4C5
    ["psgr"] = "ψ", -- U+003C8
    ["psi"] = "ψ", -- U+003C8
    ["puncsp"] = " ", -- U+02008
    ["qfr"] = "𝔮", -- U+1D52E
    ["qint"] = "⨌", -- U+02A0C
    ["qopf"] = "𝕢", -- U+1D562
    ["qprime"] = "⁗", -- U+02057
    ["qscr"] = "𝓆", -- U+1D4C6
    ["quaternions"] = "ℍ", -- U+0210D
    ["quatint"] = "⨖", -- U+02A16
    ["quest"] = "?", -- U+0003F
    ["questeq"] = "≟", -- U+0225F
    ["quot"] = "\"", -- U+00022
    ["rAarr"] = "⇛", -- U+021DB
    ["rArr"] = "⇒", -- U+021D2
    ["rAtail"] = "⤜", -- U+0291C
    ["rBarr"] = "⤏", -- U+0290F
    ["rHar"] = "⥤", -- U+02964
    ["race"] = "∽̱", -- U+0223D 00331
    ["racute"] = "ŕ", -- U+00155
    ["radic"] = "√", -- U+0221A
    ["raemptyv"] = "⦳", -- U+029B3
    ["rang"] = "⟩", -- U+027E9
    ["rangd"] = "⦒", -- U+02992
    ["range"] = "⦥", -- U+029A5
    ["rangle"] = "⟩", -- U+027E9
    ["raquo"] = "»", -- U+000BB
    ["rarr"] = "→", -- U+02192
    ["rarrap"] = "⥵", -- U+02975
    ["rarrb"] = "⇥", -- U+021E5
    ["rarrbfs"] = "⤠", -- U+02920
    ["rarrc"] = "⤳", -- U+02933
    ["rarrfs"] = "⤞", -- U+0291E
    ["rarrhk"] = "↪", -- U+021AA
    ["rarrlp"] = "↬", -- U+021AC
    ["rarrpl"] = "⥅", -- U+02945
    ["rarrsim"] = "⥴", -- U+02974
    ["rarrtl"] = "↣", -- U+021A3
    ["rarrw"] = "↝", -- U+0219D
    ["ratail"] = "⤚", -- U+0291A
    ["ratio"] = "∶", -- U+02236
    ["rationals"] = "ℚ", -- U+0211A
    ["rbarr"] = "⤍", -- U+0290D
    ["rbbrk"] = "❳", -- U+02773
    ["rbrace"] = "}", -- U+0007D
    ["rbrack"] = "]", -- U+0005D
    ["rbrke"] = "⦌", -- U+0298C
    ["rbrksld"] = "⦎", -- U+0298E
    ["rbrkslu"] = "⦐", -- U+02990
    ["rcaron"] = "ř", -- U+00159
    ["rcedil"] = "ŗ", -- U+00157
    ["rceil"] = "⌉", -- U+02309
    ["rcub"] = "}", -- U+0007D
    ["rcy"] = "р", -- U+00440
    ["rdca"] = "⤷", -- U+02937
    ["rdldhar"] = "⥩", -- U+02969
    ["rdquo"] = "”", -- U+0201D
    ["rdquor"] = "”", -- U+0201D
    ["rdsh"] = "↳", -- U+021B3
    ["real"] = "ℜ", -- U+0211C
    ["realine"] = "ℛ", -- U+0211B
    ["realpart"] = "ℜ", -- U+0211C
    ["reals"] = "ℝ", -- U+0211D
    ["rect"] = "▭", -- U+025AD
    ["reg"] = "®", -- U+000AE
    ["rfisht"] = "⥽", -- U+0297D
    ["rfloor"] = "⌋", -- U+0230B
    ["rfr"] = "𝔯", -- U+1D52F
    ["rgr"] = "ρ", -- U+003C1
    ["rhard"] = "⇁", -- U+021C1
    ["rharu"] = "⇀", -- U+021C0
    ["rharul"] = "⥬", -- U+0296C
    ["rho"] = "ρ", -- U+003C1
    ["rhov"] = "ϱ", -- U+003F1
    ["rightarrow"] = "→", -- U+02192
    ["rightarrowtail"] = "↣", -- U+021A3
    ["rightharpoondown"] = "⇁", -- U+021C1
    ["rightharpoonup"] = "⇀", -- U+021C0
    ["rightleftarrows"] = "⇄", -- U+021C4
    ["rightleftharpoons"] = "⇌", -- U+021CC
    ["rightrightarrows"] = "⇉", -- U+021C9
    ["rightsquigarrow"] = "↝", -- U+0219D
    ["rightthreetimes"] = "⋌", -- U+022CC
    ["ring"] = "˚", -- U+002DA
    ["risingdotseq"] = "≓", -- U+02253
    ["rlarr"] = "⇄", -- U+021C4
    ["rlhar"] = "⇌", -- U+021CC
    ["rlm"] = "‏", -- U+0200F
    ["rmoust"] = "⎱", -- U+023B1
    ["rmoustache"] = "⎱", -- U+023B1
    ["rnmid"] = "⫮", -- U+02AEE
    ["roang"] = "⟭", -- U+027ED
    ["roarr"] = "⇾", -- U+021FE
    ["robrk"] = "⟧", -- U+027E7
    ["ropar"] = "⦆", -- U+02986
    ["ropf"] = "𝕣", -- U+1D563
    ["roplus"] = "⨮", -- U+02A2E
    ["rotimes"] = "⨵", -- U+02A35
    ["rpar"] = ")", -- U+00029
    ["rpargt"] = "⦔", -- U+02994
    ["rppolint"] = "⨒", -- U+02A12
    ["rrarr"] = "⇉", -- U+021C9
    ["rsaquo"] = "›", -- U+0203A
    ["rscr"] = "𝓇", -- U+1D4C7
    ["rsh"] = "↱", -- U+021B1
    ["rsqb"] = "]", -- U+0005D
    ["rsquo"] = "’", -- U+02019
    ["rsquor"] = "’", -- U+02019
    ["rthree"] = "⋌", -- U+022CC
    ["rtimes"] = "⋊", -- U+022CA
    ["rtri"] = "▹", -- U+025B9
    ["rtrie"] = "⊵", -- U+022B5
    ["rtrif"] = "▸", -- U+025B8
    ["rtriltri"] = "⧎", -- U+029CE
    ["ruluhar"] = "⥨", -- U+02968
    ["rx"] = "℞", -- U+0211E
    ["sacute"] = "ś", -- U+0015B
    ["sbquo"] = "‚", -- U+0201A
    ["sc"] = "≻", -- U+0227B
    ["scE"] = "⪴", -- U+02AB4
    ["scap"] = "⪸", -- U+02AB8
    ["scaron"] = "š", -- U+00161
    ["sccue"] = "≽", -- U+0227D
    ["sce"] = "⪰", -- U+02AB0
    ["scedil"] = "ş", -- U+0015F
    ["scirc"] = "ŝ", -- U+0015D
    ["scnE"] = "⪶", -- U+02AB6
    ["scnap"] = "⪺", -- U+02ABA
    ["scnsim"] = "⋩", -- U+022E9
    ["scpolint"] = "⨓", -- U+02A13
    ["scsim"] = "≿", -- U+0227F
    ["scy"] = "с", -- U+00441
    ["sdot"] = "⋅", -- U+022C5
    ["sdotb"] = "⊡", -- U+022A1
    ["sdote"] = "⩦", -- U+02A66
    ["seArr"] = "⇘", -- U+021D8
    ["searhk"] = "⤥", -- U+02925
    ["searr"] = "↘", -- U+02198
    ["searrow"] = "↘", -- U+02198
    ["sect"] = "§", -- U+000A7
    ["semi"] = ";", -- U+0003B
    ["seswar"] = "⤩", -- U+02929
    ["setminus"] = "∖", -- U+02216
    ["setmn"] = "∖", -- U+02216
    ["sext"] = "✶", -- U+02736
    ["sfgr"] = "ς", -- U+003C2
    ["sfr"] = "𝔰", -- U+1D530
    ["sfrown"] = "⌢", -- U+02322
    ["sgr"] = "σ", -- U+003C3
    ["sharp"] = "♯", -- U+0266F
    ["shchcy"] = "щ", -- U+00449
    ["shcy"] = "ш", -- U+00448
    ["shortmid"] = "∣", -- U+02223
    ["shortparallel"] = "∥", -- U+02225
    ["shy"] = "­", -- U+000AD
    ["sigma"] = "σ", -- U+003C3
    ["sigmaf"] = "ς", -- U+003C2
    ["sigmav"] = "ς", -- U+003C2
    ["sim"] = "∼", -- U+0223C
    ["simdot"] = "⩪", -- U+02A6A
    ["sime"] = "≃", -- U+02243
    ["simeq"] = "≃", -- U+02243
    ["simg"] = "⪞", -- U+02A9E
    ["simgE"] = "⪠", -- U+02AA0
    ["siml"] = "⪝", -- U+02A9D
    ["simlE"] = "⪟", -- U+02A9F
    ["simne"] = "≆", -- U+02246
    ["simplus"] = "⨤", -- U+02A24
    ["simrarr"] = "⥲", -- U+02972
    ["slarr"] = "←", -- U+02190
    ["smallsetminus"] = "∖", -- U+02216
    ["smashp"] = "⨳", -- U+02A33
    ["smeparsl"] = "⧤", -- U+029E4
    ["smid"] = "∣", -- U+02223
    ["smile"] = "⌣", -- U+02323
    ["smt"] = "⪪", -- U+02AAA
    ["smte"] = "⪬", -- U+02AAC
    ["smtes"] = "⪬︀", -- U+02AAC 0FE00
    ["softcy"] = "ь", -- U+0044C
    ["sol"] = "/", -- U+0002F
    ["solb"] = "⧄", -- U+029C4
    ["solbar"] = "⌿", -- U+0233F
    ["sopf"] = "𝕤", -- U+1D564
    ["spades"] = "♠", -- U+02660
    ["spadesuit"] = "♠", -- U+02660
    ["spar"] = "∥", -- U+02225
    ["sqcap"] = "⊓", -- U+02293
    ["sqcaps"] = "⊓︀", -- U+02293 0FE00
    ["sqcup"] = "⊔", -- U+02294
    ["sqcups"] = "⊔︀", -- U+02294 0FE00
    ["sqsub"] = "⊏", -- U+0228F
    ["sqsube"] = "⊑", -- U+02291
    ["sqsubset"] = "⊏", -- U+0228F
    ["sqsubseteq"] = "⊑", -- U+02291
    ["sqsup"] = "⊐", -- U+02290
    ["sqsupe"] = "⊒", -- U+02292
    ["sqsupset"] = "⊐", -- U+02290
    ["sqsupseteq"] = "⊒", -- U+02292
    ["squ"] = "□", -- U+025A1
    ["square"] = "□", -- U+025A1
    ["squarf"] = "▪", -- U+025AA
    ["squf"] = "▪", -- U+025AA
    ["srarr"] = "→", -- U+02192
    ["sscr"] = "𝓈", -- U+1D4C8
    ["ssetmn"] = "∖", -- U+02216
    ["ssmile"] = "⌣", -- U+02323
    ["sstarf"] = "⋆", -- U+022C6
    ["star"] = "☆", -- U+02606
    ["starf"] = "★", -- U+02605
    ["straightepsilon"] = "ϵ", -- U+003F5
    ["straightphi"] = "ϕ", -- U+003D5
    ["strns"] = "¯", -- U+000AF
    ["sub"] = "⊂", -- U+02282
    ["subE"] = "⫅", -- U+02AC5
    ["subdot"] = "⪽", -- U+02ABD
    ["sube"] = "⊆", -- U+02286
    ["subedot"] = "⫃", -- U+02AC3
    ["submult"] = "⫁", -- U+02AC1
    ["subnE"] = "⫋", -- U+02ACB
    ["subne"] = "⊊", -- U+0228A
    ["subplus"] = "⪿", -- U+02ABF
    ["subrarr"] = "⥹", -- U+02979
    ["subset"] = "⊂", -- U+02282
    ["subseteq"] = "⊆", -- U+02286
    ["subseteqq"] = "⫅", -- U+02AC5
    ["subsetneq"] = "⊊", -- U+0228A
    ["subsetneqq"] = "⫋", -- U+02ACB
    ["subsim"] = "⫇", -- U+02AC7
    ["subsub"] = "⫕", -- U+02AD5
    ["subsup"] = "⫓", -- U+02AD3
    ["succ"] = "≻", -- U+0227B
    ["succapprox"] = "⪸", -- U+02AB8
    ["succcurlyeq"] = "≽", -- U+0227D
    ["succeq"] = "⪰", -- U+02AB0
    ["succnapprox"] = "⪺", -- U+02ABA
    ["succneqq"] = "⪶", -- U+02AB6
    ["succnsim"] = "⋩", -- U+022E9
    ["succsim"] = "≿", -- U+0227F
    ["sum"] = "∑", -- U+02211
    ["sung"] = "♪", -- U+0266A
    ["sup"] = "⊃", -- U+02283
    ["sup1"] = "¹", -- U+000B9
    ["sup2"] = "²", -- U+000B2
    ["sup3"] = "³", -- U+000B3
    ["supE"] = "⫆", -- U+02AC6
    ["supdot"] = "⪾", -- U+02ABE
    ["supdsub"] = "⫘", -- U+02AD8
    ["supe"] = "⊇", -- U+02287
    ["supedot"] = "⫄", -- U+02AC4
    ["suphsol"] = "⟉", -- U+027C9
    ["suphsub"] = "⫗", -- U+02AD7
    ["suplarr"] = "⥻", -- U+0297B
    ["supmult"] = "⫂", -- U+02AC2
    ["supnE"] = "⫌", -- U+02ACC
    ["supne"] = "⊋", -- U+0228B
    ["supplus"] = "⫀", -- U+02AC0
    ["supset"] = "⊃", -- U+02283
    ["supseteq"] = "⊇", -- U+02287
    ["supseteqq"] = "⫆", -- U+02AC6
    ["supsetneq"] = "⊋", -- U+0228B
    ["supsetneqq"] = "⫌", -- U+02ACC
    ["supsim"] = "⫈", -- U+02AC8
    ["supsub"] = "⫔", -- U+02AD4
    ["supsup"] = "⫖", -- U+02AD6
    ["swArr"] = "⇙", -- U+021D9
    ["swarhk"] = "⤦", -- U+02926
    ["swarr"] = "↙", -- U+02199
    ["swarrow"] = "↙", -- U+02199
    ["swnwar"] = "⤪", -- U+0292A
    ["szlig"] = "ß", -- U+000DF
    ["target"] = "⌖", -- U+02316
    ["tau"] = "τ", -- U+003C4
    ["tbrk"] = "⎴", -- U+023B4
    ["tcaron"] = "ť", -- U+00165
    ["tcedil"] = "ţ", -- U+00163
    ["tcy"] = "т", -- U+00442
    ["tdot"] = "⃛", -- U+020DB
    ["telrec"] = "⌕", -- U+02315
    ["tfr"] = "𝔱", -- U+1D531
    ["tgr"] = "τ", -- U+003C4
    ["there4"] = "∴", -- U+02234
    ["therefore"] = "∴", -- U+02234
    ["theta"] = "θ", -- U+003B8
    ["thetasym"] = "ϑ", -- U+003D1
    ["thetav"] = "ϑ", -- U+003D1
    ["thgr"] = "θ", -- U+003B8
    ["thickapprox"] = "≈", -- U+02248
    ["thicksim"] = "∼", -- U+0223C
    ["thinsp"] = " ", -- U+02009
    ["thkap"] = "≈", -- U+02248
    ["thksim"] = "∼", -- U+0223C
    ["thorn"] = "þ", -- U+000FE
    ["tilde"] = "˜", -- U+002DC
    ["times"] = "×", -- U+000D7
    ["timesb"] = "⊠", -- U+022A0
    ["timesbar"] = "⨱", -- U+02A31
    ["timesd"] = "⨰", -- U+02A30
    ["tint"] = "∭", -- U+0222D
    ["toea"] = "⤨", -- U+02928
    ["top"] = "⊤", -- U+022A4
    ["topbot"] = "⌶", -- U+02336
    ["topcir"] = "⫱", -- U+02AF1
    ["topf"] = "𝕥", -- U+1D565
    ["topfork"] = "⫚", -- U+02ADA
    ["tosa"] = "⤩", -- U+02929
    ["tprime"] = "‴", -- U+02034
    ["trade"] = "™", -- U+02122
    ["triangle"] = "▵", -- U+025B5
    ["triangledown"] = "▿", -- U+025BF
    ["triangleleft"] = "◃", -- U+025C3
    ["trianglelefteq"] = "⊴", -- U+022B4
    ["triangleq"] = "≜", -- U+0225C
    ["triangleright"] = "▹", -- U+025B9
    ["trianglerighteq"] = "⊵", -- U+022B5
    ["tridot"] = "◬", -- U+025EC
    ["trie"] = "≜", -- U+0225C
    ["triminus"] = "⨺", -- U+02A3A
    ["triplus"] = "⨹", -- U+02A39
    ["trisb"] = "⧍", -- U+029CD
    ["tritime"] = "⨻", -- U+02A3B
    ["trpezium"] = "⏢", -- U+023E2
    ["tscr"] = "𝓉", -- U+1D4C9
    ["tscy"] = "ц", -- U+00446
    ["tshcy"] = "ћ", -- U+0045B
    ["tstrok"] = "ŧ", -- U+00167
    ["twixt"] = "≬", -- U+0226C
    ["twoheadleftarrow"] = "↞", -- U+0219E
    ["twoheadrightarrow"] = "↠", -- U+021A0
    ["uArr"] = "⇑", -- U+021D1
    ["uHar"] = "⥣", -- U+02963
    ["uacgr"] = "ύ", -- U+003CD
    ["uacute"] = "ú", -- U+000FA
    ["uarr"] = "↑", -- U+02191
    ["ubrcy"] = "ў", -- U+0045E
    ["ubreve"] = "ŭ", -- U+0016D
    ["ucirc"] = "û", -- U+000FB
    ["ucy"] = "у", -- U+00443
    ["udarr"] = "⇅", -- U+021C5
    ["udblac"] = "ű", -- U+00171
    ["udhar"] = "⥮", -- U+0296E
    ["udiagr"] = "ΰ", -- U+003B0
    ["udigr"] = "ϋ", -- U+003CB
    ["ufisht"] = "⥾", -- U+0297E
    ["ufr"] = "𝔲", -- U+1D532
    ["ugr"] = "υ", -- U+003C5
    ["ugrave"] = "ù", -- U+000F9
    ["uharl"] = "↿", -- U+021BF
    ["uharr"] = "↾", -- U+021BE
    ["uhblk"] = "▀", -- U+02580
    ["ulcorn"] = "⌜", -- U+0231C
    ["ulcorner"] = "⌜", -- U+0231C
    ["ulcrop"] = "⌏", -- U+0230F
    ["ultri"] = "◸", -- U+025F8
    ["umacr"] = "ū", -- U+0016B
    ["uml"] = "¨", -- U+000A8
    ["uogon"] = "ų", -- U+00173
    ["uopf"] = "𝕦", -- U+1D566
    ["uparrow"] = "↑", -- U+02191
    ["updownarrow"] = "↕", -- U+02195
    ["upharpoonleft"] = "↿", -- U+021BF
    ["upharpoonright"] = "↾", -- U+021BE
    ["uplus"] = "⊎", -- U+0228E
    ["upsi"] = "υ", -- U+003C5
    ["upsih"] = "ϒ", -- U+003D2
    ["upsilon"] = "υ", -- U+003C5
    ["upuparrows"] = "⇈", -- U+021C8
    ["urcorn"] = "⌝", -- U+0231D
    ["urcorner"] = "⌝", -- U+0231D
    ["urcrop"] = "⌎", -- U+0230E
    ["uring"] = "ů", -- U+0016F
    ["urtri"] = "◹", -- U+025F9
    ["uscr"] = "𝓊", -- U+1D4CA
    ["utdot"] = "⋰", -- U+022F0
    ["utilde"] = "ũ", -- U+00169
    ["utri"] = "▵", -- U+025B5
    ["utrif"] = "▴", -- U+025B4
    ["uuarr"] = "⇈", -- U+021C8
    ["uuml"] = "ü", -- U+000FC
    ["uwangle"] = "⦧", -- U+029A7
    ["vArr"] = "⇕", -- U+021D5
    ["vBar"] = "⫨", -- U+02AE8
    ["vBarv"] = "⫩", -- U+02AE9
    ["vDash"] = "⊨", -- U+022A8
    ["vangrt"] = "⦜", -- U+0299C
    ["varepsilon"] = "ϵ", -- U+003F5
    ["varkappa"] = "ϰ", -- U+003F0
    ["varnothing"] = "∅", -- U+02205
    ["varphi"] = "ϕ", -- U+003D5
    ["varpi"] = "ϖ", -- U+003D6
    ["varpropto"] = "∝", -- U+0221D
    ["varr"] = "↕", -- U+02195
    ["varrho"] = "ϱ", -- U+003F1
    ["varsigma"] = "ς", -- U+003C2
    ["varsubsetneq"] = "⊊︀", -- U+0228A 0FE00
    ["varsubsetneqq"] = "⫋︀", -- U+02ACB 0FE00
    ["varsupsetneq"] = "⊋︀", -- U+0228B 0FE00
    ["varsupsetneqq"] = "⫌︀", -- U+02ACC 0FE00
    ["vartheta"] = "ϑ", -- U+003D1
    ["vartriangleleft"] = "⊲", -- U+022B2
    ["vartriangleright"] = "⊳", -- U+022B3
    ["vcy"] = "в", -- U+00432
    ["vdash"] = "⊢", -- U+022A2
    ["vee"] = "∨", -- U+02228
    ["veebar"] = "⊻", -- U+022BB
    ["veeeq"] = "≚", -- U+0225A
    ["vellip"] = "⋮", -- U+022EE
    ["verbar"] = "|", -- U+0007C
    ["vert"] = "|", -- U+0007C
    ["vfr"] = "𝔳", -- U+1D533
    ["vltri"] = "⊲", -- U+022B2
    ["vnsub"] = "⊂⃒", -- U+02282 020D2
    ["vnsup"] = "⊃⃒", -- U+02283 020D2
    ["vopf"] = "𝕧", -- U+1D567
    ["vprop"] = "∝", -- U+0221D
    ["vrtri"] = "⊳", -- U+022B3
    ["vscr"] = "𝓋", -- U+1D4CB
    ["vsubnE"] = "⫋︀", -- U+02ACB 0FE00
    ["vsubne"] = "⊊︀", -- U+0228A 0FE00
    ["vsupnE"] = "⫌︀", -- U+02ACC 0FE00
    ["vsupne"] = "⊋︀", -- U+0228B 0FE00
    ["vzigzag"] = "⦚", -- U+0299A
    ["wcirc"] = "ŵ", -- U+00175
    ["wedbar"] = "⩟", -- U+02A5F
    ["wedge"] = "∧", -- U+02227
    ["wedgeq"] = "≙", -- U+02259
    ["weierp"] = "℘", -- U+02118
    ["wfr"] = "𝔴", -- U+1D534
    ["wopf"] = "𝕨", -- U+1D568
    ["wp"] = "℘", -- U+02118
    ["wr"] = "≀", -- U+02240
    ["wreath"] = "≀", -- U+02240
    ["wscr"] = "𝓌", -- U+1D4CC
    ["xcap"] = "⋂", -- U+022C2
    ["xcirc"] = "◯", -- U+025EF
    ["xcup"] = "⋃", -- U+022C3
    ["xdtri"] = "▽", -- U+025BD
    ["xfr"] = "𝔵", -- U+1D535
    ["xgr"] = "ξ", -- U+003BE
    ["xhArr"] = "⟺", -- U+027FA
    ["xharr"] = "⟷", -- U+027F7
    ["xi"] = "ξ", -- U+003BE
    ["xlArr"] = "⟸", -- U+027F8
    ["xlarr"] = "⟵", -- U+027F5
    ["xmap"] = "⟼", -- U+027FC
    ["xnis"] = "⋻", -- U+022FB
    ["xodot"] = "⨀", -- U+02A00
    ["xopf"] = "𝕩", -- U+1D569
    ["xoplus"] = "⨁", -- U+02A01
    ["xotime"] = "⨂", -- U+02A02
    ["xrArr"] = "⟹", -- U+027F9
    ["xrarr"] = "⟶", -- U+027F6
    ["xscr"] = "𝓍", -- U+1D4CD
    ["xsqcup"] = "⨆", -- U+02A06
    ["xuplus"] = "⨄", -- U+02A04
    ["xutri"] = "△", -- U+025B3
    ["xvee"] = "⋁", -- U+022C1
    ["xwedge"] = "⋀", -- U+022C0
    ["yacute"] = "ý", -- U+000FD
    ["yacy"] = "я", -- U+0044F
    ["ycirc"] = "ŷ", -- U+00177
    ["ycy"] = "ы", -- U+0044B
    ["yen"] = "¥", -- U+000A5
    ["yfr"] = "𝔶", -- U+1D536
    ["yicy"] = "ї", -- U+00457
    ["yopf"] = "𝕪", -- U+1D56A
    ["yscr"] = "𝓎", -- U+1D4CE
    ["yucy"] = "ю", -- U+0044E
    ["yuml"] = "ÿ", -- U+000FF
    ["zacute"] = "ź", -- U+0017A
    ["zcaron"] = "ž", -- U+0017E
    ["zcy"] = "з", -- U+00437
    ["zdot"] = "ż", -- U+0017C
    ["zeetrf"] = "ℨ", -- U+02128
    ["zeta"] = "ζ", -- U+003B6
    ["zfr"] = "𝔷", -- U+1D537
    ["zgr"] = "ζ", -- U+003B6
    ["zhcy"] = "ж", -- U+00436
    ["zigrarr"] = "⇝", -- U+021DD
    ["zopf"] = "𝕫", -- U+1D56B
    ["zscr"] = "𝓏", -- U+1D4CF
    ["zwj"] = "‍", -- U+0200D
    ["zwnj"] = "‌", -- U+0200C
}

characters          = characters or { }
characters.entities = entities

entities.plusminus  = "±"               -- 0x000B1
entities.minusplus  = "∓"               -- 0x02213
entities.cdots      = utf.char(0x02026) -- U+02026
