# Find sndfile library
#
# Released under BSD license
#
#  SNDFILE_INCLUDE_DIRS - where to find sndfile.h, etc
#  SNDFILE_LIBRARIES    - Lists of libraries when using sndfile
#  SNDFILE_FOUND        - True if sndfile found

INCLUDE(FindPackageHandleStandardArgs)

# Look for the header file
FIND_PATH(SNDFILE_INCLUDE_DIR NAMES sndfile.h)
MARK_AS_ADVANCED(SNDFILE_INCLUDE_DIR)

# Look for the library
SET(SNDFILE_LIBS sndfile)
FIND_LIBRARY(SNDFILE_LIBRARY NAMES ${SNDFILE_LIBS})
MARK_AS_ADVANCED(SNDFILE_LIBRARY)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(SNDFILE REQUIRED_VARS SNDFILE_LIBRARY SNDFILE_INCLUDE_DIR)

# Copy the result to output variables
IF(SNDFILE_FOUND)
  SET(SNDFILE_LIBRARIES ${SNDFILE_LIBRARY})
  SET(SNDFILE_INCLUDE_DIRS ${SNDFILE_INCLUDE_DIR})
ELSE(SNDFILE_FOUND)
  SET(SNDFILE_LIBS)
  SET(SNDFILE_LIBRARY)
  SET(SNDFILE_LIBRARIES)
  SET(SNDFILE_INCLUDE_DIR)
  SET(SNDFILE_INCLUDE_DIRS)
ENDIF(SNDFILE_FOUND)
