/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIStudentData
extends CMICategory
implements Serializable {
    public Element mastery_score = new Element("", "checkDecimal", "NULL", false, true, false);
    public Element max_time_allowed = new Element("", "checkTimespan", "NULL", false, true, false);
    public Element time_limit_action = new Element("", "checkVocabulary", "TimeLimitAction", false, true, false);
    private static int CMISTUD_DATA_MIN_NUM_TOKENS = 3;

    public CMIStudentData() {
        super(true);
    }

    public Element getMasteryScore() {
        return this.mastery_score;
    }

    public Element getMaxTimeAllowed() {
        return this.max_time_allowed;
    }

    public Element getTimeLimitAction() {
        return this.time_limit_action;
    }

    public void setMasteryScore(String inMasteryScore) {
        this.mastery_score.setValue(inMasteryScore);
    }

    public void setMaxTimeAllowed(String inMaxTimeAllowed) {
        this.max_time_allowed.setValue(inMaxTimeAllowed);
    }

    public void setTimeLimitAction(String inTimeLimitAction) {
        this.time_limit_action.setValue(inTimeLimitAction);
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        String token = theRequest.getNextToken();
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + token + "is not a valid element of the CMI Student Data\n" + "Data Model Category");
            }
            if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            } else {
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else {
            result = theRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, token, dmErrorMgr);
        }
        return result;
    }

    public String getChildren() {
        String children = "mastery_score,max_time_allowed,time_limit_action";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String token = theRequest.getNextToken();
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + token + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        } else {
            String value = theRequest.getValue();
            if (!theRequest.isAKeywordRequest()) {
                this.doSet(this, token, value, dmErrorMgr);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Cannot Set Data Model Element");
                    System.out.println("Element being processed: " + token + "cannot be set\n");
                }
                dmErrorMgr.recKeyWordError(token);
            }
        }
    }

    private boolean isValidStudDataRequest(CMIRequest theRequest) {
        boolean rtrnFlag = false;
        if (theRequest.isForASetRequest()) {
            if (theRequest.getTotalNumTokens() - 1 >= CMISTUD_DATA_MIN_NUM_TOKENS) {
                rtrnFlag = true;
            }
        } else if (theRequest.getTotalNumTokens() >= CMISTUD_DATA_MIN_NUM_TOKENS) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }
}

