/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.PlafMacros;
import org.emboss.jemboss.parser.ParseAcd;

public class ReportFormat {
    private static String[] rpt = new String[]{"embl", "genbank", "gff", "pir", "swiss", "listfile", "dbmotif", "diffseq", "excel", "feattable", "motif", "nametable", "regions", "seqtable", "simple", "srs", "table", "tagseq", "dasgff"};
    private JembossComboPopup cp;
    private JCheckBox raccshow = new JCheckBox();
    private JCheckBox rdesshow = new JCheckBox();
    private JCheckBox rusashow = new JCheckBox();
    private String def;

    public ReportFormat(ParseAcd parseAcd, int nf) {
        this.cp = new JembossComboPopup(ReportFormat.getReportFormats());
        int np = parseAcd.getNumofParams(nf);
        for (int i = 0; i < np; ++i) {
            if (!parseAcd.getParameterAttribute(nf, i).equals("rformat")) continue;
            this.def = parseAcd.getParamValueStr(nf, i);
            this.cp.setSelectedItem(parseAcd.getParamValueStr(nf, i));
        }
        Dimension d = this.cp.getPreferredSize();
        d = new Dimension(150, (int)d.getHeight());
        this.cp.setMaximumSize(d);
        this.cp.setPreferredSize(d);
    }

    public JembossComboPopup getComboPopup() {
        return this.cp;
    }

    public String getDefaultFormat() {
        return this.def;
    }

    public JCheckBox getAccCheckBox() {
        return this.raccshow;
    }

    public JCheckBox getDesCheckBox() {
        return this.rdesshow;
    }

    public JCheckBox getUsaDesCheckBox() {
        return this.rusashow;
    }

    private static String[] getReportFormats() {
        return rpt;
    }

    public String getReportFormat() {
        String report = " -rformat " + this.cp.getSelectedItem();
        if (this.raccshow.isSelected()) {
            report = report.concat(" -raccshow ");
        }
        if (this.rdesshow.isSelected()) {
            report = report.concat(" -rdesshow ");
        }
        if (this.rusashow.isSelected()) {
            report = report.concat(" -rusashow ");
        }
        return report;
    }

    public List getReportFormatA() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add("-rformat");
        ret.add(this.cp.getSelectedItem());
        if (this.raccshow.isSelected()) {
            ret.add("-raccshow");
        }
        if (this.rdesshow.isSelected()) {
            ret.add("-rdesshow");
        }
        if (this.rusashow.isSelected()) {
            ret.add("-rusashow");
        }
        return ret;
    }

    protected Box getReportCheckBox() {
        Box pan = new Box(0);
        pan.add(this.getAccCheckBox());
        pan.add(new LabelTextBox("Accession number", "Displays the accession number in the report"));
        pan.add(Box.createHorizontalStrut(20));
        pan.add(this.getDesCheckBox());
        pan.add(new LabelTextBox("Description", "Displays the sequence description in the report"));
        pan.add(Box.createHorizontalStrut(20));
        pan.add(this.getUsaDesCheckBox());
        pan.add(new LabelTextBox("Full USA", "Displays the universal sequence address in the report"));
        pan.add(Box.createHorizontalGlue());
        return pan;
    }

    public static String getToolTip() {
        String ls = PlafMacros.getLineSeparator();
        return "embl \t\t\t\t\t\t\t\t- EMBL feature table format." + ls + "genbank \t- Genbank feature table format." + ls + "gff \t\t\t\t\t\t\t\t\t\t\t\t- GFF feature table format." + ls + "pir \t\t\t\t\t\t\t\t\t\t\t\t- PIR feature table format." + ls + "swiss \t\t\t\t\t\t\t- SwissProt feature table format." + ls + "listfile \t\t\t\t\t\t- writes out a list file with start and end" + "points of the motifs given" + ls + "by '[start:end]' after the" + "sequence's full USA. This can be read by other EMBOSS" + ls + "programs using '@' or 'list::' before the filename." + ls + "dbmotif \t\t\t\t- DbMotif format." + ls + "diffseq \t\t\t\t\t- Useful when reporting the results of two sequences" + ls + "aligned, as in the program diffseq." + ls + "excel \t\t\t\t\t\t\t\t- TAB-delimited table format for spread-sheets" + ls + "feattable \t\t- FeatTable format. It is an EMBL feature table" + ls + "table using only the tags in the report definition." + ls + "motif \t\t\t\t\t\t\t\t- Motif format. Based on the original" + ls + "output format of antigenic, helixturnhelix and sigcleave." + ls + "regions \t\t\t- Regions format." + ls + "seqtable \t\t- Simple table format that includes the feature sequence." + ls + "simple \t\t\t\t\t- SRS simple format." + ls + "srs \t\t\t\t\t\t\t\t\t\t\t- SRS format." + ls + "table \t\t\t\t\t\t\t- Table format." + ls + "tagseq \t\t\t\t-  Tagseq format. Features are marked up below the sequence.";
    }
}

