/*
SHA-1 in C
By Steve Reid <steve@edmweb.com>
100% Public Domain

Test Vectors (from FIPS PUB 180-1)
"abc"
  A9993E36 4706816A BA3E2571 7850C26C 9CD0D89D
"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
  84983E44 1C3BD26E BAAE4AA1 F95129E5 E54670F1
A million repetitions of "a"
  34AA973C D4C4DAA4 F61EEB2B DBAD2731 6534016F

	$Id: sha1.h,v 1.9 2007-08-08 00:53:29 disconn3ct Exp $
*/

#define SHA1HANDSOFF /* Copies data before messing with it. */
#ifndef _SHA1
#define _SHA1
typedef struct {
    unsigned int state[5];
    size_t count[2];
    unsigned char buffer[64];
} SHA1_CTX;

#define DIGEST_SIZE 20
void SHA1Transform(unsigned int state[5], unsigned char buffer[64]);
void SHA1Init(SHA1_CTX* context);
void SHA1Update(SHA1_CTX* context, unsigned char* data, size_t len);
void SHA1Final(unsigned char digest[DIGEST_SIZE], SHA1_CTX* context);

#define rol(value, bits) (((value) << (bits)) | ((value) >> (32 - (bits))))

/* blk0() and blk() perform the initial expand. */
/* I got the idea of expanding during the round function from SSLeay */
/*
#ifdef __BIG_ENDIAN
#define blk0(i) block->l[i]
#else
#define blk0(i) (block->l[i] =	(rol(block->l[i], 24) & 0xFF00FF00) | \
							    (rol(block->l[i],  8) & 0x00FF00FF))
#endif
*/

#define blk0(i) (block->l[i] = BigLong(block->l[i]))

#define blk(i) (block->l[i&15] = rol(block->l[(i+13)&15]^block->l[(i+8)&15] \
    ^block->l[(i+2)&15]^block->l[i&15],1))

/* (R0+R1), R2, R3, R4 are the different operations used in SHA1 */
#define R0(v,w,x,y,z,i) z+=((w&(x^y))^y)+blk0(i)+0x5A827999+rol(v,5);w=rol(w,30);
#define R1(v,w,x,y,z,i) z+=((w&(x^y))^y)+blk(i)+0x5A827999+rol(v,5);w=rol(w,30);
#define R2(v,w,x,y,z,i) z+=(w^x^y)+blk(i)+0x6ED9EBA1+rol(v,5);w=rol(w,30);
#define R3(v,w,x,y,z,i) z+=(((w|x)&y)|(w&x))+blk(i)+0x8F1BBCDC+rol(v,5);w=rol(w,30);
#define R4(v,w,x,y,z,i) z+=(w^x^y)+blk(i)+0xCA62C1D6+rol(v,5);w=rol(w,30);

//VVD: SHA1 crypt
char *SHA1(char *string);
void SHA1_Init(void);
void SHA1_Update(unsigned char* data);
char *SHA1_Final(void);
char *bin2hex(unsigned char *d);
#endif //_SHA1
