/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.util.Slider;
import visad.util.SliderChangeEvent;

public class ArrowSlider
extends Slider
implements MouseListener,
MouseMotionListener {
    private float upper;
    private float lower;
    private float val;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private Object lock = new Object();
    private int oldxval;

    public ArrowSlider() {
        this(-1.0f, 1.0f, 0.0f);
    }

    public ArrowSlider(float lower, float upper, float initial) {
        this(lower, upper, initial, "value");
    }

    public ArrowSlider(float lower, float upper, float initial, String name) {
        if (lower > initial) {
            throw new IllegalArgumentException("ArrowSlider: lower bound is greater than initial value");
        }
        if (initial > upper) {
            throw new IllegalArgumentException("ArrowSlider: initial value is greater than the upper bound");
        }
        this.upper = upper;
        this.lower = lower;
        this.val = initial;
        this.name = name;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Visad Arrow Slider");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ArrowSlider a = new ArrowSlider();
        frame.getContentPane().add(a);
        frame.setSize(a.getPreferredSize());
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(float min, float max, float init) {
        Object object = this.lock;
        synchronized (object) {
            if (min > max) {
                throw new IllegalArgumentException("ArrowSlider: min cannot be greater than max");
            }
            if (init < min || init > max) {
                throw new IllegalArgumentException("ArrowSlider: initial value must be between min and max");
            }
            this.lower = min;
            this.upper = max;
            this.val = init;
        }
        this.notifyListeners(new SliderChangeEvent(2, min));
        this.notifyListeners(new SliderChangeEvent(3, max));
        this.notifyListeners(new SliderChangeEvent(1, init));
        this.validate();
        this.repaint();
    }

    public float getMinimum() {
        return this.lower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimum(float value) {
        Object object = this.lock;
        synchronized (object) {
            if (value > this.val || value == this.val && value == this.upper) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new minimum value greater than the current value");
            }
            this.lower = value;
        }
        this.notifyListeners(new SliderChangeEvent(2, value));
        this.validate();
        this.repaint();
    }

    public float getMaximum() {
        return this.upper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximum(float value) {
        Object object = this.lock;
        synchronized (object) {
            if (value < this.val || value == this.val && value == this.lower) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new maximum value less than the current value");
            }
            this.upper = value;
        }
        this.notifyListeners(new SliderChangeEvent(3, value));
        this.validate();
        this.repaint();
    }

    public float getValue() {
        return this.val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float value) {
        Object object = this.lock;
        synchronized (object) {
            if (value > this.upper || value < this.lower) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new value out of slider range");
            }
            this.val = value;
        }
        this.notifyListeners(new SliderChangeEvent(1, value));
        this.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 16);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 16);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(40, 16);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.updatePosition(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.updatePosition(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void updatePosition(MouseEvent e) {
        int x = e.getX();
        if (x < 0) {
            x = 0;
        }
        if (x >= this.getBounds().width) {
            x = this.getBounds().width - 1;
        }
        float dist = (float)x / (float)(this.getBounds().width - 1);
        this.setValue(this.lower + dist * (this.upper - this.lower));
    }

    public void update(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(this.oldxval, 0, this.oldxval, this.getBounds().height - 1);
        g.drawLine(this.oldxval, 0, this.oldxval - 4, 4);
        g.drawLine(this.oldxval, 0, this.oldxval + 4, 4);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawLine(xval, 0, xval, this.getBounds().height - 1);
        g.drawLine(xval, 0, xval - 4, 4);
        g.drawLine(xval, 0, xval + 4, 4);
        this.oldxval = xval;
    }

    public void paint(Graphics g) {
        if (this.val != this.val || this.lower != this.lower || this.upper != this.upper) {
            return;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawLine(xval, 0, xval, this.getBounds().height - 1);
        g.drawLine(xval, 0, xval - 4, 4);
        g.drawLine(xval, 0, xval + 4, 4);
        this.oldxval = xval;
    }
}

