/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PtocaProducer.java 1338605 2012-05-15 09:07:02Z mehdi $ */

package org.apache.fop.afp.ptoca;

import java.io.IOException;

/**
 * Producer interface that is passed to a {@link org.apache.fop.afp.modca.PresentationTextObject}
 * to produce PTOCA control sequences using a {@link PtocaBuilder}.
 */
public interface PtocaProducer {

    /**
     * Produces the PTOCA control sequences by calling methods on {@link PtocaBuilder}.
     * @param builder the builder object
     * @throws IOException if an I/O error occurs
     */
    void produce(PtocaBuilder builder) throws IOException;

}
