/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.secure;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.xmlrpc.AuthDemo;
import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.secure.SecurityConstants;
import org.apache.xmlrpc.secure.SecurityTool;

public class SecureWebServer
extends WebServer
implements SecurityConstants {
    static /* synthetic */ Class class$java$lang$Math;

    public SecureWebServer(int n) throws IOException {
        this(n, null);
    }

    public SecureWebServer(int n, InetAddress inetAddress) throws IOException {
        super(n, inetAddress);
    }

    protected ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws Exception {
        SecurityTool.setup();
        SSLContext sSLContext = SSLContext.getInstance((String)SecurityTool.getSecurityProtocol());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)SecurityTool.getKeyManagerType());
        KeyStore keyStore = KeyStore.getInstance(SecurityTool.getKeyStoreType());
        keyStore.load(new FileInputStream(SecurityTool.getKeyStore()), SecurityTool.getKeyStorePassword().toCharArray());
        keyManagerFactory.init(keyStore, SecurityTool.getKeyStorePassword().toCharArray());
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        return (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
    }

    public static void main(String[] stringArray) {
        System.err.println("Usage: java org.apache.xmlrpc.SecureWebServer [port]");
        int n = 10000;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing port number: " + stringArray[0]);
            }
        }
        XmlRpc.setKeepAlive(true);
        try {
            SecureWebServer secureWebServer = new SecureWebServer(n);
            secureWebServer.addHandler("string", "Welcome to XML-RPC!");
            secureWebServer.addHandler("math", class$java$lang$Math == null ? (class$java$lang$Math = SecureWebServer.class$("java.lang.Math")) : class$java$lang$Math);
            secureWebServer.addHandler("auth", new AuthDemo());
            secureWebServer.addHandler("$default", new Echo());
            System.err.println("started web server on port " + n);
        }
        catch (IOException iOException) {
            System.err.println("Error creating web server: " + iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

