/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.coordinates.Accuracy;
import geotrans3.coordinates.ConvertResults;
import geotrans3.coordinates.CoordinateTuple;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui.AboutDlg;
import geotrans3.gui.CreateDatumDlg;
import geotrans3.gui.CreateEllipsoidDlg;
import geotrans3.gui.CreateFileHeaderDlg;
import geotrans3.gui.DeleteDlg;
import geotrans3.gui.FileDlg;
import geotrans3.gui.FormatOptionsDlg;
import geotrans3.gui.LoadSettings;
import geotrans3.gui.MasterPanel;
import geotrans3.gui.SaveSettings;
import geotrans3.gui.StartBrowser;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIFiomeths;
import geotrans3.misc.AOI;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.StringHandler;
import geotrans3.parameters.CoordinateSystemParameters;
import geotrans3.parameters.EquidistantCylindricalParameters;
import geotrans3.parameters.GeodeticParameters;
import geotrans3.parameters.LocalCartesianParameters;
import geotrans3.parameters.MapProjection3Parameters;
import geotrans3.parameters.MapProjection4Parameters;
import geotrans3.parameters.MapProjection5Parameters;
import geotrans3.parameters.MapProjection6Parameters;
import geotrans3.parameters.MercatorScaleFactorParameters;
import geotrans3.parameters.MercatorStandardParallelParameters;
import geotrans3.parameters.NeysParameters;
import geotrans3.parameters.ObliqueMercatorParameters;
import geotrans3.parameters.PolarStereographicScaleFactorParameters;
import geotrans3.parameters.PolarStereographicStandardParallelParameters;
import geotrans3.parameters.UTMParameters;
import geotrans3.utility.DATFileFilter;
import geotrans3.utility.Directory;
import geotrans3.utility.Platform;
import geotrans3.utility.ReadEnv;
import geotrans3.utility.Utility;
import geotrans3.utility.XMLFileFilter;
import geotrans3.utility.color.Green;
import geotrans3.utility.color.Red;
import geotrans3.utility.color.Yellow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;

public class MSP_GEOTRANS3
extends JFrame {
    private JNICoordinateConversionService jniCoordinateConversionService;
    private Directory currentDir = new Directory(".");
    private StringHandler stringHandler = new StringHandler();
    private Color defaultSelectedColor = (Color)UIManager.get("Button.select");
    private Color currentColor = Green.VALUE;
    private Color currentColorUp = Green.VALUE;
    private Color currentColorDown = Green.VALUE;
    private Component prevFocus;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private FormatOptions formatOptions;
    private String currLookAndFeel = "Java";
    private String dataDirPathName = "";
    private File defaultFile;
    private LoadSettings defaultSettings;
    private String[] currentDatum = new String[2];
    private CoordinateSystemParameters[] currentParameters = new CoordinateSystemParameters[2];
    private Accuracy[] currentAccuracy = new Accuracy[2];
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JButton convertDownButton;
    private JMenuItem convertDownMenuItem;
    private JMenu convertMenu;
    private JSeparator convertMenuSeparator;
    private JPanel convertPanel;
    private JButton convertUpButton;
    private JMenuItem convertUpMenuItem;
    private JButton copyButton;
    private JMenuItem copyMenuItem;
    private JMenuItem createDatumMenuItem;
    private JMenuItem createEllipsoidMenuItem;
    private JMenuItem createFileHeaderMenuItem;
    private JButton cutButton;
    private JMenuItem cutMenuItem;
    private JMenu datumMenu;
    private JMenuItem deleteDatumMenuItem;
    private JMenuItem deleteEllipsoidMenuItem;
    private JMenu editMenu;
    private JMenu ellipsoidMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JSeparator fileMenuSeparator;
    private JButton formatButton;
    private JMenuItem formatMenuItem;
    private JMenu helpMenu;
    private JSeparator helpMenuSeparator;
    private JMenuItem loadSettingsMenuItem;
    private JMenu lookAndFeelMenu;
    private JPanel lowerPanel;
    private JMenuBar menuBar;
    private JRadioButtonMenuItem metalRadioButtonMenuItem;
    private JMenuItem openMenuItem;
    private JMenu optionsMenu;
    private JButton pasteButton;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveSettingsMenuItem;
    private JToolBar toolBar;
    private JSeparator toolBarSeparator;
    private JRadioButtonMenuItem unixRadioButtonMenuItem;
    private JPanel upperPanel;
    private JRadioButtonMenuItem windowsRadioButtonMenuItem;

    public MSP_GEOTRANS3() {
        this.initComponents();
        this.setIcons();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.metalRadioButtonMenuItem);
        buttonGroup.add(this.unixRadioButtonMenuItem);
        buttonGroup.add(this.windowsRadioButtonMenuItem);
        Utility.setIcon(this, "/geotrans3/gui/icons/geotrans_logo.gif");
        if (Platform.isUnix) {
            this.setSize(new Dimension(484, 679));
        }
        try {
            Properties properties = ReadEnv.getEnvVars();
            this.dataDirPathName = properties.getProperty("MSPCCS_DATA");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.dataDirPathName = this.dataDirPathName != null && this.dataDirPathName.length() > 0 ? this.dataDirPathName + "/" : "../../data/";
        this.dataDirPathName = this.dataDirPathName + "default.xml";
        this.defaultFile = new File(this.dataDirPathName);
        try {
            if (this.defaultFile.exists()) {
                this.defaultSettings = new LoadSettings(this, this.defaultFile);
                this.defaultSettings.readDefaults();
            }
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
            this.defaultSettings = null;
        }
        this.initialize();
        this.pack();
        Utility.center(null, this);
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.formatButton = new JButton();
        this.toolBarSeparator = new JSeparator();
        this.upperPanel = new JPanel();
        this.convertPanel = new JPanel();
        this.convertDownButton = new JButton();
        this.convertUpButton = new JButton();
        this.lowerPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.createFileHeaderMenuItem = new JMenuItem();
        this.loadSettingsMenuItem = new JMenuItem();
        this.saveSettingsMenuItem = new JMenuItem();
        this.fileMenuSeparator = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.formatMenuItem = new JMenuItem();
        this.lookAndFeelMenu = new JMenu();
        this.metalRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.unixRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.windowsRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.datumMenu = new JMenu();
        this.createDatumMenuItem = new JMenuItem();
        this.deleteDatumMenuItem = new JMenuItem();
        this.ellipsoidMenu = new JMenu();
        this.createEllipsoidMenuItem = new JMenuItem();
        this.deleteEllipsoidMenuItem = new JMenuItem();
        this.convertMenu = new JMenu();
        this.convertDownMenuItem = new JMenuItem();
        this.convertMenuSeparator = new JSeparator();
        this.convertUpMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.helpMenuSeparator = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("MSP GEOTRANS 3.7");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MSP_GEOTRANS3.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setMinimumSize(new Dimension(25, 25));
        this.toolBar.setPreferredSize(new Dimension(25, 25));
        this.cutButton.setToolTipText("Cut");
        this.cutButton.setMaximumSize(new Dimension(25, 30));
        this.cutButton.setMinimumSize(new Dimension(17, 21));
        this.cutButton.setPreferredSize(new Dimension(27, 27));
        this.cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.cutActionPerformed(actionEvent);
            }
        });
        this.cutButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.editButtonMouseEntered(mouseEvent);
            }
        });
        this.toolBar.add(this.cutButton);
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setMaximumSize(new Dimension(25, 30));
        this.copyButton.setMinimumSize(new Dimension(17, 21));
        this.copyButton.setPreferredSize(new Dimension(27, 27));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.copyActionPerformed(actionEvent);
            }
        });
        this.copyButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.editButtonMouseEntered(mouseEvent);
            }
        });
        this.toolBar.add(this.copyButton);
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setMaximumSize(new Dimension(25, 30));
        this.pasteButton.setMinimumSize(new Dimension(17, 21));
        this.pasteButton.setPreferredSize(new Dimension(27, 27));
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.pasteActionPerformed(actionEvent);
            }
        });
        this.pasteButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.editButtonMouseEntered(mouseEvent);
            }
        });
        this.toolBar.add(this.pasteButton);
        this.formatButton.setToolTipText("Format Options");
        this.formatButton.setMaximumSize(new Dimension(25, 30));
        this.formatButton.setMinimumSize(new Dimension(17, 21));
        this.formatButton.setPreferredSize(new Dimension(27, 27));
        this.formatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.formatActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.formatButton);
        this.toolBarSeparator.setOrientation(1);
        this.toolBar.add(this.toolBarSeparator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.toolBar, gridBagConstraints);
        this.upperPanel.setBackground(Color.lightGray);
        this.upperPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.upperPanel.setMinimumSize(new Dimension(469, 284));
        this.upperPanel.setOpaque(false);
        this.upperPanel.setPreferredSize(new Dimension(469, 284));
        this.upperPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.upperPanel, gridBagConstraints);
        this.convertPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.convertPanel.setLayout(new GridBagLayout());
        this.convertDownButton.setFont(new Font("Dialog", 0, 11));
        this.convertDownButton.setText("Convert Upper -> Lower");
        this.convertDownButton.setToolTipText("Convert Upper to Lower");
        this.convertDownButton.setBorder(BorderFactory.createBevelBorder(0));
        this.convertDownButton.setMaximumSize(new Dimension(197, 24));
        this.convertDownButton.setMinimumSize(new Dimension(197, 24));
        this.convertDownButton.setPreferredSize(new Dimension(197, 24));
        this.convertDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.convertDownActionPerformed(actionEvent);
            }
        });
        this.convertDownButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.convertButtonMousePressed(mouseEvent);
                MSP_GEOTRANS3.this.convertDownButtonMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.convertButtonMouseReleased(mouseEvent);
                MSP_GEOTRANS3.this.convertDownButtonMouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 12);
        this.convertPanel.add((Component)this.convertDownButton, gridBagConstraints);
        this.convertUpButton.setFont(new Font("Dialog", 0, 11));
        this.convertUpButton.setText("Convert Lower -> Upper");
        this.convertUpButton.setToolTipText("Convert Lower to Upper");
        this.convertUpButton.setBorder(BorderFactory.createBevelBorder(0));
        this.convertUpButton.setMaximumSize(new Dimension(197, 24));
        this.convertUpButton.setMinimumSize(new Dimension(197, 24));
        this.convertUpButton.setPreferredSize(new Dimension(197, 24));
        this.convertUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.convertUpActionPerformed(actionEvent);
            }
        });
        this.convertUpButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.convertButtonMousePressed(mouseEvent);
                MSP_GEOTRANS3.this.convertUpButtonMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MSP_GEOTRANS3.this.convertButtonMouseReleased(mouseEvent);
                MSP_GEOTRANS3.this.convertUpButtonMouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.convertPanel.add((Component)this.convertUpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.convertPanel, gridBagConstraints);
        this.lowerPanel.setBackground(Color.lightGray);
        this.lowerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createLineBorder(new Color(0, 0, 0))));
        this.lowerPanel.setMinimumSize(new Dimension(469, 284));
        this.lowerPanel.setOpaque(false);
        this.lowerPanel.setPreferredSize(new Dimension(469, 284));
        this.lowerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.lowerPanel, gridBagConstraints);
        this.menuBar.setMinimumSize(new Dimension(285, 23));
        this.fileMenu.setMnemonic(70);
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic(79);
        this.openMenuItem.setText("Open . . .");
        this.openMenuItem.setToolTipText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.openActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.createFileHeaderMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.createFileHeaderMenuItem.setMnemonic(67);
        this.createFileHeaderMenuItem.setText("Create File Header . . .");
        this.createFileHeaderMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.createFileHeaderActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.createFileHeaderMenuItem);
        this.loadSettingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.loadSettingsMenuItem.setMnemonic(76);
        this.loadSettingsMenuItem.setText("Load Settings");
        this.loadSettingsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.loadSettingsActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.loadSettingsMenuItem);
        this.saveSettingsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveSettingsMenuItem.setMnemonic(83);
        this.saveSettingsMenuItem.setText("Save Settings");
        this.saveSettingsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.saveSettingsActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveSettingsMenuItem);
        this.fileMenu.add(this.fileMenuSeparator);
        this.exitMenuItem.setMnemonic(88);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.exitActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic(69);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setMnemonic(84);
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.cutActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setMnemonic(67);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.copyActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic(80);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.pasteActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.menuBar.add(this.editMenu);
        this.optionsMenu.setMnemonic(79);
        this.optionsMenu.setText("Options");
        this.formatMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.formatMenuItem.setMnemonic(70);
        this.formatMenuItem.setText("Format . . .");
        this.formatMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.formatActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.formatMenuItem);
        this.lookAndFeelMenu.setMnemonic(76);
        this.lookAndFeelMenu.setText("Look and Feel");
        this.metalRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.metalRadioButtonMenuItem.setMnemonic(74);
        this.metalRadioButtonMenuItem.setSelected(true);
        this.metalRadioButtonMenuItem.setText("Java");
        this.metalRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.lookAndFeelActionPerformed(actionEvent);
            }
        });
        this.lookAndFeelMenu.add(this.metalRadioButtonMenuItem);
        this.unixRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.unixRadioButtonMenuItem.setMnemonic(85);
        this.unixRadioButtonMenuItem.setText("Unix");
        this.unixRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.lookAndFeelActionPerformed(actionEvent);
            }
        });
        this.lookAndFeelMenu.add(this.unixRadioButtonMenuItem);
        this.windowsRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.windowsRadioButtonMenuItem.setMnemonic(87);
        this.windowsRadioButtonMenuItem.setText("Windows");
        this.windowsRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.lookAndFeelActionPerformed(actionEvent);
            }
        });
        this.lookAndFeelMenu.add(this.windowsRadioButtonMenuItem);
        this.optionsMenu.add(this.lookAndFeelMenu);
        this.menuBar.add(this.optionsMenu);
        this.datumMenu.setMnemonic(68);
        this.datumMenu.setText("Datum");
        this.createDatumMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.createDatumMenuItem.setMnemonic(67);
        this.createDatumMenuItem.setText("Create . . .");
        this.createDatumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.createDatumActionPerformed(actionEvent);
            }
        });
        this.datumMenu.add(this.createDatumMenuItem);
        this.deleteDatumMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.deleteDatumMenuItem.setMnemonic(68);
        this.deleteDatumMenuItem.setText("Delete . . .");
        this.deleteDatumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.deleteDatumActionPerformed(actionEvent);
            }
        });
        this.datumMenu.add(this.deleteDatumMenuItem);
        this.menuBar.add(this.datumMenu);
        this.ellipsoidMenu.setMnemonic(76);
        this.ellipsoidMenu.setText("Ellipsoid");
        this.createEllipsoidMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.createEllipsoidMenuItem.setMnemonic(67);
        this.createEllipsoidMenuItem.setText("Create . . .");
        this.createEllipsoidMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.createEllipsoidActionPerformed(actionEvent);
            }
        });
        this.ellipsoidMenu.add(this.createEllipsoidMenuItem);
        this.deleteEllipsoidMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.deleteEllipsoidMenuItem.setMnemonic(68);
        this.deleteEllipsoidMenuItem.setText("Delete . . .");
        this.deleteEllipsoidMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.deleteEllipsoidActionPerformed(actionEvent);
            }
        });
        this.ellipsoidMenu.add(this.deleteEllipsoidMenuItem);
        this.menuBar.add(this.ellipsoidMenu);
        this.convertMenu.setMnemonic(67);
        this.convertMenu.setText("Convert");
        this.convertDownMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.convertDownMenuItem.setMnemonic(85);
        this.convertDownMenuItem.setLabel(" Upper to Lower");
        this.convertDownMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.convertDownActionPerformed(actionEvent);
            }
        });
        this.convertMenu.add(this.convertDownMenuItem);
        this.convertMenu.add(this.convertMenuSeparator);
        this.convertUpMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.convertUpMenuItem.setMnemonic(76);
        this.convertUpMenuItem.setLabel("Lower to Upper");
        this.convertUpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.convertUpActionPerformed(actionEvent);
            }
        });
        this.convertMenu.add(this.convertUpMenuItem);
        this.menuBar.add(this.convertMenu);
        this.helpMenu.setMnemonic(72);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.contentsMenuItem.setMnemonic(67);
        this.contentsMenuItem.setText("Contents");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.helpContentsActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.helpMenu.add(this.helpMenuSeparator);
        this.aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.aboutMenuItem.setMnemonic(65);
        this.aboutMenuItem.setText("About . . .");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSP_GEOTRANS3.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void loadSettingsActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
        jFileChooser.addChoosableFileFilter(new XMLFileFilter());
        jFileChooser.setSelectedFile(new File("*.xml"));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDir.setDirectory(file.getAbsolutePath());
            if (file != null) {
                this.defaultSettings = new LoadSettings(this, file);
            }
        }
        try {
            this.defaultSettings.readDefaults();
            this.formatOptions = this.defaultSettings.getDefaultFormatOptions();
            this.updateDefaultSettings();
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
        }
    }

    private void saveSettingsActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
        jFileChooser.setDialogTitle("Save As");
        jFileChooser.addChoosableFileFilter(new XMLFileFilter());
        jFileChooser.setSelectedFile(new File("*.xml"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDir.setDirectory(file.getAbsolutePath());
            if (file != null) {
                new SaveSettings(this, file, this.upperMasterPanel, this.lowerMasterPanel, this.formatOptions);
            }
        }
    }

    private void convertUpButtonMouseReleased(MouseEvent mouseEvent) {
        this.convertUpButton.setBorder(new BevelBorder(0));
    }

    private void convertUpButtonMousePressed(MouseEvent mouseEvent) {
        this.convertUpButton.setBorder(new BevelBorder(1));
    }

    private void convertDownButtonMouseReleased(MouseEvent mouseEvent) {
        this.convertDownButton.setBorder(new BevelBorder(0));
    }

    private void convertDownButtonMousePressed(MouseEvent mouseEvent) {
        this.convertDownButton.setBorder(new BevelBorder(1));
    }

    private void convertButtonMouseReleased(MouseEvent mouseEvent) {
        UIManager.put("Button.select", this.defaultSelectedColor);
    }

    private void convertButtonMousePressed(MouseEvent mouseEvent) {
        UIManager.put("Button.select", this.currentColor);
    }

    private void createFileHeaderActionPerformed(ActionEvent actionEvent) {
        new CreateFileHeaderDlg(this.jniCoordinateConversionService, this, true, this.currentDir, this.formatOptions, this.stringHandler).show();
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
        new AboutDlg((Frame)this, true).show();
    }

    private void helpContentsActionPerformed(ActionEvent actionEvent) {
        File file = new File("..");
        try {
            if (StartBrowser.isWindowsPlatform()) {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "\\help\\contents.htm");
            } else {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "/help/contents.htm");
            }
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, "Could not invoke browser");
        }
    }

    private void lookAndFeelActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.metalRadioButtonMenuItem.isSelected()) {
                this.currLookAndFeel = "Java";
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (this.unixRadioButtonMenuItem.isSelected()) {
                this.currLookAndFeel = "Unix";
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (this.windowsRadioButtonMenuItem.isSelected()) {
                String string = System.getProperty("os.name");
                if (string != null && string.indexOf("Windows") != -1) {
                    this.currLookAndFeel = "Windows";
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else {
                    this.resetLookAndFeel();
                    this.stringHandler.displayErrorMsg(this, "This option is only available on a Windows platform");
                }
            }
            SwingUtilities.updateComponentTreeUI(this);
            this.upperMasterPanel.setLookAndFeel(this.currLookAndFeel);
            this.lowerMasterPanel.setLookAndFeel(this.currLookAndFeel);
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
        }
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.jniCoordinateConversionService.destroy();
        this.dispose();
        System.exit(0);
    }

    private void exitActionPerformed(ActionEvent actionEvent) {
        this.jniCoordinateConversionService.destroy();
        this.dispose();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
        jFileChooser.addChoosableFileFilter(new DATFileFilter());
        jFileChooser.setSelectedFile(new File("*.dat"));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDir.setDirectory(file.getAbsolutePath());
            if (file != null) {
                JNIFiomeths jNIFiomeths = null;
                try {
                    jNIFiomeths = new JNIFiomeths(file.getPath());
                    FileDlg fileDlg = new FileDlg(this.jniCoordinateConversionService, this, true, this.currentDir, this.formatOptions, jNIFiomeths, this.stringHandler);
                    fileDlg.show();
                }
                catch (Exception exception) {
                    this.stringHandler.displayErrorMsg(this, exception.getMessage());
                }
                finally {
                    if (jNIFiomeths != null) {
                        jNIFiomeths.destroy();
                    }
                }
            }
        }
    }

    private void formatActionPerformed(ActionEvent actionEvent) {
        FormatOptionsDlg formatOptionsDlg = new FormatOptionsDlg((Frame)this, true, this.formatOptions);
        formatOptionsDlg.show();
    }

    private void convertUpActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.checkParametersChanged(1, 0)) {
                CoordinateTuple coordinateTuple = this.lowerMasterPanel.getCoordinates();
                Accuracy accuracy = this.lowerMasterPanel.getAccuracy();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, 0, this.lowerMasterPanel.getProjectionType());
                } else {
                    CoordinateTuple coordinateTuple2 = this.upperMasterPanel.initTargetCoordinates();
                    Accuracy accuracy2 = new Accuracy();
                    ConvertResults convertResults = this.jniCoordinateConversionService.convertSourceToTarget(coordinateTuple, accuracy, coordinateTuple2, accuracy2);
                    coordinateTuple2 = convertResults.getCoordinateTuple();
                    accuracy2 = convertResults.getAccuracy();
                    String string = coordinateTuple2.getWarningMessage();
                    if (string.length() > 0) {
                        this.stringHandler.displayWarningMsg(this, string);
                    }
                    this.upperMasterPanel.setCoordinates(coordinateTuple2);
                    this.upperMasterPanel.setAccuracy(accuracy2);
                }
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void convertDownActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.checkParametersChanged(0, 1)) {
                CoordinateTuple coordinateTuple = this.upperMasterPanel.getCoordinates();
                Accuracy accuracy = this.upperMasterPanel.getAccuracy();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, 0, this.upperMasterPanel.getProjectionType());
                } else {
                    CoordinateTuple coordinateTuple2 = this.lowerMasterPanel.initTargetCoordinates();
                    Accuracy accuracy2 = new Accuracy();
                    ConvertResults convertResults = this.jniCoordinateConversionService.convertSourceToTarget(coordinateTuple, accuracy, coordinateTuple2, accuracy2);
                    coordinateTuple2 = convertResults.getCoordinateTuple();
                    accuracy2 = convertResults.getAccuracy();
                    String string = coordinateTuple2.getWarningMessage();
                    if (string.length() > 0) {
                        this.stringHandler.displayWarningMsg(this, string);
                    }
                    this.lowerMasterPanel.setCoordinates(coordinateTuple2);
                    this.lowerMasterPanel.setAccuracy(accuracy2);
                }
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void deleteEllipsoidActionPerformed(ActionEvent actionEvent) {
        try {
            new DeleteDlg(this.jniCoordinateConversionService, this, true, 1).show();
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void createEllipsoidActionPerformed(ActionEvent actionEvent) {
        try {
            new CreateEllipsoidDlg(this.jniCoordinateConversionService, this, true).show();
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void deleteDatumActionPerformed(ActionEvent actionEvent) {
        try {
            DeleteDlg deleteDlg = new DeleteDlg(this.jniCoordinateConversionService, this, true, 0);
            deleteDlg.show();
            if (deleteDlg.getDeleted()) {
                int n = deleteDlg.getIndex();
                this.upperMasterPanel.updateCurrentDatumIndex(n);
                this.lowerMasterPanel.updateCurrentDatumIndex(n);
                this.upperMasterPanel.deleteDatumFromList();
                this.lowerMasterPanel.deleteDatumFromList();
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void createDatumActionPerformed(ActionEvent actionEvent) {
        try {
            CreateDatumDlg createDatumDlg = new CreateDatumDlg(this.jniCoordinateConversionService, this, true);
            createDatumDlg.show();
            if (createDatumDlg.getDatumCreated()) {
                this.upperMasterPanel.addDatumToList();
                this.lowerMasterPanel.addDatumToList();
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
        }
    }

    private void editButtonMouseEntered(MouseEvent mouseEvent) {
        this.prevFocus = this.getFocusOwner();
    }

    private void pasteActionPerformed(ActionEvent actionEvent) {
        Component component = this.getFocusOwner();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).paste();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).paste();
        }
    }

    private void cutActionPerformed(ActionEvent actionEvent) {
        Component component = this.getFocusOwner();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).cut();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).cut();
        }
    }

    private void copyActionPerformed(ActionEvent actionEvent) {
        Component component = this.getFocusOwner();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).copy();
        } else if (this.prevFocus instanceof JTextComponent) {
            ((JTextComponent)this.prevFocus).copy();
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MSP_GEOTRANS3 mSP_GEOTRANS3 = new MSP_GEOTRANS3();
                mSP_GEOTRANS3.setVisible(true);
            }
        });
    }

    public void check3DConversion() {
        boolean bl = false;
        if (this.upperMasterPanel.getProjectionType() == 10) {
            if (this.lowerMasterPanel.getProjectionType() == 10 || this.lowerMasterPanel.getProjectionType() == 9 || this.lowerMasterPanel.getProjectionType() == 16) {
                this.upperMasterPanel.enableHeightComboBox(true);
                bl = true;
                this.upperMasterPanel.setHeightFieldEditable(true);
                if (this.lowerMasterPanel.getProjectionType() == 10) {
                    this.lowerMasterPanel.enableHeightComboBox(true);
                    this.lowerMasterPanel.setHeightFieldEditable(true);
                }
            } else {
                this.upperMasterPanel.selectNoHeightButton();
                this.upperMasterPanel.setHeightText("0");
                this.upperMasterPanel.setHeightFieldEditable(false);
                this.upperMasterPanel.enableHeightComboBox(false);
            }
        } else if (this.lowerMasterPanel.getProjectionType() == 10) {
            if (this.upperMasterPanel.getProjectionType() == 10 || this.upperMasterPanel.getProjectionType() == 9 || this.upperMasterPanel.getProjectionType() == 16) {
                this.lowerMasterPanel.enableHeightComboBox(true);
                bl = true;
                this.lowerMasterPanel.setHeightFieldEditable(true);
            } else {
                this.lowerMasterPanel.selectNoHeightButton();
                this.lowerMasterPanel.setHeightText("0");
                this.lowerMasterPanel.setHeightFieldEditable(false);
                this.lowerMasterPanel.enableHeightComboBox(false);
            }
        } else if (!(this.upperMasterPanel.getProjectionType() != 9 && this.upperMasterPanel.getProjectionType() != 16 || this.lowerMasterPanel.getProjectionType() != 9 && this.lowerMasterPanel.getProjectionType() != 16)) {
            bl = true;
        }
        this.upperMasterPanel.updateSrcErrors(bl);
        this.lowerMasterPanel.updateSrcErrors(bl);
    }

    public void checkValidConversion() {
        try {
            JNIDatumLibrary jNIDatumLibrary = new JNIDatumLibrary(this.jniCoordinateConversionService.getDatumLibrary());
            long l = this.upperMasterPanel.getDatumIndex();
            long l2 = this.lowerMasterPanel.getDatumIndex();
            String string = jNIDatumLibrary.getDatumInfo(l).getDatumEllipsoidCode();
            String string2 = jNIDatumLibrary.getDatumInfo(l2).getDatumEllipsoidCode();
            int n = this.upperMasterPanel.getProjectionType();
            int n2 = this.lowerMasterPanel.getProjectionType();
            int n3 = 0;
            int n4 = 0;
            if (n == 3 && !string.equalsIgnoreCase("AA") || n2 == 3 && !string2.equalsIgnoreCase("AA") || n == 37 && !string.equalsIgnoreCase("WE") || n2 == 37 && !string2.equalsIgnoreCase("WE") || n == 37 && n2 != 10 || n2 == 37 && n != 10 || n == 22 && !string.equalsIgnoreCase("IN") || n2 == 22 && !string2.equalsIgnoreCase("IN")) {
                n3 = 0;
                n4 = 0;
            } else if (n == 37 && n2 == 10) {
                n3 = 0;
                n4 = 2;
            } else if (n2 == 37 && n == 10) {
                n3 = 2;
                n4 = 0;
            } else {
                AOI aOI = jNIDatumLibrary.getDatumValidRectangle(l);
                AOI aOI2 = jNIDatumLibrary.getDatumValidRectangle(l2);
                if (aOI.getWestLongitude() >= aOI2.getEastLongitude() || aOI.getEastLongitude() <= aOI2.getWestLongitude() || aOI.getSouthLatitude() >= aOI2.getNorthLatitude() || aOI.getNorthLatitude() <= aOI2.getSouthLatitude()) {
                    n3 = 1;
                    n4 = 1;
                } else {
                    n3 = 2;
                    n4 = 2;
                }
            }
            if (n3 == 0) {
                this.currentColorUp = Red.VALUE;
            } else if (n3 == 1) {
                this.currentColorUp = Yellow.VALUE;
            } else if (n3 == 2) {
                this.currentColorUp = Green.VALUE;
            }
            if (n4 == 0) {
                this.currentColorDown = Red.VALUE;
            } else if (n4 == 1) {
                this.currentColorDown = Yellow.VALUE;
            } else if (n4 == 2) {
                this.currentColorDown = Green.VALUE;
            }
            this.convertUpButton.setBackground(this.currentColorUp);
            this.convertDownButton.setBackground(this.currentColorDown);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(this, "checkValidConversion: " + coordinateConversionException.getMessage());
        }
    }

    private void initialize() {
        boolean bl = false;
        try {
            if (this.defaultSettings != null) {
                this.formatOptions = this.defaultSettings.getDefaultFormatOptions();
                this.currentDatum[0] = this.defaultSettings.getDefaultSourceDatumCode();
                this.currentDatum[1] = this.defaultSettings.getDefaultTargetDatumCode();
                this.currentParameters[0] = this.defaultSettings.getDefaultSourceParameters();
                this.currentParameters[1] = this.defaultSettings.getDefaultTargetParameters();
            } else {
                this.formatOptions = new FormatOptions();
                this.currentDatum[0] = "WGE";
                this.currentDatum[1] = "WGE";
                this.currentParameters[0] = new GeodeticParameters(10, 0);
                this.currentParameters[1] = new UTMParameters(34, 0L, 0L);
            }
            this.stringHandler = new StringHandler(this.formatOptions.getStringToVal());
            this.jniCoordinateConversionService = new JNICoordinateConversionService(this.currentDatum[0], this.currentParameters[0], this.currentDatum[1], this.currentParameters[1]);
            this.upperMasterPanel = new MasterPanel(this.jniCoordinateConversionService, 1, 0, this.formatOptions, this.stringHandler);
            this.upperMasterPanel.setDefaults(0, this.jniCoordinateConversionService, this.formatOptions, this.stringHandler);
            if (this.upperMasterPanel == null) {
                this.stringHandler.displayErrorMsg(this, "Unable to initialize GEOTRANS");
                System.exit(0);
            }
            this.lowerMasterPanel = new MasterPanel(this.jniCoordinateConversionService, 1, 1, this.formatOptions, this.stringHandler);
            this.lowerMasterPanel.setDefaults(1, this.jniCoordinateConversionService, this.formatOptions, this.stringHandler);
            if (this.lowerMasterPanel == null) {
                this.stringHandler.displayErrorMsg(this, "Unable to initialize GEOTRANS");
                System.exit(0);
            }
            this.upperMasterPanel.setParent(this);
            this.lowerMasterPanel.setParent(this);
            this.check3DConversion();
            this.checkValidConversion();
            this.upperPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            this.upperPanel.add((Component)this.upperMasterPanel, gridBagConstraints);
            gridBagConstraints.anchor = 16;
            this.lowerPanel.add((Component)this.lowerMasterPanel, gridBagConstraints);
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, "Initialization error: \n\n" + exception.getMessage());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.stringHandler.displayErrorMsg(this, "Unsatisfied Link Error: " + unsatisfiedLinkError.getMessage());
            bl = true;
        }
        if (bl) {
            this.dispose();
            System.exit(0);
        }
    }

    private void resetLookAndFeel() {
        if (this.currLookAndFeel.equals("Java")) {
            this.metalRadioButtonMenuItem.setSelected(true);
        } else if (this.currLookAndFeel.equals("Unix")) {
            this.unixRadioButtonMenuItem.setSelected(true);
        } else if (this.currLookAndFeel.equals("Windows")) {
            this.windowsRadioButtonMenuItem.setSelected(true);
        }
    }

    private boolean checkParametersChanged(int n, int n2) throws CoordinateConversionException {
        try {
            CoordinateSystemParameters coordinateSystemParameters;
            CoordinateSystemParameters coordinateSystemParameters2;
            String string;
            String string2;
            if (n == 0) {
                string2 = this.upperMasterPanel.getDatumCode();
                string = this.lowerMasterPanel.getDatumCode();
                coordinateSystemParameters2 = this.upperMasterPanel.getParameters();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, n, this.upperMasterPanel.getProjectionType());
                }
                coordinateSystemParameters = this.lowerMasterPanel.getParameters();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, n2, this.lowerMasterPanel.getProjectionType());
                    return false;
                }
            } else {
                string2 = this.lowerMasterPanel.getDatumCode();
                string = this.upperMasterPanel.getDatumCode();
                coordinateSystemParameters2 = this.lowerMasterPanel.getParameters();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, n, this.lowerMasterPanel.getProjectionType());
                }
                coordinateSystemParameters = this.upperMasterPanel.getParameters();
                if (this.stringHandler.getError()) {
                    this.stringHandler.displayErrorMsg(this, n2, this.upperMasterPanel.getProjectionType());
                    return false;
                }
            }
            boolean bl = false;
            if (!this.currentDatum[0].equalsIgnoreCase(string2) || !this.currentDatum[1].equalsIgnoreCase(string) || this.currentParameters[0].getCoordinateType() != coordinateSystemParameters2.getCoordinateType() || this.currentParameters[1].getCoordinateType() != coordinateSystemParameters.getCoordinateType()) {
                bl = true;
            } else if (this.coordinateSystemParametersChanged(this.currentParameters[0], coordinateSystemParameters2)) {
                bl = true;
            } else if (this.coordinateSystemParametersChanged(this.currentParameters[1], coordinateSystemParameters)) {
                bl = true;
            }
            if (bl) {
                JNICoordinateConversionService jNICoordinateConversionService = new JNICoordinateConversionService(string2, coordinateSystemParameters2, string, coordinateSystemParameters);
                if (this.jniCoordinateConversionService != null) {
                    this.jniCoordinateConversionService.destroy();
                }
                this.jniCoordinateConversionService = jNICoordinateConversionService;
                this.currentDatum[0] = string2;
                this.currentDatum[1] = string;
                this.currentParameters[0] = coordinateSystemParameters2;
                this.currentParameters[1] = coordinateSystemParameters;
                this.upperMasterPanel.setCoordinateConversionService(this.jniCoordinateConversionService);
                this.lowerMasterPanel.setCoordinateConversionService(this.jniCoordinateConversionService);
            }
            return true;
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
            return false;
        }
    }

    private boolean coordinateSystemParametersChanged(CoordinateSystemParameters coordinateSystemParameters, CoordinateSystemParameters coordinateSystemParameters2) throws CoordinateConversionException {
        int n = coordinateSystemParameters2.getCoordinateType();
        switch (n) {
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 22: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                return !coordinateSystemParameters.equal(coordinateSystemParameters2);
            }
            case 10: {
                return !((GeodeticParameters)coordinateSystemParameters).equal((GeodeticParameters)coordinateSystemParameters2);
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 29: 
            case 36: {
                return !((MapProjection3Parameters)coordinateSystemParameters).equal((MapProjection3Parameters)coordinateSystemParameters2);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 25: 
            case 28: 
            case 30: {
                return !((MapProjection4Parameters)coordinateSystemParameters).equal((MapProjection4Parameters)coordinateSystemParameters2);
            }
            case 14: 
            case 31: 
            case 32: {
                return !((MapProjection5Parameters)coordinateSystemParameters).equal((MapProjection5Parameters)coordinateSystemParameters2);
            }
            case 0: 
            case 15: {
                return !((MapProjection6Parameters)coordinateSystemParameters).equal((MapProjection6Parameters)coordinateSystemParameters2);
            }
            case 8: {
                return !((EquidistantCylindricalParameters)coordinateSystemParameters).equal((EquidistantCylindricalParameters)coordinateSystemParameters2);
            }
            case 16: {
                return !((LocalCartesianParameters)coordinateSystemParameters).equal((LocalCartesianParameters)coordinateSystemParameters2);
            }
            case 17: {
                return !((MercatorStandardParallelParameters)coordinateSystemParameters).equal((MercatorStandardParallelParameters)coordinateSystemParameters2);
            }
            case 18: {
                return !((MercatorScaleFactorParameters)coordinateSystemParameters).equal((MercatorScaleFactorParameters)coordinateSystemParameters2);
            }
            case 23: {
                return !((NeysParameters)coordinateSystemParameters).equal((NeysParameters)coordinateSystemParameters2);
            }
            case 24: {
                return !((ObliqueMercatorParameters)coordinateSystemParameters).equal((ObliqueMercatorParameters)coordinateSystemParameters2);
            }
            case 26: {
                return !((PolarStereographicStandardParallelParameters)coordinateSystemParameters).equal((PolarStereographicStandardParallelParameters)coordinateSystemParameters2);
            }
            case 27: {
                return !((PolarStereographicScaleFactorParameters)coordinateSystemParameters).equal((PolarStereographicScaleFactorParameters)coordinateSystemParameters2);
            }
            case 34: {
                return !((UTMParameters)coordinateSystemParameters).equal((UTMParameters)coordinateSystemParameters2);
            }
        }
        throw new CoordinateConversionException("Invalid coordinate type");
    }

    private void updateDefaultSettings() {
        try {
            this.formatOptions = this.defaultSettings.getDefaultFormatOptions();
            this.currentDatum[0] = this.defaultSettings.getDefaultSourceDatumCode();
            this.currentDatum[1] = this.defaultSettings.getDefaultTargetDatumCode();
            this.currentParameters[0] = this.defaultSettings.getDefaultSourceParameters();
            this.currentParameters[1] = this.defaultSettings.getDefaultTargetParameters();
            this.stringHandler = new StringHandler(this.formatOptions.getStringToVal());
            JNICoordinateConversionService jNICoordinateConversionService = new JNICoordinateConversionService(this.currentDatum[0], this.currentParameters[0], this.currentDatum[1], this.currentParameters[1]);
            if (this.jniCoordinateConversionService != null) {
                this.jniCoordinateConversionService.destroy();
            }
            this.jniCoordinateConversionService = jNICoordinateConversionService;
            this.upperMasterPanel.setDefaults(0, this.jniCoordinateConversionService, this.formatOptions, this.stringHandler);
            this.lowerMasterPanel.setDefaults(1, this.jniCoordinateConversionService, this.formatOptions, this.stringHandler);
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
            this.defaultSettings = null;
        }
    }

    void setIcons() {
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Cut16.gif")));
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Copy16.gif")));
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Paste16.gif")));
        this.formatButton.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Preferences16.gif")));
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Open16.gif")));
        this.createFileHeaderMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Create16.gif")));
        this.loadSettingsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Open16.gif")));
        this.saveSettingsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Save16.gif")));
        this.exitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Stop16.gif")));
        this.cutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Cut16.gif")));
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Copy16.gif")));
        this.pasteMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Paste16.gif")));
        this.formatMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Preferences16.gif")));
        this.convertDownMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Down16.gif")));
        this.convertUpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/geotrans3/gui/icons/Up16.gif")));
    }

    static {
        System.loadLibrary("jnimsp_ccs");
    }
}

