/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/discrime.h
*       Authors:  Janne Grunau
*
*       Copyright (C) 1998-2004 Alexander Schliep
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*       Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik,
*                               Berlin
*
*       Contact: schliep@ghmm.org
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 1713 $
*                       from $Date: 2006-10-16 10:06:28 -0400 (Mon, 16 Oct 2006) $
*             last change by $Author: grunau $.
*
*******************************************************************************/


#ifndef GHMM_DISCRIME_H
#define GHMM_DISCRIME_H

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*/
/**
   Trains two or more models to opimise the discrimination between the
   classes in the trainingset.
   @return                 0/-1 success/error
   @param mo:              array of pointers to some models
   @param sqs:             array of annotated sequence sets
   @param noC:             number of classes
   @param max_steps:       maximum number of training steps for a class
   @param gradient:        if gradient == 0 try a closed form solution
                           otherwise a gradient descent
 */
  int ghmm_dmodel_label_discriminative (ghmm_dmodel ** mo, ghmm_dseq ** sqs, int noC, int max_steps,
		      int gradient);

/*----------------------------------------------------------------------------*/
/**
   Returns the value of teh in this discriminative training algorithm optimised
   function for a tupel of HMMs and sequencesets.
   @return                 value of funcion
   @param mo:              array of pointers to some models
   @param sqs:             array of annotated sequence sets
   @param noC:             number of classes
*/
  double ghmm_dmodel_label_discrim_perf (ghmm_dmodel ** mo, ghmm_dseq ** sqs,
                                       int noC);


#ifdef __cplusplus
}
#endif
#endif
