// Code generated by smithy-go-codegen DO NOT EDIT.

package amplifybackend

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/amplifybackend/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCloneBackend struct {
}

func (*awsRestjson1_serializeOpCloneBackend) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCloneBackend) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CloneBackendInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/environments/{BackendEnvironmentName}/clone")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCloneBackendInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCloneBackendInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCloneBackendInput(v *CloneBackendInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCloneBackendInput(v *CloneBackendInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetEnvironmentName != nil {
		ok := object.Key("targetEnvironmentName")
		ok.String(*v.TargetEnvironmentName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackend struct {
}

func (*awsRestjson1_serializeOpCreateBackend) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackend) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackendInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackendInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackendInput(v *CreateBackendInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackendInput(v *CreateBackendInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppId != nil {
		ok := object.Key("appId")
		ok.String(*v.AppId)
	}

	if v.AppName != nil {
		ok := object.Key("appName")
		ok.String(*v.AppName)
	}

	if v.BackendEnvironmentName != nil {
		ok := object.Key("backendEnvironmentName")
		ok.String(*v.BackendEnvironmentName)
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackendAPI struct {
}

func (*awsRestjson1_serializeOpCreateBackendAPI) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackendAPI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackendAPIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackendAPIInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackendAPIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackendAPIInput(v *CreateBackendAPIInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackendAPIInput(v *CreateBackendAPIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendEnvironmentName != nil {
		ok := object.Key("backendEnvironmentName")
		ok.String(*v.BackendEnvironmentName)
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentBackendAPIResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackendAuth struct {
}

func (*awsRestjson1_serializeOpCreateBackendAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackendAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackendAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/auth")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackendAuthInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackendAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackendAuthInput(v *CreateBackendAuthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackendAuthInput(v *CreateBackendAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendEnvironmentName != nil {
		ok := object.Key("backendEnvironmentName")
		ok.String(*v.BackendEnvironmentName)
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackendConfig struct {
}

func (*awsRestjson1_serializeOpCreateBackendConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackendConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackendConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/config")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackendConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackendConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackendConfigInput(v *CreateBackendConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackendConfigInput(v *CreateBackendConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendManagerAppId != nil {
		ok := object.Key("backendManagerAppId")
		ok.String(*v.BackendManagerAppId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackendStorage struct {
}

func (*awsRestjson1_serializeOpCreateBackendStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackendStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackendStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/storage")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackendStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackendStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackendStorageInput(v *CreateBackendStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackendStorageInput(v *CreateBackendStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendEnvironmentName != nil {
		ok := object.Key("backendEnvironmentName")
		ok.String(*v.BackendEnvironmentName)
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentCreateBackendStorageResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateToken struct {
}

func (*awsRestjson1_serializeOpCreateToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/challenge")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTokenInput(v *CreateTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackend struct {
}

func (*awsRestjson1_serializeOpDeleteBackend) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackend) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackendInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/environments/{BackendEnvironmentName}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackendInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackendInput(v *DeleteBackendInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackendAPI struct {
}

func (*awsRestjson1_serializeOpDeleteBackendAPI) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackendAPI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackendAPIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api/{BackendEnvironmentName}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackendAPIInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteBackendAPIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackendAPIInput(v *DeleteBackendAPIInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteBackendAPIInput(v *DeleteBackendAPIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentBackendAPIResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackendAuth struct {
}

func (*awsRestjson1_serializeOpDeleteBackendAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackendAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackendAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/auth/{BackendEnvironmentName}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackendAuthInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteBackendAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackendAuthInput(v *DeleteBackendAuthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteBackendAuthInput(v *DeleteBackendAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackendStorage struct {
}

func (*awsRestjson1_serializeOpDeleteBackendStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackendStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackendStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/storage/{BackendEnvironmentName}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackendStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteBackendStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackendStorageInput(v *DeleteBackendStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteBackendStorageInput(v *DeleteBackendStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	if len(v.ServiceName) > 0 {
		ok := object.Key("serviceName")
		ok.String(string(v.ServiceName))
	}

	return nil
}

type awsRestjson1_serializeOpDeleteToken struct {
}

func (*awsRestjson1_serializeOpDeleteToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/challenge/{SessionId}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTokenInput(v *DeleteTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("SessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateBackendAPIModels struct {
}

func (*awsRestjson1_serializeOpGenerateBackendAPIModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateBackendAPIModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateBackendAPIModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api/{BackendEnvironmentName}/generateModels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateBackendAPIModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateBackendAPIModelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateBackendAPIModelsInput(v *GenerateBackendAPIModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateBackendAPIModelsInput(v *GenerateBackendAPIModelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackend struct {
}

func (*awsRestjson1_serializeOpGetBackend) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackend) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/details")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackendInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendInput(v *GetBackendInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackendInput(v *GetBackendInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackendEnvironmentName != nil {
		ok := object.Key("backendEnvironmentName")
		ok.String(*v.BackendEnvironmentName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackendAPI struct {
}

func (*awsRestjson1_serializeOpGetBackendAPI) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackendAPI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendAPIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api/{BackendEnvironmentName}/details")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendAPIInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackendAPIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendAPIInput(v *GetBackendAPIInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackendAPIInput(v *GetBackendAPIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentBackendAPIResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackendAPIModels struct {
}

func (*awsRestjson1_serializeOpGetBackendAPIModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackendAPIModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendAPIModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api/{BackendEnvironmentName}/getModels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendAPIModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackendAPIModelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendAPIModelsInput(v *GetBackendAPIModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackendAPIModelsInput(v *GetBackendAPIModelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackendAuth struct {
}

func (*awsRestjson1_serializeOpGetBackendAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackendAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/auth/{BackendEnvironmentName}/details")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendAuthInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackendAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendAuthInput(v *GetBackendAuthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackendAuthInput(v *GetBackendAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackendJob struct {
}

func (*awsRestjson1_serializeOpGetBackendJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackendJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/job/{BackendEnvironmentName}/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendJobInput(v *GetBackendJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackendStorage struct {
}

func (*awsRestjson1_serializeOpGetBackendStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackendStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackendStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/storage/{BackendEnvironmentName}/details")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackendStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackendStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackendStorageInput(v *GetBackendStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackendStorageInput(v *GetBackendStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpGetToken struct {
}

func (*awsRestjson1_serializeOpGetToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/challenge/{SessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTokenInput(v *GetTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("SessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpImportBackendAuth struct {
}

func (*awsRestjson1_serializeOpImportBackendAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpImportBackendAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportBackendAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/auth/{BackendEnvironmentName}/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsImportBackendAuthInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentImportBackendAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsImportBackendAuthInput(v *ImportBackendAuthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentImportBackendAuthInput(v *ImportBackendAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityPoolId != nil {
		ok := object.Key("identityPoolId")
		ok.String(*v.IdentityPoolId)
	}

	if v.NativeClientId != nil {
		ok := object.Key("nativeClientId")
		ok.String(*v.NativeClientId)
	}

	if v.UserPoolId != nil {
		ok := object.Key("userPoolId")
		ok.String(*v.UserPoolId)
	}

	if v.WebClientId != nil {
		ok := object.Key("webClientId")
		ok.String(*v.WebClientId)
	}

	return nil
}

type awsRestjson1_serializeOpImportBackendStorage struct {
}

func (*awsRestjson1_serializeOpImportBackendStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpImportBackendStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportBackendStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/storage/{BackendEnvironmentName}/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsImportBackendStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentImportBackendStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsImportBackendStorageInput(v *ImportBackendStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentImportBackendStorageInput(v *ImportBackendStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if len(v.ServiceName) > 0 {
		ok := object.Key("serviceName")
		ok.String(string(v.ServiceName))
	}

	return nil
}

type awsRestjson1_serializeOpListBackendJobs struct {
}

func (*awsRestjson1_serializeOpListBackendJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackendJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackendJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/job/{BackendEnvironmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackendJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBackendJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackendJobsInput(v *ListBackendJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBackendJobsInput(v *ListBackendJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.Operation != nil {
		ok := object.Key("operation")
		ok.String(*v.Operation)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

type awsRestjson1_serializeOpListS3Buckets struct {
}

func (*awsRestjson1_serializeOpListS3Buckets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListS3Buckets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListS3BucketsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/s3Buckets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListS3BucketsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListS3BucketsInput(v *ListS3BucketsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListS3BucketsInput(v *ListS3BucketsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveAllBackends struct {
}

func (*awsRestjson1_serializeOpRemoveAllBackends) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveAllBackends) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveAllBackendsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveAllBackendsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRemoveAllBackendsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveAllBackendsInput(v *RemoveAllBackendsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRemoveAllBackendsInput(v *RemoveAllBackendsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CleanAmplifyApp != nil {
		ok := object.Key("cleanAmplifyApp")
		ok.Boolean(*v.CleanAmplifyApp)
	}

	return nil
}

type awsRestjson1_serializeOpRemoveBackendConfig struct {
}

func (*awsRestjson1_serializeOpRemoveBackendConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRemoveBackendConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveBackendConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/config/remove")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRemoveBackendConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRemoveBackendConfigInput(v *RemoveBackendConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackendAPI struct {
}

func (*awsRestjson1_serializeOpUpdateBackendAPI) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackendAPI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackendAPIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/api/{BackendEnvironmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackendAPIInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackendAPIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackendAPIInput(v *UpdateBackendAPIInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackendAPIInput(v *UpdateBackendAPIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentBackendAPIResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackendAuth struct {
}

func (*awsRestjson1_serializeOpUpdateBackendAuth) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackendAuth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackendAuthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/auth/{BackendEnvironmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackendAuthInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackendAuthInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackendAuthInput(v *UpdateBackendAuthInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackendAuthInput(v *UpdateBackendAuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackendConfig struct {
}

func (*awsRestjson1_serializeOpUpdateBackendConfig) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackendConfig) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackendConfigInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/config/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackendConfigInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackendConfigInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackendConfigInput(v *UpdateBackendConfigInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackendConfigInput(v *UpdateBackendConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoginAuthConfig != nil {
		ok := object.Key("loginAuthConfig")
		if err := awsRestjson1_serializeDocumentLoginAuthConfigReqObj(v.LoginAuthConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackendJob struct {
}

func (*awsRestjson1_serializeOpUpdateBackendJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackendJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackendJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/job/{BackendEnvironmentName}/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackendJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackendJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackendJobInput(v *UpdateBackendJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackendJobInput(v *UpdateBackendJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operation != nil {
		ok := object.Key("operation")
		ok.String(*v.Operation)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackendStorage struct {
}

func (*awsRestjson1_serializeOpUpdateBackendStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackendStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackendStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backend/{AppId}/storage/{BackendEnvironmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackendStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackendStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackendStorageInput(v *UpdateBackendStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AppId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("AppId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.BackendEnvironmentName == nil || len(*v.BackendEnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackendEnvironmentName must not be empty")}
	}
	if v.BackendEnvironmentName != nil {
		if err := encoder.SetURI("BackendEnvironmentName").String(*v.BackendEnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackendStorageInput(v *UpdateBackendStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentUpdateBackendStorageResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.ResourceName != nil {
		ok := object.Key("resourceName")
		ok.String(*v.ResourceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAPIAppSyncAuthSettings(v *types.BackendAPIAppSyncAuthSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CognitoUserPoolId != nil {
		ok := object.Key("cognitoUserPoolId")
		ok.String(*v.CognitoUserPoolId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExpirationTime != nil {
		ok := object.Key("expirationTime")
		switch {
		case math.IsNaN(*v.ExpirationTime):
			ok.String("NaN")

		case math.IsInf(*v.ExpirationTime, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ExpirationTime, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ExpirationTime)

		}
	}

	if v.OpenIDAuthTTL != nil {
		ok := object.Key("openIDAuthTTL")
		ok.String(*v.OpenIDAuthTTL)
	}

	if v.OpenIDClientId != nil {
		ok := object.Key("openIDClientId")
		ok.String(*v.OpenIDClientId)
	}

	if v.OpenIDIatTTL != nil {
		ok := object.Key("openIDIatTTL")
		ok.String(*v.OpenIDIatTTL)
	}

	if v.OpenIDIssueURL != nil {
		ok := object.Key("openIDIssueURL")
		ok.String(*v.OpenIDIssueURL)
	}

	if v.OpenIDProviderName != nil {
		ok := object.Key("openIDProviderName")
		ok.String(*v.OpenIDProviderName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAPIAuthType(v *types.BackendAPIAuthType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentBackendAPIAppSyncAuthSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAPIConflictResolution(v *types.BackendAPIConflictResolution, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResolutionStrategy) > 0 {
		ok := object.Key("resolutionStrategy")
		ok.String(string(v.ResolutionStrategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAPIResourceConfig(v *types.BackendAPIResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalAuthTypes != nil {
		ok := object.Key("additionalAuthTypes")
		if err := awsRestjson1_serializeDocumentListOfBackendAPIAuthType(v.AdditionalAuthTypes, ok); err != nil {
			return err
		}
	}

	if v.ApiName != nil {
		ok := object.Key("apiName")
		ok.String(*v.ApiName)
	}

	if v.ConflictResolution != nil {
		ok := object.Key("conflictResolution")
		if err := awsRestjson1_serializeDocumentBackendAPIConflictResolution(v.ConflictResolution, ok); err != nil {
			return err
		}
	}

	if v.DefaultAuthType != nil {
		ok := object.Key("defaultAuthType")
		if err := awsRestjson1_serializeDocumentBackendAPIAuthType(v.DefaultAuthType, ok); err != nil {
			return err
		}
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	if v.TransformSchema != nil {
		ok := object.Key("transformSchema")
		ok.String(*v.TransformSchema)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAuthAppleProviderConfig(v *types.BackendAuthAppleProviderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("client_id")
		ok.String(*v.ClientId)
	}

	if v.KeyId != nil {
		ok := object.Key("key_id")
		ok.String(*v.KeyId)
	}

	if v.PrivateKey != nil {
		ok := object.Key("private_key")
		ok.String(*v.PrivateKey)
	}

	if v.TeamId != nil {
		ok := object.Key("team_id")
		ok.String(*v.TeamId)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendAuthSocialProviderConfig(v *types.BackendAuthSocialProviderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("client_id")
		ok.String(*v.ClientId)
	}

	if v.ClientSecret != nil {
		ok := object.Key("client_secret")
		ok.String(*v.ClientSecret)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackendStoragePermissions(v *types.BackendStoragePermissions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Authenticated != nil {
		ok := object.Key("authenticated")
		if err := awsRestjson1_serializeDocumentListOfAuthenticatedElement(v.Authenticated, ok); err != nil {
			return err
		}
	}

	if v.UnAuthenticated != nil {
		ok := object.Key("unAuthenticated")
		if err := awsRestjson1_serializeDocumentListOfUnAuthenticatedElement(v.UnAuthenticated, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthForgotPasswordConfig(v *types.CreateBackendAuthForgotPasswordConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeliveryMethod) > 0 {
		ok := object.Key("deliveryMethod")
		ok.String(string(v.DeliveryMethod))
	}

	if v.EmailSettings != nil {
		ok := object.Key("emailSettings")
		if err := awsRestjson1_serializeDocumentEmailSettings(v.EmailSettings, ok); err != nil {
			return err
		}
	}

	if v.SmsSettings != nil {
		ok := object.Key("smsSettings")
		if err := awsRestjson1_serializeDocumentSmsSettings(v.SmsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthIdentityPoolConfig(v *types.CreateBackendAuthIdentityPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityPoolName != nil {
		ok := object.Key("identityPoolName")
		ok.String(*v.IdentityPoolName)
	}

	if v.UnauthenticatedLogin != nil {
		ok := object.Key("unauthenticatedLogin")
		ok.Boolean(*v.UnauthenticatedLogin)
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthMFAConfig(v *types.CreateBackendAuthMFAConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MFAMode) > 0 {
		ok := object.Key("MFAMode")
		ok.String(string(v.MFAMode))
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthOAuthConfig(v *types.CreateBackendAuthOAuthConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainPrefix != nil {
		ok := object.Key("domainPrefix")
		ok.String(*v.DomainPrefix)
	}

	if len(v.OAuthGrantType) > 0 {
		ok := object.Key("oAuthGrantType")
		ok.String(string(v.OAuthGrantType))
	}

	if v.OAuthScopes != nil {
		ok := object.Key("oAuthScopes")
		if err := awsRestjson1_serializeDocumentListOfOAuthScopesElement(v.OAuthScopes, ok); err != nil {
			return err
		}
	}

	if v.RedirectSignInURIs != nil {
		ok := object.Key("redirectSignInURIs")
		if err := awsRestjson1_serializeDocumentListOf__string(v.RedirectSignInURIs, ok); err != nil {
			return err
		}
	}

	if v.RedirectSignOutURIs != nil {
		ok := object.Key("redirectSignOutURIs")
		if err := awsRestjson1_serializeDocumentListOf__string(v.RedirectSignOutURIs, ok); err != nil {
			return err
		}
	}

	if v.SocialProviderSettings != nil {
		ok := object.Key("socialProviderSettings")
		if err := awsRestjson1_serializeDocumentSocialProviderSettings(v.SocialProviderSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthPasswordPolicyConfig(v *types.CreateBackendAuthPasswordPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalConstraints != nil {
		ok := object.Key("additionalConstraints")
		if err := awsRestjson1_serializeDocumentListOfAdditionalConstraintsElement(v.AdditionalConstraints, ok); err != nil {
			return err
		}
	}

	if v.MinimumLength != nil {
		ok := object.Key("minimumLength")
		switch {
		case math.IsNaN(*v.MinimumLength):
			ok.String("NaN")

		case math.IsInf(*v.MinimumLength, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinimumLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinimumLength)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthResourceConfig(v *types.CreateBackendAuthResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthResources) > 0 {
		ok := object.Key("authResources")
		ok.String(string(v.AuthResources))
	}

	if v.IdentityPoolConfigs != nil {
		ok := object.Key("identityPoolConfigs")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthIdentityPoolConfig(v.IdentityPoolConfigs, ok); err != nil {
			return err
		}
	}

	if len(v.Service) > 0 {
		ok := object.Key("service")
		ok.String(string(v.Service))
	}

	if v.UserPoolConfigs != nil {
		ok := object.Key("userPoolConfigs")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthUserPoolConfig(v.UserPoolConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthUserPoolConfig(v *types.CreateBackendAuthUserPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ForgotPassword != nil {
		ok := object.Key("forgotPassword")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthForgotPasswordConfig(v.ForgotPassword, ok); err != nil {
			return err
		}
	}

	if v.Mfa != nil {
		ok := object.Key("mfa")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthMFAConfig(v.Mfa, ok); err != nil {
			return err
		}
	}

	if v.OAuth != nil {
		ok := object.Key("oAuth")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthOAuthConfig(v.OAuth, ok); err != nil {
			return err
		}
	}

	if v.PasswordPolicy != nil {
		ok := object.Key("passwordPolicy")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthPasswordPolicyConfig(v.PasswordPolicy, ok); err != nil {
			return err
		}
	}

	if v.RequiredSignUpAttributes != nil {
		ok := object.Key("requiredSignUpAttributes")
		if err := awsRestjson1_serializeDocumentListOfRequiredSignUpAttributesElement(v.RequiredSignUpAttributes, ok); err != nil {
			return err
		}
	}

	if len(v.SignInMethod) > 0 {
		ok := object.Key("signInMethod")
		ok.String(string(v.SignInMethod))
	}

	if v.UserPoolName != nil {
		ok := object.Key("userPoolName")
		ok.String(*v.UserPoolName)
	}

	if v.VerificationMessage != nil {
		ok := object.Key("verificationMessage")
		if err := awsRestjson1_serializeDocumentCreateBackendAuthVerificationMessageConfig(v.VerificationMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendAuthVerificationMessageConfig(v *types.CreateBackendAuthVerificationMessageConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeliveryMethod) > 0 {
		ok := object.Key("deliveryMethod")
		ok.String(string(v.DeliveryMethod))
	}

	if v.EmailSettings != nil {
		ok := object.Key("emailSettings")
		if err := awsRestjson1_serializeDocumentEmailSettings(v.EmailSettings, ok); err != nil {
			return err
		}
	}

	if v.SmsSettings != nil {
		ok := object.Key("smsSettings")
		if err := awsRestjson1_serializeDocumentSmsSettings(v.SmsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateBackendStorageResourceConfig(v *types.CreateBackendStorageResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("bucketName")
		ok.String(*v.BucketName)
	}

	if v.Permissions != nil {
		ok := object.Key("permissions")
		if err := awsRestjson1_serializeDocumentBackendStoragePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	if len(v.ServiceName) > 0 {
		ok := object.Key("serviceName")
		ok.String(string(v.ServiceName))
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailSettings(v *types.EmailSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EmailMessage != nil {
		ok := object.Key("emailMessage")
		ok.String(*v.EmailMessage)
	}

	if v.EmailSubject != nil {
		ok := object.Key("emailSubject")
		ok.String(*v.EmailSubject)
	}

	return nil
}

func awsRestjson1_serializeDocumentListOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfAdditionalConstraintsElement(v []types.AdditionalConstraintsElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfAuthenticatedElement(v []types.AuthenticatedElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfBackendAPIAuthType(v []types.BackendAPIAuthType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBackendAPIAuthType(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfMfaTypesElement(v []types.MfaTypesElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfOAuthScopesElement(v []types.OAuthScopesElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfRequiredSignUpAttributesElement(v []types.RequiredSignUpAttributesElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentListOfUnAuthenticatedElement(v []types.UnAuthenticatedElement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentLoginAuthConfigReqObj(v *types.LoginAuthConfigReqObj, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsCognitoIdentityPoolId != nil {
		ok := object.Key("aws_cognito_identity_pool_id")
		ok.String(*v.AwsCognitoIdentityPoolId)
	}

	if v.AwsCognitoRegion != nil {
		ok := object.Key("aws_cognito_region")
		ok.String(*v.AwsCognitoRegion)
	}

	if v.AwsUserPoolsId != nil {
		ok := object.Key("aws_user_pools_id")
		ok.String(*v.AwsUserPoolsId)
	}

	if v.AwsUserPoolsWebClientId != nil {
		ok := object.Key("aws_user_pools_web_client_id")
		ok.String(*v.AwsUserPoolsWebClientId)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceConfig(v *types.ResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentSettings(v *types.Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MfaTypes != nil {
		ok := object.Key("mfaTypes")
		if err := awsRestjson1_serializeDocumentListOfMfaTypesElement(v.MfaTypes, ok); err != nil {
			return err
		}
	}

	if v.SmsMessage != nil {
		ok := object.Key("smsMessage")
		ok.String(*v.SmsMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentSmsSettings(v *types.SmsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SmsMessage != nil {
		ok := object.Key("smsMessage")
		ok.String(*v.SmsMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentSocialProviderSettings(v *types.SocialProviderSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Facebook != nil {
		ok := object.Key("Facebook")
		if err := awsRestjson1_serializeDocumentBackendAuthSocialProviderConfig(v.Facebook, ok); err != nil {
			return err
		}
	}

	if v.Google != nil {
		ok := object.Key("Google")
		if err := awsRestjson1_serializeDocumentBackendAuthSocialProviderConfig(v.Google, ok); err != nil {
			return err
		}
	}

	if v.LoginWithAmazon != nil {
		ok := object.Key("LoginWithAmazon")
		if err := awsRestjson1_serializeDocumentBackendAuthSocialProviderConfig(v.LoginWithAmazon, ok); err != nil {
			return err
		}
	}

	if v.SignInWithApple != nil {
		ok := object.Key("SignInWithApple")
		if err := awsRestjson1_serializeDocumentBackendAuthAppleProviderConfig(v.SignInWithApple, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthForgotPasswordConfig(v *types.UpdateBackendAuthForgotPasswordConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeliveryMethod) > 0 {
		ok := object.Key("deliveryMethod")
		ok.String(string(v.DeliveryMethod))
	}

	if v.EmailSettings != nil {
		ok := object.Key("emailSettings")
		if err := awsRestjson1_serializeDocumentEmailSettings(v.EmailSettings, ok); err != nil {
			return err
		}
	}

	if v.SmsSettings != nil {
		ok := object.Key("smsSettings")
		if err := awsRestjson1_serializeDocumentSmsSettings(v.SmsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthIdentityPoolConfig(v *types.UpdateBackendAuthIdentityPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UnauthenticatedLogin != nil {
		ok := object.Key("unauthenticatedLogin")
		ok.Boolean(*v.UnauthenticatedLogin)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthMFAConfig(v *types.UpdateBackendAuthMFAConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MFAMode) > 0 {
		ok := object.Key("MFAMode")
		ok.String(string(v.MFAMode))
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthOAuthConfig(v *types.UpdateBackendAuthOAuthConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DomainPrefix != nil {
		ok := object.Key("domainPrefix")
		ok.String(*v.DomainPrefix)
	}

	if len(v.OAuthGrantType) > 0 {
		ok := object.Key("oAuthGrantType")
		ok.String(string(v.OAuthGrantType))
	}

	if v.OAuthScopes != nil {
		ok := object.Key("oAuthScopes")
		if err := awsRestjson1_serializeDocumentListOfOAuthScopesElement(v.OAuthScopes, ok); err != nil {
			return err
		}
	}

	if v.RedirectSignInURIs != nil {
		ok := object.Key("redirectSignInURIs")
		if err := awsRestjson1_serializeDocumentListOf__string(v.RedirectSignInURIs, ok); err != nil {
			return err
		}
	}

	if v.RedirectSignOutURIs != nil {
		ok := object.Key("redirectSignOutURIs")
		if err := awsRestjson1_serializeDocumentListOf__string(v.RedirectSignOutURIs, ok); err != nil {
			return err
		}
	}

	if v.SocialProviderSettings != nil {
		ok := object.Key("socialProviderSettings")
		if err := awsRestjson1_serializeDocumentSocialProviderSettings(v.SocialProviderSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthPasswordPolicyConfig(v *types.UpdateBackendAuthPasswordPolicyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalConstraints != nil {
		ok := object.Key("additionalConstraints")
		if err := awsRestjson1_serializeDocumentListOfAdditionalConstraintsElement(v.AdditionalConstraints, ok); err != nil {
			return err
		}
	}

	if v.MinimumLength != nil {
		ok := object.Key("minimumLength")
		switch {
		case math.IsNaN(*v.MinimumLength):
			ok.String("NaN")

		case math.IsInf(*v.MinimumLength, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinimumLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinimumLength)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthResourceConfig(v *types.UpdateBackendAuthResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthResources) > 0 {
		ok := object.Key("authResources")
		ok.String(string(v.AuthResources))
	}

	if v.IdentityPoolConfigs != nil {
		ok := object.Key("identityPoolConfigs")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthIdentityPoolConfig(v.IdentityPoolConfigs, ok); err != nil {
			return err
		}
	}

	if len(v.Service) > 0 {
		ok := object.Key("service")
		ok.String(string(v.Service))
	}

	if v.UserPoolConfigs != nil {
		ok := object.Key("userPoolConfigs")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthUserPoolConfig(v.UserPoolConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthUserPoolConfig(v *types.UpdateBackendAuthUserPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ForgotPassword != nil {
		ok := object.Key("forgotPassword")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthForgotPasswordConfig(v.ForgotPassword, ok); err != nil {
			return err
		}
	}

	if v.Mfa != nil {
		ok := object.Key("mfa")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthMFAConfig(v.Mfa, ok); err != nil {
			return err
		}
	}

	if v.OAuth != nil {
		ok := object.Key("oAuth")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthOAuthConfig(v.OAuth, ok); err != nil {
			return err
		}
	}

	if v.PasswordPolicy != nil {
		ok := object.Key("passwordPolicy")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthPasswordPolicyConfig(v.PasswordPolicy, ok); err != nil {
			return err
		}
	}

	if v.VerificationMessage != nil {
		ok := object.Key("verificationMessage")
		if err := awsRestjson1_serializeDocumentUpdateBackendAuthVerificationMessageConfig(v.VerificationMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendAuthVerificationMessageConfig(v *types.UpdateBackendAuthVerificationMessageConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeliveryMethod) > 0 {
		ok := object.Key("deliveryMethod")
		ok.String(string(v.DeliveryMethod))
	}

	if v.EmailSettings != nil {
		ok := object.Key("emailSettings")
		if err := awsRestjson1_serializeDocumentEmailSettings(v.EmailSettings, ok); err != nil {
			return err
		}
	}

	if v.SmsSettings != nil {
		ok := object.Key("smsSettings")
		if err := awsRestjson1_serializeDocumentSmsSettings(v.SmsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateBackendStorageResourceConfig(v *types.UpdateBackendStorageResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Permissions != nil {
		ok := object.Key("permissions")
		if err := awsRestjson1_serializeDocumentBackendStoragePermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	if len(v.ServiceName) > 0 {
		ok := object.Key("serviceName")
		ok.String(string(v.ServiceName))
	}

	return nil
}
