// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpApplyGuardrail struct {
}

func (*validateOpApplyGuardrail) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpApplyGuardrail) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ApplyGuardrailInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpApplyGuardrailInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpConverse struct {
}

func (*validateOpConverse) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpConverse) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ConverseInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpConverseInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpConverseStream struct {
}

func (*validateOpConverseStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpConverseStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ConverseStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpConverseStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeModel struct {
}

func (*validateOpInvokeModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInvokeModelWithResponseStream struct {
}

func (*validateOpInvokeModelWithResponseStream) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeModelWithResponseStream) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeModelWithResponseStreamInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeModelWithResponseStreamInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpApplyGuardrailValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpApplyGuardrail{}, middleware.After)
}

func addOpConverseValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpConverse{}, middleware.After)
}

func addOpConverseStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpConverseStream{}, middleware.After)
}

func addOpInvokeModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeModel{}, middleware.After)
}

func addOpInvokeModelWithResponseStreamValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeModelWithResponseStream{}, middleware.After)
}

func validateContentBlock(v types.ContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ContentBlock"}
	switch uv := v.(type) {
	case *types.ContentBlockMemberDocument:
		if err := validateDocumentBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[document]", err.(smithy.InvalidParamsError))
		}

	case *types.ContentBlockMemberGuardContent:
		if err := validateGuardrailConverseContentBlock(uv.Value); err != nil {
			invalidParams.AddNested("[guardContent]", err.(smithy.InvalidParamsError))
		}

	case *types.ContentBlockMemberImage:
		if err := validateImageBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[image]", err.(smithy.InvalidParamsError))
		}

	case *types.ContentBlockMemberToolResult:
		if err := validateToolResultBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[toolResult]", err.(smithy.InvalidParamsError))
		}

	case *types.ContentBlockMemberToolUse:
		if err := validateToolUseBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[toolUse]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateContentBlocks(v []types.ContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ContentBlocks"}
	for i := range v {
		if err := validateContentBlock(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDocumentBlock(v *types.DocumentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DocumentBlock"}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Source == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Source"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailConfiguration(v *types.GuardrailConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailConfiguration"}
	if v.GuardrailIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailIdentifier"))
	}
	if v.GuardrailVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailContentBlock(v types.GuardrailContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailContentBlock"}
	switch uv := v.(type) {
	case *types.GuardrailContentBlockMemberText:
		if err := validateGuardrailTextBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[text]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailContentBlockList(v []types.GuardrailContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailContentBlockList"}
	for i := range v {
		if err := validateGuardrailContentBlock(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailConverseContentBlock(v types.GuardrailConverseContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailConverseContentBlock"}
	switch uv := v.(type) {
	case *types.GuardrailConverseContentBlockMemberText:
		if err := validateGuardrailConverseTextBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[text]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailConverseTextBlock(v *types.GuardrailConverseTextBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailConverseTextBlock"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailStreamConfiguration(v *types.GuardrailStreamConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailStreamConfiguration"}
	if v.GuardrailIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailIdentifier"))
	}
	if v.GuardrailVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGuardrailTextBlock(v *types.GuardrailTextBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GuardrailTextBlock"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImageBlock(v *types.ImageBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImageBlock"}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if v.Source == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Source"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMessage(v *types.Message) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Message"}
	if len(v.Role) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Role"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	} else if v.Content != nil {
		if err := validateContentBlocks(v.Content); err != nil {
			invalidParams.AddNested("Content", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMessages(v []types.Message) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Messages"}
	for i := range v {
		if err := validateMessage(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSpecificToolChoice(v *types.SpecificToolChoice) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SpecificToolChoice"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSystemContentBlock(v types.SystemContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SystemContentBlock"}
	switch uv := v.(type) {
	case *types.SystemContentBlockMemberGuardContent:
		if err := validateGuardrailConverseContentBlock(uv.Value); err != nil {
			invalidParams.AddNested("[guardContent]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSystemContentBlocks(v []types.SystemContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SystemContentBlocks"}
	for i := range v {
		if err := validateSystemContentBlock(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTool(v types.Tool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tool"}
	switch uv := v.(type) {
	case *types.ToolMemberToolSpec:
		if err := validateToolSpecification(&uv.Value); err != nil {
			invalidParams.AddNested("[toolSpec]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolChoice(v types.ToolChoice) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolChoice"}
	switch uv := v.(type) {
	case *types.ToolChoiceMemberTool:
		if err := validateSpecificToolChoice(&uv.Value); err != nil {
			invalidParams.AddNested("[tool]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolConfiguration(v *types.ToolConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolConfiguration"}
	if v.Tools == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tools"))
	} else if v.Tools != nil {
		if err := validateTools(v.Tools); err != nil {
			invalidParams.AddNested("Tools", err.(smithy.InvalidParamsError))
		}
	}
	if v.ToolChoice != nil {
		if err := validateToolChoice(v.ToolChoice); err != nil {
			invalidParams.AddNested("ToolChoice", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolResultBlock(v *types.ToolResultBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolResultBlock"}
	if v.ToolUseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ToolUseId"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	} else if v.Content != nil {
		if err := validateToolResultContentBlocks(v.Content); err != nil {
			invalidParams.AddNested("Content", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolResultContentBlock(v types.ToolResultContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolResultContentBlock"}
	switch uv := v.(type) {
	case *types.ToolResultContentBlockMemberDocument:
		if err := validateDocumentBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[document]", err.(smithy.InvalidParamsError))
		}

	case *types.ToolResultContentBlockMemberImage:
		if err := validateImageBlock(&uv.Value); err != nil {
			invalidParams.AddNested("[image]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolResultContentBlocks(v []types.ToolResultContentBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolResultContentBlocks"}
	for i := range v {
		if err := validateToolResultContentBlock(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTools(v []types.Tool) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tools"}
	for i := range v {
		if err := validateTool(v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolSpecification(v *types.ToolSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolSpecification"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.InputSchema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputSchema"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateToolUseBlock(v *types.ToolUseBlock) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ToolUseBlock"}
	if v.ToolUseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ToolUseId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpApplyGuardrailInput(v *ApplyGuardrailInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApplyGuardrailInput"}
	if v.GuardrailIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailIdentifier"))
	}
	if v.GuardrailVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GuardrailVersion"))
	}
	if len(v.Source) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Source"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	} else if v.Content != nil {
		if err := validateGuardrailContentBlockList(v.Content); err != nil {
			invalidParams.AddNested("Content", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpConverseInput(v *ConverseInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConverseInput"}
	if v.ModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelId"))
	}
	if v.Messages == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Messages"))
	} else if v.Messages != nil {
		if err := validateMessages(v.Messages); err != nil {
			invalidParams.AddNested("Messages", err.(smithy.InvalidParamsError))
		}
	}
	if v.System != nil {
		if err := validateSystemContentBlocks(v.System); err != nil {
			invalidParams.AddNested("System", err.(smithy.InvalidParamsError))
		}
	}
	if v.ToolConfig != nil {
		if err := validateToolConfiguration(v.ToolConfig); err != nil {
			invalidParams.AddNested("ToolConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.GuardrailConfig != nil {
		if err := validateGuardrailConfiguration(v.GuardrailConfig); err != nil {
			invalidParams.AddNested("GuardrailConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpConverseStreamInput(v *ConverseStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConverseStreamInput"}
	if v.ModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelId"))
	}
	if v.Messages == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Messages"))
	} else if v.Messages != nil {
		if err := validateMessages(v.Messages); err != nil {
			invalidParams.AddNested("Messages", err.(smithy.InvalidParamsError))
		}
	}
	if v.System != nil {
		if err := validateSystemContentBlocks(v.System); err != nil {
			invalidParams.AddNested("System", err.(smithy.InvalidParamsError))
		}
	}
	if v.ToolConfig != nil {
		if err := validateToolConfiguration(v.ToolConfig); err != nil {
			invalidParams.AddNested("ToolConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.GuardrailConfig != nil {
		if err := validateGuardrailStreamConfiguration(v.GuardrailConfig); err != nil {
			invalidParams.AddNested("GuardrailConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeModelInput(v *InvokeModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeModelInput"}
	if v.Body == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Body"))
	}
	if v.ModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeModelWithResponseStreamInput(v *InvokeModelWithResponseStreamInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeModelWithResponseStreamInput"}
	if v.Body == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Body"))
	}
	if v.ModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
