package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/servicebus/mgmt/2017-04-01/servicebus"

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// SendEnumValue ...
	SendEnumValue AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, SendEnumValue}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// Allow ...
	Allow DefaultAction = "Allow"
	// Deny ...
	Deny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{Allow, Deny}
}

// EncodingCaptureDescription enumerates the values for encoding capture description.
type EncodingCaptureDescription string

const (
	// Avro ...
	Avro EncodingCaptureDescription = "Avro"
	// AvroDeflate ...
	AvroDeflate EncodingCaptureDescription = "AvroDeflate"
)

// PossibleEncodingCaptureDescriptionValues returns an array of possible values for the EncodingCaptureDescription const type.
func PossibleEncodingCaptureDescriptionValues() []EncodingCaptureDescription {
	return []EncodingCaptureDescription{Avro, AvroDeflate}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Active ...
	Active EntityStatus = "Active"
	// Creating ...
	Creating EntityStatus = "Creating"
	// Deleting ...
	Deleting EntityStatus = "Deleting"
	// Disabled ...
	Disabled EntityStatus = "Disabled"
	// ReceiveDisabled ...
	ReceiveDisabled EntityStatus = "ReceiveDisabled"
	// Renaming ...
	Renaming EntityStatus = "Renaming"
	// Restoring ...
	Restoring EntityStatus = "Restoring"
	// SendDisabled ...
	SendDisabled EntityStatus = "SendDisabled"
	// Unknown ...
	Unknown EntityStatus = "Unknown"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{Active, Creating, Deleting, Disabled, ReceiveDisabled, Renaming, Restoring, SendDisabled, Unknown}
}

// FilterType enumerates the values for filter type.
type FilterType string

const (
	// FilterTypeCorrelationFilter ...
	FilterTypeCorrelationFilter FilterType = "CorrelationFilter"
	// FilterTypeSQLFilter ...
	FilterTypeSQLFilter FilterType = "SqlFilter"
)

// PossibleFilterTypeValues returns an array of possible values for the FilterType const type.
func PossibleFilterTypeValues() []FilterType {
	return []FilterType{FilterTypeCorrelationFilter, FilterTypeSQLFilter}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// PrimaryKey ...
	PrimaryKey KeyType = "PrimaryKey"
	// SecondaryKey ...
	SecondaryKey KeyType = "SecondaryKey"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{PrimaryKey, SecondaryKey}
}

// NameSpaceType enumerates the values for name space type.
type NameSpaceType string

const (
	// EventHub ...
	EventHub NameSpaceType = "EventHub"
	// Messaging ...
	Messaging NameSpaceType = "Messaging"
	// Mixed ...
	Mixed NameSpaceType = "Mixed"
	// NotificationHub ...
	NotificationHub NameSpaceType = "NotificationHub"
	// Relay ...
	Relay NameSpaceType = "Relay"
)

// PossibleNameSpaceTypeValues returns an array of possible values for the NameSpaceType const type.
func PossibleNameSpaceTypeValues() []NameSpaceType {
	return []NameSpaceType{EventHub, Messaging, Mixed, NotificationHub, Relay}
}

// NetworkRuleIPAction enumerates the values for network rule ip action.
type NetworkRuleIPAction string

const (
	// NetworkRuleIPActionAllow ...
	NetworkRuleIPActionAllow NetworkRuleIPAction = "Allow"
)

// PossibleNetworkRuleIPActionValues returns an array of possible values for the NetworkRuleIPAction const type.
func PossibleNetworkRuleIPActionValues() []NetworkRuleIPAction {
	return []NetworkRuleIPAction{NetworkRuleIPActionAllow}
}

// ProvisioningStateDR enumerates the values for provisioning state dr.
type ProvisioningStateDR string

const (
	// Accepted ...
	Accepted ProvisioningStateDR = "Accepted"
	// Failed ...
	Failed ProvisioningStateDR = "Failed"
	// Succeeded ...
	Succeeded ProvisioningStateDR = "Succeeded"
)

// PossibleProvisioningStateDRValues returns an array of possible values for the ProvisioningStateDR const type.
func PossibleProvisioningStateDRValues() []ProvisioningStateDR {
	return []ProvisioningStateDR{Accepted, Failed, Succeeded}
}

// RoleDisasterRecovery enumerates the values for role disaster recovery.
type RoleDisasterRecovery string

const (
	// Primary ...
	Primary RoleDisasterRecovery = "Primary"
	// PrimaryNotReplicating ...
	PrimaryNotReplicating RoleDisasterRecovery = "PrimaryNotReplicating"
	// Secondary ...
	Secondary RoleDisasterRecovery = "Secondary"
)

// PossibleRoleDisasterRecoveryValues returns an array of possible values for the RoleDisasterRecovery const type.
func PossibleRoleDisasterRecoveryValues() []RoleDisasterRecovery {
	return []RoleDisasterRecovery{Primary, PrimaryNotReplicating, Secondary}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Premium, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierPremium, SkuTierStandard}
}

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName ...
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown ...
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse ...
	NameInUse UnavailableReason = "NameInUse"
	// None ...
	None UnavailableReason = "None"
	// SubscriptionIsDisabled ...
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription ...
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// PossibleUnavailableReasonValues returns an array of possible values for the UnavailableReason const type.
func PossibleUnavailableReasonValues() []UnavailableReason {
	return []UnavailableReason{InvalidName, NameInLockdown, NameInUse, None, SubscriptionIsDisabled, TooManyNamespaceInCurrentSubscription}
}

// AccessKeys namespace/ServiceBus Connection String
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - READ-ONLY; Primary connection string of the created namespace authorization rule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - READ-ONLY; Secondary connection string of the created namespace authorization rule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// AliasPrimaryConnectionString - READ-ONLY; Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string `json:"aliasPrimaryConnectionString,omitempty"`
	// AliasSecondaryConnectionString - READ-ONLY; Secondary  connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string `json:"aliasSecondaryConnectionString,omitempty"`
	// PrimaryKey - READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - READ-ONLY; A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty"`
}

// Action represents the filter actions which are allowed for the transformation of a message that have
// been matched by a filter expression.
type Action struct {
	// SQLExpression - SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
	// CompatibilityLevel - This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`
	// RequiresPreprocessing - Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`
}

// ArmDisasterRecovery single item in List or Get Alias(Disaster Recovery configuration) operation
type ArmDisasterRecovery struct {
	autorest.Response `json:"-"`
	// ArmDisasterRecoveryProperties - Properties required to the Create Or Update Alias(Disaster Recovery configurations)
	*ArmDisasterRecoveryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ArmDisasterRecovery.
func (adr ArmDisasterRecovery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adr.ArmDisasterRecoveryProperties != nil {
		objectMap["properties"] = adr.ArmDisasterRecoveryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArmDisasterRecovery struct.
func (adr *ArmDisasterRecovery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var armDisasterRecoveryProperties ArmDisasterRecoveryProperties
				err = json.Unmarshal(*v, &armDisasterRecoveryProperties)
				if err != nil {
					return err
				}
				adr.ArmDisasterRecoveryProperties = &armDisasterRecoveryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adr.Type = &typeVar
			}
		}
	}

	return nil
}

// ArmDisasterRecoveryListResult the result of the List Alias(Disaster Recovery configuration) operation.
type ArmDisasterRecoveryListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Alias(Disaster Recovery configurations)
	Value *[]ArmDisasterRecovery `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of Alias(Disaster Recovery configuration)
	NextLink *string `json:"nextLink,omitempty"`
}

// ArmDisasterRecoveryListResultIterator provides access to a complete listing of ArmDisasterRecovery
// values.
type ArmDisasterRecoveryListResultIterator struct {
	i    int
	page ArmDisasterRecoveryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArmDisasterRecoveryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmDisasterRecoveryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArmDisasterRecoveryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArmDisasterRecoveryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArmDisasterRecoveryListResultIterator) Response() ArmDisasterRecoveryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArmDisasterRecoveryListResultIterator) Value() ArmDisasterRecovery {
	if !iter.page.NotDone() {
		return ArmDisasterRecovery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArmDisasterRecoveryListResultIterator type.
func NewArmDisasterRecoveryListResultIterator(page ArmDisasterRecoveryListResultPage) ArmDisasterRecoveryListResultIterator {
	return ArmDisasterRecoveryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adrlr ArmDisasterRecoveryListResult) IsEmpty() bool {
	return adrlr.Value == nil || len(*adrlr.Value) == 0
}

// armDisasterRecoveryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adrlr ArmDisasterRecoveryListResult) armDisasterRecoveryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if adrlr.NextLink == nil || len(to.String(adrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adrlr.NextLink)))
}

// ArmDisasterRecoveryListResultPage contains a page of ArmDisasterRecovery values.
type ArmDisasterRecoveryListResultPage struct {
	fn    func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)
	adrlr ArmDisasterRecoveryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArmDisasterRecoveryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArmDisasterRecoveryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.adrlr)
	if err != nil {
		return err
	}
	page.adrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArmDisasterRecoveryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArmDisasterRecoveryListResultPage) NotDone() bool {
	return !page.adrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArmDisasterRecoveryListResultPage) Response() ArmDisasterRecoveryListResult {
	return page.adrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArmDisasterRecoveryListResultPage) Values() []ArmDisasterRecovery {
	if page.adrlr.IsEmpty() {
		return nil
	}
	return *page.adrlr.Value
}

// Creates a new instance of the ArmDisasterRecoveryListResultPage type.
func NewArmDisasterRecoveryListResultPage(getNextPage func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)) ArmDisasterRecoveryListResultPage {
	return ArmDisasterRecoveryListResultPage{fn: getNextPage}
}

// ArmDisasterRecoveryProperties properties required to the Create Or Update Alias(Disaster Recovery
// configurations)
type ArmDisasterRecoveryProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the Alias(Disaster Recovery configuration) - possible values 'Accepted' or 'Succeeded' or 'Failed'. Possible values include: 'Accepted', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningStateDR `json:"provisioningState,omitempty"`
	// PendingReplicationOperationsCount - READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty"`
	// PartnerNamespace - ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	PartnerNamespace *string `json:"partnerNamespace,omitempty"`
	// AlternateName - Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
	AlternateName *string `json:"alternateName,omitempty"`
	// Role - READ-ONLY; role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating' or 'Secondary'. Possible values include: 'Primary', 'PrimaryNotReplicating', 'Secondary'
	Role RoleDisasterRecovery `json:"role,omitempty"`
}

// AuthorizationRuleProperties authorizationRule properties.
type AuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// CaptureDescription properties to configure capture description for eventhub
type CaptureDescription struct {
	// Enabled - A value that indicates whether capture description is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Encoding - Enumerates the possible values for the encoding format of capture description. Possible values include: 'Avro', 'AvroDeflate'
	Encoding EncodingCaptureDescription `json:"encoding,omitempty"`
	// IntervalInSeconds - The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// SizeLimitInBytes - The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 and 524288000 bytes
	SizeLimitInBytes *int32 `json:"sizeLimitInBytes,omitempty"`
	// Destination - Properties of Destination where capture will be stored. (Storage Account, Blob Names)
	Destination *Destination `json:"destination,omitempty"`
}

// CheckNameAvailability description of a Check Name availability request properties.
type CheckNameAvailability struct {
	// Name - The Name to check the namespace name availability and The namespace name can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it must end with a letter or number.
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Message - READ-ONLY; The detailed info regarding the reason associated with the namespace.
	Message *string `json:"message,omitempty"`
	// NameAvailable - Value indicating namespace is availability, true if the namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability of a namespace. Possible values include: 'None', 'InvalidName', 'SubscriptionIsDisabled', 'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
	Reason UnavailableReason `json:"reason,omitempty"`
}

// CorrelationFilter represents the correlation filter expression.
type CorrelationFilter struct {
	// Properties - dictionary object for custom filters
	Properties map[string]*string `json:"properties"`
	// CorrelationID - Identifier of the correlation.
	CorrelationID *string `json:"correlationId,omitempty"`
	// MessageID - Identifier of the message.
	MessageID *string `json:"messageId,omitempty"`
	// To - Address to send to.
	To *string `json:"to,omitempty"`
	// ReplyTo - Address of the queue to reply to.
	ReplyTo *string `json:"replyTo,omitempty"`
	// Label - Application specific label.
	Label *string `json:"label,omitempty"`
	// SessionID - Session identifier.
	SessionID *string `json:"sessionId,omitempty"`
	// ReplyToSessionID - Session identifier to reply to.
	ReplyToSessionID *string `json:"replyToSessionId,omitempty"`
	// ContentType - Content type of the message.
	ContentType *string `json:"contentType,omitempty"`
	// RequiresPreprocessing - Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`
}

// MarshalJSON is the custom marshaler for CorrelationFilter.
func (cf CorrelationFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cf.Properties != nil {
		objectMap["properties"] = cf.Properties
	}
	if cf.CorrelationID != nil {
		objectMap["correlationId"] = cf.CorrelationID
	}
	if cf.MessageID != nil {
		objectMap["messageId"] = cf.MessageID
	}
	if cf.To != nil {
		objectMap["to"] = cf.To
	}
	if cf.ReplyTo != nil {
		objectMap["replyTo"] = cf.ReplyTo
	}
	if cf.Label != nil {
		objectMap["label"] = cf.Label
	}
	if cf.SessionID != nil {
		objectMap["sessionId"] = cf.SessionID
	}
	if cf.ReplyToSessionID != nil {
		objectMap["replyToSessionId"] = cf.ReplyToSessionID
	}
	if cf.ContentType != nil {
		objectMap["contentType"] = cf.ContentType
	}
	if cf.RequiresPreprocessing != nil {
		objectMap["requiresPreprocessing"] = cf.RequiresPreprocessing
	}
	return json.Marshal(objectMap)
}

// Destination capture storage details for capture description
type Destination struct {
	// Name - Name for capture destination
	Name *string `json:"name,omitempty"`
	// DestinationProperties - Properties describing the storage account, blob container and archive name format for capture destination
	*DestinationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Destination.
func (d Destination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.DestinationProperties != nil {
		objectMap["properties"] = d.DestinationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Destination struct.
func (d *Destination) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "properties":
			if v != nil {
				var destinationProperties DestinationProperties
				err = json.Unmarshal(*v, &destinationProperties)
				if err != nil {
					return err
				}
				d.DestinationProperties = &destinationProperties
			}
		}
	}

	return nil
}

// DestinationProperties properties describing the storage account, blob container and archive name format
// for capture destination
type DestinationProperties struct {
	// StorageAccountResourceID - Resource id of the storage account to be used to create the blobs
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// BlobContainer - Blob container Name
	BlobContainer *string `json:"blobContainer,omitempty"`
	// ArchiveNameFormat - Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order
	ArchiveNameFormat *string `json:"archiveNameFormat,omitempty"`
}

// ErrorResponse error response indicates ServiceBus service is not able to process the incoming request.
// The reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Eventhub single item in List or Get Event Hub operation
type Eventhub struct {
	// EventhubProperties - Properties supplied to the Create Or Update Event Hub operation.
	*EventhubProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Eventhub.
func (e Eventhub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EventhubProperties != nil {
		objectMap["properties"] = e.EventhubProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Eventhub struct.
func (e *Eventhub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventhubProperties EventhubProperties
				err = json.Unmarshal(*v, &eventhubProperties)
				if err != nil {
					return err
				}
				e.EventhubProperties = &eventhubProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// EventHubListResult the result of the List EventHubs operation.
type EventHubListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List EventHubs operation.
	Value *[]Eventhub `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of EventHubs.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventHubListResultIterator provides access to a complete listing of Eventhub values.
type EventHubListResultIterator struct {
	i    int
	page EventHubListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventHubListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventHubListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventHubListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventHubListResultIterator) Response() EventHubListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventHubListResultIterator) Value() Eventhub {
	if !iter.page.NotDone() {
		return Eventhub{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventHubListResultIterator type.
func NewEventHubListResultIterator(page EventHubListResultPage) EventHubListResultIterator {
	return EventHubListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ehlr EventHubListResult) IsEmpty() bool {
	return ehlr.Value == nil || len(*ehlr.Value) == 0
}

// eventHubListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ehlr EventHubListResult) eventHubListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ehlr.NextLink == nil || len(to.String(ehlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ehlr.NextLink)))
}

// EventHubListResultPage contains a page of Eventhub values.
type EventHubListResultPage struct {
	fn   func(context.Context, EventHubListResult) (EventHubListResult, error)
	ehlr EventHubListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventHubListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ehlr)
	if err != nil {
		return err
	}
	page.ehlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventHubListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventHubListResultPage) NotDone() bool {
	return !page.ehlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventHubListResultPage) Response() EventHubListResult {
	return page.ehlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventHubListResultPage) Values() []Eventhub {
	if page.ehlr.IsEmpty() {
		return nil
	}
	return *page.ehlr.Value
}

// Creates a new instance of the EventHubListResultPage type.
func NewEventHubListResultPage(getNextPage func(context.Context, EventHubListResult) (EventHubListResult, error)) EventHubListResultPage {
	return EventHubListResultPage{fn: getNextPage}
}

// EventhubProperties properties supplied to the Create Or Update Event Hub operation.
type EventhubProperties struct {
	// PartitionIds - READ-ONLY; Current number of shards on the Event Hub.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// CreatedAt - READ-ONLY; Exact time the Event Hub was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// MessageRetentionInDays - Number of days to retain the events for this Event Hub, value should be 1 to 7 days
	MessageRetentionInDays *int64 `json:"messageRetentionInDays,omitempty"`
	// PartitionCount - Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
	PartitionCount *int64 `json:"partitionCount,omitempty"`
	// Status - Enumerates the possible values for the status of the Event Hub. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// CaptureDescription - Properties of capture description
	CaptureDescription *CaptureDescription `json:"captureDescription,omitempty"`
}

// MessageCountDetails message Count Details.
type MessageCountDetails struct {
	// ActiveMessageCount - READ-ONLY; Number of active messages in the queue, topic, or subscription.
	ActiveMessageCount *int64 `json:"activeMessageCount,omitempty"`
	// DeadLetterMessageCount - READ-ONLY; Number of messages that are dead lettered.
	DeadLetterMessageCount *int64 `json:"deadLetterMessageCount,omitempty"`
	// ScheduledMessageCount - READ-ONLY; Number of scheduled messages.
	ScheduledMessageCount *int64 `json:"scheduledMessageCount,omitempty"`
	// TransferMessageCount - READ-ONLY; Number of messages transferred to another queue, topic, or subscription.
	TransferMessageCount *int64 `json:"transferMessageCount,omitempty"`
	// TransferDeadLetterMessageCount - READ-ONLY; Number of messages transferred into dead letters.
	TransferDeadLetterMessageCount *int64 `json:"transferDeadLetterMessageCount,omitempty"`
}

// MigrationConfigListResult the result of the List migrationConfigurations operation.
type MigrationConfigListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Migration Configs
	Value *[]MigrationConfigProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of migrationConfigurations
	NextLink *string `json:"nextLink,omitempty"`
}

// MigrationConfigListResultIterator provides access to a complete listing of MigrationConfigProperties
// values.
type MigrationConfigListResultIterator struct {
	i    int
	page MigrationConfigListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MigrationConfigListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationConfigListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MigrationConfigListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MigrationConfigListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MigrationConfigListResultIterator) Response() MigrationConfigListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MigrationConfigListResultIterator) Value() MigrationConfigProperties {
	if !iter.page.NotDone() {
		return MigrationConfigProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MigrationConfigListResultIterator type.
func NewMigrationConfigListResultIterator(page MigrationConfigListResultPage) MigrationConfigListResultIterator {
	return MigrationConfigListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr MigrationConfigListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// migrationConfigListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr MigrationConfigListResult) migrationConfigListResultPreparer(ctx context.Context) (*http.Request, error) {
	if mclr.NextLink == nil || len(to.String(mclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// MigrationConfigListResultPage contains a page of MigrationConfigProperties values.
type MigrationConfigListResultPage struct {
	fn   func(context.Context, MigrationConfigListResult) (MigrationConfigListResult, error)
	mclr MigrationConfigListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MigrationConfigListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationConfigListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mclr)
	if err != nil {
		return err
	}
	page.mclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MigrationConfigListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MigrationConfigListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MigrationConfigListResultPage) Response() MigrationConfigListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MigrationConfigListResultPage) Values() []MigrationConfigProperties {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the MigrationConfigListResultPage type.
func NewMigrationConfigListResultPage(getNextPage func(context.Context, MigrationConfigListResult) (MigrationConfigListResult, error)) MigrationConfigListResultPage {
	return MigrationConfigListResultPage{fn: getNextPage}
}

// MigrationConfigProperties single item in List or Get Migration Config operation
type MigrationConfigProperties struct {
	autorest.Response `json:"-"`
	// MigrationConfigPropertiesProperties - Properties required to the Create Migration Configuration
	*MigrationConfigPropertiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationConfigProperties.
func (mcp MigrationConfigProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcp.MigrationConfigPropertiesProperties != nil {
		objectMap["properties"] = mcp.MigrationConfigPropertiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrationConfigProperties struct.
func (mcp *MigrationConfigProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var migrationConfigPropertiesProperties MigrationConfigPropertiesProperties
				err = json.Unmarshal(*v, &migrationConfigPropertiesProperties)
				if err != nil {
					return err
				}
				mcp.MigrationConfigPropertiesProperties = &migrationConfigPropertiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcp.Type = &typeVar
			}
		}
	}

	return nil
}

// MigrationConfigPropertiesProperties properties required to the Create Migration Configuration
type MigrationConfigPropertiesProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of Migration Configuration
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PendingReplicationOperationsCount - READ-ONLY; Number of entities pending to be replicated.
	PendingReplicationOperationsCount *int64 `json:"pendingReplicationOperationsCount,omitempty"`
	// TargetNamespace - Existing premium Namespace ARM Id name which has no entities, will be used for migration
	TargetNamespace *string `json:"targetNamespace,omitempty"`
	// PostMigrationName - Name to access Standard Namespace after migration
	PostMigrationName *string `json:"postMigrationName,omitempty"`
	// MigrationState - READ-ONLY; State in which Standard to Premium Migration is, possible values : Unknown, Reverting, Completing, Initiating, Syncing, Active
	MigrationState *string `json:"migrationState,omitempty"`
}

// MigrationConfigsCreateAndStartMigrationFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type MigrationConfigsCreateAndStartMigrationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MigrationConfigsCreateAndStartMigrationFuture) Result(client MigrationConfigsClient) (mcp MigrationConfigProperties, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.MigrationConfigsCreateAndStartMigrationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.MigrationConfigsCreateAndStartMigrationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mcp.Response.Response, err = future.GetResult(sender); err == nil && mcp.Response.Response.StatusCode != http.StatusNoContent {
		mcp, err = client.CreateAndStartMigrationResponder(mcp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicebus.MigrationConfigsCreateAndStartMigrationFuture", "Result", mcp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NamespacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesCreateOrUpdateFuture) Result(client NamespacesClient) (sn SBNamespace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sn.Response.Response, err = future.GetResult(sender); err == nil && sn.Response.Response.StatusCode != http.StatusNoContent {
		sn, err = client.CreateOrUpdateResponder(sn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicebus.NamespacesCreateOrUpdateFuture", "Result", sn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicebus.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NetworkRuleSet description of NetworkRuleSet resource.
type NetworkRuleSet struct {
	autorest.Response `json:"-"`
	// NetworkRuleSetProperties - NetworkRuleSet properties
	*NetworkRuleSetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkRuleSet.
func (nrs NetworkRuleSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nrs.NetworkRuleSetProperties != nil {
		objectMap["properties"] = nrs.NetworkRuleSetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkRuleSet struct.
func (nrs *NetworkRuleSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkRuleSetProperties NetworkRuleSetProperties
				err = json.Unmarshal(*v, &networkRuleSetProperties)
				if err != nil {
					return err
				}
				nrs.NetworkRuleSetProperties = &networkRuleSetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nrs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nrs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nrs.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkRuleSetListResult the response of the List NetworkRuleSet operation.
type NetworkRuleSetListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List NetworkRuleSet operation.
	Value *[]NetworkRuleSet `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of NetworkRuleSet.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkRuleSetListResultIterator provides access to a complete listing of NetworkRuleSet values.
type NetworkRuleSetListResultIterator struct {
	i    int
	page NetworkRuleSetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkRuleSetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkRuleSetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NetworkRuleSetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkRuleSetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkRuleSetListResultIterator) Response() NetworkRuleSetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkRuleSetListResultIterator) Value() NetworkRuleSet {
	if !iter.page.NotDone() {
		return NetworkRuleSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NetworkRuleSetListResultIterator type.
func NewNetworkRuleSetListResultIterator(page NetworkRuleSetListResultPage) NetworkRuleSetListResultIterator {
	return NetworkRuleSetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nrslr NetworkRuleSetListResult) IsEmpty() bool {
	return nrslr.Value == nil || len(*nrslr.Value) == 0
}

// networkRuleSetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nrslr NetworkRuleSetListResult) networkRuleSetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if nrslr.NextLink == nil || len(to.String(nrslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nrslr.NextLink)))
}

// NetworkRuleSetListResultPage contains a page of NetworkRuleSet values.
type NetworkRuleSetListResultPage struct {
	fn    func(context.Context, NetworkRuleSetListResult) (NetworkRuleSetListResult, error)
	nrslr NetworkRuleSetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkRuleSetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NetworkRuleSetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nrslr)
	if err != nil {
		return err
	}
	page.nrslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NetworkRuleSetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkRuleSetListResultPage) NotDone() bool {
	return !page.nrslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkRuleSetListResultPage) Response() NetworkRuleSetListResult {
	return page.nrslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkRuleSetListResultPage) Values() []NetworkRuleSet {
	if page.nrslr.IsEmpty() {
		return nil
	}
	return *page.nrslr.Value
}

// Creates a new instance of the NetworkRuleSetListResultPage type.
func NewNetworkRuleSetListResultPage(getNextPage func(context.Context, NetworkRuleSetListResult) (NetworkRuleSetListResult, error)) NetworkRuleSetListResultPage {
	return NetworkRuleSetListResultPage{fn: getNextPage}
}

// NetworkRuleSetProperties networkRuleSet properties
type NetworkRuleSetProperties struct {
	// DefaultAction - Default Action for Network Rule Set. Possible values include: 'Allow', 'Deny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
	// VirtualNetworkRules - List VirtualNetwork Rules
	VirtualNetworkRules *[]NWRuleSetVirtualNetworkRules `json:"virtualNetworkRules,omitempty"`
	// IPRules - List of IpRules
	IPRules *[]NWRuleSetIPRules `json:"ipRules,omitempty"`
}

// NWRuleSetIPRules description of NetWorkRuleSet - IpRules resource.
type NWRuleSetIPRules struct {
	// IPMask - IP Mask
	IPMask *string `json:"ipMask,omitempty"`
	// Action - The IP Filter Action. Possible values include: 'NetworkRuleIPActionAllow'
	Action NetworkRuleIPAction `json:"action,omitempty"`
}

// NWRuleSetVirtualNetworkRules description of VirtualNetworkRules - NetworkRules resource.
type NWRuleSetVirtualNetworkRules struct {
	// Subnet - Subnet properties
	Subnet *Subnet `json:"subnet,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Value that indicates whether to ignore missing VNet Service Endpoint
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}

// Operation a ServiceBus REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.ServiceBus
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list ServiceBus operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ServiceBus operations supported by the Microsoft.ServiceBus resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PremiumMessagingRegions premium Messaging Region
type PremiumMessagingRegions struct {
	Properties *PremiumMessagingRegionsProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PremiumMessagingRegions.
func (pmr PremiumMessagingRegions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmr.Properties != nil {
		objectMap["properties"] = pmr.Properties
	}
	if pmr.Location != nil {
		objectMap["location"] = pmr.Location
	}
	if pmr.Tags != nil {
		objectMap["tags"] = pmr.Tags
	}
	return json.Marshal(objectMap)
}

// PremiumMessagingRegionsListResult the response of the List PremiumMessagingRegions operation.
type PremiumMessagingRegionsListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List PremiumMessagingRegions type.
	Value *[]PremiumMessagingRegions `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of PremiumMessagingRegions.
	NextLink *string `json:"nextLink,omitempty"`
}

// PremiumMessagingRegionsListResultIterator provides access to a complete listing of
// PremiumMessagingRegions values.
type PremiumMessagingRegionsListResultIterator struct {
	i    int
	page PremiumMessagingRegionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PremiumMessagingRegionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremiumMessagingRegionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PremiumMessagingRegionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PremiumMessagingRegionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PremiumMessagingRegionsListResultIterator) Response() PremiumMessagingRegionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PremiumMessagingRegionsListResultIterator) Value() PremiumMessagingRegions {
	if !iter.page.NotDone() {
		return PremiumMessagingRegions{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PremiumMessagingRegionsListResultIterator type.
func NewPremiumMessagingRegionsListResultIterator(page PremiumMessagingRegionsListResultPage) PremiumMessagingRegionsListResultIterator {
	return PremiumMessagingRegionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmrlr PremiumMessagingRegionsListResult) IsEmpty() bool {
	return pmrlr.Value == nil || len(*pmrlr.Value) == 0
}

// premiumMessagingRegionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmrlr PremiumMessagingRegionsListResult) premiumMessagingRegionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if pmrlr.NextLink == nil || len(to.String(pmrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmrlr.NextLink)))
}

// PremiumMessagingRegionsListResultPage contains a page of PremiumMessagingRegions values.
type PremiumMessagingRegionsListResultPage struct {
	fn    func(context.Context, PremiumMessagingRegionsListResult) (PremiumMessagingRegionsListResult, error)
	pmrlr PremiumMessagingRegionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PremiumMessagingRegionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremiumMessagingRegionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pmrlr)
	if err != nil {
		return err
	}
	page.pmrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PremiumMessagingRegionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PremiumMessagingRegionsListResultPage) NotDone() bool {
	return !page.pmrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PremiumMessagingRegionsListResultPage) Response() PremiumMessagingRegionsListResult {
	return page.pmrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PremiumMessagingRegionsListResultPage) Values() []PremiumMessagingRegions {
	if page.pmrlr.IsEmpty() {
		return nil
	}
	return *page.pmrlr.Value
}

// Creates a new instance of the PremiumMessagingRegionsListResultPage type.
func NewPremiumMessagingRegionsListResultPage(getNextPage func(context.Context, PremiumMessagingRegionsListResult) (PremiumMessagingRegionsListResult, error)) PremiumMessagingRegionsListResultPage {
	return PremiumMessagingRegionsListResultPage{fn: getNextPage}
}

// PremiumMessagingRegionsProperties ...
type PremiumMessagingRegionsProperties struct {
	// Code - READ-ONLY; Region code
	Code *string `json:"code,omitempty"`
	// FullName - READ-ONLY; Full name of the region
	FullName *string `json:"fullName,omitempty"`
}

// RegenerateAccessKeyParameters parameters supplied to the Regenerate Authorization Rule operation,
// specifies which key needs to be reset.
type RegenerateAccessKeyParameters struct {
	// KeyType - The access key to regenerate. Possible values include: 'PrimaryKey', 'SecondaryKey'
	KeyType KeyType `json:"keyType,omitempty"`
	// Key - Optional, if the key value provided, is reset for KeyType value or autogenerate Key value set for keyType
	Key *string `json:"key,omitempty"`
}

// Resource the Resource definition for other than namespace.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// ResourceNamespacePatch the Resource definition.
type ResourceNamespacePatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceNamespacePatch.
func (rnp ResourceNamespacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rnp.Location != nil {
		objectMap["location"] = rnp.Location
	}
	if rnp.Tags != nil {
		objectMap["tags"] = rnp.Tags
	}
	return json.Marshal(objectMap)
}

// Rule description of Rule Resource.
type Rule struct {
	autorest.Response `json:"-"`
	// Ruleproperties - Properties of Rule resource
	*Ruleproperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Ruleproperties != nil {
		objectMap["properties"] = r.Ruleproperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Rule struct.
func (r *Rule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleproperties Ruleproperties
				err = json.Unmarshal(*v, &ruleproperties)
				if err != nil {
					return err
				}
				r.Ruleproperties = &ruleproperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		}
	}

	return nil
}

// RuleListResult the response of the List rule operation.
type RuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Rules operation.
	Value *[]Rule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of rules
	NextLink *string `json:"nextLink,omitempty"`
}

// RuleListResultIterator provides access to a complete listing of Rule values.
type RuleListResultIterator struct {
	i    int
	page RuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RuleListResultIterator) Response() RuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RuleListResultIterator) Value() Rule {
	if !iter.page.NotDone() {
		return Rule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RuleListResultIterator type.
func NewRuleListResultIterator(page RuleListResultPage) RuleListResultIterator {
	return RuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RuleListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// ruleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RuleListResult) ruleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RuleListResultPage contains a page of Rule values.
type RuleListResultPage struct {
	fn  func(context.Context, RuleListResult) (RuleListResult, error)
	rlr RuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RuleListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RuleListResultPage) Response() RuleListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RuleListResultPage) Values() []Rule {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RuleListResultPage type.
func NewRuleListResultPage(getNextPage func(context.Context, RuleListResult) (RuleListResult, error)) RuleListResultPage {
	return RuleListResultPage{fn: getNextPage}
}

// Ruleproperties description of Rule Resource.
type Ruleproperties struct {
	// Action - Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
	Action *Action `json:"action,omitempty"`
	// FilterType - Filter type that is evaluated against a BrokeredMessage. Possible values include: 'FilterTypeSQLFilter', 'FilterTypeCorrelationFilter'
	FilterType FilterType `json:"filterType,omitempty"`
	// SQLFilter - Properties of sqlFilter
	SQLFilter *SQLFilter `json:"sqlFilter,omitempty"`
	// CorrelationFilter - Properties of correlationFilter
	CorrelationFilter *CorrelationFilter `json:"correlationFilter,omitempty"`
}

// SBAuthorizationRule description of a namespace authorization rule.
type SBAuthorizationRule struct {
	autorest.Response `json:"-"`
	// SBAuthorizationRuleProperties - AuthorizationRule properties.
	*SBAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBAuthorizationRule.
func (sar SBAuthorizationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sar.SBAuthorizationRuleProperties != nil {
		objectMap["properties"] = sar.SBAuthorizationRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBAuthorizationRule struct.
func (sar *SBAuthorizationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sBAuthorizationRuleProperties SBAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sBAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				sar.SBAuthorizationRuleProperties = &sBAuthorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sar.Type = &typeVar
			}
		}
	}

	return nil
}

// SBAuthorizationRuleListResult the response to the List Namespace operation.
type SBAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Authorization Rules operation.
	Value *[]SBAuthorizationRule `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Authorization Rules.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBAuthorizationRuleListResultIterator provides access to a complete listing of SBAuthorizationRule
// values.
type SBAuthorizationRuleListResultIterator struct {
	i    int
	page SBAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBAuthorizationRuleListResultIterator) Response() SBAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBAuthorizationRuleListResultIterator) Value() SBAuthorizationRule {
	if !iter.page.NotDone() {
		return SBAuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBAuthorizationRuleListResultIterator type.
func NewSBAuthorizationRuleListResultIterator(page SBAuthorizationRuleListResultPage) SBAuthorizationRuleListResultIterator {
	return SBAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sarlr SBAuthorizationRuleListResult) IsEmpty() bool {
	return sarlr.Value == nil || len(*sarlr.Value) == 0
}

// sBAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sarlr SBAuthorizationRuleListResult) sBAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sarlr.NextLink == nil || len(to.String(sarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sarlr.NextLink)))
}

// SBAuthorizationRuleListResultPage contains a page of SBAuthorizationRule values.
type SBAuthorizationRuleListResultPage struct {
	fn    func(context.Context, SBAuthorizationRuleListResult) (SBAuthorizationRuleListResult, error)
	sarlr SBAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sarlr)
	if err != nil {
		return err
	}
	page.sarlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBAuthorizationRuleListResultPage) Response() SBAuthorizationRuleListResult {
	return page.sarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBAuthorizationRuleListResultPage) Values() []SBAuthorizationRule {
	if page.sarlr.IsEmpty() {
		return nil
	}
	return *page.sarlr.Value
}

// Creates a new instance of the SBAuthorizationRuleListResultPage type.
func NewSBAuthorizationRuleListResultPage(getNextPage func(context.Context, SBAuthorizationRuleListResult) (SBAuthorizationRuleListResult, error)) SBAuthorizationRuleListResultPage {
	return SBAuthorizationRuleListResultPage{fn: getNextPage}
}

// SBAuthorizationRuleProperties authorizationRule properties.
type SBAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SBNamespace description of a namespace resource.
type SBNamespace struct {
	autorest.Response `json:"-"`
	// Sku - Properties of Sku
	Sku *SBSku `json:"sku,omitempty"`
	// SBNamespaceProperties - Properties of the namespace.
	*SBNamespaceProperties `json:"properties,omitempty"`
	// Location - The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBNamespace.
func (sn SBNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sn.Sku != nil {
		objectMap["sku"] = sn.Sku
	}
	if sn.SBNamespaceProperties != nil {
		objectMap["properties"] = sn.SBNamespaceProperties
	}
	if sn.Location != nil {
		objectMap["location"] = sn.Location
	}
	if sn.Tags != nil {
		objectMap["tags"] = sn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBNamespace struct.
func (sn *SBNamespace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku SBSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sn.Sku = &sku
			}
		case "properties":
			if v != nil {
				var sBNamespaceProperties SBNamespaceProperties
				err = json.Unmarshal(*v, &sBNamespaceProperties)
				if err != nil {
					return err
				}
				sn.SBNamespaceProperties = &sBNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sn.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sn.Type = &typeVar
			}
		}
	}

	return nil
}

// SBNamespaceListResult the response of the List Namespace operation.
type SBNamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]SBNamespace `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBNamespaceListResultIterator provides access to a complete listing of SBNamespace values.
type SBNamespaceListResultIterator struct {
	i    int
	page SBNamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBNamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBNamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBNamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBNamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBNamespaceListResultIterator) Response() SBNamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBNamespaceListResultIterator) Value() SBNamespace {
	if !iter.page.NotDone() {
		return SBNamespace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBNamespaceListResultIterator type.
func NewSBNamespaceListResultIterator(page SBNamespaceListResultPage) SBNamespaceListResultIterator {
	return SBNamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (snlr SBNamespaceListResult) IsEmpty() bool {
	return snlr.Value == nil || len(*snlr.Value) == 0
}

// sBNamespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (snlr SBNamespaceListResult) sBNamespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if snlr.NextLink == nil || len(to.String(snlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(snlr.NextLink)))
}

// SBNamespaceListResultPage contains a page of SBNamespace values.
type SBNamespaceListResultPage struct {
	fn   func(context.Context, SBNamespaceListResult) (SBNamespaceListResult, error)
	snlr SBNamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBNamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBNamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.snlr)
	if err != nil {
		return err
	}
	page.snlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBNamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBNamespaceListResultPage) NotDone() bool {
	return !page.snlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBNamespaceListResultPage) Response() SBNamespaceListResult {
	return page.snlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBNamespaceListResultPage) Values() []SBNamespace {
	if page.snlr.IsEmpty() {
		return nil
	}
	return *page.snlr.Value
}

// Creates a new instance of the SBNamespaceListResultPage type.
func NewSBNamespaceListResultPage(getNextPage func(context.Context, SBNamespaceListResult) (SBNamespaceListResult, error)) SBNamespaceListResultPage {
	return SBNamespaceListResultPage{fn: getNextPage}
}

// SBNamespaceMigrate namespace Migrate Object
type SBNamespaceMigrate struct {
	// TargetNamespaceType - Type of namespaces. Possible values include: 'Messaging', 'NotificationHub', 'Mixed', 'EventHub', 'Relay'
	TargetNamespaceType NameSpaceType `json:"targetNamespaceType,omitempty"`
}

// SBNamespaceProperties properties of the namespace.
type SBNamespaceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CreatedAt - READ-ONLY; The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// MetricID - READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty"`
}

// SBNamespaceUpdateParameters description of a namespace resource.
type SBNamespaceUpdateParameters struct {
	// Sku - Properties of Sku
	Sku *SBSku `json:"sku,omitempty"`
	// SBNamespaceProperties - Properties of the namespace.
	*SBNamespaceProperties `json:"properties,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBNamespaceUpdateParameters.
func (snup SBNamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if snup.Sku != nil {
		objectMap["sku"] = snup.Sku
	}
	if snup.SBNamespaceProperties != nil {
		objectMap["properties"] = snup.SBNamespaceProperties
	}
	if snup.Location != nil {
		objectMap["location"] = snup.Location
	}
	if snup.Tags != nil {
		objectMap["tags"] = snup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBNamespaceUpdateParameters struct.
func (snup *SBNamespaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku SBSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				snup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var sBNamespaceProperties SBNamespaceProperties
				err = json.Unmarshal(*v, &sBNamespaceProperties)
				if err != nil {
					return err
				}
				snup.SBNamespaceProperties = &sBNamespaceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				snup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				snup.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				snup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				snup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				snup.Type = &typeVar
			}
		}
	}

	return nil
}

// SBQueue description of queue Resource.
type SBQueue struct {
	autorest.Response `json:"-"`
	// SBQueueProperties - Queue Properties
	*SBQueueProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBQueue.
func (sq SBQueue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sq.SBQueueProperties != nil {
		objectMap["properties"] = sq.SBQueueProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBQueue struct.
func (sq *SBQueue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sBQueueProperties SBQueueProperties
				err = json.Unmarshal(*v, &sBQueueProperties)
				if err != nil {
					return err
				}
				sq.SBQueueProperties = &sBQueueProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sq.Type = &typeVar
			}
		}
	}

	return nil
}

// SBQueueListResult the response to the List Queues operation.
type SBQueueListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Queues operation.
	Value *[]SBQueue `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of queues.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBQueueListResultIterator provides access to a complete listing of SBQueue values.
type SBQueueListResultIterator struct {
	i    int
	page SBQueueListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBQueueListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBQueueListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBQueueListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBQueueListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBQueueListResultIterator) Response() SBQueueListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBQueueListResultIterator) Value() SBQueue {
	if !iter.page.NotDone() {
		return SBQueue{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBQueueListResultIterator type.
func NewSBQueueListResultIterator(page SBQueueListResultPage) SBQueueListResultIterator {
	return SBQueueListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sqlr SBQueueListResult) IsEmpty() bool {
	return sqlr.Value == nil || len(*sqlr.Value) == 0
}

// sBQueueListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sqlr SBQueueListResult) sBQueueListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sqlr.NextLink == nil || len(to.String(sqlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sqlr.NextLink)))
}

// SBQueueListResultPage contains a page of SBQueue values.
type SBQueueListResultPage struct {
	fn   func(context.Context, SBQueueListResult) (SBQueueListResult, error)
	sqlr SBQueueListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBQueueListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBQueueListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sqlr)
	if err != nil {
		return err
	}
	page.sqlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBQueueListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBQueueListResultPage) NotDone() bool {
	return !page.sqlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBQueueListResultPage) Response() SBQueueListResult {
	return page.sqlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBQueueListResultPage) Values() []SBQueue {
	if page.sqlr.IsEmpty() {
		return nil
	}
	return *page.sqlr.Value
}

// Creates a new instance of the SBQueueListResultPage type.
func NewSBQueueListResultPage(getNextPage func(context.Context, SBQueueListResult) (SBQueueListResult, error)) SBQueueListResultPage {
	return SBQueueListResultPage{fn: getNextPage}
}

// SBQueueProperties the Queue Properties definition.
type SBQueueProperties struct {
	// CountDetails - READ-ONLY; Message Count Details.
	CountDetails *MessageCountDetails `json:"countDetails,omitempty"`
	// CreatedAt - READ-ONLY; The exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// AccessedAt - READ-ONLY; Last time a message was sent, or the last time there was a receive request to this queue.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// SizeInBytes - READ-ONLY; The size of the queue, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// MessageCount - READ-ONLY; The number of messages in the queue.
	MessageCount *int64 `json:"messageCount,omitempty"`
	// LockDuration - ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
	LockDuration *string `json:"lockDuration,omitempty"`
	// MaxSizeInMegabytes - The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
	MaxSizeInMegabytes *int32 `json:"maxSizeInMegabytes,omitempty"`
	// RequiresDuplicateDetection - A value indicating if this queue requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`
	// RequiresSession - A value that indicates whether the queue supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`
	// DefaultMessageTimeToLive - ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// DeadLetteringOnMessageExpiration - A value that indicates whether this queue has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`
	// DuplicateDetectionHistoryTimeWindow - ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	// MaxDeliveryCount - The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// EnableBatchedOperations - Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// AutoDeleteOnIdle - ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`
	// EnablePartitioning - A value that indicates whether the queue is to be partitioned across multiple message brokers.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`
	// EnableExpress - A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`
	// ForwardTo - Queue/Topic name to forward the messages
	ForwardTo *string `json:"forwardTo,omitempty"`
	// ForwardDeadLetteredMessagesTo - Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string `json:"forwardDeadLetteredMessagesTo,omitempty"`
}

// SBSku SKU of the namespace.
type SBSku struct {
	// Name - Name of this SKU. Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - The billing tier of this particular SKU. Possible values include: 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
	// Capacity - The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SBSubscription description of subscription resource.
type SBSubscription struct {
	autorest.Response `json:"-"`
	// SBSubscriptionProperties - Properties of subscriptions resource.
	*SBSubscriptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBSubscription.
func (ss SBSubscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SBSubscriptionProperties != nil {
		objectMap["properties"] = ss.SBSubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBSubscription struct.
func (ss *SBSubscription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sBSubscriptionProperties SBSubscriptionProperties
				err = json.Unmarshal(*v, &sBSubscriptionProperties)
				if err != nil {
					return err
				}
				ss.SBSubscriptionProperties = &sBSubscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// SBSubscriptionListResult the response to the List Subscriptions operation.
type SBSubscriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Subscriptions operation.
	Value *[]SBSubscription `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of subscriptions.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBSubscriptionListResultIterator provides access to a complete listing of SBSubscription values.
type SBSubscriptionListResultIterator struct {
	i    int
	page SBSubscriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBSubscriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBSubscriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBSubscriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBSubscriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBSubscriptionListResultIterator) Response() SBSubscriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBSubscriptionListResultIterator) Value() SBSubscription {
	if !iter.page.NotDone() {
		return SBSubscription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBSubscriptionListResultIterator type.
func NewSBSubscriptionListResultIterator(page SBSubscriptionListResultPage) SBSubscriptionListResultIterator {
	return SBSubscriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sslr SBSubscriptionListResult) IsEmpty() bool {
	return sslr.Value == nil || len(*sslr.Value) == 0
}

// sBSubscriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sslr SBSubscriptionListResult) sBSubscriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sslr.NextLink == nil || len(to.String(sslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sslr.NextLink)))
}

// SBSubscriptionListResultPage contains a page of SBSubscription values.
type SBSubscriptionListResultPage struct {
	fn   func(context.Context, SBSubscriptionListResult) (SBSubscriptionListResult, error)
	sslr SBSubscriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBSubscriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBSubscriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sslr)
	if err != nil {
		return err
	}
	page.sslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBSubscriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBSubscriptionListResultPage) NotDone() bool {
	return !page.sslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBSubscriptionListResultPage) Response() SBSubscriptionListResult {
	return page.sslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBSubscriptionListResultPage) Values() []SBSubscription {
	if page.sslr.IsEmpty() {
		return nil
	}
	return *page.sslr.Value
}

// Creates a new instance of the SBSubscriptionListResultPage type.
func NewSBSubscriptionListResultPage(getNextPage func(context.Context, SBSubscriptionListResult) (SBSubscriptionListResult, error)) SBSubscriptionListResultPage {
	return SBSubscriptionListResultPage{fn: getNextPage}
}

// SBSubscriptionProperties description of Subscription Resource.
type SBSubscriptionProperties struct {
	// MessageCount - READ-ONLY; Number of messages.
	MessageCount *int64 `json:"messageCount,omitempty"`
	// CreatedAt - READ-ONLY; Exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// AccessedAt - READ-ONLY; Last time there was a receive request to this subscription.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// UpdatedAt - READ-ONLY; The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// CountDetails - READ-ONLY; Message count details
	CountDetails *MessageCountDetails `json:"countDetails,omitempty"`
	// LockDuration - ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
	LockDuration *string `json:"lockDuration,omitempty"`
	// RequiresSession - Value indicating if a subscription supports the concept of sessions.
	RequiresSession *bool `json:"requiresSession,omitempty"`
	// DefaultMessageTimeToLive - ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// DeadLetteringOnFilterEvaluationExceptions - Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
	DeadLetteringOnFilterEvaluationExceptions *bool `json:"deadLetteringOnFilterEvaluationExceptions,omitempty"`
	// DeadLetteringOnMessageExpiration - Value that indicates whether a subscription has dead letter support when a message expires.
	DeadLetteringOnMessageExpiration *bool `json:"deadLetteringOnMessageExpiration,omitempty"`
	// DuplicateDetectionHistoryTimeWindow - ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	// MaxDeliveryCount - Number of maximum deliveries.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// EnableBatchedOperations - Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// AutoDeleteOnIdle - ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`
	// ForwardTo - Queue/Topic name to forward the messages
	ForwardTo *string `json:"forwardTo,omitempty"`
	// ForwardDeadLetteredMessagesTo - Queue/Topic name to forward the Dead Letter message
	ForwardDeadLetteredMessagesTo *string `json:"forwardDeadLetteredMessagesTo,omitempty"`
}

// SBTopic description of topic resource.
type SBTopic struct {
	autorest.Response `json:"-"`
	// SBTopicProperties - Properties of topic resource.
	*SBTopicProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SBTopic.
func (st SBTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if st.SBTopicProperties != nil {
		objectMap["properties"] = st.SBTopicProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SBTopic struct.
func (st *SBTopic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sBTopicProperties SBTopicProperties
				err = json.Unmarshal(*v, &sBTopicProperties)
				if err != nil {
					return err
				}
				st.SBTopicProperties = &sBTopicProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				st.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				st.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				st.Type = &typeVar
			}
		}
	}

	return nil
}

// SBTopicListResult the response to the List Topics operation.
type SBTopicListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Topics operation.
	Value *[]SBTopic `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of topics.
	NextLink *string `json:"nextLink,omitempty"`
}

// SBTopicListResultIterator provides access to a complete listing of SBTopic values.
type SBTopicListResultIterator struct {
	i    int
	page SBTopicListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SBTopicListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBTopicListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SBTopicListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SBTopicListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SBTopicListResultIterator) Response() SBTopicListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SBTopicListResultIterator) Value() SBTopic {
	if !iter.page.NotDone() {
		return SBTopic{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SBTopicListResultIterator type.
func NewSBTopicListResultIterator(page SBTopicListResultPage) SBTopicListResultIterator {
	return SBTopicListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (stlr SBTopicListResult) IsEmpty() bool {
	return stlr.Value == nil || len(*stlr.Value) == 0
}

// sBTopicListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (stlr SBTopicListResult) sBTopicListResultPreparer(ctx context.Context) (*http.Request, error) {
	if stlr.NextLink == nil || len(to.String(stlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(stlr.NextLink)))
}

// SBTopicListResultPage contains a page of SBTopic values.
type SBTopicListResultPage struct {
	fn   func(context.Context, SBTopicListResult) (SBTopicListResult, error)
	stlr SBTopicListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SBTopicListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SBTopicListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.stlr)
	if err != nil {
		return err
	}
	page.stlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SBTopicListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SBTopicListResultPage) NotDone() bool {
	return !page.stlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SBTopicListResultPage) Response() SBTopicListResult {
	return page.stlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SBTopicListResultPage) Values() []SBTopic {
	if page.stlr.IsEmpty() {
		return nil
	}
	return *page.stlr.Value
}

// Creates a new instance of the SBTopicListResultPage type.
func NewSBTopicListResultPage(getNextPage func(context.Context, SBTopicListResult) (SBTopicListResult, error)) SBTopicListResultPage {
	return SBTopicListResultPage{fn: getNextPage}
}

// SBTopicProperties the Topic Properties definition.
type SBTopicProperties struct {
	// SizeInBytes - READ-ONLY; Size of the topic, in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// CreatedAt - READ-ONLY; Exact time the message was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; The exact time the message was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// AccessedAt - READ-ONLY; Last time the message was sent, or a request was received, for this topic.
	AccessedAt *date.Time `json:"accessedAt,omitempty"`
	// SubscriptionCount - READ-ONLY; Number of subscriptions.
	SubscriptionCount *int32 `json:"subscriptionCount,omitempty"`
	// CountDetails - READ-ONLY; Message count details
	CountDetails *MessageCountDetails `json:"countDetails,omitempty"`
	// DefaultMessageTimeToLive - ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
	DefaultMessageTimeToLive *string `json:"defaultMessageTimeToLive,omitempty"`
	// MaxSizeInMegabytes - Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
	MaxSizeInMegabytes *int32 `json:"maxSizeInMegabytes,omitempty"`
	// RequiresDuplicateDetection - Value indicating if this topic requires duplicate detection.
	RequiresDuplicateDetection *bool `json:"requiresDuplicateDetection,omitempty"`
	// DuplicateDetectionHistoryTimeWindow - ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
	DuplicateDetectionHistoryTimeWindow *string `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	// EnableBatchedOperations - Value that indicates whether server-side batched operations are enabled.
	EnableBatchedOperations *bool `json:"enableBatchedOperations,omitempty"`
	// Status - Enumerates the possible values for the status of a messaging entity. Possible values include: 'Active', 'Disabled', 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming', 'Unknown'
	Status EntityStatus `json:"status,omitempty"`
	// SupportOrdering - Value that indicates whether the topic supports ordering.
	SupportOrdering *bool `json:"supportOrdering,omitempty"`
	// AutoDeleteOnIdle - ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
	AutoDeleteOnIdle *string `json:"autoDeleteOnIdle,omitempty"`
	// EnablePartitioning - Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
	EnablePartitioning *bool `json:"enablePartitioning,omitempty"`
	// EnableExpress - Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
	EnableExpress *bool `json:"enableExpress,omitempty"`
}

// SQLFilter represents a filter which is a composition of an expression and an action that is executed in
// the pub/sub pipeline.
type SQLFilter struct {
	// SQLExpression - The SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
	// CompatibilityLevel - This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`
	// RequiresPreprocessing - Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`
}

// SQLRuleAction represents set of actions written in SQL language-based syntax that is performed against a
// ServiceBus.Messaging.BrokeredMessage
type SQLRuleAction struct {
	// SQLExpression - SQL expression. e.g. MyProperty='ABC'
	SQLExpression *string `json:"sqlExpression,omitempty"`
	// CompatibilityLevel - This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
	CompatibilityLevel *int32 `json:"compatibilityLevel,omitempty"`
	// RequiresPreprocessing - Value that indicates whether the rule action requires preprocessing.
	RequiresPreprocessing *bool `json:"requiresPreprocessing,omitempty"`
}

// Subnet properties supplied for Subnet
type Subnet struct {
	// ID - Resource ID of Virtual Network Subnet
	ID *string `json:"id,omitempty"`
}

// TrackedResource the Resource definition.
type TrackedResource struct {
	// Location - The Geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}
