// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.21.12
// source: jwt_hmac.proto

package jwt_hmac_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// See https://datatracker.ietf.org/doc/html/rfc7518#section-3.2
type JwtHmacAlgorithm int32

const (
	JwtHmacAlgorithm_HS_UNKNOWN JwtHmacAlgorithm = 0
	JwtHmacAlgorithm_HS256      JwtHmacAlgorithm = 1 // HMAC using SHA-256
	JwtHmacAlgorithm_HS384      JwtHmacAlgorithm = 2 // HMAC using SHA-384
	JwtHmacAlgorithm_HS512      JwtHmacAlgorithm = 3 // HMAC using SHA-512
)

// Enum value maps for JwtHmacAlgorithm.
var (
	JwtHmacAlgorithm_name = map[int32]string{
		0: "HS_UNKNOWN",
		1: "HS256",
		2: "HS384",
		3: "HS512",
	}
	JwtHmacAlgorithm_value = map[string]int32{
		"HS_UNKNOWN": 0,
		"HS256":      1,
		"HS384":      2,
		"HS512":      3,
	}
)

func (x JwtHmacAlgorithm) Enum() *JwtHmacAlgorithm {
	p := new(JwtHmacAlgorithm)
	*p = x
	return p
}

func (x JwtHmacAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JwtHmacAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_jwt_hmac_proto_enumTypes[0].Descriptor()
}

func (JwtHmacAlgorithm) Type() protoreflect.EnumType {
	return &file_jwt_hmac_proto_enumTypes[0]
}

func (x JwtHmacAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JwtHmacAlgorithm.Descriptor instead.
func (JwtHmacAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_jwt_hmac_proto_rawDescGZIP(), []int{0}
}

// key_type: type.googleapis.com/google.crypto.tink.JwtHmacKey
type JwtHmacKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm     JwtHmacAlgorithm       `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtHmacAlgorithm" json:"algorithm,omitempty"`
	KeyValue      []byte                 `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype and debug_redact.
	CustomKid     *JwtHmacKey_CustomKid  `protobuf:"bytes,4,opt,name=custom_kid,json=customKid,proto3" json:"custom_kid,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtHmacKey) Reset() {
	*x = JwtHmacKey{}
	mi := &file_jwt_hmac_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtHmacKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKey) ProtoMessage() {}

func (x *JwtHmacKey) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_hmac_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKey.ProtoReflect.Descriptor instead.
func (*JwtHmacKey) Descriptor() ([]byte, []int) {
	return file_jwt_hmac_proto_rawDescGZIP(), []int{0}
}

func (x *JwtHmacKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtHmacKey) GetAlgorithm() JwtHmacAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtHmacAlgorithm_HS_UNKNOWN
}

func (x *JwtHmacKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *JwtHmacKey) GetCustomKid() *JwtHmacKey_CustomKid {
	if x != nil {
		return x.CustomKid
	}
	return nil
}

type JwtHmacKeyFormat struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm     JwtHmacAlgorithm       `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtHmacAlgorithm" json:"algorithm,omitempty"`
	KeySize       uint32                 `protobuf:"varint,3,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtHmacKeyFormat) Reset() {
	*x = JwtHmacKeyFormat{}
	mi := &file_jwt_hmac_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtHmacKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKeyFormat) ProtoMessage() {}

func (x *JwtHmacKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_hmac_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKeyFormat.ProtoReflect.Descriptor instead.
func (*JwtHmacKeyFormat) Descriptor() ([]byte, []int) {
	return file_jwt_hmac_proto_rawDescGZIP(), []int{1}
}

func (x *JwtHmacKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtHmacKeyFormat) GetAlgorithm() JwtHmacAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtHmacAlgorithm_HS_UNKNOWN
}

func (x *JwtHmacKeyFormat) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

// Optional, custom kid header value to be used with "RAW" keys.
// "TINK" keys with this value set will be rejected.
type JwtHmacKey_CustomKid struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         string                 `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *JwtHmacKey_CustomKid) Reset() {
	*x = JwtHmacKey_CustomKid{}
	mi := &file_jwt_hmac_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JwtHmacKey_CustomKid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKey_CustomKid) ProtoMessage() {}

func (x *JwtHmacKey_CustomKid) ProtoReflect() protoreflect.Message {
	mi := &file_jwt_hmac_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKey_CustomKid.ProtoReflect.Descriptor instead.
func (*JwtHmacKey_CustomKid) Descriptor() ([]byte, []int) {
	return file_jwt_hmac_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtHmacKey_CustomKid) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_jwt_hmac_proto protoreflect.FileDescriptor

const file_jwt_hmac_proto_rawDesc = "" +
	"\n" +
	"\x0ejwt_hmac.proto\x12\x12google.crypto.tink\"\xf3\x01\n" +
	"\n" +
	"JwtHmacKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12B\n" +
	"\talgorithm\x18\x02 \x01(\x0e2$.google.crypto.tink.JwtHmacAlgorithmR\talgorithm\x12\x1b\n" +
	"\tkey_value\x18\x03 \x01(\fR\bkeyValue\x12G\n" +
	"\n" +
	"custom_kid\x18\x04 \x01(\v2(.google.crypto.tink.JwtHmacKey.CustomKidR\tcustomKid\x1a!\n" +
	"\tCustomKid\x12\x14\n" +
	"\x05value\x18\x01 \x01(\tR\x05value\"\x8b\x01\n" +
	"\x10JwtHmacKeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12B\n" +
	"\talgorithm\x18\x02 \x01(\x0e2$.google.crypto.tink.JwtHmacAlgorithmR\talgorithm\x12\x19\n" +
	"\bkey_size\x18\x03 \x01(\rR\akeySize*C\n" +
	"\x10JwtHmacAlgorithm\x12\x0e\n" +
	"\n" +
	"HS_UNKNOWN\x10\x00\x12\t\n" +
	"\x05HS256\x10\x01\x12\t\n" +
	"\x05HS384\x10\x02\x12\t\n" +
	"\x05HS512\x10\x03B[\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z9github.com/tink-crypto/tink-go/v2/proto/jwt_hmac_go_protob\x06proto3"

var (
	file_jwt_hmac_proto_rawDescOnce sync.Once
	file_jwt_hmac_proto_rawDescData []byte
)

func file_jwt_hmac_proto_rawDescGZIP() []byte {
	file_jwt_hmac_proto_rawDescOnce.Do(func() {
		file_jwt_hmac_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_jwt_hmac_proto_rawDesc), len(file_jwt_hmac_proto_rawDesc)))
	})
	return file_jwt_hmac_proto_rawDescData
}

var file_jwt_hmac_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_jwt_hmac_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_jwt_hmac_proto_goTypes = []any{
	(JwtHmacAlgorithm)(0),        // 0: google.crypto.tink.JwtHmacAlgorithm
	(*JwtHmacKey)(nil),           // 1: google.crypto.tink.JwtHmacKey
	(*JwtHmacKeyFormat)(nil),     // 2: google.crypto.tink.JwtHmacKeyFormat
	(*JwtHmacKey_CustomKid)(nil), // 3: google.crypto.tink.JwtHmacKey.CustomKid
}
var file_jwt_hmac_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.JwtHmacKey.algorithm:type_name -> google.crypto.tink.JwtHmacAlgorithm
	3, // 1: google.crypto.tink.JwtHmacKey.custom_kid:type_name -> google.crypto.tink.JwtHmacKey.CustomKid
	0, // 2: google.crypto.tink.JwtHmacKeyFormat.algorithm:type_name -> google.crypto.tink.JwtHmacAlgorithm
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_jwt_hmac_proto_init() }
func file_jwt_hmac_proto_init() {
	if File_jwt_hmac_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_jwt_hmac_proto_rawDesc), len(file_jwt_hmac_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_jwt_hmac_proto_goTypes,
		DependencyIndexes: file_jwt_hmac_proto_depIdxs,
		EnumInfos:         file_jwt_hmac_proto_enumTypes,
		MessageInfos:      file_jwt_hmac_proto_msgTypes,
	}.Build()
	File_jwt_hmac_proto = out.File
	file_jwt_hmac_proto_goTypes = nil
	file_jwt_hmac_proto_depIdxs = nil
}
