// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/oslogin/v1beta/oslogin.proto

/*
Package oslogin is a generated protocol buffer package.

It is generated from these files:
	google/cloud/oslogin/v1beta/oslogin.proto

It has these top-level messages:
	LoginProfile
	DeletePosixAccountRequest
	DeleteSshPublicKeyRequest
	GetLoginProfileRequest
	GetSshPublicKeyRequest
	ImportSshPublicKeyRequest
	ImportSshPublicKeyResponse
	UpdateSshPublicKeyRequest
*/
package oslogin

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_cloud_oslogin_common "google.golang.org/genproto/googleapis/cloud/oslogin/common"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The user profile information used for logging in to a virtual machine on
// Google Compute Engine.
type LoginProfile struct {
	// The primary email address that uniquely identifies the user.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The list of POSIX accounts associated with the user.
	PosixAccounts []*google_cloud_oslogin_common.PosixAccount `protobuf:"bytes,2,rep,name=posix_accounts,json=posixAccounts" json:"posix_accounts,omitempty"`
	// A map from SSH public key fingerprint to the associated key object.
	SshPublicKeys map[string]*google_cloud_oslogin_common.SshPublicKey `protobuf:"bytes,3,rep,name=ssh_public_keys,json=sshPublicKeys" json:"ssh_public_keys,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Indicates if the user is suspended. A suspended user cannot log in but
	// their profile information is retained.
	Suspended bool `protobuf:"varint,4,opt,name=suspended" json:"suspended,omitempty"`
}

func (m *LoginProfile) Reset()                    { *m = LoginProfile{} }
func (m *LoginProfile) String() string            { return proto.CompactTextString(m) }
func (*LoginProfile) ProtoMessage()               {}
func (*LoginProfile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *LoginProfile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LoginProfile) GetPosixAccounts() []*google_cloud_oslogin_common.PosixAccount {
	if m != nil {
		return m.PosixAccounts
	}
	return nil
}

func (m *LoginProfile) GetSshPublicKeys() map[string]*google_cloud_oslogin_common.SshPublicKey {
	if m != nil {
		return m.SshPublicKeys
	}
	return nil
}

func (m *LoginProfile) GetSuspended() bool {
	if m != nil {
		return m.Suspended
	}
	return false
}

// A request message for deleting a POSIX account entry.
type DeletePosixAccountRequest struct {
	// A reference to the POSIX account to update. POSIX accounts are identified
	// by the project ID they are associated with. A reference to the POSIX
	// account is in format `users/{user}/projects/{project}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeletePosixAccountRequest) Reset()                    { *m = DeletePosixAccountRequest{} }
func (m *DeletePosixAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*DeletePosixAccountRequest) ProtoMessage()               {}
func (*DeletePosixAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *DeletePosixAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for deleting an SSH public key.
type DeleteSshPublicKeyRequest struct {
	// The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteSshPublicKeyRequest) Reset()                    { *m = DeleteSshPublicKeyRequest{} }
func (m *DeleteSshPublicKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSshPublicKeyRequest) ProtoMessage()               {}
func (*DeleteSshPublicKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *DeleteSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for retrieving the login profile information for a user.
type GetLoginProfileRequest struct {
	// The unique ID for the user in format `users/{user}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetLoginProfileRequest) Reset()                    { *m = GetLoginProfileRequest{} }
func (m *GetLoginProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLoginProfileRequest) ProtoMessage()               {}
func (*GetLoginProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GetLoginProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for retrieving an SSH public key.
type GetSshPublicKeyRequest struct {
	// The fingerprint of the public key to retrieve. Public keys are identified
	// by their SHA-256 fingerprint. The fingerprint of the public key is in
	// format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetSshPublicKeyRequest) Reset()                    { *m = GetSshPublicKeyRequest{} }
func (m *GetSshPublicKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSshPublicKeyRequest) ProtoMessage()               {}
func (*GetSshPublicKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for importing an SSH public key.
type ImportSshPublicKeyRequest struct {
	// The unique ID for the user in format `users/{user}`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The SSH public key and expiration time.
	SshPublicKey *google_cloud_oslogin_common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey" json:"ssh_public_key,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *ImportSshPublicKeyRequest) Reset()                    { *m = ImportSshPublicKeyRequest{} }
func (m *ImportSshPublicKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyRequest) ProtoMessage()               {}
func (*ImportSshPublicKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ImportSshPublicKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportSshPublicKeyRequest) GetSshPublicKey() *google_cloud_oslogin_common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *ImportSshPublicKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// A response message for importing an SSH public key.
type ImportSshPublicKeyResponse struct {
	// The login profile information for the user.
	LoginProfile *LoginProfile `protobuf:"bytes,1,opt,name=login_profile,json=loginProfile" json:"login_profile,omitempty"`
}

func (m *ImportSshPublicKeyResponse) Reset()                    { *m = ImportSshPublicKeyResponse{} }
func (m *ImportSshPublicKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyResponse) ProtoMessage()               {}
func (*ImportSshPublicKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ImportSshPublicKeyResponse) GetLoginProfile() *LoginProfile {
	if m != nil {
		return m.LoginProfile
	}
	return nil
}

// A request message for updating an SSH public key.
type UpdateSshPublicKeyRequest struct {
	// The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The SSH public key and expiration time.
	SshPublicKey *google_cloud_oslogin_common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey" json:"ssh_public_key,omitempty"`
	// Mask to control which fields get updated. Updates all if not present.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateSshPublicKeyRequest) Reset()                    { *m = UpdateSshPublicKeyRequest{} }
func (m *UpdateSshPublicKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSshPublicKeyRequest) ProtoMessage()               {}
func (*UpdateSshPublicKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *UpdateSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSshPublicKeyRequest) GetSshPublicKey() *google_cloud_oslogin_common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *UpdateSshPublicKeyRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterType((*LoginProfile)(nil), "google.cloud.oslogin.v1beta.LoginProfile")
	proto.RegisterType((*DeletePosixAccountRequest)(nil), "google.cloud.oslogin.v1beta.DeletePosixAccountRequest")
	proto.RegisterType((*DeleteSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.DeleteSshPublicKeyRequest")
	proto.RegisterType((*GetLoginProfileRequest)(nil), "google.cloud.oslogin.v1beta.GetLoginProfileRequest")
	proto.RegisterType((*GetSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.GetSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.ImportSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyResponse)(nil), "google.cloud.oslogin.v1beta.ImportSshPublicKeyResponse")
	proto.RegisterType((*UpdateSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1beta.UpdateSshPublicKeyRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OsLoginService service

type OsLoginServiceClient interface {
	// Deletes a POSIX account.
	DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*google_cloud_oslogin_common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*google_cloud_oslogin_common.SshPublicKey, error)
}

type osLoginServiceClient struct {
	cc *grpc.ClientConn
}

func NewOsLoginServiceClient(cc *grpc.ClientConn) OsLoginServiceClient {
	return &osLoginServiceClient{cc}
}

func (c *osLoginServiceClient) DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error) {
	out := new(LoginProfile)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*google_cloud_oslogin_common.SshPublicKey, error) {
	out := new(google_cloud_oslogin_common.SshPublicKey)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error) {
	out := new(ImportSshPublicKeyResponse)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*google_cloud_oslogin_common.SshPublicKey, error) {
	out := new(google_cloud_oslogin_common.SshPublicKey)
	err := grpc.Invoke(ctx, "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OsLoginService service

type OsLoginServiceServer interface {
	// Deletes a POSIX account.
	DeletePosixAccount(context.Context, *DeletePosixAccountRequest) (*google_protobuf1.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(context.Context, *DeleteSshPublicKeyRequest) (*google_protobuf1.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(context.Context, *GetLoginProfileRequest) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(context.Context, *GetSshPublicKeyRequest) (*google_cloud_oslogin_common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(context.Context, *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(context.Context, *UpdateSshPublicKeyRequest) (*google_cloud_oslogin_common.SshPublicKey, error)
}

func RegisterOsLoginServiceServer(s *grpc.Server, srv OsLoginServiceServer) {
	s.RegisterService(&_OsLoginService_serviceDesc, srv)
}

func _OsLoginService_DeletePosixAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePosixAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeletePosixAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, req.(*DeletePosixAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_DeleteSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/DeleteSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, req.(*DeleteSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetLoginProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoginProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetLoginProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, req.(*GetLoginProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/GetSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, req.(*GetSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_ImportSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/ImportSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, req.(*ImportSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_UpdateSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1beta.OsLoginService/UpdateSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, req.(*UpdateSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OsLoginService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.oslogin.v1beta.OsLoginService",
	HandlerType: (*OsLoginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeletePosixAccount",
			Handler:    _OsLoginService_DeletePosixAccount_Handler,
		},
		{
			MethodName: "DeleteSshPublicKey",
			Handler:    _OsLoginService_DeleteSshPublicKey_Handler,
		},
		{
			MethodName: "GetLoginProfile",
			Handler:    _OsLoginService_GetLoginProfile_Handler,
		},
		{
			MethodName: "GetSshPublicKey",
			Handler:    _OsLoginService_GetSshPublicKey_Handler,
		},
		{
			MethodName: "ImportSshPublicKey",
			Handler:    _OsLoginService_ImportSshPublicKey_Handler,
		},
		{
			MethodName: "UpdateSshPublicKey",
			Handler:    _OsLoginService_UpdateSshPublicKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/oslogin/v1beta/oslogin.proto",
}

func init() { proto.RegisterFile("google/cloud/oslogin/v1beta/oslogin.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 780 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcd, 0x4e, 0xdb, 0x4a,
	0x14, 0x96, 0x13, 0x2e, 0x82, 0x21, 0xc0, 0xd5, 0x2c, 0x50, 0x30, 0x5c, 0xdd, 0x60, 0xd4, 0x2a,
	0x84, 0xca, 0x16, 0x41, 0x6a, 0x11, 0x94, 0x56, 0x0d, 0xa5, 0x08, 0xf5, 0x87, 0x28, 0xa8, 0x2c,
	0x2a, 0xa4, 0x68, 0x62, 0x0f, 0xc6, 0x8d, 0xed, 0x99, 0x7a, 0x6c, 0xd4, 0xa8, 0x62, 0x53, 0xa9,
	0xeb, 0x2e, 0xda, 0x75, 0xa5, 0xaa, 0xbb, 0xee, 0xba, 0xea, 0xaa, 0x2f, 0xc0, 0xb6, 0xaf, 0xd0,
	0xbe, 0x47, 0xe5, 0xf1, 0x18, 0x9c, 0xc4, 0x49, 0x8c, 0xd4, 0x9d, 0x67, 0xce, 0x39, 0xdf, 0xf9,
	0xe6, 0x3b, 0x3f, 0x32, 0x58, 0x31, 0x09, 0x31, 0x6d, 0xac, 0xe9, 0x36, 0x09, 0x0c, 0x8d, 0x30,
	0x9b, 0x98, 0x96, 0xab, 0x9d, 0xad, 0xb5, 0xb0, 0x8f, 0xe2, 0xa3, 0x4a, 0x3d, 0xe2, 0x13, 0xb8,
	0x10, 0xb9, 0xaa, 0xdc, 0x55, 0x8d, 0x6d, 0x91, 0xab, 0xbc, 0x28, 0x70, 0x10, 0xb5, 0x34, 0xe4,
	0xba, 0xc4, 0x47, 0xbe, 0x45, 0x5c, 0x16, 0x85, 0xca, 0x4b, 0xa9, 0x59, 0x74, 0xe2, 0x38, 0x44,
	0xa0, 0xcb, 0x02, 0x5d, 0xe3, 0xa7, 0x56, 0x70, 0xa2, 0x61, 0x87, 0xfa, 0x1d, 0x61, 0x2c, 0xf5,
	0x1a, 0x4f, 0x2c, 0x6c, 0x1b, 0x4d, 0x07, 0xb1, 0x76, 0xe4, 0xa1, 0xfc, 0xce, 0x81, 0xc2, 0x93,
	0x10, 0xb5, 0xee, 0x91, 0x13, 0xcb, 0xc6, 0x10, 0x82, 0x31, 0x17, 0x39, 0xb8, 0x28, 0x95, 0xa4,
	0xf2, 0x64, 0x83, 0x7f, 0xc3, 0x3a, 0x98, 0xa1, 0x84, 0x59, 0xaf, 0x9b, 0x48, 0xd7, 0x49, 0xe0,
	0xfa, 0xac, 0x98, 0x2b, 0xe5, 0xcb, 0x53, 0xd5, 0x15, 0x35, 0xf5, 0x69, 0x82, 0x5f, 0x3d, 0x0c,
	0x79, 0x10, 0x45, 0x34, 0xa6, 0x69, 0xe2, 0xc4, 0xa0, 0x01, 0x66, 0x19, 0x3b, 0x6d, 0xd2, 0xa0,
	0x65, 0x5b, 0x7a, 0xb3, 0x8d, 0x3b, 0xac, 0x98, 0xe7, 0x90, 0x77, 0xd5, 0x21, 0x6a, 0xa9, 0x49,
	0xa6, 0xea, 0x21, 0x3b, 0xad, 0xf3, 0xf8, 0xc7, 0xb8, 0xc3, 0x76, 0x5d, 0xdf, 0xeb, 0x34, 0xa6,
	0x59, 0xf2, 0x0e, 0x2e, 0x82, 0x49, 0x16, 0x30, 0x8a, 0x5d, 0x03, 0x1b, 0xc5, 0xb1, 0x92, 0x54,
	0x9e, 0x68, 0x5c, 0x5d, 0xc8, 0x6d, 0x00, 0xfb, 0x21, 0xe0, 0xbf, 0x20, 0xdf, 0xc6, 0x1d, 0xf1,
	0xfc, 0xf0, 0x13, 0xde, 0x07, 0xff, 0x9c, 0x21, 0x3b, 0xc0, 0xc5, 0x5c, 0x49, 0x1a, 0xf9, 0xe8,
	0x24, 0x62, 0x23, 0x8a, 0xdb, 0xcc, 0x6d, 0x48, 0x8a, 0x06, 0xe6, 0x1f, 0x62, 0x1b, 0xfb, 0xb8,
	0x4b, 0x15, 0xfc, 0x2a, 0xc0, 0xcc, 0x4f, 0xd3, 0xfc, 0x2a, 0xa0, 0x0b, 0x71, 0x48, 0xc0, 0x2d,
	0x30, 0xb7, 0x87, 0xfd, 0xa4, 0x42, 0xa3, 0xbd, 0xb3, 0x62, 0x7f, 0x91, 0xc0, 0xfc, 0xbe, 0x43,
	0x89, 0x97, 0x1a, 0x31, 0x07, 0xc6, 0x29, 0xf2, 0xb0, 0xeb, 0x8b, 0x18, 0x71, 0x82, 0x07, 0x60,
	0xa6, 0xbb, 0xc8, 0xd7, 0x57, 0xb0, 0x90, 0x2c, 0x28, 0xfc, 0x0f, 0x00, 0xea, 0x91, 0x97, 0x58,
	0xf7, 0x9b, 0x96, 0x51, 0xcc, 0xf3, 0x64, 0x93, 0xe2, 0x66, 0xdf, 0x50, 0x6c, 0x20, 0xa7, 0x91,
	0x64, 0x94, 0xb8, 0x0c, 0xc3, 0x67, 0x60, 0x9a, 0xe7, 0x69, 0xd2, 0x48, 0x1d, 0x4e, 0x76, 0x20,
	0x99, 0x94, 0x86, 0x6b, 0x14, 0xec, 0xc4, 0x49, 0xf9, 0x21, 0x81, 0xf9, 0xe7, 0xd4, 0x40, 0x99,
	0x2b, 0xf4, 0xf7, 0xf5, 0xd8, 0x02, 0x53, 0x01, 0x67, 0xc0, 0x27, 0x9a, 0x0b, 0x32, 0x55, 0x95,
	0x63, 0xb4, 0x78, 0xe8, 0xd5, 0x47, 0xe1, 0xd0, 0x3f, 0x45, 0xac, 0xdd, 0x00, 0x91, 0x7b, 0xf8,
	0x5d, 0x7d, 0x37, 0x01, 0x66, 0x0e, 0x18, 0x7f, 0xe0, 0x21, 0xf6, 0xce, 0x2c, 0x1d, 0xc3, 0xf7,
	0x12, 0x80, 0xfd, 0x5d, 0x0a, 0x6f, 0x0f, 0x95, 0x68, 0x60, 0x5b, 0xcb, 0x73, 0x7d, 0x4c, 0x76,
	0xc3, 0xdd, 0xa4, 0xac, 0xbc, 0xfd, 0xf9, 0xeb, 0x43, 0x6e, 0xb9, 0xb2, 0x14, 0xef, 0xcb, 0x37,
	0xa1, 0x3c, 0xdb, 0x01, 0xc3, 0x1e, 0xd3, 0x2a, 0x9a, 0x28, 0x28, 0xd3, 0x2a, 0xe7, 0xf0, 0xe3,
	0x25, 0xa3, 0xa4, 0x0c, 0x99, 0x18, 0xa5, 0x54, 0x65, 0x20, 0x23, 0x95, 0x33, 0x2a, 0x57, 0x6e,
	0xa6, 0x33, 0xea, 0xda, 0x2a, 0x21, 0xad, 0x4f, 0x12, 0x98, 0xed, 0x19, 0x36, 0xb8, 0x3e, 0x94,
	0x53, 0xfa, 0x68, 0xca, 0xd9, 0xbb, 0x4f, 0x59, 0xe5, 0x1c, 0x6f, 0xc0, 0xe5, 0x54, 0x8e, 0xe7,
	0x5a, 0xb2, 0x39, 0xe1, 0xe7, 0x88, 0x60, 0x97, 0x68, 0x23, 0x09, 0xa6, 0x29, 0x96, 0xbd, 0x37,
	0x63, 0x11, 0x61, 0x56, 0x11, 0x2f, 0x24, 0x00, 0xfb, 0xe7, 0x75, 0x44, 0x6d, 0x07, 0x6e, 0x21,
	0xf9, 0xce, 0xb5, 0xe3, 0xa2, 0xc5, 0xa0, 0xec, 0x70, 0xde, 0xdb, 0xca, 0xea, 0x25, 0xef, 0x68,
	0x7f, 0x5d, 0x4a, 0xbb, 0x69, 0xf5, 0x05, 0x6f, 0xf6, 0x4c, 0x32, 0xfc, 0x2e, 0x01, 0xd8, 0xbf,
	0x0d, 0x46, 0x3c, 0x66, 0xe0, 0xfa, 0xb8, 0x8e, 0xec, 0xf7, 0x38, 0xfd, 0x8d, 0x6a, 0x46, 0xd9,
	0x7b, 0x99, 0xd7, 0xbe, 0x49, 0xe0, 0x7f, 0x9d, 0x38, 0xc3, 0x88, 0xd6, 0x0a, 0x62, 0x51, 0xd4,
	0xc3, 0xb1, 0xa9, 0x4b, 0x2f, 0x6a, 0xc2, 0xd9, 0x24, 0x36, 0x72, 0x4d, 0x95, 0x78, 0xa6, 0x66,
	0x62, 0x97, 0x0f, 0x95, 0x16, 0x99, 0x10, 0xb5, 0x58, 0xea, 0xcf, 0xd1, 0x96, 0x38, 0x7e, 0xcd,
	0x2d, 0xec, 0x45, 0x20, 0x3b, 0x3c, 0xa3, 0xc8, 0xa0, 0x1e, 0xad, 0xd5, 0xb0, 0x8f, 0x2e, 0x62,
	0xeb, 0x31, 0xb7, 0x1e, 0x0b, 0xeb, 0xf1, 0x11, 0xc7, 0x68, 0x8d, 0xf3, 0x54, 0xeb, 0x7f, 0x02,
	0x00, 0x00, 0xff, 0xff, 0x63, 0x03, 0xf6, 0x66, 0x86, 0x09, 0x00, 0x00,
}
