// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/custom_interest_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomInterestService.GetCustomInterest][google.ads.googleads.v2.services.CustomInterestService.GetCustomInterest].
type GetCustomInterestRequest struct {
	// Required. The resource name of the custom interest to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomInterestRequest) Reset()         { *m = GetCustomInterestRequest{} }
func (m *GetCustomInterestRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomInterestRequest) ProtoMessage()    {}
func (*GetCustomInterestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a70a4da2ad94b8a5, []int{0}
}

func (m *GetCustomInterestRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomInterestRequest.Unmarshal(m, b)
}
func (m *GetCustomInterestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomInterestRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomInterestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomInterestRequest.Merge(m, src)
}
func (m *GetCustomInterestRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomInterestRequest.Size(m)
}
func (m *GetCustomInterestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomInterestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomInterestRequest proto.InternalMessageInfo

func (m *GetCustomInterestRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomInterestService.MutateCustomInterests][google.ads.googleads.v2.services.CustomInterestService.MutateCustomInterests].
type MutateCustomInterestsRequest struct {
	// Required. The ID of the customer whose custom interests are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual custom interests.
	Operations []*CustomInterestOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomInterestsRequest) Reset()         { *m = MutateCustomInterestsRequest{} }
func (m *MutateCustomInterestsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestsRequest) ProtoMessage()    {}
func (*MutateCustomInterestsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a70a4da2ad94b8a5, []int{1}
}

func (m *MutateCustomInterestsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestsRequest.Unmarshal(m, b)
}
func (m *MutateCustomInterestsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestsRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestsRequest.Merge(m, src)
}
func (m *MutateCustomInterestsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestsRequest.Size(m)
}
func (m *MutateCustomInterestsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestsRequest proto.InternalMessageInfo

func (m *MutateCustomInterestsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomInterestsRequest) GetOperations() []*CustomInterestOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomInterestsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update) on a custom interest.
type CustomInterestOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomInterestOperation_Create
	//	*CustomInterestOperation_Update
	Operation            isCustomInterestOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *CustomInterestOperation) Reset()         { *m = CustomInterestOperation{} }
func (m *CustomInterestOperation) String() string { return proto.CompactTextString(m) }
func (*CustomInterestOperation) ProtoMessage()    {}
func (*CustomInterestOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_a70a4da2ad94b8a5, []int{2}
}

func (m *CustomInterestOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInterestOperation.Unmarshal(m, b)
}
func (m *CustomInterestOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInterestOperation.Marshal(b, m, deterministic)
}
func (m *CustomInterestOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInterestOperation.Merge(m, src)
}
func (m *CustomInterestOperation) XXX_Size() int {
	return xxx_messageInfo_CustomInterestOperation.Size(m)
}
func (m *CustomInterestOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInterestOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInterestOperation proto.InternalMessageInfo

func (m *CustomInterestOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomInterestOperation_Operation interface {
	isCustomInterestOperation_Operation()
}

type CustomInterestOperation_Create struct {
	Create *resources.CustomInterest `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomInterestOperation_Update struct {
	Update *resources.CustomInterest `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomInterestOperation_Create) isCustomInterestOperation_Operation() {}

func (*CustomInterestOperation_Update) isCustomInterestOperation_Operation() {}

func (m *CustomInterestOperation) GetOperation() isCustomInterestOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomInterestOperation) GetCreate() *resources.CustomInterest {
	if x, ok := m.GetOperation().(*CustomInterestOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomInterestOperation) GetUpdate() *resources.CustomInterest {
	if x, ok := m.GetOperation().(*CustomInterestOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomInterestOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomInterestOperation_Create)(nil),
		(*CustomInterestOperation_Update)(nil),
	}
}

// Response message for custom interest mutate.
type MutateCustomInterestsResponse struct {
	// All results for the mutate.
	Results              []*MutateCustomInterestResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *MutateCustomInterestsResponse) Reset()         { *m = MutateCustomInterestsResponse{} }
func (m *MutateCustomInterestsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestsResponse) ProtoMessage()    {}
func (*MutateCustomInterestsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a70a4da2ad94b8a5, []int{3}
}

func (m *MutateCustomInterestsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestsResponse.Unmarshal(m, b)
}
func (m *MutateCustomInterestsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestsResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestsResponse.Merge(m, src)
}
func (m *MutateCustomInterestsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestsResponse.Size(m)
}
func (m *MutateCustomInterestsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestsResponse proto.InternalMessageInfo

func (m *MutateCustomInterestsResponse) GetResults() []*MutateCustomInterestResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the custom interest mutate.
type MutateCustomInterestResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomInterestResult) Reset()         { *m = MutateCustomInterestResult{} }
func (m *MutateCustomInterestResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomInterestResult) ProtoMessage()    {}
func (*MutateCustomInterestResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a70a4da2ad94b8a5, []int{4}
}

func (m *MutateCustomInterestResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomInterestResult.Unmarshal(m, b)
}
func (m *MutateCustomInterestResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomInterestResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomInterestResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomInterestResult.Merge(m, src)
}
func (m *MutateCustomInterestResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomInterestResult.Size(m)
}
func (m *MutateCustomInterestResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomInterestResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomInterestResult proto.InternalMessageInfo

func (m *MutateCustomInterestResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomInterestRequest)(nil), "google.ads.googleads.v2.services.GetCustomInterestRequest")
	proto.RegisterType((*MutateCustomInterestsRequest)(nil), "google.ads.googleads.v2.services.MutateCustomInterestsRequest")
	proto.RegisterType((*CustomInterestOperation)(nil), "google.ads.googleads.v2.services.CustomInterestOperation")
	proto.RegisterType((*MutateCustomInterestsResponse)(nil), "google.ads.googleads.v2.services.MutateCustomInterestsResponse")
	proto.RegisterType((*MutateCustomInterestResult)(nil), "google.ads.googleads.v2.services.MutateCustomInterestResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/custom_interest_service.proto", fileDescriptor_a70a4da2ad94b8a5)
}

var fileDescriptor_a70a4da2ad94b8a5 = []byte{
	// 703 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4f, 0x6b, 0xd4, 0x40,
	0x14, 0x37, 0x59, 0xa9, 0x76, 0xb6, 0x3d, 0x18, 0xa8, 0x5d, 0x63, 0xc5, 0x25, 0x16, 0xac, 0x8b,
	0x24, 0x34, 0x15, 0xa4, 0xa9, 0xad, 0xcc, 0x0a, 0xb6, 0x45, 0x6a, 0x4b, 0x94, 0x45, 0x64, 0x71,
	0x99, 0x6e, 0xa6, 0x6b, 0x68, 0x92, 0x89, 0x99, 0xc9, 0x4a, 0x29, 0x3d, 0xe8, 0x57, 0xf0, 0x1b,
	0x78, 0xf4, 0x9b, 0x58, 0xf0, 0xe4, 0xad, 0xa7, 0x1e, 0x3c, 0x79, 0xf4, 0xa6, 0x20, 0x48, 0x32,
	0x33, 0xfb, 0xa7, 0x6e, 0x58, 0xac, 0xb7, 0xb7, 0x79, 0xbf, 0xf7, 0x7b, 0x7f, 0x7e, 0xef, 0xcd,
	0x82, 0xb5, 0x0e, 0x21, 0x9d, 0x00, 0x5b, 0xc8, 0xa3, 0x16, 0x37, 0x33, 0xab, 0x6b, 0x5b, 0x14,
	0x27, 0x5d, 0xbf, 0x8d, 0xa9, 0xd5, 0x4e, 0x29, 0x23, 0x61, 0xcb, 0x8f, 0x18, 0x4e, 0x30, 0x65,
	0x2d, 0xe1, 0x30, 0xe3, 0x84, 0x30, 0xa2, 0x55, 0x79, 0x90, 0x89, 0x3c, 0x6a, 0xf6, 0xe2, 0xcd,
	0xae, 0x6d, 0xca, 0x78, 0xfd, 0x7e, 0x51, 0x86, 0x04, 0x53, 0x92, 0x26, 0x23, 0x52, 0x70, 0x6a,
	0x7d, 0x4e, 0x06, 0xc6, 0xbe, 0x85, 0xa2, 0x88, 0x30, 0xc4, 0x7c, 0x12, 0x51, 0xe1, 0x9d, 0x1d,
	0xf0, 0xb6, 0x03, 0x1f, 0x47, 0x32, 0xec, 0xe6, 0x80, 0x63, 0xcf, 0xc7, 0x81, 0xd7, 0xda, 0xc5,
	0xaf, 0x51, 0xd7, 0x27, 0x89, 0x00, 0x5c, 0x1b, 0x00, 0xc8, 0x1a, 0x84, 0x4b, 0x74, 0x63, 0xe5,
	0xbf, 0x76, 0xd3, 0x3d, 0x41, 0x10, 0x22, 0xba, 0xcf, 0x11, 0x46, 0x0c, 0x2a, 0xeb, 0x98, 0x3d,
	0xca, 0x0b, 0xde, 0x14, 0xf5, 0xba, 0xf8, 0x4d, 0x8a, 0x29, 0xd3, 0x9e, 0x83, 0x69, 0xc9, 0xd7,
	0x8a, 0x50, 0x88, 0x2b, 0x4a, 0x55, 0x59, 0x98, 0xac, 0x5b, 0xa7, 0x50, 0xfd, 0x05, 0xef, 0x80,
	0xdb, 0xfd, 0xf9, 0x08, 0x2b, 0xf6, 0xa9, 0xd9, 0x26, 0xa1, 0x75, 0x86, 0x6e, 0x4a, 0xb2, 0x3c,
	0x45, 0x21, 0x36, 0x3e, 0x2b, 0x60, 0x6e, 0x2b, 0x65, 0x88, 0xe1, 0x61, 0x18, 0x95, 0x69, 0xe7,
	0x41, 0x99, 0x0f, 0x10, 0x27, 0x2d, 0xdf, 0x13, 0x49, 0x4b, 0xa7, 0x50, 0x75, 0x81, 0xfc, 0xbe,
	0xe9, 0x69, 0xaf, 0x00, 0x20, 0x31, 0x4e, 0xf8, 0x0c, 0x2b, 0x6a, 0xb5, 0xb4, 0x50, 0xb6, 0x97,
	0xcd, 0x71, 0xea, 0x99, 0xc3, 0x39, 0xb7, 0x25, 0x83, 0xe0, 0xef, 0x33, 0x6a, 0xb7, 0xc0, 0x74,
	0x17, 0x05, 0xbe, 0x87, 0x18, 0x6e, 0x91, 0x28, 0x38, 0xa8, 0x5c, 0xac, 0x2a, 0x0b, 0x97, 0xdd,
	0x29, 0xf9, 0x71, 0x3b, 0x0a, 0x0e, 0x8c, 0xdf, 0x0a, 0x98, 0x2d, 0x60, 0xd4, 0x56, 0x40, 0x39,
	0x8d, 0xf3, 0xf0, 0x6c, 0xdc, 0x79, 0x78, 0xd9, 0xd6, 0x65, 0x85, 0x52, 0x11, 0xf3, 0x71, 0xa6,
	0xc8, 0x16, 0xa2, 0xfb, 0x2e, 0xe0, 0xf0, 0xcc, 0xd6, 0x9e, 0x80, 0x89, 0x76, 0x82, 0x11, 0xe3,
	0x33, 0x2f, 0xdb, 0x8b, 0x85, 0x9d, 0xf5, 0xb6, 0xee, 0x4c, 0x6b, 0x1b, 0x17, 0x5c, 0x41, 0x91,
	0x91, 0x71, 0xea, 0x8a, 0xfa, 0x1f, 0x64, 0x9c, 0xa2, 0x5e, 0x06, 0x93, 0xbd, 0x29, 0x19, 0x6f,
	0xc1, 0x8d, 0x02, 0x29, 0x69, 0x4c, 0x22, 0x8a, 0xb5, 0x06, 0xb8, 0x94, 0x60, 0x9a, 0x06, 0x4c,
	0x4a, 0xf4, 0x60, 0xbc, 0x44, 0xa3, 0x18, 0xdd, 0x9c, 0xc4, 0x95, 0x64, 0x06, 0x04, 0x7a, 0x31,
	0x2c, 0xd3, 0x6e, 0xc4, 0xe2, 0x0e, 0xef, 0xa1, 0xfd, 0xb3, 0x04, 0x66, 0x86, 0xa3, 0x9f, 0xf1,
	0x0a, 0xb4, 0x2f, 0x0a, 0xb8, 0xf2, 0xd7, 0x51, 0x68, 0xce, 0xf8, 0xca, 0x8b, 0x2e, 0x49, 0xff,
	0xf7, 0x89, 0x1b, 0x9b, 0x27, 0x70, 0xb8, 0x89, 0xf7, 0x5f, 0xbf, 0x7d, 0x50, 0x97, 0xb4, 0xc5,
	0xec, 0xa9, 0x39, 0x1c, 0xf2, 0xac, 0xca, 0xb3, 0xa0, 0x56, 0x4d, 0xbc, 0x3d, 0x3d, 0x25, 0xac,
	0xda, 0x91, 0xf6, 0x43, 0x01, 0x33, 0x23, 0x65, 0xd2, 0xd6, 0xce, 0xa7, 0x86, 0x3c, 0x55, 0xfd,
	0xe1, 0xb9, 0xe3, 0xf9, 0x7e, 0x18, 0x2f, 0x4e, 0xe0, 0xd5, 0x81, 0x63, 0xbf, 0xdb, 0x3f, 0xc0,
	0xbc, 0xdd, 0x65, 0xe3, 0x5e, 0xd6, 0x6e, 0xbf, 0xbf, 0xc3, 0x01, 0xf0, 0x6a, 0xed, 0xe8, 0x6c,
	0xb7, 0x4e, 0x98, 0x67, 0x73, 0x94, 0x9a, 0x7e, 0xfd, 0x18, 0x56, 0x8a, 0x1e, 0xa8, 0xfa, 0x3b,
	0x15, 0xcc, 0xb7, 0x49, 0x38, 0xb6, 0xfa, 0xba, 0x3e, 0x72, 0x43, 0x76, 0xb2, 0xe3, 0xdd, 0x51,
	0x5e, 0x6e, 0x88, 0xf8, 0x0e, 0x09, 0x50, 0xd4, 0x31, 0x49, 0xd2, 0xb1, 0x3a, 0x38, 0xca, 0x4f,
	0xdb, 0xea, 0x67, 0x2c, 0xfe, 0x2f, 0x5a, 0x91, 0xc6, 0x47, 0xb5, 0xb4, 0x0e, 0xe1, 0x27, 0xb5,
	0xba, 0xce, 0x09, 0xa1, 0x47, 0x4d, 0x6e, 0x66, 0x56, 0xc3, 0x36, 0x45, 0x62, 0x7a, 0x2c, 0x21,
	0x4d, 0xe8, 0xd1, 0x66, 0x0f, 0xd2, 0x6c, 0xd8, 0x4d, 0x09, 0xf9, 0xae, 0xce, 0xf3, 0xef, 0x8e,
	0x03, 0x3d, 0xea, 0x38, 0x3d, 0x90, 0xe3, 0x34, 0x6c, 0xc7, 0x91, 0xb0, 0xdd, 0x89, 0xbc, 0xce,
	0xa5, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xbd, 0xe2, 0x62, 0xcc, 0x32, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomInterestServiceClient is the client API for CustomInterestService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomInterestServiceClient interface {
	// Returns the requested custom interest in full detail.
	GetCustomInterest(ctx context.Context, in *GetCustomInterestRequest, opts ...grpc.CallOption) (*resources.CustomInterest, error)
	// Creates or updates custom interests. Operation statuses are returned.
	MutateCustomInterests(ctx context.Context, in *MutateCustomInterestsRequest, opts ...grpc.CallOption) (*MutateCustomInterestsResponse, error)
}

type customInterestServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomInterestServiceClient(cc grpc.ClientConnInterface) CustomInterestServiceClient {
	return &customInterestServiceClient{cc}
}

func (c *customInterestServiceClient) GetCustomInterest(ctx context.Context, in *GetCustomInterestRequest, opts ...grpc.CallOption) (*resources.CustomInterest, error) {
	out := new(resources.CustomInterest)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomInterestService/GetCustomInterest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customInterestServiceClient) MutateCustomInterests(ctx context.Context, in *MutateCustomInterestsRequest, opts ...grpc.CallOption) (*MutateCustomInterestsResponse, error) {
	out := new(MutateCustomInterestsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.CustomInterestService/MutateCustomInterests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomInterestServiceServer is the server API for CustomInterestService service.
type CustomInterestServiceServer interface {
	// Returns the requested custom interest in full detail.
	GetCustomInterest(context.Context, *GetCustomInterestRequest) (*resources.CustomInterest, error)
	// Creates or updates custom interests. Operation statuses are returned.
	MutateCustomInterests(context.Context, *MutateCustomInterestsRequest) (*MutateCustomInterestsResponse, error)
}

// UnimplementedCustomInterestServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomInterestServiceServer struct {
}

func (*UnimplementedCustomInterestServiceServer) GetCustomInterest(ctx context.Context, req *GetCustomInterestRequest) (*resources.CustomInterest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomInterest not implemented")
}
func (*UnimplementedCustomInterestServiceServer) MutateCustomInterests(ctx context.Context, req *MutateCustomInterestsRequest) (*MutateCustomInterestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomInterests not implemented")
}

func RegisterCustomInterestServiceServer(s *grpc.Server, srv CustomInterestServiceServer) {
	s.RegisterService(&_CustomInterestService_serviceDesc, srv)
}

func _CustomInterestService_GetCustomInterest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomInterestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomInterestServiceServer).GetCustomInterest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomInterestService/GetCustomInterest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomInterestServiceServer).GetCustomInterest(ctx, req.(*GetCustomInterestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomInterestService_MutateCustomInterests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomInterestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomInterestServiceServer).MutateCustomInterests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.CustomInterestService/MutateCustomInterests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomInterestServiceServer).MutateCustomInterests(ctx, req.(*MutateCustomInterestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomInterestService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.CustomInterestService",
	HandlerType: (*CustomInterestServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomInterest",
			Handler:    _CustomInterestService_GetCustomInterest_Handler,
		},
		{
			MethodName: "MutateCustomInterests",
			Handler:    _CustomInterestService_MutateCustomInterests_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/custom_interest_service.proto",
}
