#include <qglobal.h>
#include <qtimer.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_canvas.h>
#include <qwt_plot_layout.h>
#include <qwt_scale_widget.h>
#include <qwt_scale_draw.h>
#include "scrollzoomer.h"
#include "randomplot.h"

const unsigned int c_rangeMax = 1000;

class Zoomer: public ScrollZoomer
{
public:
    Zoomer(QwtPlotCanvas *canvas):
        ScrollZoomer(canvas)
    {
#if 0
        setRubberBandPen(QPen(Qt::red, 2, Qt::DotLine));
#else
        setRubberBandPen(QPen(Qt::red));
#endif
    }

    virtual QwtText trackerTextF(const QPointF &pos) const
    {
        QColor bg(Qt::white);

        QwtText text = QwtPlotZoomer::trackerTextF(pos);
        text.setBackgroundBrush( QBrush( bg ));
        return text;
    }

    virtual void rescale()
    {
        QwtScaleWidget *scaleWidget = plot()->axisWidget(yAxis());
        QwtScaleDraw *sd = scaleWidget->scaleDraw();

        int minExtent = 0;
        if ( zoomRectIndex() > 0 )
        {
            // When scrolling in vertical direction
            // the plot is jumping in horizontal direction
            // because of the different widths of the labels
            // So we better use a fixed extent.

            minExtent = sd->spacing() + sd->maxTickLength() + 1;
            minExtent += sd->labelSize(
                scaleWidget->font(), c_rangeMax).width();
        }

        sd->setMinimumExtent(minExtent);

        ScrollZoomer::rescale();
    }
};

RandomPlot::RandomPlot(QWidget *parent):
    IncrementalPlot(parent),
    d_timer(0),
    d_timerCount(0)
{
    setFrameStyle(QFrame::NoFrame);
    setLineWidth(0);
    setCanvasLineWidth(2);

    plotLayout()->setAlignCanvasToScales(true);

    QwtPlotGrid *grid = new QwtPlotGrid;
    grid->setMajPen(QPen(Qt::gray, 0, Qt::DotLine));
    grid->attach(this);

    setCanvasBackground(QColor(29, 100, 141)); // nice blue

    setAxisScale(xBottom, 0, c_rangeMax);
    setAxisScale(yLeft, 0, c_rangeMax);

    replot();

    // enable zooming

    (void) new Zoomer(canvas());
}

QSize RandomPlot::sizeHint() const
{
    return QSize(540,400);
}

void RandomPlot::appendPoint()
{
    double x = qrand() % c_rangeMax;
    x += ( qrand() % 100 ) / 100;

    double y = qrand() % c_rangeMax;
    y += ( qrand() % 100 ) / 100;

    IncrementalPlot::appendPoint( QPointF( x, y ) );

    if ( --d_timerCount <= 0 )
        stop();
}

void RandomPlot::append(int timeout, int count)
{
    if ( !d_timer )
    {
        d_timer = new QTimer(this);
        connect(d_timer, SIGNAL(timeout()), SLOT(appendPoint()));
    }

    d_timerCount = count;

    Q_EMIT running(true);
    d_timeStamp.start();

    canvas()->setPaintAttribute(QwtPlotCanvas::BackingStore, false);
    d_timer->start(timeout);
}

void RandomPlot::stop()
{
    Q_EMIT elapsed( d_timeStamp.elapsed() );

    if ( d_timer )
    {
        d_timer->stop();
        Q_EMIT running(false);
    }

    canvas()->setPaintAttribute(QwtPlotCanvas::BackingStore, true);
}

void RandomPlot::clear()
{
    clearPoints();
    replot();
}
