// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/audioringbuffer.h>
#include <gstreamermm/private/audioringbuffer_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/handle_error.h>


namespace Gst
{

AudioRingBufferSpec::AudioRingBufferSpec()
: m_spec(g_try_new(GstAudioRingBufferSpec, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error(
      "Failed to allocate a new Gst::AudioRingBufferSpec.");
    return;
  }
}

AudioRingBufferSpec::AudioRingBufferSpec(const Glib::RefPtr<Gst::Caps>& caps,
  Gst::AudioRingBufferFormatType type,
  guint64 latency_time, guint64 buffer_time, int segsize, int segtotal,
  int seglatency)
: m_spec(g_try_new(GstAudioRingBufferSpec, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::AudioRingBufferSpec.");
    return;
  }

  GstAudioRingBufferSpec* spec = gobj();

  spec->caps = Glib::unwrap(caps);

  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if (caps)
    caps->reference();

  spec->type = static_cast<GstAudioRingBufferFormatType>(type);
  spec->latency_time = latency_time;
  spec->buffer_time = buffer_time;
  spec->segsize = segsize;
  spec->segtotal = segtotal;
  spec->seglatency = seglatency;
}


AudioRingBufferSpec::AudioRingBufferSpec(GstAudioRingBufferSpec& castitem, bool take_ownership)
: m_spec(&castitem),
  take_ownership(take_ownership)
{
  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if(castitem.caps)
      gst_caps_ref(castitem.caps);
}

AudioRingBufferSpec::AudioRingBufferSpec(const AudioRingBufferSpec& other)
: m_spec(g_try_new(GstAudioRingBufferSpec, 1)),
  take_ownership(true)
{
  // Handle possible memory allocation failure.
  if(!m_spec)
  {
    gstreamermm_handle_error("Failed to allocate a new Gst::AudioRingBufferSpec.");
    return;
  }

  m_spec->caps = other.m_spec->caps;

  // Keep a copy of the caps (it will be unreferenced in the destructor).
  if(m_spec->caps)
    gst_caps_ref(m_spec->caps);

  m_spec->type = other.m_spec->type;
  m_spec->latency_time = other.m_spec->latency_time;
  m_spec->buffer_time = other.m_spec->buffer_time;
  m_spec->segsize = other.m_spec->segsize;
  m_spec->segtotal = other.m_spec->segtotal;
  m_spec->seglatency = other.m_spec->seglatency;
}

AudioRingBufferSpec& AudioRingBufferSpec::operator=(const AudioRingBufferSpec& other)
{
  AudioRingBufferSpec temp(other);
  swap(temp);
  return *this;
}

AudioRingBufferSpec::~AudioRingBufferSpec()
{
  // Unref existing reference to caps.
  if(m_spec->caps)
    gst_caps_unref(m_spec->caps);

  // Release the underlying m_spec if it is owned.
  if(take_ownership)
    g_free(m_spec);
}

void AudioRingBufferSpec::swap(AudioRingBufferSpec& other)
{
  GstAudioRingBufferSpec* spec_temp = m_spec;
  m_spec = other.m_spec;
  other.m_spec = spec_temp;

  const bool take_temp = take_ownership;
  take_ownership = other.take_ownership;
  other.take_ownership = take_temp;
}

bool AudioRingBuffer::prepare_read(int& segment, std::vector<guint8>& readptr,
  int& len)
{
  guint8* c_readptr = 0;

  const bool result = static_cast<bool>(gst_audio_ring_buffer_prepare_read(gobj(), &segment, &c_readptr, &len));
  readptr.assign(c_readptr, c_readptr + len);

  if (c_readptr)
    g_free(c_readptr);

  return result;
}

gboolean AudioRingBuffer_Class::acquire_vfunc_callback(GstAudioRingBuffer* self, GstAudioRingBufferSpec* spec)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        Gst::AudioRingBufferSpec cpp_spec(*spec);

        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->acquire_vfunc(cpp_spec));

      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->acquire)
    return (*base->acquire)(self, spec);


  typedef gboolean RType;
  return RType();
}
bool Gst::AudioRingBuffer::acquire_vfunc(Gst::AudioRingBufferSpec& spec) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->acquire)
    return static_cast<bool>((*base->acquire)(gobj(), spec.gobj()));

  typedef bool RType;
  return RType();
}
guint AudioRingBuffer_Class::commit_vfunc_callback(GstAudioRingBuffer* self, guint64* sample, guchar* data, gint in_samples, gint out_samples, gint* accum)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Declare the ArrayHandle for the C++ vfunc.
        Glib::ArrayHandle<guchar> cpp_data(data, self->size, Glib::OWNERSHIP_NONE);
        // Call the virtual member method, which derived classes might override.
        return obj->commit_vfunc(*(sample), Glib::ArrayHandler<guint8>::array_to_vector(data, self->size, Glib::OWNERSHIP_NONE), in_samples, out_samples, *(accum));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->commit)
    return (*base->commit)(self, sample, data, in_samples, out_samples, accum);


  typedef guint RType;
  return RType();
}
guint Gst::AudioRingBuffer::commit_vfunc(guint64& sample, const std::vector<guint8>& data, int in_samples, int out_samples, int& accum) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->commit)
    return (*base->commit)(gobj(),&sample,Glib::ArrayHandler<guint8>::vector_to_array(data).data(),in_samples,out_samples,&accum);

  typedef guint RType;
  return RType();
}

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::AudioChannelPosition>::value_type()
{
  return gst_audio_channel_position_get_type();
}

// static
GType Glib::Value<Gst::AudioRingBufferState>::value_type()
{
  return gst_audio_ring_buffer_state_get_type();
}

// static
GType Glib::Value<Gst::AudioRingBufferFormatType>::value_type()
{
  return gst_audio_ring_buffer_format_type_get_type();
}


namespace Gst
{


 Glib::RefPtr<Gst::Caps> AudioRingBufferSpec::get_caps()
{
  Glib::RefPtr<Gst::Caps> ref_ptr(Glib::wrap(gobj()->caps));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Caps> AudioRingBufferSpec::get_caps() const
{
  Glib::RefPtr<const Gst::Caps> ref_ptr(Glib::wrap(gobj()->caps));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 
 void AudioRingBufferSpec::set_caps(const Glib::RefPtr<Gst::Caps>& value)
{
  Glib::RefPtr<Gst::Caps> valueOld(Glib::wrap(gobj()->caps)); //Take possession of the old one, unref-ing it in the destructor.

  if(value)
    value->reference(); //Ref once for the recipient.

  gobj()->caps = Glib::unwrap(value);
}
 
 Gst::AudioRingBufferFormatType AudioRingBufferSpec::get_type() const
{
  return ((Gst::AudioRingBufferFormatType)(gobj()->type));
}
 
 void AudioRingBufferSpec::set_type(const Gst::AudioRingBufferFormatType& value)
{
  gobj()->type = ((GstAudioRingBufferFormatType)(value));
}
 
 guint64 AudioRingBufferSpec::get_latency_time() const
{
  return gobj()->latency_time;
}
 
 void AudioRingBufferSpec::set_latency_time(const guint64& value)
{
  gobj()->latency_time = value;
}
 
 guint64 AudioRingBufferSpec::get_buffer_time() const
{
  return gobj()->buffer_time;
}
 
 void AudioRingBufferSpec::set_buffer_time(const guint64& value)
{
  gobj()->buffer_time = value;
}
 
 int AudioRingBufferSpec::get_segsize() const
{
  return gobj()->segsize;
}
 
 void AudioRingBufferSpec::set_segsize(const int& value)
{
  gobj()->segsize = value;
}
 
 int AudioRingBufferSpec::get_segtotal() const
{
  return gobj()->segtotal;
}
 
 void AudioRingBufferSpec::set_segtotal(const int& value)
{
  gobj()->segtotal = value;
}
 
 int AudioRingBufferSpec::get_seglatency() const
{
  return gobj()->seglatency;
}
 
 void AudioRingBufferSpec::set_seglatency(const int& value)
{
  gobj()->seglatency = value;
}
 

} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::AudioRingBuffer> wrap(GstAudioRingBuffer* object, bool take_copy)
{
  return Glib::RefPtr<Gst::AudioRingBuffer>( dynamic_cast<Gst::AudioRingBuffer*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& AudioRingBuffer_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &AudioRingBuffer_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_audio_ring_buffer_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void AudioRingBuffer_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->open_device = &open_device_vfunc_callback;
  klass->release = &release_vfunc_callback;
  klass->close_device = &close_device_vfunc_callback;
  klass->start = &start_vfunc_callback;
  klass->pause = &pause_vfunc_callback;
  klass->resume = &resume_vfunc_callback;
  klass->stop = &stop_vfunc_callback;
  klass->delay = &delay_vfunc_callback;
  klass->activate = &activate_vfunc_callback;
  klass->clear_all = &clear_all_vfunc_callback;
  klass->acquire = &acquire_vfunc_callback;
  klass->commit = &commit_vfunc_callback;
  
}

gboolean AudioRingBuffer_Class::open_device_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->open_device_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->open_device)
  {
    gboolean retval = (*base->open_device)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::release_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->release_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->release)
  {
    gboolean retval = (*base->release)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::close_device_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->close_device_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->close_device)
  {
    gboolean retval = (*base->close_device)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::start_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->start_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->start)
  {
    gboolean retval = (*base->start)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::pause_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->pause_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->pause)
  {
    gboolean retval = (*base->pause)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::resume_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->resume_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->resume)
  {
    gboolean retval = (*base->resume)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
gboolean AudioRingBuffer_Class::stop_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->stop_vfunc());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->stop)
  {
    gboolean retval = (*base->stop)(self);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
guint AudioRingBuffer_Class::delay_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->delay_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->delay)
  {
    guint retval = (*base->delay)(self);
    return retval;
  }

  typedef guint RType;
  return RType();
}
gboolean AudioRingBuffer_Class::activate_vfunc_callback(GstAudioRingBuffer* self, gboolean active)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->activate_vfunc(active
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->activate)
  {
    gboolean retval = (*base->activate)(self, active);
    return retval;
  }

  typedef gboolean RType;
  return RType();
}
void AudioRingBuffer_Class::clear_all_vfunc_callback(GstAudioRingBuffer* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->clear_all_vfunc();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->clear_all)
  {
    (*base->clear_all)(self);
  }

}


Glib::ObjectBase* AudioRingBuffer_Class::wrap_new(GObject* object)
{
  return new AudioRingBuffer((GstAudioRingBuffer*)object);
}


/* The implementation: */

GstAudioRingBuffer* AudioRingBuffer::gobj_copy()
{
  reference();
  return gobj();
}

AudioRingBuffer::AudioRingBuffer(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

AudioRingBuffer::AudioRingBuffer(GstAudioRingBuffer* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}


AudioRingBuffer::~AudioRingBuffer()
{}


AudioRingBuffer::CppClassType AudioRingBuffer::audioringbuffer_class_; // initialize static member

GType AudioRingBuffer::get_type()
{
  return audioringbuffer_class_.init().get_type();
}


GType AudioRingBuffer::get_base_type()
{
  return gst_audio_ring_buffer_get_type();
}

bool AudioRingBuffer::acquire(Gst::AudioRingBufferSpec& spec)
{
  return gst_audio_ring_buffer_acquire(gobj(), spec.gobj());
}

bool AudioRingBuffer::release()
{
  return gst_audio_ring_buffer_release(gobj());
}

bool AudioRingBuffer::is_acquired() const
{
  return gst_audio_ring_buffer_is_acquired(const_cast<GstAudioRingBuffer*>(gobj()));
}

bool AudioRingBuffer::activate(bool active)
{
  return gst_audio_ring_buffer_activate(gobj(), static_cast<int>(active));
}

bool AudioRingBuffer::is_active() const
{
  return gst_audio_ring_buffer_is_active(const_cast<GstAudioRingBuffer*>(gobj()));
}

bool AudioRingBuffer::start()
{
  return gst_audio_ring_buffer_start(gobj());
}

bool AudioRingBuffer::pause()
{
  return gst_audio_ring_buffer_pause(gobj());
}

bool AudioRingBuffer::stop()
{
  return gst_audio_ring_buffer_stop(gobj());
}

guint AudioRingBuffer::get_delay() const
{
  return gst_audio_ring_buffer_delay(const_cast<GstAudioRingBuffer*>(gobj()));
}

guint64 AudioRingBuffer::get_samples_done() const
{
  return gst_audio_ring_buffer_samples_done(const_cast<GstAudioRingBuffer*>(gobj()));
}

void AudioRingBuffer::set_sample(guint64 sample)
{
  gst_audio_ring_buffer_set_sample(gobj(), sample);
}

void AudioRingBuffer::set_channel_position(const Gst::AudioChannelPosition& position)
{
  gst_audio_ring_buffer_set_channel_positions(gobj(), (const GstAudioChannelPosition*)(&position));
}

gboolean AudioRingBuffer::is_flushing()
{
  return gst_audio_ring_buffer_is_flushing(gobj());
}

void AudioRingBuffer::set_timestamp(gint readseg, ClockTime timestamp)
{
  gst_audio_ring_buffer_set_timestamp(gobj(), readseg, ((GstClockTime)(timestamp)));
}

guint AudioRingBuffer::commit(guint64& sample, const std::vector<guint8>& data, int in_samples, int out_samples, int& accum)
{
  return gst_audio_ring_buffer_commit(gobj(), &(sample), Glib::ArrayHandler<guint8>::vector_to_array(data).data(), in_samples, out_samples, &(accum));
}

bool AudioRingBuffer::convert(Gst::Format src_fmt, gint64 src_val, Gst::Format dest_fmt, gint64& dest_val) const
{
  return gst_audio_ring_buffer_convert(const_cast<GstAudioRingBuffer*>(gobj()), ((GstFormat)(src_fmt)), src_val, ((GstFormat)(dest_fmt)), &(dest_val));
}

guint AudioRingBuffer::read(guint64 sample, const std::vector<guint8>& data, guint len, ClockTime& timestamp)
{
  return gst_audio_ring_buffer_read(gobj(), sample, Glib::ArrayHandler<guint8>::vector_to_array(data).data(), len, (GstClockTime*)(&timestamp));
}

void AudioRingBuffer::clear(int segment)
{
  gst_audio_ring_buffer_clear(gobj(), segment);
}

void AudioRingBuffer::clear_all()
{
  gst_audio_ring_buffer_clear_all(gobj());
}

void AudioRingBuffer::advance(guint advance)
{
  gst_audio_ring_buffer_advance(gobj(), advance);
}

bool AudioRingBuffer::close_device()
{
  return gst_audio_ring_buffer_close_device(gobj());
}

bool AudioRingBuffer::open_device()
{
  return gst_audio_ring_buffer_open_device(gobj());
}

bool AudioRingBuffer::device_is_open() const
{
  return gst_audio_ring_buffer_device_is_open(const_cast<GstAudioRingBuffer*>(gobj()));
}

void AudioRingBuffer::set_may_start(bool allowed)
{
  gst_audio_ring_buffer_may_start(gobj(), static_cast<int>(allowed));
}

bool AudioRingBuffer::parse_caps(Gst::AudioRingBufferSpec& p1, const Glib::RefPtr<Gst::Caps>& caps)
{
  return gst_audio_ring_buffer_parse_caps(p1.gobj(), Glib::unwrap(caps));
}


void AudioRingBuffer::set_flushing(bool flushing)
{
  gst_audio_ring_buffer_set_flushing(gobj(), static_cast<int>(flushing));
}


bool Gst::AudioRingBuffer::open_device_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->open_device)
  {
    bool retval((*base->open_device)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::release_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->release)
  {
    bool retval((*base->release)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::close_device_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->close_device)
  {
    bool retval((*base->close_device)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::start_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->start)
  {
    bool retval((*base->start)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::pause_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->pause)
  {
    bool retval((*base->pause)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::resume_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->resume)
  {
    bool retval((*base->resume)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
bool Gst::AudioRingBuffer::stop_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->stop)
  {
    bool retval((*base->stop)(gobj()));
    return retval;
  }

  typedef bool RType;
  return RType();
}
guint Gst::AudioRingBuffer::delay_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delay)
  {
    guint retval((*base->delay)(gobj()));
    return retval;
  }

  typedef guint RType;
  return RType();
}
bool Gst::AudioRingBuffer::activate_vfunc(bool active) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
  {
    bool retval((*base->activate)(gobj(),static_cast<int>(active)));
    return retval;
  }

  typedef bool RType;
  return RType();
}
void Gst::AudioRingBuffer::clear_all_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->clear_all)
  {
    (*base->clear_all)(gobj());
  }
}


} // namespace Gst


