/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.base;
public class SplitterTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.base.testModule";
}
public void testCharacterSimpleSplit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSimpleSplit();
}

public void testCharacterSimpleSplitToList() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSimpleSplitToList();
}

public void testCharacterSimpleSplitToStream() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSimpleSplitToStream();
}

public void testCharacterSimpleSplitWithNoDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSimpleSplitWithNoDelimiter();
}

public void testCharacterSplitEmptyToken() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitEmptyToken();
}

public void testCharacterSplitEmptyTokenOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitEmptyTokenOmitEmptyStrings();
}

public void testCharacterSplitOnEmptyString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitOnEmptyString();
}

public void testCharacterSplitOnEmptyStringOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitOnEmptyStringOmitEmptyStrings();
}

public void testCharacterSplitOnOnlyDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitOnOnlyDelimiter();
}

public void testCharacterSplitOnOnlyDelimitersOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitOnOnlyDelimitersOmitEmptyStrings();
}

public void testCharacterSplitWithDoubleDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithDoubleDelimiter();
}

public void testCharacterSplitWithDoubleDelimiterAndSpace() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithDoubleDelimiterAndSpace();
}

public void testCharacterSplitWithDoubleDelimiterOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithDoubleDelimiterOmitEmptyStrings();
}

public void testCharacterSplitWithLeadingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithLeadingDelimiter();
}

public void testCharacterSplitWithMatcherDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithMatcherDelimiter();
}

public void testCharacterSplitWithMultipleLetters() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithMultipleLetters();
}

public void testCharacterSplitWithTrailingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithTrailingDelimiter();
}

public void testCharacterSplitWithTrim() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testCharacterSplitWithTrim();
}

public void testFixedLengthSimpleSplit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSimpleSplit();
}

public void testFixedLengthSplitEmptyString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitEmptyString();
}

public void testFixedLengthSplitEmptyStringWithOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitEmptyStringWithOmitEmptyStrings();
}

public void testFixedLengthSplitEqualChunkLength() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitEqualChunkLength();
}

public void testFixedLengthSplitIntoChars() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitIntoChars();
}

public void testFixedLengthSplitNegativeChunkLen() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitNegativeChunkLen();
}

public void testFixedLengthSplitOnlyOneChunk() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitOnlyOneChunk();
}

public void testFixedLengthSplitSmallerString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitSmallerString();
}

public void testFixedLengthSplitZeroChunkLen() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testFixedLengthSplitZeroChunkLen();
}

public void testInvalidZeroLimit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testInvalidZeroLimit();
}

public void testLimit1Separator() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimit1Separator();
}

public void testLimitExtraSeparators() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparators();
}

public void testLimitExtraSeparatorsOmitEmpty() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsOmitEmpty();
}

public void testLimitExtraSeparatorsOmitEmpty3() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsOmitEmpty3();
}

public void testLimitExtraSeparatorsTrim() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim();
}

public void testLimitExtraSeparatorsTrim1() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim1();
}

public void testLimitExtraSeparatorsTrim1Empty() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim1Empty();
}

public void testLimitExtraSeparatorsTrim1EmptyOmit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim1EmptyOmit();
}

public void testLimitExtraSeparatorsTrim1NoOmit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim1NoOmit();
}

public void testLimitExtraSeparatorsTrim3() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitExtraSeparatorsTrim3();
}

public void testLimitFixedLength() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitFixedLength();
}

public void testLimitLarge() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitLarge();
}

public void testLimitOne() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitOne();
}

public void testLimitSeparator() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testLimitSeparator();
}

public void testMapSplitter_CharacterSeparator() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_CharacterSeparator();
}

public void testMapSplitter_duplicateKeys() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_duplicateKeys();
}

public void testMapSplitter_emptySeparator() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_emptySeparator();
}

public void testMapSplitter_extraValueDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_extraValueDelimiter();
}

public void testMapSplitter_malformedEntry() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_malformedEntry();
}

public void testMapSplitter_multiCharacterSeparator() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_multiCharacterSeparator();
}

public void testMapSplitter_notTrimmed() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_notTrimmed();
}

public void testMapSplitter_orderedResults() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_orderedResults();
}

public void testMapSplitter_trimmedBoth() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_trimmedBoth();
}

public void testMapSplitter_trimmedEntries() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_trimmedEntries();
}

public void testMapSplitter_trimmedKeyValue() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_trimmedKeyValue();
}

public void testMapSplitter_varyingTrimLevels() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testMapSplitter_varyingTrimLevels();
}

public void testSplitNullString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testSplitNullString();
}

public void testSplitterIterableIsLazy_char() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testSplitterIterableIsLazy_char();
}

public void testSplitterIterableIsLazy_string() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testSplitterIterableIsLazy_string();
}

public void testSplitterIterableIsUnmodifiable_char() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testSplitterIterableIsUnmodifiable_char();
}

public void testSplitterIterableIsUnmodifiable_string() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testSplitterIterableIsUnmodifiable_string();
}

public void testStringSimpleSplit() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSimpleSplit();
}

public void testStringSimpleSplitWithNoDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSimpleSplitWithNoDelimiter();
}

public void testStringSplitEmptyToken() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitEmptyToken();
}

public void testStringSplitEmptyTokenOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitEmptyTokenOmitEmptyStrings();
}

public void testStringSplitOnEmptyString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitOnEmptyString();
}

public void testStringSplitOnEmptyStringOmitEmptyString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitOnEmptyStringOmitEmptyString();
}

public void testStringSplitOnOnlyDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitOnOnlyDelimiter();
}

public void testStringSplitOnOnlyDelimitersOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitOnOnlyDelimitersOmitEmptyStrings();
}

public void testStringSplitWithDelimiterSubstringInValue() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithDelimiterSubstringInValue();
}

public void testStringSplitWithDoubleDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithDoubleDelimiter();
}

public void testStringSplitWithDoubleDelimiterAndSpace() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithDoubleDelimiterAndSpace();
}

public void testStringSplitWithDoubleDelimiterOmitEmptyStrings() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithDoubleDelimiterOmitEmptyStrings();
}

public void testStringSplitWithEmptyString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithEmptyString();
}

public void testStringSplitWithLeadingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithLeadingDelimiter();
}

public void testStringSplitWithLongDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithLongDelimiter();
}

public void testStringSplitWithLongLeadingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithLongLeadingDelimiter();
}

public void testStringSplitWithLongTrailingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithLongTrailingDelimiter();
}

public void testStringSplitWithMultipleLetters() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithMultipleLetters();
}

public void testStringSplitWithTrailingDelimiter() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithTrailingDelimiter();
}

public void testStringSplitWithTrim() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testStringSplitWithTrim();
}

public void testToString() throws Exception {
  com.google.common.base.SplitterTest testCase = new com.google.common.base.SplitterTest();
  testCase.testToString();
}
}
