{- This module was generated from data in the Kate syntax
   highlighting file curry.xml, version 0.3, by Björn Peemöller (bjp@informatik.uni-kiel.de) -}

module Text.Highlighting.Kate.Syntax.Curry
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Curry"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.curry"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Curry","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Curry","Normal") -> return ()
      ("Curry","Pragma") -> return ()
      ("Curry","Multiline Comment") -> return ()
      ("Curry","Currydoc") -> (popContext) >> pEndLine
      ("Curry","Comment") -> (popContext) >> pEndLine
      ("Curry","Import") -> (popContext) >> pEndLine
      ("Curry","Char") -> pushContext ("Curry","CharSyntaxError") >> return ()
      ("Curry","CharEscape") -> (popContext) >> pEndLine
      ("Curry","CharEnd") -> (popContext) >> pEndLine
      ("Curry","CharSyntaxError") -> return ()
      ("Curry","String") -> pushContext ("Curry","StringSyntaxError") >> return ()
      ("Curry","StringEscape") -> pushContext ("Curry","StringGap") >> return ()
      ("Curry","StringGap") -> return ()
      ("Curry","StringSyntaxError") -> return ()
      ("Curry","Infix") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "case data do else external fcase free if in infix infixl infixr let module of then type where"
list_Prelude_Func = Set.fromList $ words $ "and all any appendFile best break browse browseList chr concat concatMap const curry div done doSolve drop dropWhile either elem ensureNotFree ensureSpine enumFrom enumFromThen enumFromTo enumFromThenTo error failed filter findall flip foldl foldl1 foldr foldr1 fst getChar getLine id if_then_else iterate head length lines lookup map mapIO mapIO_ max maybe min mod negate not notElem null once or ord otherwise print putChar putStr putStrLn readFile repeat replicate return reverse seq sequenceIO sequenceIO_ show snd solveAll span splitAt success tail take takeWhile try uncurry unknown unlines unpack until unwords unzip unzip3 writeFile words zip zip3 zipWith zipWith3"
list_Prelude_Type = Set.fromList $ words $ "Bool Char Either Float Int IO Maybe Ordering String Success"
list_Prelude_Cons = Set.fromList $ words $ "False True Left Right Just Nothing EQ LT GT"

regex_import'5cs'2b'28qualified'29'3f = compileRegex "import\\s+(qualified)?"
regex_0'28o'7cO'29'5b0'2d7'5d'2b = compileRegex "0(o|O)[0-7]+"
regex_'28'3a'3a'7c'3a'3d'7c'3a'3e'7c'5c'2d'3e'7c'3c'5c'2d'7c'5c'2e'5c'2e'29 = compileRegex "(::|:=|:>|\\->|<\\-|\\.\\.)"
regex_'5cs'2a'28'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'7c'5c'28'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b'5c'29'29'5cs'2a'28'2c'5cs'2a'28'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'7c'5c'28'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b'5c'29'29'29'2a'5cs'2a'28'3f'3d'3a'3a'5b'5e'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'29 = compileRegex "\\s*([a-z][a-zA-Z0-9_']*|\\([~!@#\\$%\\^&\\*\\+\\-=<>\\?\\./\\|\\\\:]+\\))\\s*(,\\s*([a-z][a-zA-Z0-9_']*|\\([~!@#\\$%\\^&\\*\\+\\-=<>\\?\\./\\|\\\\:]+\\)))*\\s*(?=::[^~!@#\\$%\\^&\\*\\+\\-=<>\\?\\./\\|\\\\:])"
regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a = compileRegex "([A-Z][a-zA-Z0-9_']*\\.)*[a-z][a-zA-Z0-9_']*"
regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b = compileRegex "([A-Z][a-zA-Z0-9_']*\\.)*[~!@#\\$%\\^&\\*\\+\\-=<>\\?\\./\\|\\\\:]+"
regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a = compileRegex "([A-Z][a-zA-Z0-9_']*\\.)*[A-Z][a-zA-Z0-9_']*"
regex_'5cS'2b = compileRegex "\\S+"
regex_'5b'5e'27'5c'5c'5d = compileRegex "[^'\\\\]"
regex_o'5b0'2d7'5d'2b = compileRegex "o[0-7]+"
regex_'5b0'2d9'5d'2b = compileRegex "[0-9]+"
regex_x'5b0'2d9a'2dfA'2dF'5d'2b = compileRegex "x[0-9a-fA-F]+"
regex_'5c'5e'5bA'2dZ'40'5c'5b'5c'5c'5c'5d'5c'5e'5f'5d = compileRegex "\\^[A-Z@\\[\\\\\\]\\^_]"
regex_NUL'7cSOH'7cSTX'7cETX'7cEOT'7cENQ'7cACK'7cBEL'7cBS'7cHT'7cLF'7cVT'7cFF'7cCR'7cSO'7cSI'7cDLE'7cDC1'7cDC2'7cDC3'7cDC4'7cNAK'7cSYN'7cETB'7cCAN'7cEM'7cSUB'7cESC'7cFS'7cGS'7cRS'7cUS'7cSP'7cDEL = compileRegex "NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL"
regex_'2e = compileRegex "."
regex_'5b'5e'22'5c'5c'5d'2a = compileRegex "[^\"\\\\]*"

parseRules ("Curry","Normal") =
  (((pString False "{-#" >>= withAttribute OtherTok) >>~ pushContext ("Curry","Pragma"))
   <|>
   ((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Curry","Multiline Comment"))
   <|>
   ((pString False "---" >>= withAttribute CommentTok) >>~ pushContext ("Curry","Currydoc"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Curry","Comment"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Prelude_Func >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Prelude_Type >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Prelude_Cons >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_import'5cs'2b'28qualified'29'3f >>= withAttribute KeywordTok) >>~ pushContext ("Curry","Import"))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_0'28o'7cO'29'5b0'2d7'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Curry","Char"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Curry","String"))
   <|>
   ((pRegExpr regex_'28'3a'3a'7c'3a'3d'7c'3a'3e'7c'5c'2d'3e'7c'3c'5c'2d'7c'5c'2e'5c'2e'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cs'2a'28'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'7c'5c'28'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b'5c'29'29'5cs'2a'28'2c'5cs'2a'28'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'7c'5c'28'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b'5c'29'29'29'2a'5cs'2a'28'3f'3d'3a'3a'5b'5e'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5b'7e'21'40'23'5c'24'25'5c'5e'26'5c'2a'5c'2b'5c'2d'3d'3c'3e'5c'3f'5c'2e'2f'5c'7c'5c'5c'3a'5d'2b >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute OtherTok) >>~ pushContext ("Curry","Infix"))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Curry","Pragma") =
  (((pString False "#-}" >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Pragma")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Curry","Multiline Comment") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Multiline Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Curry","Currydoc") =
  (currentContext >>= \x -> guard (x == ("Curry","Currydoc")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Curry","Comment") =
  (currentContext >>= \x -> guard (x == ("Curry","Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Curry","Import") =
  (((pString False "{-#" >>= withAttribute OtherTok) >>~ pushContext ("Curry","Pragma"))
   <|>
   ((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Curry","Multiline Comment"))
   <|>
   ((pString False "---" >>= withAttribute CommentTok) >>~ pushContext ("Curry","Currydoc"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Curry","Comment"))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a'5c'2e'29'2a'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'27'5d'2a >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False 'a' 's' >>= withAttribute KeywordTok))
   <|>
   ((pString False "hiding" >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS'2b >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Import")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Curry","Char") =
  (((pDetectChar False '\'' >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\\' >>= withAttribute CharTok) >>~ pushContext ("Curry","CharEscape"))
   <|>
   ((pRegExpr regex_'5b'5e'27'5c'5c'5d >>= withAttribute CharTok) >>~ pushContext ("Curry","CharEnd"))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Char")) >> pDefault >>= withAttribute CharTok))

parseRules ("Curry","CharEscape") =
  (((pAnyChar "abfnrtv\\\"'" >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_o'5b0'2d7'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_x'5b0'2d9a'2dfA'2dF'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5e'5bA'2dZ'40'5c'5b'5c'5c'5c'5d'5c'5e'5f'5d >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_NUL'7cSOH'7cSTX'7cETX'7cEOT'7cENQ'7cACK'7cBEL'7cBS'7cHT'7cLF'7cVT'7cFF'7cCR'7cSO'7cSI'7cDLE'7cDC1'7cDC2'7cDC3'7cDC4'7cNAK'7cSYN'7cETB'7cCAN'7cEM'7cSUB'7cESC'7cFS'7cGS'7cRS'7cUS'7cSP'7cDEL >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","CharEscape")) >> pDefault >>= withAttribute CharTok))

parseRules ("Curry","CharEnd") =
  (((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","CharEnd")) >> pDefault >>= withAttribute CharTok))

parseRules ("Curry","CharSyntaxError") =
  (((pDetectChar False '\'' >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","CharSyntaxError")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Curry","String") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\\' >>= withAttribute CharTok) >>~ pushContext ("Curry","StringEscape"))
   <|>
   ((pRegExpr regex_'5b'5e'22'5c'5c'5d'2a >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Curry","StringEscape") =
  (((pAnyChar "abfnrtv\\\"'&" >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_o'5b0'2d7'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_x'5b0'2d9a'2dfA'2dF'5d'2b >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5e'5bA'2dZ'40'5c'5b'5c'5c'5c'5d'5c'5e'5f'5d >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_NUL'7cSOH'7cSTX'7cETX'7cEOT'7cENQ'7cACK'7cBEL'7cBS'7cHT'7cLF'7cVT'7cFF'7cCR'7cSO'7cSI'7cDLE'7cDC1'7cDC2'7cDC3'7cDC4'7cNAK'7cSYN'7cETB'7cCAN'7cEM'7cSUB'7cESC'7cFS'7cGS'7cRS'7cUS'7cSP'7cDEL >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((pDetectSpaces >>= withAttribute CharTok) >>~ pushContext ("Curry","StringGap"))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","StringEscape")) >> pDefault >>= withAttribute StringTok))

parseRules ("Curry","StringGap") =
  (((pDetectSpaces >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\\' >>= withAttribute CharTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","StringGap")) >> pDefault >>= withAttribute StringTok))

parseRules ("Curry","StringSyntaxError") =
  (((pDetectChar False '"' >>= withAttribute ErrorTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","StringSyntaxError")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("Curry","Infix") =
  (((pDetectChar False '`' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Curry","Infix")) >> pDefault >>= withAttribute OtherTok))


parseRules x = parseRules ("Curry","Normal") <|> fail ("Unknown context" ++ show x)
