from abc import ABC, abstractmethod


class HtmlGeneratorConfiguration(ABC):
    """HTML generator configuration interface."""

    @property
    @abstractmethod
    def markdown_tex_support(self) -> bool:
        """Get whether markdown TeX rendering is supported.

        :return: Markdown TeX supported
        :rtype: bool
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def line_length(self) -> int:
        """Get line length.

        :return: Size in pixels
        :rtype: int
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def markdown_use_monospace_font(self) -> bool:
        """Get whether to use a monospace font for the markdown render.

        :return: Using monospace font
        :rtype: bool
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def use_monospace_font(self) -> bool:
        """Get whether to use a monospace font.

        :return: Using monospace font
        :rtype: bool
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def font_size(self) -> int:
        """Get font size.

        :return: Size
        :rtype: int
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def high_contrast(self) -> bool:
        """Get whether high contrast output should be used for screen rendering.

        :return: Whether visible
        :rtype: bool
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def markdown_render_monospace_font_ratio(self) -> float:
        """Get the adjustment in size from proportional to fixed width font.

        :return: Ratio
        :rtype: float
        """
        raise NotImplementedError()

    @property
    @abstractmethod
    def editor_header_bar_visible_for_window_state(self) -> bool:
        """Get whether the header bar is configured visible for the window maximised state."

        :return: Whether visible
        :rtype: bool
        """
        raise NotImplementedError()
