## JerryScript debugger interface

JerryScript provides a remote debugger which allows debugging
JavaScript programs. The debugger has two main components:
a server which is part of the JerryScript binary and a
separate client application. Currently two debugger clients
are available in the /jerry-debugger subdirectory: an HTML
and a Python application. These simple applications demonstrate
the communication protocol between the client and server and can
be reused by integrated development environments.

## Setting up the debugger server

The following arguments must be passed to `tools/build.py`:

`--jerry-debugger=on --jerry-libc=off`

At the moment only a Websocket-based implementation is provided
by JerryScript which transmits messages over TCP/IP networks.
This implementation requires a socket API which is not yet
supported by jerry-libc so the standard libc is used instead.
In the future any reliable stream or datagram based protocol
can be used for transmitting debugger messages.

## Debugging JavaScript applications

The debugger client must be connected to the server before the
JavaScript application runs. On-the-fly attachment is not supported
because the debugging information (e.g. line index of each possible
breakpoint location) is not preserved by JerryScript. The client is
expected to be run on a system with much more resources and it should
be capable of storing this information. JerryScript frees all debug
information after it is transmitted to the client to save memory.

The following argument makes JerryScript wait for a client
connection:

`--start-debug-server`

It is also recommended to increase the log level to see
the *Waiting for client connection* message:

`--log-level 2`

The HTML client can connect to the IP address of the server with
the `connect` command. The IP address can be localhost
if the server and the client are running on the same machine.

After the connection is established the execution can be
controlled by the debugger. The debugger always stops at
the first possible breakpoint location. The effect is the
same as using the `stop` command. This allows inserting
breakpoints right before the meaningful part of the execution
starts.

All available commands of the client can be queried by the
`help` command.

## Integrating debugger support into applications using JerryScript

The debugger can be enabled by passing the `JERRY_INIT_DEBUGGER` flag
to the `jerry_init ()` function which then initializes the debugger
and blocks until a client connects.

When the debugger is enabled it is recommended to use
`jerry_parse_named_resource ()` instead of `jerry_parse ()` because
the resource name (usually a file name) is also passed to this
function. This resource name is used by the client to identify
the corresponding resource. In general it is always recommended to
use `jerry_parse_named_resource ()` when the resource name is
available because it silently ignores the resource name if the
debugger is disabled.

## JerryScript debugger C-API interface

The following section describes the debugger functions
available for the host application.

### jerry_debugger_is_connected

**Summary**

Returns true if a remote debugger client is connected.

**Prototype**

```c
bool
jerry_debugger_is_connected (void);
```

**Example**

```c
{
  jerry_init (JERRY_INIT_DEBUGGER);

  if (jerry_debugger_is_connected ())
  {
    printf ("A remote debugger client is connected.");
  }
}
```

### jerry_debugger_stop

**Summary**

Stops execution at the next available breakpoint if a remote
debugger client is connected and the engine is not waiting at
a breakpoint. The engine will stop regardless the breakpoint
is enabled or not.

**Prototype**

```c
void
jerry_debugger_stop (void)
```

**Example**

```c
{
  jerry_init (JERRY_INIT_DEBUGGER);

  jerry_debugger_stop ();
}
```

**See also**

- [jerry_debugger_continue](#jerry_debugger_continue)

### jerry_debugger_continue

**Summary**

If the engine would stop at the next available breakpoint it
cancels this effect. The engine will still stop at enabled
breakpoints. This function effectively negates the effect of
[jerry_debugger_stop ()](#jerry_debugger_stop) calls or stop
requests issued by the debugger client.

**Prototype**

```c
void
jerry_debugger_continue (void)
```

**Example**

```c
{
  jerry_init (JERRY_INIT_DEBUGGER);

  jerry_debugger_continue ();
}
```

**See also**

- [jerry_debugger_stop](#jerry_debugger_stop)

### jerry_debugger_disable_stop_at_breakpoint

**Summary**

Enables or disables stopping at breakpoints. When stopping is
disabled all breakpoints are ignored including user enabled
breakpoints. This allows hidden execution of ECMAScript code.

**Prototype**

```c
void
jerry_debugger_stop_at_breakpoint (bool enable_stop_at_breakpoint)
```

- `enable_stop_at_breakpoint` - enable (=`true`) or disable (=`false`) stopping at breakpoints

**Example**

```c
{
  jerry_init (JERRY_INIT_DEBUGGER);

  jerry_debugger_stop_at_breakpoint (true);

  // Protected execution of JavaScript code.
  jerry_eval (...);

  jerry_debugger_stop_at_breakpoint (false);
}
```
