/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeIterator
implements Iterator<Segment> {
    private final Segment segment;
    private final Source source;
    private int pos;
    private Tag nextTag;
    private CharacterReference characterReferenceAtCurrentPosition = null;
    private final boolean legacyIteratorCompatabilityMode = Source.LegacyIteratorCompatabilityMode;

    public NodeIterator(Segment segment) {
        this.segment = segment;
        this.source = segment.source;
        if (segment == this.source) {
            this.source.fullSequentialParse();
        }
        this.pos = segment.begin;
        this.nextTag = this.source.getNextTag(this.pos);
        if (this.nextTag != null && this.nextTag.begin >= segment.end) {
            this.nextTag = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.segment.end || this.nextTag != null;
    }

    @Override
    public Segment next() {
        int n = this.pos;
        if (this.nextTag != null) {
            if (n < this.nextTag.begin) {
                return this.nextNonTagSegment(n, this.nextTag.begin);
            }
            Tag tag = this.nextTag;
            this.nextTag = this.nextTag.getNextTag();
            if (this.nextTag != null && this.nextTag.begin >= this.segment.end) {
                this.nextTag = null;
            }
            if (this.pos < tag.end) {
                this.pos = tag.end;
            }
            return tag;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextNonTagSegment(n, this.segment.end);
    }

    private Segment nextNonTagSegment(int n, int n2) {
        if (!this.legacyIteratorCompatabilityMode) {
            CharacterReference characterReference = this.characterReferenceAtCurrentPosition;
            if (characterReference != null) {
                this.characterReferenceAtCurrentPosition = null;
                this.pos = characterReference.end;
                return characterReference;
            }
            ParseText parseText = this.source.getParseText();
            int n3 = parseText.indexOf('&', n, n2);
            while (n3 != -1) {
                CharacterReference characterReference2 = CharacterReference.construct(this.source, n3, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
                if (characterReference2 != null) {
                    if (n3 == n) {
                        this.pos = characterReference2.end;
                        return characterReference2;
                    }
                    this.pos = characterReference2.begin;
                    this.characterReferenceAtCurrentPosition = characterReference2;
                    return new Segment(this.source, n, this.pos);
                }
                n3 = parseText.indexOf('&', n3 + 1, n2);
            }
        }
        this.pos = n2;
        return new Segment(this.source, n, this.pos);
    }

    public void skipToPos(int n) {
        if (n < this.pos) {
            return;
        }
        this.pos = n;
        this.nextTag = this.source.getNextTag(n);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

