#!/bin/sh

set -e


# called by uscan with '--upstream-version' <version> <jarfile>
TAR=../astrogrid-samp_$2.orig.tar.gz
DIR=astrogrid-samp-$2
JAR=$3
TARBALLDIR=../tarballs

# unjar and clean up the upstream archive
mkdir $DIR && cd $DIR && jar -xvf ../$JAR
cd ../ && find $DIR/ -name *.class | xargs rm -f

# strip the xmlrpc/apache/ dir from the sources
find $DIR/ -name apache -type d -print | xargs rm -rf

# create a tarball
tar -czvf $TAR $DIR

# remove temporary dir
rm -rf $DIR

# move tarball to "tarballs/" if this directory exists
if [ -d "$TARBALLDIR" ]; then 
	mv $TAR $TARBALLDIR
    echo "moved $TAR to $TARBALLDIR" 
fi


# find src/java/org/astrogrid/samp/xmlrpc -name "apache" -type d -print
