/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef KVPNCKICKER_H
#define KVPNCKICKER_H

#include <QtGui/QCloseEvent>
#include <QtGui/QPixmap>
#include <QtGui/QWidget>
#include <QPoint>

#include <kmenu.h>
#include <ksystemtrayicon.h>

#include "kvpncconfig.h"

class KVpncKicker : public KSystemTrayIcon
{
    Q_OBJECT

public:
    enum Status {
        disconnected = 0,
        connecting = 1,
        connected = 2
    };

    KVpncKicker(KVpncConfig *GlobalConfig, QWidget *parent = 0, const char *name = 0);
    ~KVpncKicker();

    KMenu* menu();
    void setStatus(int status);
	public slots:
		void closeEvent(QCloseEvent* e);
		bool event(QEvent *e);
	signals:
		void showTooltipRequested(const QPoint &);

protected:
    void initDockWindow();

    QWidget *parent;
    KVpncConfig *GlobalConfig;

private:
    QColor currentStatus;
    QPixmap connectedIcon;
    QPixmap disconnectedIcon;
    QPixmap connectingIcon;

Q_SIGNALS:
    void closeEventKicker(QCloseEvent *e);
};

#endif
